<?php
/**
*
* @package Icy Phoenix
* @version $Id$
* @copyright (c) 2008 Icy Phoenix
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
*
* @Extra credits for this file
* Lopalong
*
*/

if (!defined('IN_ICYPHOENIX'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

$lang = array_merge($lang, array(
	// MG CMS - BEGIN
	'CMS_WELCOME' => 'Welcome to Icy Phoenix',
	'CMS_THANKS' => 'Thanks for using <a href="http://www.icyphoenix.com/" title="Icy Phoenix">Icy Phoenix</a>. If you need help you can check <a href="http://www.icyphoenix.com/viewforumlist.php?f=4" title="Documentation">Documentation</a> or <a href="http://www.icyphoenix.com/forum.php" title="Support Forum">Support Forum</a>.',
	'BP_Title' => 'Blocks Position Tag',
	'BP_Explain' => 'Add, edit or delete blocks position that can be used in site pages. The default positions are \'header\', \'footer\', \'right\', \'left\' and \'centre\'. These positions correspond to the layout being used for a specific site page. Only existing positions per site page must be added here. Position keys that are not existing in the specified layout will not appear in the site page. Each position tag key and character must be unique per site page.',
	'BP_Position' => 'Position character',
	'BP_Key' => 'Position Tag Key',
	'BP_Layout' => 'Site Page',
	'BP_Add_Position' => 'Add New Position',
	'No_bp_selected' => 'No position selected for editing',
	'BP_Edit_Position' => 'Edit block position',
	'Must_enter_bp' => 'You must enter a position tag key, position character and site page',
	'BP_updated' => 'Block position updated',
	'BP_added' => 'Block position added',
	'Click_return_bpadmin' => 'Click %sHere%s to return to Blocks Position Administration',
	'BP_removed' => 'Block position removed',
	'Portal_wide' => 'Global Blocks',

	'No_layout_selected' => 'No site page selected for editing',
	'LAYOUT_TITLE' => 'Site Pages',
	'LAYOUT_TEXT' => 'Add, edit or delete layout information for your site pages. Multiple site pages can use the same layout. The layout template file selected must reside in the layout directory under your forum template directory. You are not allowed to delete the default site page. Deleting a site page also deletes the corresponding block positions for that page and all the blocks assigned to it. You can also edit the blocks assigned to each page and create new pages from scratch even with a new physical name (if your server allows it you can create for example a new page called <b>mypage.php</b>).',
	'Layout_Special_Explain' => 'Add, edit or delete blocks for standard pages of your site (i.e.: forum, view topic, memberlist, downloads, etc.).',
	'LAYOUT_NAME' => 'Name',
	'LAYOUT_TEMPLATE' => 'Template File',
	'LAYOUT_EDIT' => 'Edit site page',
	'Layout_Page' => 'Page ID',
	'LAYOUT_VIEW' => 'View permissions',
	'LAYOUT_EDIT_PERM' => 'Edit permissions',
	'LAYOUT_GLOBAL_BLOCKS' => 'Show Global Blocks',
	'LAYOUT_PAGE_NAV' => 'Page Navigation Block (Breadcrumbs)',
	'Must_enter_layout' => 'You must enter a name and a template file',
	'Layout_updated' => 'Page Updated',
	'Click_return_layoutadmin' => 'Click %sHere%s to return to Site Page Administration',
	'Layout_added' => 'Page added',
	'Layout_removed' => 'Page removed',
	'LAYOUT_ADD' => 'Add New Page',
	'Layout_BP_added' => 'Layout Config file available: Block Position Tags automatically inserted',
	'Layout_default' => 'Default',
	'Layout_make_default' => 'Make Default',

	'BLOCKS_TITLE' => 'Blocks Management',
	'BLOCKS_TEXT' => 'Add, edit, delete and move blocks for each available site page. A block template must exist for every block file added. If you want to add a text only block (with BBCodes or HTML) you should not choose any block file and then you\'ll be redirected to the editor page. Blocks creation/edit setup is split among two pages: the first where you will be able to choose the general settings for the block, and a second page where you will be able to set the block specific variables.',
	'BLOCKS_CREATION' => 'Add / Edit Block',
	'BLOCKS_CREATION_01' => 'Add / Edit Block Page 1 of 2',
	'BLOCKS_CREATION_02' => 'Add / Edit Block Page 2 of 2',
	'CMS_STANDARD_PAGES' => 'Standard Pages',
	'CMS_CUSTOM_PAGES' => 'CMS Pages',
	'CMS_CUSTOM_PAGES_ADV' => 'CMS Pages ADV',
	'CHOOSE_LAYOUT' => 'Choose Page',
	'B_TITLE' => 'Title',
	'B_NAME' => 'Name',
	'B_POSITION' => 'Position',
	'B_ACTIVE' => 'Status',
	'B_DISPLAY' => 'Content',
	'B_HTML' => 'HTML',
	'B_BBCODE' => 'BBCode',
	'B_TYPE' => 'Type',
	'B_BORDER' => 'Show Border',
	'B_Border_and_Background' => 'Border and Background',
	'B_TITLEBAR' => 'Show Titlebar',
	'B_Titlebar_Content' => 'Titlebar',
	'B_BACKGROUND' => 'Show Background',
	'B_LOCAL' => 'Localize Titlebar',
	'B_Cache' => 'Cache?',
	'B_Cachetime' => 'Cache Duration',
	'B_GROUPS' => 'Usergroups',
	'B_ALL' => 'All',
	'B_ALL_NO_BOTS' => 'All But BOTs',
	'B_GUESTS' => 'Guests Only',
	'B_REG' => 'Registered Users',
	'B_MOD' => 'Moderators',
	'B_ADMIN' => 'Administrators',
	'B_NONE' => 'None',
	'B_LAYOUT' => 'Site Page',
	'B_LAYOUT_EDIT' => 'Edit Page Settings',
	'B_PAGE' => 'Page ID',
	'B_ADD' => 'Add Block',
	'B_UPDATE' => 'Update Blocks',
	'YES' => 'Yes',
	'NO' => 'No',
	'ENABLED' => 'Enabled',
	'DISABLED' => 'Disabled',
	'B_TEXT' => 'Text',
	'B_FILE' => 'Block File',
	'B_MOVE' => 'Move',
	'B_MOVE_UP' => 'Move Up',
	'B_MOVE_DOWN' => 'Move Down',
	'B_VIEW_BY' => 'View By',
	'B_TEXT_BLOCK' => 'Text or HTML block',
	'NO_BLOCKS_AVAILABLE' => 'No blocks in this layout, click on "Add Block" to add one',
	'No_blocks_selected' => 'No block file selected',
	'B_CONTENT' => 'Content',
	'B_BLOCKFILE' => 'Block File',
	'Block_Edit' => 'Block Edit',
	'Block_updated' => 'Block updated',
	'Blocks_updated' => 'Blocks updated',
	'Must_enter_block' => 'You must enter a block title',
	'Block_added' => 'Block added',
	'Blocks_added' => 'Blocks added',
	'Blocks_duplicated' => 'Blocks duplicated',
	'Click_return_blocksadmin' => 'Click %sHere%s to return to Blocks Management',
	'Block_removed' => 'Block removed',
	'B_BV_added' => 'Block Config file available: Block Variables automatically inserted',
	'B_EDIT_BS' => 'Edit Settings',
	'B_EDIT' => 'Edit',
	'B_DELETE' => 'Delete',

	'BV_Title' => 'Blocks Variables',
	'BV_Explain' => 'Add, edit or delete blocks config variables that are used in blocks in Site Pages. These variables can then be configured through the Home Page Configuration page to customize your portal.',
	'BV_Label' => 'Field Label',
	'BV_Sub_Label' => 'Field Info',
	'BV_Name' => 'Config Name',
	'BV_Options' => 'Options',
	'BV_Values' => 'Field Values',
	'BV_Type' => 'Control Type',
	'BV_Block' => 'Block',
	'BV_Add_Variable' => 'Add Block Variable',
	'No_bv_selected' => 'No block variable to be configured, click on SUBMIT to save this block.',
	'BV_Edit_Variable' => 'Edit block variable',
	'Must_enter_bv' => 'You must enter a field label and config name',
	'BV_updated' => 'Block variable updated',
	'BV_added' => 'Block variable added',
	'Click_return_bvadmin' => 'Click %sHere%s to return to Blocks Variables Administration',
	'Config_Name_Explain' => 'Must have no space',
	'Field_Options_Explain' => 'Mandatory for dropdown lists and<br />radio buttons (comma delimited).',
	'Field_Values_Explain' => 'Mandatory for dropdown lists and<br />radio buttons (comma delimited).',
	'BV_removed' => 'Block variable removed',

	'Config_updated' => 'Configuration updated',
	'Click_return_config' => 'Click %sHere%s to return to Configuration',
	'Portal_Config' => 'Site Pages Configuration',
	'Portal_Explain' => 'In page, you can set the configuration needed for your customized site pages. Block variables listed in this page can be created/updated in <b>Blocks Variables Configuration</b> page. Global blocks for standard pages may be enabled/disabled in <b>Page Permissions</b>.',
	'Portal_General_Config' => 'General Configuration',
	'Default_Portal' => 'Default Site Page',
	'Default_Portal_Explain' => 'Homepage of the site',
	'Cache_Enabled' => 'Enable cache system',
	'Cache_Enabled_Explain' => 'For faster loading of site pages related information',
	'Confirm_delete_item' => 'Are you sure you want to delete this item?',
	'Cache_cleared' => 'Cache files removed',

	'CMS_Config_updated' => 'Configuration Updated Successfully',
	'CMS_Click_return_config' => 'Click %sHere%s to return to settings',
	'CMS_Click_return_cms' => 'Click %sHere%s to return to CMS Management',
	'CMS_TITLE' => 'CMS',
	'CMS_MANAGEMENT' => 'CMS Management',
	'CMS_CONFIG' => 'Configuration',
	'CMS_ACP' => 'Edit This Page',
	'CMS_PAGES' => 'Site Pages',
	'CMS_ID' => 'ID',
	'CMS_ACTIONS' => 'Actions',
	'CMS_LAYOUT' => 'Layout',
	'CMS_BLOCKS' => 'Blocks',
	'CMS_NAME' => 'Name',
	'CMS_DESCRIPTION' => 'Description',
	'CMS_LAYOUT_PAGE_ID' => 'Page ID',
	'CMS_LAYOUT_PAGE_ID_EXPLAIN' => 'This is the Page ID used by the auth system. Chars allowed: lowercase alpha, numbers, underscore, no spaces.',
	'CMS_MUST_FILL_ALL_FIELDS' => 'You have to fill all fields',
	'CMS_FILENAME' => 'Filename',
	'CMS_FILENAME_EXPLAIN' => 'If you specify a filename then a new page is created with the physical name you have chosen.',
	'CMS_Filename_Explain_OK' => '<i>After a quick test it seems that your server allows automatic files creation, so the file should be created automatically.</i>',
	'CMS_Filename_Explain_NO' => '<i>After a quick test it seems that your server <b>DOES NOT ALLOW</b> automatic files creation on your root. If you want to create a new page with a new physical name you should manually create the file on the server by duplicating <b>index_empty.php</b> and renaming it according to name you have chosen here. Alternatively you may assign the correct permissions to the root of your site so the procedure may run automatically.</i>',
	'CMS_TEMPLATE' => 'Template',
	'CMS_FileAlreadyExists' => 'The file you are trying to create already exists. Please choose another filename.',
	'CMS_FileCreationSuccess' => 'The new page has been automatically created.',
	'CMS_FileCreationError' => 'The file cannot be automatically created.',
	'CMS_FileCreationManual' => 'Please create a copy of index_empty.php, assign it the name you have inserted in the page creation form and upload it in your site root.',
	'CMS_PERMISSIONS' => 'Permissions',
	'CMS_PERMISSIONS_AUTH_EDIT_SET' => 'Set Page Edit Permissions',
	'CMS_PERMISSIONS_AUTH_EDIT' => 'Edit Permissions',
	'CMS_PERMISSIONS_AUTH_VIEW' => 'View Permissions',
	'CMS_PERMISSIONS_ROLES' => 'Permissions Roles',
	'CMS_Global_Header' => 'Global Header',
	'CMS_GLOBAL_BLOCKS' => 'Global Blocks',
	'CMS_BREADCRUMBS' => 'Breadcrumbs',
	'CMS_EDIT' => 'Edit',
	'CMS_DELETE' => 'Delete',
	'CMS_PREVIEW' => 'Preview',
	'CMS_CONFIGURE_BLOCKS' => 'Configure Blocks',
	'CMS_PAGES_PERMISSIONS' => 'Extra Permissions',
	'CMS_PAGES_PERMISSIONS_EXPLAIN' => 'Configure the user level required to view some others standard pages. If applicable, for each page you can also select to display global blocks (for this feature Global Blocks should be enabled in <b>CMS Configuration</b>).',
	'CMS_Page' => 'Page',
	'CMS_ADS' => 'Ads &amp; Sponsors',
	'CMS_OWNER' => 'Owner',
	'CMS_SAVE_CHANGES' => 'Save Changes',
	'CMS_CHANGES_SAVED' => 'Changes Saved',
	'CMS_BLOCK_SETTINGS' => 'Parent Blocks',
	'CMS_BLOCK_SETTINGS_TITLE' => 'Parent Blocks',
	'CMS_BLOCK_SETTINGS_TEXT' => 'In this page you can create parent blocks to be used in CMS pages.',
	'CMS_BLOCK_SETTINGS_INSTALL' => 'Create Parent Block',
	'CMS_BLOCK_NAME' => 'Name',
	'CMS_BLOCK_PARENT' => 'Parent block',
	// MG CMS - END

// MG CMS MENU - BEGIN
	'CMS_MENU_PAGE' => 'Dynamic Menu',
	'CMS_MENU_PAGE_EXPLAIN' => 'Create a customized menu to show in your CMS pages as a block. When creating a category or a link you can use language keys to assign names or specify your own name. You may even choose the permission level required for each link or whether the link should be opened in the same window or a new one.',

	'CMS_Menu_New_Menu' => 'Create a new menu block',
	'CMS_Menu_New_cat' => 'Create a new category',
	'CMS_Menu_New_link' => 'Create a new link',
	'CMS_Menu_Edit_menu_links_button' => 'Edit links in this menu',
	'CMS_Menu_Edit_cat_button' => 'Edit category',
	'CMS_Menu_Edit_link_button' => 'Edit link',
	'CMS_Menu_Set_auth' => 'Permission',
	'CMS_Menu_New_menu_name' => 'Menu name',
	'CMS_Menu_New_cat_name' => 'Category name',
	'CMS_Menu_New_link_name' => 'Link name',
	'CMS_Menu_Default_link' => 'Default link (<b>*</b> will be ignored)',
	'CMS_Menu_No_default_link' => 'No Default Link (Custom Settings)',
	'CMS_MENU_NO_DEFAULT_LINK_SELECT' => '-- No Default Link (Custom Settings) --',
	'CMS_Menu_New_menu_des' => 'Menu description',
	'CMS_Menu_New_cat_des' => 'Category description',
	'CMS_Menu_New_link_des' => 'Link description',
	'CMS_Menu_Choose_cat' => 'Choose category',
	'CMS_Menu_Choose_cat_desc' => 'Choose the category where the link is related to.',
	'CMS_Menu_link_status' => 'Status',
	'CMS_Menu_Icon' => 'Icon',
	'CMS_Menu_No_Icon' => 'No Icon',
	'CMS_Menu_Standard_Icon' => 'Standard Icon',
	'CMS_Menu_link_external' => 'External link',
	'CMS_Menu_New_link_name_key' => 'Language var (specified in <b>lang_dyn_menu.php</b>)',
	'CMS_Menu_No_lang_key' => 'No lang var (use the specified name)',
	'CMS_Menu_New_link_url' => 'URL of the link',
	'CMS_Menu_New_cat_link_url' => 'URL of the category (if no URL is entered, clicking on category link you can expand/collapse category items)',
	'CMS_Menu_Update' => 'Update Menu',

	'Click_Return_CMS_Menu' => 'Click %sHere%s to return to the menu administration',

	'Menu_created' => 'Menu successfully created.',
	'Cat_created' => 'Category successfully created.',
	'Link_created' => 'Link successfully created.',
	'Menu_updated' => 'Menu successfully updated.',
	'Cat_updated' => 'Category successfully updated.',
	'Link_updated' => 'Link successfully updated.',
	'Menu_deleted' => 'Menu successfully removed.',
	'Cat_deleted' => 'Category successfully removed.',
	'Link_deleted' => 'Link successfully removed.',

	'CMS_Menu_Not_Exist' => 'This menu doesn\'t exist.',
	'CMS_Menu_Items_Not_Exist' => 'This menu block doesn\'t have any category. Click on add to add one.',
	'CMS_Menu_No_Cats_Exist' => 'This menu block doesn\'t have any category. Before creating a link you need to create a category.',
	'CMS_Menu_Item_Not_Exist' => 'This menu item doesn\'t exist.',
	'CMS_Menu_Item_Add_Edit' => 'Add/Edit Menu Item',
// MG CMS MENU - END

// CMS - ADV - BEGIN
	'CMS_ADV' => 'CMS ADV',
	'CMS_LINKS' => 'Links',
	'CMS_SETTINGS' => 'Settings',
	'CMS_USERS' => 'CMS Users',
	'CMS_ADV_CUSTOM_PAGES' => 'Light Pages',
	'CMS_ADV_DEFAULT_TEMPLATE' => 'Default',
	'CMS_ADV_DEFAULT_TEMPLATE_OPTION' => '-- Template default --',

	'BLOCK_MOVE' => 'Move Block',
	'TURN_ACTIVE' => 'Enable / Disable Block',
	'TURN_BORDER' => 'Enable / Disable Border',
	'TURN_TITLEBAR' => 'Enable / Disable Title Bar',
	'TURN_LOCAL' => 'Enable / Disable Location Title',
	'TURN_BACKGROUND' => 'Enable / Disable Background',

	'BLOCKS_POSITION_SAVE' => 'Save Blocks Positions',
	'BLOCKS_POSITION_UPDATED' => 'Blocks location successfully updated',

	'INVALID_BLOCKS' => 'Invalid blocks position',

	'CMS_BLOCK_PAGE' => 'Add / Edit Block',
	'CMS_BLOCK_CONFIG' => 'Block Configuration',
	'CMS_BLOCK_CONFIG_EDIT' => 'Edit Configuration',
	'CMS_BLOCK_CONFIG_NO_VARS' => 'No block variables',
	'CMS_AJAX_ENABLE' => 'Enable AJAX',
	'CMS_AJAX_DISABLE' => 'Disable AJAX',
// CMS - ADV - END

// CMS - TIPS - BEGIN
	'CMS_TIP_TITLE' => 'Main CMS page',
	'CMS_TIP_CUSTOM_PAGES' => 'Customized pages: all pages created from scratch into Icy Phoenix based on one among the available layouts templates.<br />You can customize each page by adding, editing or deleting blocks and contents.<br />You can also assign a a physical name to a page (if your server allows it, you can create for example a new page called <b>mypage.php</b>).<br />In this section you can also customize permissions and global page settings like breadcrumbs and global blocks.',
	'CMS_TIP_STANDARD_PAGES' => 'Standard pages: default pages in Icy Phoenix.<br />These pages already have a defined content, but you can customize them by adding blocks or content in one of the allowed positions.<br />You can also add new pages, but these must already exists on your server.<br />In this section you can also customize permissions and global page settings like breadcrumbs and global blocks.',
	'CMS_TIP_BLOCK_SETTINGS' => 'A block is a section or widget you can add to any page.<br />Before being able to add a block to a page, you need to create it in this section.<br />Once block content has been defined and saved, you can then add the block on any page.<br />After you have created a new block, you can also add the same block on multiple pages without having to duplicate its content again.',
	'CMS_TIP_GLOBAL_BLOCKS' => 'Global blocks are blocks that could be used on any page without the needs to add them on any page.<br />To be able to display global blocks you need to make sure that the target page has Global Blocks enabled in its settings.',
	'CMS_TIP_AUTH' => 'Permissions system for CMS and plugins.',
	'CMS_TIP_CONFIG' => 'CMS configuration: some basics settings for the CMS.',
	'CMS_TIP_MENU' => 'This section allows you to create and manage navigations menu.<br />You can create several navigations menu and then you will be able to add them on any page through the &quot;Dynamic Menu&quot; block (remember to add the right Menu ID).<br />You are also able to set special images and permissions on any link and links categories.',
	'CMS_TIP_ADS' => 'The advertising section is intended to manage common kind of advertising in all pages and in some common sections (like forums, topics and menu).<br />In this section you will be able to create several ads and then you can decide how to be displayed (if more than one ad is set for the same position, then ads will be displayed randomly).',
// CMS - TIPS - END

// CMS USERS
	'CMS_USERS_INDEX' => 'Index',
	'CMS_USERS_LAYOUTS' => 'Pages',
	'CMS_USERS_MENU' => 'Menu',
	'CMS_USERS_MENU_UPPERCASE' => 'MENU',
	'CMS_USERS_PROFILE' => 'Profile',
	'CMS_USERS_CONFIG' => 'Configuration',
	'CMS_USERS_CONFIG_TEXT' => 'From this page you can edit configuration settings for your CMS and blocks',
	'CMS_USERS_USERLIST' => 'Users List',
	'CMS_USERS_USERLIST_TEXT' => 'CMS Users List',
	'CMS_USERS_USERLIST_NEW' => 'Inactive Users',
	'CMS_USERS_B_GLOBAL' => 'Allow all users to use this block',
	'CMS_USERS_URL' => 'URL',
	'CMS_USERS_ACCOUNT' => 'Account type',
	'CMS_USERS_PAGE_NUMBERS' => 'pages number',
	'CMS_USERS_LAST_UPDATE' => 'Last update',

	'CMS_USER' => 'Username',
	'CMS_AUTH' => 'Permissions',
	'CMS_AUTH_TEXT' => 'In this page you can view and set permissions for administrators, moderators, users and groups. Permissions are based on a simple <samp>YES</samp>/<samp>NO</samp> system. Setting an option to <samp>NEVER</samp> for a user or usergroup overrides any other value assigned to it. If you do not wish to assign a value for an option for this user or group select <samp>NO</samp>. If values are assigned for this option elsewhere they will be used in preference, else <samp>NEVER</samp> is assumed.',
	'CMS_AUTH_XP' => 'Special permissions',
	'CMS_ROLE' => 'Role',
	'CMS_ROLES' => 'Roles',
	'CMS_AUTH_ADD' => 'Add user',
	'CMS_SAVE' => 'Save',
	'CMS_NO_AUTH' => 'You didn\'t set any special permission',
	'CMS_NO_ROLE' => 'You didn\'t set any role',

	'CMS_PERMISSIONS_ADMINS' => 'Administrators Permissions',
	'CMS_PERMISSIONS_ADMINS_EXPLAIN' => 'View Administrators Permissions',
	'CMS_PERMISSIONS_MODS' => 'Moderators Permissions',
	'CMS_PERMISSIONS_MODS_EXPLAIN' => 'View Moderators Permissions',
	'CMS_PERMISSIONS_CMS_USERS' => 'Users CMS Permissions',
	'CMS_PERMISSIONS_CMS_USERS_EXPLAIN' => 'View Users CMS Permissions',
	'CMS_PERMISSIONS_CMS_GROUPS' => 'Groups CMS Permissions',
	'CMS_PERMISSIONS_CMS_GROUPS_EXPLAIN' => 'View Groups CMS Permissions',
	'CMS_PERMISSIONS_PLUGINS_USERS' => 'Users Plugins Permissions',
	'CMS_PERMISSIONS_PLUGINS_USERS_EXPLAIN' => 'View Users Plugins Permissions',
	'CMS_PERMISSIONS_PLUGINS_GROUPS' => 'Groups Plugins Permissions',
	'CMS_PERMISSIONS_PLUGINS_GROUPS_EXPLAIN' => 'View Groups Plugins Permissions',
	'CMS_PERMISSIONS_USERS' => 'Users Permissions',
	'CMS_PERMISSIONS_USERS_EXPLAIN' => 'View Users Permissions',
	'CMS_PERMISSIONS_GROUPS' => 'Groups Permissions',
	'CMS_PERMISSIONS_GROUPS_EXPLAIN' => 'View Groups Permissions',

	'CMS_AUTH_ADMINS' => 'Administrators',
	'CMS_AUTH_ADMINS_EXPLAIN' => 'Permissions for users with administration levels',
	'CMS_AUTH_MODS' => 'Moderators',
	'CMS_AUTH_MODS_EXPLAIN' => 'Permissions for moderators',
	'CMS_AUTH_CMS_USERS' => 'CMS Users',
	'CMS_AUTH_CMS_USERS_EXPLAIN' => 'Global CMS permissions for users',
	'CMS_AUTH_CMS_GROUPS' => 'CMS Groups',
	'CMS_AUTH_CMS_GROUPS_EXPLAIN' => 'Global CMS permissions for groups',
	'CMS_AUTH_CMS_USERS_LOCAL' => 'CMS Users [Local]',
	'CMS_AUTH_CMS_USERS_LOCAL_EXPLAIN' => 'Specific CMS permissions for users',
	'CMS_AUTH_CMS_GROUPS_LOCAL' => 'CMS Groups [Local]',
	'CMS_AUTH_CMS_GROUPS_LOCAL_EXPLAIN' => 'Specific CMS permissions for groups',
	'CMS_AUTH_PLUGINS_USERS' => 'Plugins Users',
	'CMS_AUTH_PLUGINS_USERS_EXPLAIN' => 'Global Plugins permissions for users',
	'CMS_AUTH_PLUGINS_GROUPS' => 'Plugins Groups',
	'CMS_AUTH_PLUGINS_GROUPS_EXPLAIN' => 'Global Plugins permissions for groups',
	'CMS_AUTH_USERS' => 'Users',
	'CMS_AUTH_USERS_EXPLAIN' => 'Global permissions for users',
	'CMS_AUTH_GROUPS' => 'Groups',
	'CMS_AUTH_GROUPS_EXPLAIN' => 'Global permissions for groups',

	'CMS_AUTH_CMS_USERS_GROUPS' => 'CMS',
	'CMS_AUTH_CMS_USERS_GROUPS_EXPLAIN' => 'CMS permissions for users and groups',
	'CMS_AUTH_CMS_USERS_GROUPS_LOCAL' => 'CMS [Local]',
	'CMS_AUTH_CMS_USERS_GROUPS_LOCAL_EXPLAIN' => 'CMS specific permissions for users and groups',
	'CMS_AUTH_PLUGINS_USERS_GROUPS' => 'Plugins',
	'CMS_AUTH_PLUGINS_USERS_GROUPS_EXPLAIN' => 'Plugins permissions for users and groups',
	'CMS_AUTH_USERS_GROUPS' => 'Global',
	'CMS_AUTH_USERS_GROUPS_EXPLAIN' => 'Global permissions for users and groups',

	'CMS_USERS_CMS_NEW' => 'Create your site',
	'CMS_USERS_CMS_EDIT' => 'Edit settings',

	'CMS_USERS_NO_LAYOUT' => 'Page you have selected doesn\'t exist',

	// BLOCKS CONFIG - BEGIN
	/*
	'cms_var_' => '',
	'cms_option_' => '',
	'cms_value_' => '',
	*/
	// BLOCKS VARS
	'cms_var_kb_cat_id' => 'Category ID',
	'cms_var_kb_cat_id_explain' => 'Choose the category ID for the KB (dynamic menu ID)',
	'cms_var_md_ads_type' => 'Ads type',
	'cms_var_md_ads_type_explain' => 'Select the ad type (H = Horizontal, V = Vertical, B = Box, 1 = Small, 2 = Medium, 3 = Large)',
	'cms_var_md_col' => 'Number of Columns',
	'cms_var_md_col_explain' => 'Select the number of index columns',
	'cms_var_md_news_cat_id' => 'Category To Retrieve News From',
	'cms_var_md_news_cat_id_explain' => 'Enter 0 for all categories or comma delimited entries',
	'cms_var_md_list_forum_id' => 'Category To Be Listed',
	'cms_var_md_list_forum_id_explain' => 'Enter 0 for all categories or comma delimited entries',
	'cms_var_md_display_not_visit' => 'Display users who did not visit',
	'cms_var_md_display_not_visit_explain' => 'Tick to display users who didn\'t visit the site',
	'cms_var_md_events_num' => 'Number of events to show',
	'cms_var_md_events_num_explain' => 'Number of events displayed',
	'cms_var_md_events_forums_id' => 'Forum IDs',
	'cms_var_md_events_forums_id_explain' => 'IDs of the forums to be processed (0 = All)',
	'cms_var_md_events_end' => 'Display end date',
	'cms_var_md_events_end_explain' => 'Choose if displaying the end date or not',
	'cms_var_md_flash_src' => 'Flash source file',
	'cms_var_md_flash_src_explain' => 'Insert the Flash file name',
	'cms_var_md_flash_id' => 'Flash ID',
	'cms_var_md_flash_id_explain' => 'Insert the ID for the HTML elements (use only lowercase letters and no space)',
	'cms_var_md_flash_w' => 'Width',
	'cms_var_md_flash_w_explain' => 'Flash file width',
	'cms_var_md_flash_h' => 'Height',
	'cms_var_md_flash_h_explain' => 'Flash file height',
	'cms_var_md_full_search_option_text' => 'Full search option text',
	'cms_var_md_full_search_option_text_explain' => 'Text displayed as the default option',
	'cms_var_md_gsearch_banner' => 'Search site banner',
	'cms_var_md_gsearch_banner_explain' => 'Banner of the site (the url without http://)',
	'cms_var_md_gsearch_site' => 'Search site',
	'cms_var_md_gsearch_site_explain' => 'Site where the search should be performed (the url without http://)',
	'cms_var_md_gsearch_style' => 'Search style',
	'cms_var_md_gsearch_style_explain' => 'Choose between horizontal and vertical',
	'cms_var_md_gsearch_text' => 'Search option text',
	'cms_var_md_gsearch_text_explain' => 'Text displayed as the default option',
	'cms_var_md_hours_track_users' => 'Number of hours to track users',
	'cms_var_md_hours_track_users_explain' => '',
	'cms_var_md_ignore_auth_view' => 'Ignore auth view permission?',
	'cms_var_md_ignore_auth_view_explain' => 'Enabling this forums view permissions will be ignored (this is important if you want to use hidden forums with NONE as view permission)',
	'cms_var_md_jumpbox_align' => 'Alignment',
	'cms_var_md_jumpbox_align_explain' => 'Select jumpbox alignment',
	'cms_var_md_menu_id' => 'Menu block ID',
	'cms_var_md_menu_id_explain' => 'Enter the ID of the menu block you want to show (0 = default).',
	'cms_var_md_menu_show_hide' => 'Show/Hide Switch',
	'cms_var_md_menu_show_hide_explain' => 'Enable Show/Hide switch to hide menu (it will work only on left GLOBAL block!!!).',
	'cms_var_md_news_number' => 'Number Of News To Display',
	'cms_var_md_news_number_explain' => '',
	'cms_var_md_news_sort' => 'Random Or Newest News?',
	'cms_var_md_news_sort_explain' => '',
	'cms_var_md_news_length' => 'Length of News',
	'cms_var_md_news_length_explain' => 'Number of characters displayed',
	'cms_var_md_news_archive_type' => 'Show Archive Or Categories?',
	'cms_var_md_news_archive_type_explain' => 'Choose if you want to show Archives or Categories',
	'cms_var_md_news_images_width' => 'News Image Width',
	'cms_var_md_news_images_width_explain' => 'Choose image width in pixels or percentage',
	'cms_var_md_news_forum_id' => 'News Forum ID(s)',
	'cms_var_md_news_forum_id_explain' => 'Comma delimited',
	'cms_var_md_news_length' => 'Length of news',
	'cms_var_md_news_length_explain' => 'Number of characters displayed (enter 0 for all)',
	'cms_var_md_news_posters_page_link' => 'Page Link',
	'cms_var_md_news_posters_page_link_explain' => 'The link to the page which contains news archive (i.e. <b>index.php</b>)',
	'cms_var_md_news_posters_sort' => 'Sort',
	'cms_var_md_news_posters_sort_explain' => 'Select the sort method',
	'cms_var_md_news_posters_avatar' => 'Show Avatars',
	'cms_var_md_news_posters_avatar_explain' => '',
	'cms_var_md_num_new_downloads' => 'New Downloads',
	'cms_var_md_num_new_downloads_explain' => 'Number of new downloads displayed',
	'cms_var_md_num_news' => 'Number of news on portal',
	'cms_var_md_num_news_explain' => '',
	'cms_var_md_num_posts' => 'Number of posts',
	'cms_var_md_num_posts_explain' => 'Number of posts to be displayed',
	'cms_var_md_num_random_topics' => 'Number of random topics',
	'cms_var_md_num_random_topics_explain' => 'Number of topics displayed',
	'cms_var_md_num_random_topics_ver' => 'Number of random topics',
	'cms_var_md_num_random_topics_ver_explain' => 'Number of topics displayed',
	'cms_var_md_num_recent_topics' => 'Number of recent topics',
	'cms_var_md_num_recent_topics_explain' => 'Number of topics displayed',
	'cms_var_md_num_recent_topics_wide' => 'Number Of Recent Topics',
	'cms_var_md_num_recent_topics_wide_explain' => 'Number of topics displayed',
	'cms_var_md_num_top_downloads' => 'Top Downloads',
	'cms_var_md_num_top_downloads_explain' => 'Number of top downloads displayed',
	'cms_var_md_paypal_donate_link' => 'Donate Link',
	'cms_var_md_paypal_donate_link_explain' => 'Link to Donation page',
	'cms_var_md_paypal_total_donors' => 'Show Total Donations Received',
	'cms_var_md_paypal_total_donors_explain' => 'Total donations received',
	'cms_var_md_paypal_total_amount' => 'Show Total Amount Received',
	'cms_var_md_paypal_total_amount_explain' => 'Total amount donated',
	'cms_var_md_poll_bar_length' => 'Poll Bar Length',
	'cms_var_md_poll_bar_length_explain' => 'Decrease/increase the value for 1 vote bar length',
	'cms_var_md_poll_forum_id' => 'Poll Forum ID(s)',
	'cms_var_md_poll_forum_id_explain' => 'Type the forum ID(s) comma delimited if you\'ve choosen latest or random poll',
	'cms_var_md_poll_topic_id' => 'Poll Topic ID',
	'cms_var_md_poll_topic_id_explain' => 'Type the topic ID if you\'ve choosen specific poll',
	'cms_var_md_poll_type' => 'Poll to display',
	'cms_var_md_poll_type_explain' => 'Choose if you want to show the latest poll, a random poll or a specific poll',
	'cms_var_md_posts_breadcrumbs' => 'Modify breadcrumbs?',
	'cms_var_md_posts_breadcrumbs_explain' => 'Enabling this will modify the breadcrumbs so that they follow the list and/or article',
	'cms_var_md_posts_forum_id' => 'Posts Forum ID(s)',
	'cms_var_md_posts_forum_id_explain' => 'Comma delimited',
	'cms_var_md_posts_length' => 'Length of posts',
	'cms_var_md_posts_length_explain' => 'Number of characters displayed',
	'cms_var_md_posts_random' => 'Recent, random or alphabetical?',
	'cms_var_md_posts_random_explain' => 'Select recent, random or alphabetical sorting for topics',
	'cms_var_md_posts_show_portal' => 'All topics or only marked?',
	'cms_var_md_posts_show_portal_explain' => 'Select all topics or only marked with "Show in Home Page"',
	'cms_var_md_posts_title' => 'Articles list title',
	'cms_var_md_posts_title_explain' => 'Enter the title of the articles list',
	'cms_var_md_ran_att_forums_excl' => 'Random Attach Exclude Forum ID(s)',
	'cms_var_md_ran_att_forums_excl_explain' => 'Comma delimited; leave blank for no exclusions',
	'cms_var_md_ran_att_forums_incl' => 'Random Attach Include Forum ID(s)',
	'cms_var_md_ran_att_forums_incl_explain' => 'Comma delimited; leave blank for all forums',
	'cms_var_md_ran_att_height' => 'Random Attach Max Height',
	'cms_var_md_ran_att_height_explain' => 'When the height > the width, this will be set as height in the img tag',
	'cms_var_md_ran_att_max' => 'Random Attach Max Files',
	'cms_var_md_ran_att_max_explain' => 'Maximum number of files to return',
	'cms_var_md_ran_att_width' => 'Random Attach Max Width',
	'cms_var_md_ran_att_width_explain' => 'When the width > the height, this will be set as width in the img tag',
	'cms_var_md_random_topics_style' => 'Random Topics Style',
	'cms_var_md_random_topics_style_explain' => 'Choose between static and scrolling',
	'cms_var_md_random_topics_forums' => 'Forum IDs',
	'cms_var_md_random_topics_forums_explain' => 'IDs of the forums to be processed (0 = all)',
	'cms_var_md_random_topics_ver_forums' => 'Forum IDs',
	'cms_var_md_random_topics_ver_forums_explain' => 'IDs of the forums to be processed (0 = all)',
	'cms_var_md_recent_articles_style' => 'Recent Articles Style',
	'cms_var_md_recent_articles_style_explain' => 'Choose between static and scrolling',
	'cms_var_md_recent_topics_style' => 'Recent Topics Style',
	'cms_var_md_recent_topics_style_explain' => 'Choose between static and scrolling',
	'cms_var_md_recent_topics_wide_style' => 'Recent Topics Style',
	'cms_var_md_recent_topics_wide_style_explain' => 'Choose between static and scrolling',
	'cms_var_md_rss_feeder' => 'RSS Feed Address',
	'cms_var_md_rss_feeder_explain' => 'Enter the address of the RSS feed (i.e. http://www.icyphoenix.com/rss.php)',
	'cms_var_md_rss_title' => 'RSS Feed Title',
	'cms_var_md_rss_title_explain' => 'Enter the title of the RSS feed (i.e. Icy Phoenix)',
	'cms_var_md_rss_style' => 'RSS Block Style',
	'cms_var_md_rss_style_explain' => 'Choose between horizontal and vertical',
	'cms_var_md_rss_scroll' => 'RSS Block Scroll',
	'cms_var_md_rss_scroll_explain' => 'Choose between static and scrolling',
	'cms_var_md_show_background' => 'Show Cats Background?',
	'cms_var_md_show_background_explain' => 'Select YES if you want to show cats background',
	'cms_var_md_show_cats_icon' => 'Show Cats Icons?',
	'cms_var_md_show_cats_icon_explain' => 'Select YES if you want to show cats icons',
	'cms_var_md_show_desc' => 'Show Links Descriptions?',
	'cms_var_md_show_desc_explain' => 'Select YES if you want to show links descriptions with mouse-hover effect',
	'cms_var_md_show_links_icon' => 'Show Links Icons?',
	'cms_var_md_show_links_icon_explain' => 'Select YES if you want to show links icons',
	'cms_var_md_show_sep_icon' => 'Show Separator Icons?',
	'cms_var_md_show_sep_icon_explain' => 'Select YES if you want to show separator icons',
	'cms_var_md_show_title' => 'Show Cats Title?',
	'cms_var_md_show_title_explain' => 'Select YES if you want to show cats title',
	'cms_var_md_single_post_auto_id' => 'Get ID From Address',
	'cms_var_md_single_post_auto_id_explain' => 'Enabling this will get the ID directly from address (post_id=XXX)',
	'cms_var_md_single_post_id' => 'Posts ID',
	'cms_var_md_single_post_id_explain' => 'Enter post ID',
	'cms_var_md_single_post_retrieve' => 'Retrieve Single Post',
	'cms_var_md_single_post_retrieve_explain' => 'Enabling this only one post will be shown, the one specified below, all other settings will be ignored',
	'cms_var_md_scroll_delay' => 'Scroll delay',
	'cms_var_md_scroll_delay_explain' => 'Higher values means slower scroll',
	'cms_var_md_search_option_text' => 'Search Field Description',
	'cms_var_md_search_option_text_explain' => 'Search field description',
	'cms_var_md_show_avatars' => 'Show Avatars',
	'cms_var_md_show_avatars_explain' => '',
	'cms_var_md_tags_count' => 'Display Tags Counts',
	'cms_var_md_tags_count_explain' => 'Display the total number of tags next to each word',
	'cms_var_md_tags_random' => 'Top Or Random?',
	'cms_var_md_tags_random_explain' => 'Choose whether top used or random tags will be displayed',
	'cms_var_md_tags_search' => 'Tags Search',
	'cms_var_md_tags_search_explain' => 'Display a search box for all tags',
	'cms_var_md_tags_words' => 'Maximum Tags',
	'cms_var_md_tags_words_explain' => 'Select the maximum number of tags to display',
	'cms_var_md_tla_display' => 'Horizontal / Vertical',
	'cms_var_md_tla_display_explain' => 'Choose whether ads are displayed horizontally or vertically',
	'cms_var_md_tla_inventory_key' => 'Text Link Ads Inventory Key',
	'cms_var_md_tla_inventory_key_explain' => 'Insert the inventory key for this page',
	'cms_var_md_tla_xml_filename' => 'Text Link Ads XML Filename',
	'cms_var_md_tla_xml_filename_explain' => 'Insert the full XML filename which should be located in <b>files/</b> folder (example: <i>local_XXXXXX.xml</i>)',
	'cms_var_md_top_likes_counter' => 'Display Likes Counts',
	'cms_var_md_top_likes_counter_explain' => 'Display the total number of likes the topic received',
	'cms_var_md_top_likes_hours' => 'Hours',
	'cms_var_md_top_likes_hours_explain' => 'Select the number of hours to check for posts likes',
	'cms_var_md_top_likes_topics' => 'Number Of Topics',
	'cms_var_md_top_likes_topics_explain' => 'Select the maximum number of Topics to display',
	'cms_var_md_total_articles' => 'Number of Recent Articles',
	'cms_var_md_total_articles_explain' => 'Number of articles shown',
	'cms_var_md_total_poster' => 'Number Of Top Posters',
	'cms_var_md_total_poster_explain' => '',
	'cms_var_md_wordgraph_count' => 'Display Tags Counts',
	'cms_var_md_wordgraph_count_explain' => 'Display the total number of tags next to each word',
	'cms_var_md_wordgraph_words' => 'Maximum Tags',
	'cms_var_md_wordgraph_words_explain' => 'Select the maximum number of tags to display',

	'cms_var_plugin_album_cat_id' => 'Category To Retrieve Pics From',
	'cms_var_plugin_album_cat_id_explain' => 'Enter 0 for all categories or comma delimited entries',
	'cms_var_plugin_album_pics_all' => 'Display From What Galleries?',
	'cms_var_plugin_album_pics_all_explain' => '',
	'cms_var_plugin_album_pics_cols_number' => 'Number Of Columns',
	'cms_var_plugin_album_pics_cols_number_explain' => '',
	'cms_var_plugin_album_pics_number' => 'Number Of Images To Display',
	'cms_var_plugin_album_pics_number_explain' => '',
	'cms_var_plugin_album_pics_rows_number' => 'Number Of Rows',
	'cms_var_plugin_album_pics_rows_number_explain' => '',
	'cms_var_plugin_album_pics_slider' => 'Create Slideshow',
	'cms_var_plugin_album_pics_slider_explain' => 'Creates a slideshow block with images selected',
	'cms_var_plugin_album_pics_sort' => 'Random Or Newest Pics?',
	'cms_var_plugin_album_pics_sort_explain' => '',
	'cms_var_plugin_guestbook_id' => 'Guestbook ID',
	'cms_var_plugin_guestbook_id_explain' => 'Enter guestbook ID you want to show',
	'cms_var_plugin_links_cat_id' => 'Category IDs',
	'cms_var_plugin_links_cat_id_explain' => 'Please specify the categories IDs (comma separated) where you want the links to be displayed (0 = all)',
	'cms_var_plugin_links_code' => 'Links -> Code',
	'cms_var_plugin_links_code_explain' => 'Show HTML for your own link button',
	'cms_var_plugin_links_own1' => 'Links -> Own (Top)',
	'cms_var_plugin_links_own1_explain' => 'Show your own link button above other buttons',
	'cms_var_plugin_links_own2' => 'Links -> Own (Bottom)',
	'cms_var_plugin_links_own2_explain' => 'Show your own link button below other buttons',
	'cms_var_plugin_links_style' => 'Links -> Style',
	'cms_var_plugin_links_style_explain' => 'Choose between static and scrolling',

	// BLOCKS OPTIONS
	'cms_option_24' => '24 Hours',
	'cms_option_48' => '48 Hours',
	'cms_option_72' => '72 Hours',
	'cms_option_96' => '96 Hours',
	'cms_option_120' => '120 Hours',
	'cms_option_144' => '144 Hours',
	'cms_option_168' => '168 Hours',
	'cms_option_All_Topics' => 'All Topics',
	'cms_option_Alphabetical' => 'Alphabetical',
	'cms_option_Archive' => 'Archive',
	'cms_option_Categories' => 'Categories',
	'cms_option_News' => 'News',
	'cms_option_Newest' => 'Newest',
	'cms_option_Public' => 'Public',
	'cms_option_Public_and_Personal' => 'Public and Personal',
	'cms_option_Random' => 'Random',
	'cms_option_Recent' => 'Recent',
	'cms_option_Scroll' => 'Scroll',
	'cms_option_Static' => 'Static',
	'cms_option_Top' => 'Top',
	'cms_option_Horizontal' => 'Horizontal',
	'cms_option_Vertical' => 'Vertical',
	'cms_option_Show_In_Portal' => 'Show in Home Page',
	'cms_option_Yes' => 'Yes',
	'cms_option_No' => 'No',
	'cms_option_Left' => 'Left',
	'cms_option_Center' => 'Centre',
	'cms_option_Right' => 'Right',

	// BLOCKS VALUES
	'cms_value_All_Topics' => '0',
	'cms_value_Archive' => '0',
	'cms_value_Categories' => '1',
	'cms_value_Newest' => '0',
	'cms_value_Public' => '0',
	'cms_value_Public_and_Personal' => '1',
	'cms_value_Random' => '1',
	'cms_value_Recent' => '0',
	'cms_value_Show_In_Portal' => '1',

	// BLOCKS POSITIONS
	'cms_pos_header' => 'Page Header',
	'cms_pos_headerleft' => 'Left',
	'cms_pos_headercenter' => 'Top/Centre',
	'cms_pos_footercenter' => 'Bottom/Centre',
	'cms_pos_footerright' => 'Right',
	'cms_pos_footer' => 'Page Footer',
	'cms_pos_nav' => 'Navigation Bar',
	'cms_pos_left' => 'Left',
	'cms_pos_center' => 'Centre',
	'cms_pos_right' => 'Right',
	'cms_pos_xsnews' => 'News (Centre)',
	'cms_pos_centerbottom' => 'Bottom/Centre',
	'cms_pos_toprow' => 'Top',
	'cms_pos_column1' => 'Column 1 (Left)',
	'cms_pos_column2' => 'Column 2 (Right)',
	'cms_pos_bottomrow' => 'Bottom',
	'cms_pos_gheader' => 'Global Header',
	'cms_pos_gfooter' => 'Global Footer',
	'cms_pos_ghtop' => 'Header Top',
	'cms_pos_ghbottom' => 'Header Bottom',
	'cms_pos_ghleft' => 'Header Centre (Left)',
	'cms_pos_ghright' => 'Header Centre (Right)',

	// BLOCKS GLOBAL VARS
	'cms_var_cms_style' => 'CMS Modern Style',
	'cms_var_cms_style_explain' => 'Modern Style for CMS consists in a modern layout with top transparent menu, while classic style has side menu',
	'cms_var_header_width' => 'Global Left Column Width',
	'cms_var_header_width_explain' => 'Width of site-wide left column in pixels (only for global blocks where applicable)',
	'cms_var_footer_width' => 'Global Right Column Width',
	'cms_var_footer_width_explain' => 'Width of site-wide right column in pixels (only for global blocks where applicable)',
	'cms_var_md_cache_file_locking' => 'Cache File Locking',
	'cms_var_md_cache_file_locking_explain' => 'Can avoid cache corruption under bad circumstances',
	'cms_var_md_cache_write_control' => 'Cache Write Control',
	'cms_var_md_cache_write_control_explain' => 'Detect some corrupt cache files',
	'cms_var_md_cache_read_control' => 'Cache Read Control',
	'cms_var_md_cache_read_control_explain' => 'A control key is embeded in cache file',
	'cms_var_md_cache_read_type' => 'Cache Read Control Type',
	'cms_var_md_cache_read_type_explain' => 'Type of read control (only if read control is enabled)',
	'cms_var_md_cache_filename_protect' => 'Cache File Name Protection',
	'cms_var_md_cache_filename_protect_explain' => 'Encrypt cache file names for higher security',
	'cms_var_md_cache_serialize' => 'Cache Automatic Serialization',
	'cms_var_md_cache_serialize_explain' => 'Enable / disable automatic serialization',
	// BLOCKS CONFIG - END

	// CMS AJAX
	'COPY_LAYOUT' => 'Copy Page',

	'AJAX_ERROR_WRONG_BLOCKS_LOCATION' => 'At least one of blocks had incorrect position. Incorrectly placed blocks were moved to another position.',
	'AJAX_BLOCK_TITLE' => 'Block Title',
	'AJAX_OPTION_ENABLED' => 'Enabled',
	'AJAX_OPTION_BORDER' => 'Border',
	'AJAX_OPTION_TITLE' => 'Titlebar',
	'AJAX_OPTION_LOCAL' => 'Localize Titlebar',
	'AJAX_OPTION_BACKGROUND' => 'Background',
	'AJAX_OPTION_ENABLED_EXPLAIN' => 'Click here to enable or disable the block',
	'AJAX_OPTION_BORDER_EXPLAIN' => 'Click here to enable or disable block border',
	'AJAX_OPTION_TITLE_EXPLAIN' => 'Click here to display or hide the title of the block',
	'AJAX_OPTION_LOCAL_EXPLAIN' => 'Click here to enable or disable block title translation (where translation available)',
	'AJAX_OPTION_BACKGROUND_EXPLAIN' => 'Click here to enable or disable block background',
	'AJAX_TIP_TITLE' => 'Click to edit block title.',
	'AJAX_TIP_MOVE' => 'Move this block. Press mouse button and move it up, down or to another section of this page, then release mouse button.',
	'AJAX_TIP_MOVE_ALL' => 'Move all blocks above to another section.',
	'AJAX_TIP_DELETE' => 'Click to delete this block.',
	'AJAX_TIP_ADD' => 'Add new block to this section.',
	'AJAX_TIP_CHANGE_TYPE' => 'Click to change contents of this block.',
	'AJAX_TIP_CHANGE_VIEW' => 'Click to change permissions.',
	'AJAX_BUTTON_CHANGE' => 'Change',
	'AJAX_BUTTON_CANCEL' => 'Cancel',
	'AJAX_BUTTON_RESTORE' => 'Undo Changes',
	'AJAX_BUTTON_ADD' => 'Add Block',
	'AJAX_BUTTON_MOVE_ALL' => 'Move All Blocks',
	'AJAX_PARENT_BLOCK' => 'Parent Block:',
	'AJAX_PARENT_BLOCK_NONE' => 'N/A',
	'AJAX_CONFIRM_DELETE' => 'Are you sure you want to remove this block? It cannot be undone.',
	'AJAX_REMOVED_BLOCK' => 'Block has been deleted.',
	'AJAX_SAVING_CHANGES' => 'Saving changes...',
	'AJAX_SAVING_CHANGES_DONE' => 'Saving changes... done.',
	'AJAX_STATUS_ADDING' => 'Adding block, please wait...',
	'AJAX_STATUS_ADDING_ERROR' => 'Error adding block!',
	'AJAX_ERROR_CONNECTION' => 'Error: Cannot connect to server.<br />There might be a technical problem at server, please try again later.',
	'AJAX_ERROR_PARSER' => 'Error: Invalid response from server.',
	'AJAX_MANAGE_BLOCKS' => 'Edit Parent Blocks',
	'AJAX_MOVE_ALL_SELECT' => 'Where to move blocks:',
	'AJAX_SELECT_TYPE' => 'Select block type',
	'AJAX_BLOCK_TYPE' => 'Block type:',
	'AJAX_SELECT_TYPE_FILE' => 'File',
	'AJAX_SELECT_TYPE_HTML' => 'HTML Code',
	'AJAX_SELECT_TYPE_BBCODE' => 'Text with BBCode',
	'AJAX_BLOCK_CONTENT' => 'Module content:',
	'AJAX_VIEWED_BY' => 'Viewed by',
	'AJAX_USERGROUPS' => 'User groups',
	'AJAX_USERGROUPS_ALL' => 'All',
	'AJAX_USERGROUPS_EDIT' => 'Edit user groups list',
	'AJAX_BLOCK_USED' => 'This block is being used on following pages:',
	'AJAX_BLOCK_USED_NONE' => 'This block is not being used on any pages.',
	'AJAX_BLOCK_USED_DELETE' => 'Delete',
	'AJAX_BLOCK_USED_LAYOUT' => 'Layout:',
	'AJAX_BLOCK_USED_LAYOUT_SPECIAL' => 'Page:',
	'AJAX_BLOCK_USED_LAYOUT_GLOBAL' => 'Global:',
	'AJAX_BLOCK_USED_CLICK' => 'Click to edit this layout.',
	'AJAX_EDIT_BLOCK_SETTINGS' => 'Edit Settings',
	'AJAX_EDIT_BLOCK_SETTINGS_TIP' => 'Click "Edit Settings" button above to change settings.',
	'AJAX_EDIT_BLOCK_SETTINGS_ALT' => 'Edit Parent Block',
	'AJAX_BLOCK_NOT_FOUND' => 'Block not found.',

	'AUTH' => array(
		'cms_view' => 'CMS Access',
		'cms_edit' => 'CMS Settings',
		'cms_l_add' => 'Add Pages',
		'cms_l_edit' => 'Edit Pages',
		'cms_l_delete' => 'Delete Pages',
		'cms_b_add' => 'Add Blocks',
		'cms_b_edit' => 'Edit Blocks',
		'cms_b_delete' => 'Delete Blocks',
	),

	)
);

?>