<?php
/**
*
* @package Icy Phoenix
* @version $Id$
* @copyright (c) 2008 Icy Phoenix
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
*
* @Icy Phoenix is based on phpBB
* @copyright (c) 2008 phpBB Group
*
*/

if (!defined('IN_ICYPHOENIX'))
{
	die('Hacking attempt');
}

function check_image_type(&$type, &$error, &$error_msg)
{
	global $lang;

	switch($type)
	{
		case 'jpeg':
		case 'pjpeg':
		case 'jpg':
			return '.jpg';
			break;
		case 'gif':
			return '.gif';
			break;
		case 'png':
			return '.png';
			break;
		default:
			$error = true;
			$error_msg = (!empty($error_msg)) ? $error_msg . '<br />' . $lang['Avatar_filetype'] : $lang['Avatar_filetype'];
			break;
	}

	return false;
}

function user_avatar_delete($avatar_type, $avatar_file)
{
	global $config, $user;

	$avatar_file = basename($avatar_file);
	if ($avatar_type == USER_AVATAR_UPLOAD && $avatar_file != '')
	{
		if (@file_exists(@phpbb_realpath('./' . $config['avatar_path'] . '/' . $avatar_file)))
		{
			@unlink('./' . $config['avatar_path'] . '/' . $avatar_file);
		}
	}

	return ", user_avatar = '', user_avatar_type = " . USER_AVATAR_NONE;
}

function user_avatar_gallery($mode, &$error, &$error_msg, $avatar_filename, $avatar_category)
{
	global $db, $cache, $config;

	$avatar_filename = ltrim(basename($avatar_filename), "'");
	$avatar_category = ltrim(basename($avatar_category), "'");

	if(!preg_match('/(\.gif$|\.png$|\.jpg|\.jpeg)$/is', $avatar_filename))
	{
		return '';
	}

	if ($avatar_filename == "" || $avatar_category == "")
	{
		return '';
	}

	if (file_exists(@phpbb_realpath($config['avatar_gallery_path'] . '/' . $avatar_category . '/' . $avatar_filename)) && ($mode == 'editprofile'))
	{
		$return = ", user_avatar = '" . $db->sql_escape($avatar_category . '/' . $avatar_filename) . "', user_avatar_type = " . USER_AVATAR_GALLERY;
	}
	else
	{
		$return = '';
	}
	return $return;
}

function user_avatar_generator($mode, &$error, &$error_msg, $avatar_filename)
{
	global $db, $cache, $config;

	$new_filename = uniqid(rand()) . '.gif';

	@copy($avatar_filename, './' . $config['avatar_path'] . '/' . $new_filename);
	@unlink($avatar_filename);

	$avatar_sql = ($mode == 'editprofile') ? ", user_avatar = '" . $db->sql_escape($new_filename) . "', user_avatar_type = " . USER_AVATAR_UPLOAD : "'" . $db->sql_escape($new_filename) . "', " . USER_AVATAR_UPLOAD;

	return $avatar_sql;
}

function user_avatar_url($mode, &$error, &$error_msg, $avatar_filename)
{
	global $db, $cache, $config, $lang;

	if (!preg_match('#^(http)|(ftp):\/\/#i', $avatar_filename))
	{
		$avatar_filename = 'http://' . $avatar_filename;
	}
	$avatar_filename = substr($avatar_filename, 0, 100);

	if (!preg_match("#^((ht|f)tp://)([^ \?&=\#\"\n\r\t<]*?(\.(jpg|jpeg|gif|png))$)#is", $avatar_filename))
	{
		$error = true;
		$error_msg = (!empty($error_msg)) ? $error_msg . '<br />' . $lang['Wrong_remote_avatar_format'] : $lang['Wrong_remote_avatar_format'];
		return;
	}

// Start Remote Avatar Check Mod
	$remote_file = @fopen ($avatar_filename, 'rb');

	if(!$remote_file)
	{
		$error = true;
		$error_msg = sprintf($lang['Remote_avatar_no_image'], $avatar_filename);
		return;
	}

	$user_avatar_size = 0;
	do
	{
		if ((strlen(@fread($remote_file, 1)) == 0) || ($user_avatar_size > $config['avatar_filesize']))
		{
			break;
		}
		$user_avatar_size++;
	}
	while(true);
	@fclose($remote_file);

	if($user_avatar_size > $config['avatar_filesize'])
	{
		$error = true;
		$error_msg = sprintf($lang['Remote_avatar_error_filesize'], $config['avatar_filesize']);
		return;
	}

	list($user_avatar_width, $user_avatar_height) = @getimagesize($avatar_filename);

	if($user_avatar_width > $config['avatar_max_width'] || $user_avatar_height > $config['avatar_max_height'])
	{
		$error = true;
		$error_msg = sprintf($lang['Remote_avatar_error_dimension'], $config['avatar_max_width'], $config['avatar_max_height']);
		return;
	}
	// End Remote Avatar Check Mod
	return ($mode == 'editprofile') ? ", user_avatar = '" . $db->sql_escape($avatar_filename) . "', user_avatar_type = " . USER_AVATAR_REMOTE : '';

}

function user_avatar_upload($mode, $avatar_mode, &$current_avatar, &$current_type, &$error, &$error_msg, $avatar_filename, $avatar_realname, $avatar_filesize, $avatar_filetype)
{
	global $db, $cache, $config, $lang;

	$ini_val = (@phpversion() >= '4.0.0') ? 'ini_get' : 'get_cfg_var';

	$width = $height = 0;
	$type = '';
	if ($avatar_mode == 'remote' && preg_match('/^(http:\/\/)?([\w\-\.]+)\:?([0-9]*)\/([^ \?&=\#\"\n\r\t<]*?(\.(jpg|jpeg|gif|png)))$/', $avatar_filename, $url_ary))
	{
		if (empty($url_ary[4]))
		{
			$error = true;
			$error_msg = (!empty($error_msg)) ? $error_msg . '<br />' . $lang['Incomplete_URL'] : $lang['Incomplete_URL'];
			return;
		}

		$base_get = '/' . $url_ary[4];
		$port = (!empty($url_ary[3])) ? $url_ary[3] : 80;

		if (!($fsock = @fsockopen($url_ary[2], $port, $errno, $errstr)))
		{
			$error = true;
			$error_msg = (!empty($error_msg)) ? $error_msg . '<br />' . $lang['No_connection_URL'] : $lang['No_connection_URL'];
			return;
		}

		@fwrite($fsock, "GET $base_get HTTP/1.1\r\n");
		@fwrite($fsock, "HOST: " . $url_ary[2] . "\r\n");
		@fwrite($fsock, "Connection: close\r\n\r\n");

		unset($avatar_data);
		while(!@feof($fsock))
		{
			$avatar_data .= @fread($fsock, $config['avatar_filesize']);
		}
		@fclose($fsock);

		if (!preg_match('#Content-Length\: ([0-9]+)[^ /][\s]+#i', $avatar_data, $file_data1) || !preg_match('#Content-Type\: image/[x\-]*([a-z]+)[\s]+#i', $avatar_data, $file_data2))
		{
			$error = true;
			$error_msg = (!empty($error_msg)) ? $error_msg . '<br />' . $lang['File_no_data'] : $lang['File_no_data'];
			return;
		}

		$avatar_filesize = $file_data1[1];
		$avatar_filetype = $file_data2[1];

		if (!$error && $avatar_filesize > 0 && $avatar_filesize < $config['avatar_filesize'])
		{
			$avatar_data = substr($avatar_data, strlen($avatar_data) - $avatar_filesize, $avatar_filesize);

			$tmp_path = (!@$ini_val('safe_mode')) ? '/tmp' : './' . $config['avatar_path'] . '/tmp';
			$tmp_filename = tempnam($tmp_path, uniqid(rand()) . '-');

			$fptr = @fopen($tmp_filename, 'wb');
			$bytes_written = @fwrite($fptr, $avatar_data, $avatar_filesize);
			@fclose($fptr);

			if ($bytes_written != $avatar_filesize)
			{
				@unlink($tmp_filename);
				message_die(GENERAL_ERROR, 'Could not write avatar file to local storage. Please contact the board administrator with this message', '', __LINE__, __FILE__);
			}

			list($width, $height, $type) = @getimagesize($tmp_filename);
		}
		else
		{
			$l_avatar_size = sprintf($lang['Avatar_filesize'], round($config['avatar_filesize'] / 1024));

			$error = true;
			$error_msg = (!empty($error_msg)) ? $error_msg . '<br />' . $l_avatar_size : $l_avatar_size;
		}
	}
	elseif ((file_exists(@phpbb_realpath($avatar_filename))) && preg_match('/\.(jpg|jpeg|gif|png)$/i', $avatar_realname))
	{
		if ($avatar_filesize <= $config['avatar_filesize'] && $avatar_filesize > 0)
		{
			preg_match('#image\/[x\-]*([a-z]+)#', $avatar_filetype, $avatar_filetype);
			$avatar_filetype = $avatar_filetype[1];
		}
		else
		{
			$l_avatar_size = sprintf($lang['Avatar_filesize'], round($config['avatar_filesize'] / 1024));

			$error = true;
			$error_msg = (!empty($error_msg)) ? $error_msg . '<br />' . $l_avatar_size : $l_avatar_size;
			return;
		}

		list($width, $height, $type) = @getimagesize($avatar_filename);
	}

	if (!($imgtype = check_image_type($avatar_filetype, $error, $error_msg)))
	{
		return;
	}

	switch ($type)
	{
		// GIF
		case 1:
			if ($imgtype != '.gif')
			{
				@unlink($tmp_filename);
				message_die(GENERAL_ERROR, $lang['UNABLE_TO_UPLOAD_AVATAR'], '', __LINE__, __FILE__);
			}
		break;

		// JPG, JPC, JP2, JPX, JB2
		case 2:
		case 9:
		case 10:
		case 11:
		case 12:
			if (($imgtype != '.jpg') && ($imgtype != '.jpeg'))
			{
				@unlink($tmp_filename);
				message_die(GENERAL_ERROR, $lang['UNABLE_TO_UPLOAD_AVATAR'], '', __LINE__, __FILE__);
			}
		break;

		// PNG
		case 3:
			if ($imgtype != '.png')
			{
				@unlink($tmp_filename);
				message_die(GENERAL_ERROR, $lang['UNABLE_TO_UPLOAD_AVATAR'], '', __LINE__, __FILE__);
			}
		break;

		default:
			@unlink($tmp_filename);
			message_die(GENERAL_ERROR, $lang['UNABLE_TO_UPLOAD_AVATAR'], '', __LINE__, __FILE__);
	}

	// Automatic Avatar Resize - BEGIN
	// If you want tu use Avatar Resize function, you have to change the line below and decomment the block named AUTOMATIC AVATAR RESIZE some lines below.
	//if ($width > 0 && $height > 0)
	// Automatic Avatar Resize - END
	if (($width > 0) && ($height > 0) && ($width <= $config['avatar_max_width']) && ($height <= $config['avatar_max_height']))
	{
		$new_filename = uniqid(rand()) . $imgtype;

		if (($mode == 'editprofile') && ($current_type == USER_AVATAR_UPLOAD) && ($current_avatar != ''))
		{
			user_avatar_delete($current_type, $current_avatar);
		}

		if($avatar_mode == 'remote')
		{
			@copy($tmp_filename, './' . $config['avatar_path'] . "/$new_filename");
			@unlink($tmp_filename);
		}
		else
		{
			if (@$ini_val('open_basedir') != '')
			{
				if (@phpversion() < '4.0.3')
				{
					message_die(GENERAL_ERROR, 'open_basedir is set and your PHP version does not allow move_uploaded_file', '', __LINE__, __FILE__);
				}

				$move_file = 'move_uploaded_file';
			}
			else
			{
				$move_file = 'copy';
			}

			if (!is_uploaded_file($avatar_filename))
			{
				message_die(GENERAL_ERROR, 'Unable to upload file', '', __LINE__, __FILE__);
			}
			$move_file($avatar_filename, './' . $config['avatar_path'] . "/$new_filename");
		}

		@chmod('./' . $config['avatar_path'] . "/$new_filename", 0777);
		// Automatic Avatar Resize - BEGIN
		/*
		if ($width > $config['avatar_max_width'] || $height > $config['avatar_max_height'])
		{
			$width_old = $width;
			$height_old = $height;
			if ($width > $config['avatar_max_width'])
			{
				$height = ($config['avatar_max_width'] / $width) * $height;
				$width = $config['avatar_max_width'];
			}
			if ($height > $config['avatar_max_height'])
			{
				$width = ($config['avatar_max_height'] / $height) * $width;
				$height = $config['avatar_max_height'];
			}
			$width = round($width);   // to avoid float->integer conversion problems
			$height = round($height); // to avoid float->integer conversion problems
			switch ($imgtype)
			{
				case '.jpg':
					$imagecreatefrom_function = 'imagecreatefromjpeg';
					$image_function = 'imagejpeg';
					break;
				case '.gif':
					$imagecreatefrom_function = 'imagecreatefromgif';
					$image_function = 'imagegif';
					break;
				case '.png':
					$imagecreatefrom_function = 'imagecreatefrompng';
					$image_function = 'imagepng';
					break;
			}
			$img_old = $imagecreatefrom_function ('./' . $config['avatar_path'] . "/$new_filename");
			$img_new = imagecreatetruecolor ($width, $height);
			imagecopyresampled ($img_new, $img_old, 0, 0, 0, 0, $width, $height, $width_old, $height_old);
			$image_function ($img_new, './' . $config['avatar_path'] . "/$new_filename");
			imagedestroy ($img_new);
		}
		*/
		// Automatic Avatar Resize - END

		$avatar_sql = ($mode == 'editprofile') ? ", user_avatar = '" . $db->sql_escape($new_filename) . "', user_avatar_type = " . USER_AVATAR_UPLOAD : "'" . $db->sql_escape($new_filename) . "', " . USER_AVATAR_UPLOAD;
	}
	else
	{
		$l_avatar_size = sprintf($lang['Avatar_imagesize'], $config['avatar_max_width'], $config['avatar_max_height']);

		$error = true;
		$error_msg = (!empty($error_msg)) ? $error_msg . '<br />' . $l_avatar_size : $l_avatar_size;
	}

	return $avatar_sql;
}

function display_avatar_gallery($mode, &$category, &$user_id, &$email, &$current_email, &$email_confirm, &$coppa, &$username, &$new_password, &$cur_password, &$password_confirm, &$this_user_im, &$website, &$location, &$user_flag, &$user_first_name, &$user_last_name, &$occupation, &$interests, &$phone, &$selfdes, &$signature, &$viewemail, &$notifypm, &$popup_pm, &$notifyreply, &$attachsig, &$setbm, &$allowhtml, &$allowbbcode, &$allowsmilies, &$showavatars, &$showsignatures, &$allowswearywords, &$allowmassemail, &$allowpmin, &$hideonline, &$style, &$language, &$timezone, &$time_mode, &$dst_time_lag, &$dateformat, &$profile_view_popup, &$session_id, &$birthday, &$gender, &$upi2db_which_system, &$upi2db_new_word, &$upi2db_edit_word, &$upi2db_unread_color)
{
	global $db, $cache, $config, $template, $images, $theme, $lang;

	$my_counter = 0;
	$my_checker = 0;
	$sql = "SELECT user_avatar
		FROM " . USERS_TABLE . "
		WHERE user_avatar_type = 3";
	$result = $db->sql_query($sql);

	while($row = $db->sql_fetchrow($result))
	{
		$my_counter++;
		$my_used_list[$my_counter] = $row['user_avatar'];
	}
	$db->sql_freeresult($result);

	$dir = @opendir(IP_ROOT_PATH . $config['avatar_gallery_path']);

	$avatar_folders = array();
	$avatar_images = array();
	while($file = @readdir($dir))
	{
		if(($file != '.') && ($file != '..') && !is_file($config['avatar_gallery_path'] . '/' . $file) && !is_link($config['avatar_gallery_path'] . '/' . $file))
		{
			$avatar_folders[] = $file;
		}
	}
	@closedir($dir);

	if (empty($avatar_folders))
	{
		message_die(GENERAL_MESSAGE, 'NO_AVATAR_GALLERY');
	}

	@sort($avatar_folders);
	@reset($avatar_folders);

	foreach ($avatar_folders as $avatar_folder)
	{
		$sub_dir = @opendir(IP_ROOT_PATH . $config['avatar_gallery_path'] . '/' . $avatar_folder);

		$avatar_row_count = 0;
		$avatar_col_count = 0;
		while($sub_file = @readdir($sub_dir))
		{
		$my_checker = 0;
		for ($i = 1; $i<= $my_counter; $i++)
		{
			$my_temp = $avatar_folder . '/' . $sub_file;
			if ($my_temp == $my_used_list[$i])
			{
				$my_checker = 1;
			}
			if ($my_checker==1)
			{
				break;
			}
		}
			if ($my_checker == 0)
			{
				if(preg_match('/(\.gif$|\.png$|\.jpg|\.jpeg)$/is', $sub_file))
				{
					$avatar_images[$avatar_folder][$avatar_row_count][$avatar_col_count] = $sub_file;
					$avatar_name[$avatar_folder][$avatar_row_count][$avatar_col_count] = ucfirst(str_replace("_", " ", preg_replace('/^(.*)\..*$/', '\1', $sub_file)));
					$avatar_col_count++;
					if($avatar_col_count == 5)
					{
						$avatar_row_count++;
						$avatar_col_count = 0;
					}
				}
			}
		}
	}
	@ksort($avatar_images);
	@reset($avatar_images);

	if(empty($category))
	{
		list($category,) = each($avatar_images);
	}
	@reset($avatar_images);

	$s_categories = '<select name="avatarcategory">';
	while(list($key) = each($avatar_images))
	{
		$selected = ($key == $category) ? ' selected="selected"' : '';
		if(sizeof($avatar_images[$key]))
		{
			$s_categories .= '<option value="' . $key . '"' . $selected . '>' . ucfirst($key) . '</option>';
		}
	}
	$s_categories .= '</select>';

	$s_colspan = 0;
	for($i = 0; $i < sizeof($avatar_images[$category]); $i++)
	{
		$template->assign_block_vars('avatar_row', array());

		$s_colspan = max($s_colspan, sizeof($avatar_images[$category][$i]));

		for($j = 0; $j < sizeof($avatar_images[$category][$i]); $j++)
		{
			$template->assign_block_vars('avatar_row.avatar_column', array(
				'AVATAR_IMAGE' => IP_ROOT_PATH . $config['avatar_gallery_path'] . '/' . $category . '/' . $avatar_images[$category][$i][$j],
				'AVATAR_NAME' => $avatar_name[$category][$i][$j]
				)
			);

			$template->assign_block_vars('avatar_row.avatar_option_column', array(
				'S_OPTIONS_AVATAR' => $avatar_images[$category][$i][$j])
			);
		}
	}

	$params = array('coppa', 'user_id', 'username', 'email', 'current_email', 'email_confirm', 'cur_password', 'new_password', 'password_confirm', 'website', 'location', 'user_flag', 'user_first_name', 'user_last_name', 'occupation', 'interests', 'phone', 'selfdes', 'signature', 'viewemail', 'notifypm', 'popup_pm', 'notifyreply', 'attachsig', 'setbm', 'allowhtml', 'allowbbcode', 'allowsmilies', 'showavatars', 'showsignatures', 'allowswearywords', 'allowmassemail', 'allowpmin', 'hideonline', 'style', 'language', 'timezone', 'time_mode', 'dst_time_lag', 'dateformat', 'profile_view_popup', 'birthday', 'gender', 'upi2db_which_system', 'upi2db_new_word', 'upi2db_edit_word', 'upi2db_unread_color');

	$s_hidden_vars = '<input type="hidden" name="sid" value="' . $session_id . '" /><input type="hidden" name="agreed" value="true" /><input type="hidden" name="avatarcatname" value="' . $category . '" />';
	$s_hidden_vars .= '<input type="hidden" name="user_id" value="' . $user->data['user_id'] . '" />';
	for($i = 0; $i < sizeof($params); $i++)
	{
		$s_hidden_vars .= '<input type="hidden" name="' . $params[$i] . '" value="' . str_replace('"', '&quot;', $$params[$i]) . '" />';
	}

	foreach ($this_user_im as $k => $v)
	{
		$s_hidden_vars .= '<input type="hidden" name="' . $k . '" value="' . str_replace('"', '&quot;', $v) . '" />';
	}

	$template->assign_vars(array(
		'L_PROFILE' => $lang['Profile'],
		//'L_PROFILE' => $lang['Cpl_Navigation'],
		'L_CPL_NAV2' => $lang['Avatar_panel'],
		'L_AVATAR_GALLERY' => $lang['Avatar_gallery'],
		'L_SELECT_AVATAR' => $lang['Select_avatar'],
		'L_RETURN_PROFILE' => $lang['Return_profile'],
		'L_CATEGORY' => $lang['Select_category'],
		'U_PROFILE2' => append_sid(CMS_PAGE_PROFILE . '?mode=editprofile&amp;cpl_mode=avatar'),
		'S_CATEGORY_SELECT' => $s_categories,
		'S_COLSPAN' => $s_colspan,
		'S_PROFILE_ACTION' => append_sid(CMS_PAGE_PROFILE . '?mode=' . $mode . '&amp;cpl_mode=avatar'),

		'L_USER_TITLE' => $lang['User_admin'],
		'L_USER_EXPLAIN' => $lang['User_admin_explain'],
		'S_ACP_PROFILE_ACTION' => append_sid('admin_users.' . PHP_EXT . '?mode=' . $mode),

		'S_HIDDEN_FIELDS' => $s_hidden_vars
		)
	);

	return;
}

function display_avatar_generator($mode, &$avatar_filename, &$avatar_image, &$avatar_text, &$user_id, &$email, &$current_email, &$email_confirm, &$coppa, &$username, &$new_password, &$cur_password, &$password_confirm, &$this_user_im, &$website, &$location, &$user_flag, &$user_first_name, &$user_last_name, &$occupation, &$interests, &$phone, &$selfdes, &$signature, &$viewemail, &$notifypm, &$popup_pm, &$notifyreply, &$attachsig, &$setbm, &$allowhtml, &$allowbbcode, &$allowsmilies, &$showavatars, &$showsignatures, &$allowswearywords, &$allowmassemail, &$allowpmin, &$hideonline, &$style, &$language, &$timezone, &$time_mode, &$dst_time_lag, &$dateformat, &$profile_view_popup, &$session_id, &$birthday, &$gender, &$upi2db_which_system, &$upi2db_new_word, &$upi2db_edit_word, &$upi2db_unread_color)
{
	global $db, $cache, $config, $template, $images, $theme, $lang;

	$params = array('coppa', 'user_id', 'username', 'email', 'current_email', 'email_confirm', 'cur_password', 'new_password', 'password_confirm', 'website', 'location', 'user_flag', 'user_first_name', 'user_last_name', 'occupation', 'interests', 'phone', 'selfdes', 'signature', 'viewemail', 'notifypm', 'popup_pm', 'notifyreply', 'attachsig', 'setbm', 'allowhtml', 'allowbbcode', 'allowsmilies', 'showavatars', 'showsignatures', 'allowswearywords', 'allowmassemail', 'allowpmin', 'hideonline', 'style', 'language', 'timezone', 'time_mode', 'dst_time_lag', 'dateformat', 'profile_view_popup', 'birthday', 'gender', 'upi2db_which_system', 'upi2db_new_word', 'upi2db_edit_word', 'upi2db_unread_color');
	$s_hidden_vars = '<input type="hidden" name="sid" value="' . $session_id . '" /><input type="hidden" name="agreed" value="true" /><input type="hidden" name="avatar_filename" value="' . $avatar_filename . '" />';
	$s_hidden_vars .= '<input type="hidden" name="user_id" value="' . $user->data['user_id'] . '" />';

	for($i = 0; $i < sizeof($params); $i++)
	{
		$s_hidden_vars .= '<input type="hidden" name="' . $params[$i] . '" value="' . str_replace('"', '&quot;', $$params[$i]) . '" />';
	}

	foreach ($this_user_im as $k => $v)
	{
		$s_hidden_vars .= '<input type="hidden" name="' . $k . '" value="' . str_replace('"', '&quot;', $v) . '" />';
	}

	$template->assign_vars(array(
		'L_PROFILE' => $lang['Profile'],
		//'L_PROFILE' => $lang['Cpl_Navigation'],
		'L_CPL_NAV2' => $lang['Avatar_panel'],
		'U_PROFILE2' => append_sid(CMS_PAGE_PROFILE . '?mode=editprofile&cpl_mode=avatar'),
		'L_AVATAR_GENERATOR' => $lang['Avatar_Generator'],
		'L_RANDOM' => $lang['Random'],
		'L_YOUR_AVATAR' => $lang['Your_Avatar'],
		'L_AVATAR_TEXT' => $lang['Avatar_Text'],
		'L_PREVIEW_AVATAR' => $lang['Avatar_Preview'],
		'L_SUBMIT_AVATAR' => $lang['Submit_Avatar'],
		'L_RETURN_PROFILE' => $lang['Return_profile'],
		'AVATAR_VERSION' => $config['avatar_generator_version'],
		'AVATAR_TEMPLATE_PATH' => $config['avatar_generator_template_path'],
		'AVATAR_FILENAME' => $avatar_filename,

		'S_IMAGE_NAME' => $avatar_image,
		'S_IMAGE_TEXT' => $avatar_text,
		'S_PROFILE_ACTION' => append_sid(CMS_PAGE_PROFILE . '?mode=' . $mode . '&cpl_mode=avatar'),
		'S_HIDDEN_FIELDS' => $s_hidden_vars
		)
	);

	return;
}

?>