<?php
/**
*
* @package Icy Phoenix
* @version $Id$
* @copyright (c) 2008 Icy Phoenix
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
*
* @Icy Phoenix is based on phpBB
* @copyright (c) 2008 phpBB Group
*
*/

/**
*
* @Extra credits for this file
* Lopalong
*
*/

if (!defined('IN_ICYPHOENIX'))
{
	exit;
}

//
// To add an entry to your FAQ simply add a line to this file in this format:
// $faq[] = array("question", "answer");
// If you want to separate a section enter $faq[] = array("--","Block heading goes here if wanted");
// Links will be created automatically
//
// DO NOT forget the ; at the end of the line.
// Do NOT put double quotes (") in your FAQ entries, if you absolutely must then escape them ie. \"something\"
// The FAQ items will appear on the FAQ page in the same order they are listed in this file


$faq[] = array("--","Login and Registration Issues");
$faq[] = array("Why can't I log in?", "Have you registered? Seriously, you must register in order to log in. Have you been banned from the board? (A message will be displayed if you have.) If so, you should contact the webmaster or board administrator to find out why. If you have registered and are not banned and you still cannot log in, then check and double-check your username and password. Usually this is the problem; if not, contact the board administrator -- they may have incorrect configuration settings for the board.");
$faq[] = array("Why do I need to register at all?", "You may not have to -- it is up to the administrator of the board as to whether you need to register in order to post messages. However, registration will give you access to additional features not available to guest users such as definable avatar images, private messaging, emailing to fellow users, usergroup subscription, etc. It only takes a few minutes to register so it is recommended you do so.");
$faq[] = array("Why do I get logged off automatically?", "If you do not check the <i>Log me in automatically</i> box when you log in, the board will only keep you logged in for a preset time. This prevents misuse of your account by anyone else. To stay logged in, check the box during login. This is not recommended if you access the board from a shared computer, e.g. library, internet cafe, university cluster, etc.");
$faq[] = array("How do I prevent my username from appearing in the online user listings?", "In your profile you will find an option <i>Hide your online status</i>; and if you switch this <i>on</i> you'll only appear to board administrators or to yourself. You will be counted as a hidden user.");
$faq[] = array("I've lost my password!", "Don't panic! While your password cannot be retrieved it can be reset. To do this go to the login page and click <u>I've forgotten my password</u>. Follow the instructions and you should be back online in no time.");
$faq[] = array("I registered but cannot log in!", "First check that you are entering the correct username and password. If they are okay then one of two things may have happened: If COPPA support is enabled and you clicked the <u>I am under 13 years old</u> link while registering then you will have to follow the instructions you received. If this is not the case then maybe your account needs activating. Some boards will require all new registrations be activated, either by yourself or by the administrator before you can log on. When you registered it would have told you whether activation was required. If you were sent an email then follow the instructions; If you did not receive the email then check that your email address is valid. One reason activation is used is to reduce the possibility of <i>rogue</i> users abusing the board anonymously. If you are sure the email address you used is valid then try contacting the board administrator.");
$faq[] = array("I registered in the past but cannot log in now!", "The most likely reasons for this are: You entered an incorrect username or password (check the email you were sent when you first registered) or the administrator has deleted your account for some reason. If it is the latter case then perhaps you did not post anything? It is usual for boards to periodically remove users who have not posted anything so as to reduce the size of the database. Try registering again and get involved in discussions.");


$faq[] = array("--","User Preferences and settings");
$faq[] = array("How do I change my settings?", "All your settings (if you are registered) are stored in the database. To alter them click the <u>Profile</u> link (generally shown at the top of pages but this may not be the case). This will allow you to change all your settings.");
$faq[] = array("The times are not correct!", "The times are almost certainly correct; however, what you may be seeing are times displayed in a timezone different from the one you are in. If this is the case, you should change your profile setting for the timezone to match your particular area, e.g. London, Paris, New York, Sydney, etc. Please note that changing the timezone, like most settings, can only be done by registered users. So if you are not registered, this is a good time to do so, if you pardon the pun!");
$faq[] = array("I changed the timezone and the time is still wrong!", "If you are sure you have set the timezone correctly and the time is still different, the most likely answer is daylight-saving time (or summer time as it is known in the UK and other places). The board is not designed to handle the changeover between standard and daylight time so during summer months the time may be an hour different from the real local time.");
$faq[] = array("My language is not in the list!", "The most likely reasons for this are either the administrator did not install your language or someone has not translated this board into your language. Try asking the board administrator if they can install the language pack you need or if it does not exist, please feel free to create a new translation. More information can be found at the Icy Phoenix Group website (see link at bottom of pages)");
$faq[] = array("How do I show an image below my username?", "There may be two images below a username when viewing posts. The first is an image associated with your rank; generally these take the form of stars or blocks indicating how many posts you have made or your status on the forums. Below this may be a larger image known as an avatar; this is generally unique or personal to each user. It is up to the board administrator to enable avatars and they have a choice over the way in which avatars can be made available. If you are unable to use avatars then this is the decision of the board admin and you should ask them their reasons (we're sure they'll be good!)");
$faq[] = array("How do I change my rank?", "In general you cannot directly change the wording of any rank (ranks appear below your username in topics and on your profile depending on the style used). Most boards use ranks to indicate the number of posts you have made and to identify certain users. For example, moderators and administrators may have a special rank. Please do not abuse the board by posting unnecessarily just to increase your rank -- you will probably find the moderator or administrator will simply lower your post count.");
$faq[] = array("When I click the email link for a user it asks me to log in.", "Sorry, but only registered users can send email to people via the built-in email form (if the admin has enabled this feature). This is to prevent malicious use of the email system by anonymous users.");

$faq[] = array("--","Posting Issues");
$faq[] = array("How do I post a topic in a forum?", "Easy -- click the relevant button on either the forum or topic screens. You may need to register before you can post a message. The facilities available to you are listed at the bottom of the forum and topic screens (the <i>You can post new topics, You can vote in polls, etc.</i> list)");
$faq[] = array("How do I edit or delete a post?", "Unless you are the board admin or forum moderator you can only edit or delete your own posts. You can edit a post (sometimes for only a limited time after it was made) by clicking the <i>edit</i> button for the relevant post. If someone has already replied to the post, you will find a small piece of text output below the post when you return to the topic that lists the number of times you edited it. This will only appear if no one has replied; it also will not appear if moderators or administrators edit the post (they should leave a message saying what they altered and why). Please note that normal users cannot delete a post once someone has replied.");
$faq[] = array("How do I add a signature to my post?", "To add a signature to a post you must first create one; this is done via your profile. Once created you can check the <i>Add Signature</i> box on the posting form to add your signature. You can also add a signature by default to all your posts by checking the appropriate radio box in your profile. You can still prevent a signature being added to individual posts by un-checking the add signature box on the posting form.");
$faq[] = array("How do I create a poll?", "Creating a poll is easy -- when you post a new topic (or edit the first post of a topic, if you have permission) you should see a <i>Add Poll</i> form below the main posting box. If you cannot see this then you probably do not have rights to create polls. You should enter a title for the poll and then at least two options -- to set an option type in the poll question and click the <i>Add option</i> button. You can also set a time limit for the poll, 0 being an infinite amount. There will be a limit to the number of options you can list, which is set by the board administrator");
$faq[] = array("How do I edit or delete a poll?", "As with posts, polls can only be edited by the original poster, a moderator, or board administrator. To edit a poll, click the first post in the topic, which always has the poll associated with it. If no one has cast a vote then users can delete the poll or edit any poll option. However, if people have already placed votes only moderators or administrators can edit or delete it; this is to prevent people rigging polls by changing options mid-way through a poll");
$faq[] = array("Why can't I access a forum?", "Some forums may be limited to certain users or groups. To view, read, post, etc. you may need special authorization which only the forum moderator and board administrator can grant, so you should contact them.");
$faq[] = array("Why can't I vote in polls?", "Only registered users can vote in polls so as to prevent spoofing of results. If you have registered and still cannot vote then you probably do not have appropriate access rights.");

$faq[] = array("--","Formatting and Topic Types");
$faq[] = array("What is BBCode?", "BBCode is a special implementation of HTML. Whether you can use BBCode is determined by the administrator. You can also disable it on a per post basis from the posting form. BBCode itself is similar in style to HTML: tags are enclosed in square braces [ and ] rather than &lt; and &gt; and it offers greater control over what and how something is displayed. For more information on BBCode see the guide which can be accessed from the posting page (or clicking this link: <a href=\"faq.php?mode=bbcode\">BBCode Help</a>).");
$faq[] = array("Can I use HTML?", "That depends on whether the administrator allows you to; they have complete control over it. If you are allowed to use it, you will probably find only certain tags work. This is a <i>safety</i> feature to prevent people from abusing the board by using tags which may destroy the layout or cause other problems. If HTML is enabled you can disable it on a per post basis from the posting form.");
$faq[] = array("What are Smileys?", "Smileys, or Emoticons, are small graphical images which can be used to express some feeling using a short code, e.g. :) means happy, :( means sad. The full list of emoticons can be seen via the posting form. Try not to overuse smileys, though, as they can quickly render a post unreadable and a moderator may decide to edit them out or remove the post altogether.");
$faq[] = array("Can I post Images?", "Images can indeed be shown in your posts. Admins may have enabled special features to upload images directly on this site and this may happen in three way: Attachments, Album and Upload Images. Album is best when you want your pictures being available also in galleries, and you have a better control on how thumbnails are generated (even the watermark may be included). Attachments and Upload Images features may be used directly when writing a post, and have different purpose. Uploading an image instead of \"attaching\" it is suitable when you want to control the insertion point of it... making your posts nicer. If admins have disabled all the facilities to upload images directly to this site, then you must link to an image stored on a publicly accessible web server, e.g. http://www.some-unknown-place.net/my-picture.gif. You cannot link to pictures stored on your own PC (unless it is a publicly accessible server) nor to images stored behind authentication mechanisms such as Hotmail or Yahoo mailboxes, password-protected sites, etc. To display the image use either the BBCode [img] tag or appropriate HTML (if allowed). Check BBCodes FAQ to learn how.");
$faq[] = array("What are Announcements?", "Announcements often contain important information and you should read them as soon as possible. Announcements appear at the top of every page in the forum to which they are posted. Whether or not you can post an announcement depends on the permissions required, which are set by the administrator. Global Announcements are special announcements which are shown on every forum, not only where they are posted.");
$faq[] = array("What are Sticky topics?", "Sticky topics appear below any announcements in viewforum and only on the first page. They are often quite important so you should read them where possible. As with announcements the board administrator determines what permissions are required to post sticky topics in each forum.");
$faq[] = array("What are Locked topics?", "Locked topics are set this way by either the forum moderator or board administrator. You cannot reply to locked topics and any poll contained inside is automatically ended. Topics may be locked for many reasons.");

$faq[] = array("--","User Levels and Groups");
$faq[] = array("What are Administrators?", "Administrators are people assigned the highest level of control over the entire board. These people can control all facets of board operation which include setting permissions, banning users, creating usergroups or moderators, etc. They also have full moderator capabilities in all the forums.");
$faq[] = array("What are Moderators?", "Moderators are individuals (or groups of individuals) whose job it is to look after the running of the forums from day to day. They have the power to edit or delete posts and lock, unlock, move, delete and split topics in the forum they moderate. Generally moderators are there to prevent people going <i>off-topic</i> or posting abusive or offensive material.");
$faq[] = array("What are Usergroups?", "Usergroups are a way in which board administrators can group users. Each user can belong to several groups (this differs from most other boards) and each group can be assigned individual access rights. This makes it easy for administrators to set up several users as moderators of a forum, or to give them access to a private forum, etc.");
$faq[] = array("How do I join a Usergroup?", "To join a usergroup click the usergroup link on the page header (dependent on template design) and you can then view all usergroups. Not all groups are <i>open access</i> -- some are closed and some may even have hidden memberships. If the board is open then you can request to join it by clicking the appropriate button. The user group moderator will need to approve your request; they may ask why you want to join the group. Please do not pester a group moderator if they turn your request down -- they will have their reasons.");
$faq[] = array("How do I become a Usergroup Moderator?", "Usergroups are initially created by the board administrator who also assigns a board moderator. If you are interested in creating a usergroup then your first point of contact should be the administrator, so try dropping them a private message.");

$faq[] = array("--","Private Messages");
$faq[] = array("I cannot send private messages!", "There are three reasons for this; you are not registered and/or not logged on, the board administrator has disabled private messaging for the entire board, or the board administrator has prevented you individually from sending messages. If it is the latter case you should try asking the administrator why.");
$faq[] = array("I keep getting unwanted private messages!", "In the future we will be adding an ignore list to the private messaging system. For now, though, if you keep receiving unwanted private messages from someone, inform the board administrator -- they have the power to prevent a user from sending private messages at all.");
$faq[] = array("I have received a spamming or abusive email from someone on this board!", "We are sorry to hear that. The email form feature of this board includes safeguards to try to track users who send such posts. You should email the board administrator with a full copy of the email you received and it is very important this include the headers (these list details of the user that sent the email). They can then take action.");

$faq[] = array("--","Avatar Generator");
$faq[] = array("What is it?", "The <strong>Avatar Generator</strong> is used to generate avatars which users can then use as their avatar");
$faq[] = array("Where I can find it?", "You may need to login to use the avatar generator. It is located in your profile in the avatar section.");
$faq[] = array("How do i save the avatar i have made?", "There should be a link beneath the avatar that has been generated, the link says <strong>Click Here to add this to your profile avatar</strong> once you click this you will have a message that appears informing you about the change.");

$faq[] = array("--","Attachments");
$faq[] = array("How do I add an attachment?", "You can add attachments when you post a new post. You should see a <i>Add an Attachment</i> form below the main posting box. When you click the <i>Browse...</i> button the standard Open dialogue window for your computer will open. Browse to the file you want to attach, select it and click OK, Open or double-click according to your liking and/or the correct procedure for your computer. If you choose to add a comment in the <i>File Comment</i> field this comment will be used as a link to the attached file. If you haven't added a comment the filename itself will be used to link to the attachment. If the board administrator has allowed it you will be able to upload multiple attachments by following the same procedure as described above until you reach the max allowed number of attachments for each post.<br /><br />The board administrator sets an upper limit for filesize, defined file extensions and other things for attachments on the board. Be aware that it's your responsibility that your attachments comply with the boards acceptance of use policy, and that they may be deleted without warning.<br /><br />Please note that the boards owner, webmaster, administrator or moderators can not and will not take responsibility for any loss of data.");
$faq[] = array("How do I add an attachment after the initial posting?", "To add an attachment after the initial posting you'll need to edit your post and follow the description above. The new attachment will be added when you click <i>Submit</i> to add the edited post.");
$faq[] = array("How do I delete an attachment?", "To delete attachments you'll need to edit your post and click on the <i>Delete Attachment</i> next to the attachment you want to delete in the <i>Posted Attachments</i> box. The attachment will be deleted when you click <i>Submit</i> to add the edited post.");
$faq[] = array("How do I update a file comment?", "To update a file comment you'll need to edit your post, edit the text in the <i>File Comment</i> field and click on the <i>Update Comment</i> button next to the file comment you want to update in the <i>Posted Attachments</i> box. The file comment will be updated when you click <i>Submit</i> to add the edited post.");
$faq[] = array("Why isn't my attachment visible in the post?", "Most probably the file or Extension is no longer allowed on the forum, or a moderator or administrator has deleted it for being in conflict with the boards acceptance of use policy.");
$faq[] = array("Why can't I add attachments?", "On some forums adding attachments may be limited to certain users or groups. To add attachments you may need special authorization, only the forum moderator and board admin can grant this access, you should contact them.");
$faq[] = array("I've got the necessary permissions, why can't I add attachments?", "The board administrator sets an upper limit for filesize, file extensions and other things for attachments on the board. A moderator or administrator may have altered your permissions, or discontinued attachments in the specific forum. You should get an explanation in the error message when trying to add an attachment, if not you might consider contacting the moderator or administrator.");
$faq[] = array("Why can't I delete attachments?", "On some forums deleting attachments may be limited to certain users or groups. To delete attachments you may need special authorization, only the forum moderator and board admin can grant this access, you should contact them.");
$faq[] = array("Why can't I view/download attachments?", "On some viewing/downloading forums attachments may be limited to certain users or groups. To view/download attachments you may need special authorization, only the forum moderator and board admin can grant this access, you should contact them.");
$faq[] = array("Who do I contact about illegal or possibly illegal attachments?", "You should contact the administrator of this board. If you cannot find who this is you should first contact one of the forum moderators and ask them who you should in turn contact. If you still get no response you should contact the owner of the domain (do a whois lookup) or, if this is running on a free service (e.g. yahoo, free.fr, f2s.com, etc.), the management or abuse department of that service. Please note that phpBB Group has absolutely no control and cannot in any way be held liable over how, where or by whom this board is used. It is absolutely pointless contacting phpBB Group in relation to any legal (cease and desist, liable, defamatory comment, etc.) matter not directly related to the phpbb.com website or the discrete software of phpBB itself. If you do email phpBB Group about any third party use of this software then you should expect a terse response or no response at all.");

if (!empty($config['plugins']['album']['enabled']))
{
	$faq[] = array("--","Photo Album");
	$faq[] = array("How do I access the Photo Album?", "Simply use the link 'Photo Album' in the nav menu. This will take you to the main Photo Album directory where all public Photo Albums are displayed. You can also access an individual's Personal Photo Gallery by clicking the link 'Users Personal Galleries' below the Public Categories.");
	$faq[] = array("How do I upload a picture to a Photo Album?", "Once you are on the main Photo Album index page, select either one of the 'Public Categories' or 'Users Personal Galleries'. You should now see a button that says 'Upload Pic' at the top and bottom of the page. Click this button and follow the instructions on the following page.");
	$faq[] = array("What are the maximum file size, maximum image width and maximum image height allowed?", "These settings appear on the 'Upload Pic' page. The board administrator sets an upper limit for filesize, defined file extensions and other things for uploaded pictures in the Albums.");
	$faq[] = array("What format does my picture have to be in?", "These settings appear on the 'Upload Pic' page. The board administrator sets an upper limit for filesize, defined file extensions and other things for uploaded pictures in the Albums.");
	$faq[] = array("I still can't get my picture to upload; I keep getting an error message!", "Go back to the 'Upload Pic' page and make sure you are following all of the directions there. The file you are trying to upload may be bigger than the Maximum file size allowed, you may be trying to upload a pic that does not fit the dimensions specified, you may be trying to upload a pic in a format not available, or you simply may have forgotten to fill in the necessary fields for the pic to post correctly.");
	$faq[] = array("I made a mistake in the title and/or description of my picture. What can I do?", "When viewing an Album, there are several options available to users. If the board administrator has allowed it, you will find the link 'Edit' below each thumbnail which will allow you to alter this information at any time.");
	$faq[] = array("How do I delete a pic?", "When viewing an Album, there are several options available to users. If the board administrator has allowed it, you will find the link 'Delete' below each thumbnail which will allow you to remove any picture of your own.");
	$faq[] = array("I would like to let someone know how much I like or dislike their picture. How do I do that?", "When viewing an Album or a pic, there are several options available to users. If the board administrator has allowed it, you will find the links 'Rating' and 'Comments' below each thumbnail or picture which allow you to do this in a couple of ways at any time.");
}

$faq[] = array("--","Downloads ADV");
$faq[] = array("Where can I find the Downloads?", "Links to the Downloads are located in the board navigation and portal navigation. Directlink: [<a href=\"downloads.php\">Downloads</a>]");
$faq[] = array("What means <img border=\"0\" src=\"" . $images['Dl_blue'] . "\" alt=\"\" title=\"\" />?", "No download possible. The overall traffic set by the administration for each download or the displayed category is used for this month.");
$faq[] = array("What means <img border=\"0\" src=\"" . $images['Dl_red'] . "\" alt=\"\" title=\"\" />?", "No download possible. This can be:<br />- The download is blocked by an Administrator.<br />- The user is not logged in but the download is only allowed to registered users.<br />- The user have not enough traffic to download this file.<br />- The Administrator has entered a minimum number of posts, the user doesn\"t have.<br />- The traffic limit for this file is completely used.");
$faq[] = array("What means <img border=\"0\" src=\"" . $images['Dl_grey'] . "\" alt=\"\" title=\"\" />?", "External Source. The download will be started by an external server. This will be handled as <img border=\"0\" src=\"" . $images['Dl_green'] . "\" alt=\"\" title=\"\" />. The user traffic and overall traffic will not be decreased.");
$faq[] = array("What means <img border=\"0\" src=\"" . $images['Dl_white'] . "\" alt=\"\" title=\"\" />?", "Like <img border=\"0\" src=\"" . $images['Dl_green'] . "\" alt=\"\" title=\"\" /> the user traffic will not be decrease. But only logged in users can download for free. The overall traffic will go down.");
$faq[] = array("What means <img border=\"0\" src=\"" . $images['Dl_yellow'] . "\" alt=\"\" title=\"\" />?", "Download possible with restrictions. The download is just possible for registered users. The user must be logged in. The file size will be subtracted from your traffic and also be subtracted from the overall traffic.");
$faq[] = array("What means <img border=\"0\" src=\"" . $images['Dl_green'] . "\" alt=\"\" title=\"\" />?", "Free Download. The download will be not restricted. This file can also be downloaded by guests. You don't need to be logged in. Your traffic will not decreased but the overall traffic will be go down.");
$faq[] = array("Why can't I download any file?", "This can have many reasons. Look under <img border=\"0\" src=\"" . $images['Dl_blue'] . "\" alt=\"\" title=\"\" /> and <img border=\"0\" src=\"" . $images['Dl_red'] . "\" alt=\"\" title=\"\" />.");
$faq[] = array("How and when do I get new traffic for my account?", "After the first login the user will get a time-stamp. Each first day of a month the user enters the downloads their traffic quota will be refreshed. Ask your administrator how much you will get.");
$faq[] = array("I want to download still one more file, but I don't have any traffic left?", "In this cases ask an administrator. Only they can decide to increase the user traffic before the account will automatically get new traffic for the next month.");
$faq[] = array("How I can rate Downloads?", "Behind each download in a category or the detailed view you will find a section for rating.<br />By clicking on \"Rate\" a registered user can rate the download from 1 point (very bad) to 10 points (very good). You can rate a download only once.");

$faq[] = array("--","Digests");
$faq[] = array("What are Digests?", "Digests are email messages sent to you periodically with a summary of postings made here. Weekly or daily digests are available.");
$faq[] = array("Why would I want a digest?", "It makes your life easier. You don't have to explicitly visit this site to see what conversations are going on around here. Just read your digest and if there is some topic that seems of interest, click on it in your email program and start participating! Un-subscribe at any time.");
$faq[] = array("How often are digests sent?", "They can be sent daily or weekly. Weekly digests are sent on Sundays.");
$faq[] = array("When are digests sent?", "You determine the hour you want to receive the digest. Whatever time you choose, you will always get the latest news so pick a time that suits your lifestyle.");
$faq[] = array("What time period is covered by the digest?", "Either 24 hours or 7 days, depending on whether you selected a daily or weekly digest. Messages older than this will not be sent. In addition if you want to, or if you visited recently, you can elect not to see messages since you last logged in. You can even filter out your own messages.");
$faq[] = array("Suppose I don't want summaries of every message here. Can I be selective?", "Yes. You can pick the forum or forums that interest you. By default you will get messages for all forums that you are allowed to access.");
$faq[] = array("What email message formats are available?", "We can send you HTML or text. Unless your email program can't handle HTML (very unusual these days) we suggest HTML. Frankly, text digests look pretty plain and are harder to use. That's the nature of plain text.");
$faq[] = array("Do I get the whole message text in the digest?", "By default you get the first 150 characters of the text, or you can elect not to see any of the message text and just see the topic subject instead. You can select message excerpts including the first 50, 100, 150, 300 or 600 characters, or the full text of the message (up to 32,000 characters). Anything beyond the limit you set will be truncated. We recommend keeping the default message length because otherwise your digests may get so big as to be unusable. We have also heard that very large digests may be rejected by your ISP or put you over your server storage quota. An excerpt reduces bandwidth and is usually all that is needed. Why? Because each message has a convenient link that will take you to the topic or message of interest.");
$faq[] = array("How do I get started?", "Just click on the Digests link in the nav links block or if you prefer you can click here: <a href=\"./digests.php\">Digests</a>.");
$faq[] = array("Can I unsubscribe?", "Of course! Just go to the same page and select \"None\" for \"Type of Digest Wanted\". Then submit the form. Your subscription will end immediately.");
$faq[] = array("Are digests commercial free?", "Of course. There are no annoying ads nor will there ever be any on our site.");
$faq[] = array("Is my privacy protected?", "Yes, your digest is sent to you and no one else at the email address you gave us in your profile. Think of the digest as a special edition newspaper customized just for you. Someone else is likely getting a completely different digest.");


$faq[] = array("--","Unread Post Information 2 Database (UPI2DB)");
$faq[] = array("What is the difference between the default cookie system and the UPI2DB System?", "The cookie system is the default system of phpBB2-Based forums. When you read a post, information is stored in a cookie on your computer which includes information that you have read the post. The biggest disadvantage of this system is, that you lose the marked read/unread information with closing your browser. The UPI2DB system does not store the information as a cookie on the computer, but separately in the database.");
$faq[] = array("What are the pro and contras for the cookie system?", "<strong>Advantage:</strong> With larger forums the normal cookie system has faster page-loading than the UPI2DB system, because this system must load the information about posts that have been read from the database. A further advantage is that the data will be stored over many months, because you don't delete the data from your machine. This is interesting for users who only visit the forum every 2 months.<br /><strong>Disadvantage:</strong> The largest disadvantage so far with this system is that you automatically mark all posts as read by closing the browser. A further disadvantage is, that edited posts won't get marked as unread again and therefore won't get any further attention.");
$faq[] = array("What are the pro and contras for the UPI2DB system?", "<strong>Advantage:</strong> Unread posts still stay unread, if somebody closes the browser, you won't have to read all the new posts at one time. Posts can also get marked as read for a time of " . (!empty($config['upi2db_auto_read']) ? $config['upi2db_auto_read'] : 0) . " with the UPI2DB system. Forums which are not interesting for you, can be marked as 'permanently marked read', until you change the option. Edited contributions are marked as unread with the notation 'Edited' and additionally have another color to separate them from normal unread messages. A new search function allows one to look for unread and edited contributions only. When the Admin activated to display edited contributions in the top of the Topics, edited contributions will be displayed at the first line of the topic.<br /><strong>Disadvantage:</strong> At larger forums with many posts and users, it may take longer to load the page. The information whether a contribution was read, remains stored only over a certain time period, afterwards posts will automatically be marked as read. The standard time period is set to 30 days. But this may vary on the settings from your Admin.");
$faq[] = array("I can not see any switch on my profile, where I can select to choose between the cookie or UPI2DB system", "If you don't see the options for the UPI2DB system the admin has permanently deactivated the system. In this case you won't have the possibility to switch this option.");
$faq[] = array("Which conditions can the Admin set?", "As default the UPI2DB system allows the Admin the option to select how many posts a user must have to use the System and/or how long the user must be registered before the system will be activated.");
$faq[] = array("Whatever I try, I cannot mark sticky posts or announcements as read!", "Sticky posts and announcements have to be read! They cannot be marked as read within the functions 'Mark all forums/contributions as read' or 'Show unread contributions'!");
$faq[] = array("I must remark all " . (!empty($config['upi2db_auto_read']) ? $config['upi2db_auto_read'] : 0) . " days a topic as 'permanent read'!", "That's how it's got to be and you can't change this. We had to make a compromise to make sure the system won't get too slow.");
$faq[] = array("How can I set a forum to 'permanent read'?", "Just click the picture in front of the board name. When done, the picture should change.");
$faq[] = array("How can I set a topic to 'permanent read'?", "Just click the picture in front of the topic name. When done, the picture should change and the topic will move to the last position in the topic list. Alternatively you can click 'topic permanently mark as read' on the bottom of the page.");
$faq[] = array("I cannot mark sticky posts and announcements as 'permanent read'!", "Sticky posts and announcements are not allowed to be set as 'permanent read', as you might miss some very important information!");
$faq[] = array("I marked a forum as 'permanent read', but now a new post appears!", "When someone posts a sticky post or an announcement, the forum marked as 'permanent read' will be reset to default. This is important, to avoid missing any important sticky posts or announcements.!");
$faq[] = array("How can I mark a contribution, to find it again later on more easy?", "Within every contribution you will find a button in the contribution title, which you can use to mark a contribution. Contributions older than " . (!empty($config['upi2db_auto_read']) ? $config['upi2db_auto_read'] : 0) . " days or contributions, which were written before you registered with this board, cannot be marked.");
$faq[] = array("How can I set an already read contribution to 'unread' again?", "On every post there's a link below the title of the contribution. With this link you can mark all posts, which are posted or edited after this post, as new or edited.");
$faq[] = array("Why I'm not able to mark some contributions?", "Contributions, which are marked as 'permanent read' in a forum or contribution itself or which were written before you registered with this board, cannot be marked. Contributions older than " . (!empty($config['upi2db_auto_read']) ? $config['upi2db_auto_read'] : 0) . " days, cannot be marked also.");
$faq[] = array("Does marked contributions stay as marked forever?", "No, all marks you set, will be deleted automatically after " . (!empty($config['upi2db_del_mark']) ? $config['upi2db_del_mark'] : 0) . " days, where you set the mark.");
$faq[] = array("What means MAR?", "This is the shortcut for 'Mark all read'");


$faq[] = array("--","phpBB 2 Issues");
$faq[] = array("Who wrote this bulletin board?", "This software (in its unmodified form) is produced, released and is copyrighted <a href=\"http://www.phpbb.com/\" target=\"_blank\">phpBB Group</a>. It is made available under the GNU General Public License and may be freely distributed; see link for more details");
$faq[] = array("Why isn't X feature available?", "This software was written by and licensed through phpBB Group. If you believe a feature needs to be added then please visit the phpbb.com website and see what the phpBB Group has to say. Please do not post feature requests to the board at phpbb.com, as the Group uses sourceforge to handle tasking of new features. Please read through the forums and see what, if any, our position may already be for features and then follow the procedure given there.");
$faq[] = array("Whom do I contact about abusive and/or legal matters related to this board?", "You should contact the administrator of this board. If you cannot find who that is, you should first contact one of the forum moderators and ask them who you should in turn contact. If still get no response you should contact the owner of the domain (do a whois lookup) or, if this is running on a free service (e.g. yahoo, free.fr, f2s.com, etc.), the management or abuse department of that service. Please note that phpBB Group has absolutely no control and cannot in any way be held liable over how, where or by whom this board is used. It is absolutely pointless contacting phpBB Group in relation to any legal (cease and desist, liable, defamatory comment, etc.) matter not directly related to the phpbb.com website or the discrete software of phpBB itself. If you do email phpBB Group about any third party use of this software then you should expect a terse response or no response at all.");


$faq[] = array("--", "About Icy Phoenix");
$faq[] = array("What is Icy Phoenix?", "Icy Phoenix is a CMS (Content Management System) which allows users to easily create dynamic websites with several embedded features: forum, portal, customizable pages and blocks, downloads, photo gallery, and much more.");
$faq[] = array("Who wrote this software?", "This software is based upon phpBB which is released under the GNU General Public License, so Icy Phoenix must be released under the same license also, and this means that it can be freely modified and distributed. Most of the files have been directly coded or modified by Mighty Gorgon and <a href=\"http://www.icyphoenix.com/\" target=\"_blank\">Icy Phoenix Staff</a>. A non exhaustive list of the contributors to this project may be found here: <a href=\"http://www.icyphoenix.com/credits.php\" target=\"_blank\">Icy Phoenix Credits</a>.");
$faq[] = array("Whom do I contact about abusive and/or legal matters related to this site?", "You should contact the webmaster. If you cannot find who that is, you should first contact one of the forum moderators and ask them who you should in turn contact. If still get no response you should contact the owner of the domain (do a whois lookup) or, if this is running on a free service (e.g. yahoo, free.fr, f2s.com, etc.), the management or abuse department of that service. Please note that Icy Phoenix has absolutely no control and cannot in any way be held liable over how, where or by whom this site is used. It is absolutely pointless contacting Icy Phoenix in relation to any legal (cease and desist, liable, defamatory comment, etc.) matter not directly related to the icyphoenix.com website or the discrete software of Icy Phoenix itself. If you do email Icy Phoenix about any third party use of this software then you should expect a terse response or no response at all.");


?>