<?php
/**
*
* @package FAP
* @version $Id: otf_config.php
* @copyright (c) 2007 Mighty Gorgon
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/

if ( !defined('IN_PHPBB') )
{
	die('Hacking attempt');
}

// Set Memory
@ini_set('memory_limit', '16M');

// OTF LANG - BEGIN
$user->add_lang('mods/otf', false, false);
// OTF LANG - END

// Constants - BEGIN
define('IN_ALBUM', true);

define('ALBUM_FILES_PATH_FOLDER', 'album/');
define('ALBUM_FILES_PATH', $phpbb_root_path . ALBUM_FILES_PATH_FOLDER);
define('ALBUM_OTF_PATH_FOLDER', 'otf/');
define('ALBUM_OTF_PATH', ALBUM_FILES_PATH . ALBUM_OTF_PATH_FOLDER);
define('ALBUM_XML_PATH', ALBUM_FILES_PATH_FOLDER . 'xml/');
define('ALBUM_CACHE_PATH', ALBUM_FILES_PATH . 'cache/');
define('ALBUM_CACHE_S_PATH', ALBUM_CACHE_PATH . 's/');
define('ALBUM_CACHE_M_PATH', ALBUM_CACHE_PATH . 'm/');
define('ALBUM_CACHE_L_PATH', ALBUM_CACHE_PATH . 'l/');
define('ALBUM_CACHE_W_PATH', ALBUM_CACHE_PATH . 'w/');

define('POSTED_IMAGES_PATH_FOLDER_PLAIN', 'users_pics');
define('POSTED_IMAGES_PATH_FOLDER', POSTED_IMAGES_PATH_FOLDER_PLAIN . '/');
define('POSTED_IMAGES_PATH', ALBUM_OTF_PATH . POSTED_IMAGES_PATH_FOLDER);
define('IMG_NO_THUMB', ALBUM_FILES_PATH . 'otf_nothumb.png');
define('IMG_NO_HOTLINK', ALBUM_FILES_PATH . 'otf_nohotlink.png');
define('IMG_GUESTS', ALBUM_FILES_PATH . 'otf_guests.png');
// Constants - END

// OTF - GENERAL SETTINGS - BEGIN
// OTF Version
$album_config['otf_version'] = '0.5.0';
// GD Version
$album_config['gd_version'] = '2';
// Allowed extensions
$album_config['allowed_extensions'] = array('gif', 'jpg', 'jpeg', 'png');
$album_config['use_old_pics_gen'] = '0';
$album_config['thumbnail_cache'] = '1';
$album_config['thumbnail_quality'] = '75';
$album_config['show_pic_size_on_thumb'] = '0';
$album_config['rows_per_page'] = '5';
$album_config['cols_per_page'] = '4';
// OTF - GENERAL SETTINGS - END

// Hotlinks - BEGIN
// Hotlinks switch
$album_config['allow_hotlinks'] = true;
// Allowed hotlinks
$album_config['allowed_hotlinks'] = array('icyphoenix.com', 'mightygorgon.com');
// Hotlinks - END

// No image for guests
$album_config['show_images_guests'] = true;

// Upload feature - BEGIN
$album_config['show_upload_posting'] = true;
// max size in KB: it will be multiplied by 1024!!!
$album_config['upload_maxsize'] = '1000';
// max image dimension in pixels
$album_config['upload_maxwidth'] = '1280';
$album_config['upload_maxheight'] = '1024';
// Upload feature - END

// Thumbnails Settings - BEGIN
// Thumbs [S=SMALL - M=MEDIUM - LARGE]
// Path for thumbs
$album_config['thumbs_x_path'] = ALBUM_CACHE_PATH;
$album_config['thumbs_s_path'] = ALBUM_CACHE_S_PATH;
$album_config['thumbs_m_path'] = ALBUM_CACHE_M_PATH;
$album_config['thumbs_l_path'] = ALBUM_CACHE_L_PATH;

// Thumbs suffix
$album_config['thumb_x_suffix'] = '';
$album_config['thumb_s_suffix'] = '_s';
$album_config['thumb_m_suffix'] = '_m';
$album_config['thumb_l_suffix'] = '_l';

// Thumbs Size [W=WIDTH - H=HEIGHT]
$album_config['thumb_x_w'] = '120';
$album_config['thumb_x_h'] = '120';
$album_config['thumb_s_w'] = '40';
$album_config['thumb_s_h'] = '40';
$album_config['thumb_m_w'] = '120';
$album_config['thumb_m_h'] = '90';
$album_config['thumb_l_w'] = '560';
$album_config['thumb_l_h'] = '420';

// Force Width & Height to be identical to the specified size (images is scaled then borders added)
// If FALSE then W & H are scaled proportionally to mantain aspect ratio
$album_config['force_x_w_h'] = false;
$album_config['force_s_w_h'] = true;
$album_config['force_m_w_h'] = false;
$album_config['force_l_w_h'] = false;
// Thumbnails Settings - END

// Flash Slideshow - BEGIN
// XML Filename
$album_config['xml_filename'] = 'images';

// Page Title & Keywords
$album_config['page_title'] = 'Icy Phoenix - Instant Gallery';
$album_config['page_keywords'] = 'gallery,album,pictures,instant gallery,thumbnails,instant thumbnails,slideshow,flash gallery,flash slideshow,icy phoenix,mighty gorgon,flepstudio';

// Encoding Charset
$album_config['encoding_charset'] = 'UTF-8';
// Flash Slideshow - END

/*
$album_config[''] = ;
*/

?>