<?php
/**
*
* @package FAP
* @version $Id: otf_functions.php
* @copyright (c) 2007 Mighty Gorgon
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/

if ( !defined('IN_PHPBB') )
{
	die('Hacking attempt');
}

/*
Function generate_no_thumb_img to generate the default no thumbnail picture
*/
function generate_no_thumb_img($image_name)
{
	header('Content-type: image/png');
	header('Content-Disposition: filename=' . $image_name . '.png');
	readfile(IMG_NO_THUMB);
}

/*
Function generate_no_hotlink_img to generate the default no hotlink picture
*/
function generate_no_hotlink_img($image_name)
{
	header('Content-type: image/png');
	header('Content-Disposition: filename=' . $image_name . '.png');
	readfile(IMG_NO_HOTLINK);
}

/*
Function generate_guests_img to generate the default picture for guests
*/
function generate_guests_img($image_name)
{
	header('Content-type: image/png');
	header('Content-Disposition: filename=' . $image_name . '.png');
	readfile(IMG_GUESTS);
}

/*
Function any_url_exists to check whether a file exists on any domain.
*/
function any_url_exists($url)
{
	$a_url = parse_url($url);
	if (!isset($a_url['port']))
	{
		$a_url['port'] = 80;
	}
	$errno = 0;
	$errstr = '';
	$timeout = 30;
	if( (isset($a_url['host'])) && ($a_url['host'] != gethostbyname($a_url['host'])) )
	{
		$fid = fsockopen($a_url['host'], $a_url['port'], $errno, $errstr, $timeout);
		if (!$fid) return false;
		$page = isset($a_url['path']) ? $a_url['path'] : '';
		$page .= isset($a_url['query']) ? '?' . $a_url['query'] : '';
		fputs($fid, 'HEAD ' . $page . ' HTTP/1.0' . "\r\n" . 'Host: ' . $a_url['host'] . "\r\n\r\n");
		$head = fread($fid, 4096);
		fclose($fid);
		return preg_match('#^HTTP/.*\s+[200|302]+\s#i', $head);
	}
	else
	{
		return false;
	}
}

/*
Function check_referer needed to check hotlinks
*/
function check_referer($referer, $referers_list)
{
	/*
	global $_SERVER, $HTTP_REFERER;
	$referer = (!empty($_SERVER['HTTP_REFERER'])) ? $_SERVER['HTTP_REFERER'] : getenv('HTTP_REFERER');
	*/

	$check_referer = explode('?', $referer);
	$referer = trim($check_referer[0]);
	for ($i = 0; $i < count($referers_list); $i++)
	{
		if (strpos(strtolower($referer), strtolower($referers_list[$i])) !== false)
		{
			return true;
		}
	}
	return false;
}

/*
Function get_full_image_info
*/
define ('IMAGE_WIDTH', 'width');
define ('IMAGE_HEIGHT', 'height');
define ('IMAGE_TYPE', 'type');
define ('IMAGE_ATTR', 'attr');
define ('IMAGE_BITS', 'bits');
define ('IMAGE_CHANNELS', 'channels');
define ('IMAGE_MIME', 'mime');

/**
 * mixed get_full_image_info( file $file [, string $out] )
 *
 * Returns information about $file.
 *
 * If the second argument is supplied, a string representing that information will be returned.
 *
 * Valid values for the second argument are IMAGE_WIDTH, 'width', IMAGE_HEIGHT, 'height', IMAGE_TYPE, 'type',
 * IMAGE_ATTR, 'attr', IMAGE_BITS, 'bits', IMAGE_CHANNELS, 'channels', IMAGE_MIME, and 'mime'.
 *
 * If only the first argument is supplied an array containing all the information is returned,
 * which will look like the following:
 *
 *    [width] => int (width),
 *    [height] => int (height),
 *    [type] => string (type),
 *    [attr] => string (attributes formatted for IMG tags),
 *    [bits] => int (bits),
 *    [channels] => int (channels),
 *    [mime] => string (mime-type)
 *
 * Returns false if $file is not a file, no arguments are supplied, $file is not an image, or otherwise fails.
 *
 **/
function get_full_image_info($file = null, $out = null)
{
	// If $file is not supplied or is not a file, warn the user and return false.
	//if (is_null($file) || !any_url_exists($file))
	if (is_null($file) || !is_file($file))
	{
		//echo '<p><b>Warning:</b> image_info() => first argument must be a file.</p>';
		//echo '<br /><br />' . $file . '<br /><br />';
		return false;
	}

	// Defines the keys we want instead of 0, 1, 2, 3, 'bits', 'channels', and 'mime'.
	$redefine_keys = array(
		'width',
		'height',
		'type',
		'attr',
		'bits',
		'channels',
		'mime',
	);

	// If $out is supplied, but is not a valid key, nullify it.
	if (!is_null($out) && !in_array($out, $redefine_keys))
	{
		$out = null;
	}

	// Assign usefull values for the third index.
	$types = array(
		1 => 'GIF',
		2 => 'JPG',
		3 => 'PNG',
		4 => 'SWF',
		5 => 'PSD',
		6 => 'BMP',
		7 => 'TIFF(intel byte order)',
		8 => 'TIFF(motorola byte order)',
		9 => 'JPC',
		10 => 'JP2',
		11 => 'JPX',
		12 => 'JB2',
		13 => 'SWC',
		14 => 'IFF',
		15 => 'WBMP',
		16 => 'XBM'
	);
	$temp = array();
	$data = array();

	// Get the image info using getimagesize().
	// If $temp fails to populate, warn the user and return false.
	if (!$temp = @getimagesize($file))
	{
		//echo '<p><b>Warning:</b> image_info() => first argument must be an image.</p>';
		return false;
	}

	// Get the values returned by getimagesize()
	$temp = array_values($temp);

	// Make an array using values from $redefine_keys as keys and values from $temp as values.
	foreach ($temp as $k => $v)
	{
		$data[$redefine_keys[$k]] = $v;
	}

	// Make 'type' useful.
	$data['type'] = $types[$data['type']];

	// Return the desired information.
	return !is_null($out) ? $data[$out] : $data;
}

/*
* get_file_details
* Get File Details: name, extension
*/
function get_file_details($file_name)
{
	$file_details = array();
	$file_tmp = str_replace ('http://', '', $file_name);
	$file_path[] = array();
	$file_path = explode('/', $file_tmp);
	$file_details['name_full'] = $file_path[(count(explode('/', $file_tmp))) - 1];
	$file_part = explode('.', strtolower($file_details['name_full']));
	$file_details['ext'] = $file_part[sizeof($file_part) - 1];
	$file_details['name'] = substr($file_details['name_full'], 0, strlen($file_details['name_full']) - strlen($file_details['ext']) - 1);
	return $file_details;
}

/*
* create_thumb
* Thumbnails Creation
*/
function create_thumb($source_pic, $t_width, $t_height, $t_suffix = '', $t_path = '', $t_quality = '75', $force_size = false)
{
	global $allowed_extensions;
	$file_details = array();
	$pic_fullpath = str_replace(array(' '), array('%20'), $source_pic);
	$file_details = get_file_details($source_pic);
	$pic_filename = $file_details['name_full'];
	$pic_title = $file_details['name'];
	$pic_filetype = $file_details['ext'];
	$pic_title_reg = ereg_replace("[^A-Za-z0-9]", '_', $pic_title);
	$pic_thumbnail = $pic_title . $t_suffix . '.' . $pic_filetype;
	if (!in_array($pic_filetype, $allowed_extensions))
	{
		return false;
	}

	$pic_size = get_full_image_info($source_pic);
	if( $pic_size == false )
	{
		return false;
	}

	$pic_width = $pic_size['width'];
	$pic_height = $pic_size['height'];
	$pic_filetype_new = strtolower($pic_size['type']);
	$pic_thumbnail_fullpath = ( ($t_path == '') ? '' : ($t_path . '/') ) . $pic_thumbnail;

	switch($pic_filetype_new)
	{
		case 'gif':
			$img_tmp = @imagecreatefromgif($source_pic);
			break;
		case 'jpg':
			$img_tmp = @imagecreatefromjpeg($source_pic);
			break;
		case 'png':
			$img_tmp = @imagecreatefrompng($source_pic);
			break;
		default:
			return false;
			break;
	}

	$pic_ratio = $pic_width / $pic_height;
	$t_ratio = $t_width / $t_height;
	$x_offset = 0;
	$y_offset = 0;
	$dest_width = $t_width;
	$dest_height = $t_height;
	if ($force_size == true)
	{
		if ($pic_ratio > $t_ratio)
		{
			$x_tmp = $pic_width;
			$x_ratio = 1 - ( (($pic_width / $pic_height) - ($t_width / $t_height)) / 2 );
			$pic_width = round($pic_width * $x_ratio, 0);
			$x_offset = round(($x_tmp - $pic_width) / 2, 0);
			//$x_offset = round((($t_height * $pic_ratio) - $t_width) / 2, 0);
		}
		else
		{
			$y_tmp = $pic_height;
			$y_ratio = 1 - ( (($t_width / $t_height) - ($pic_width / $pic_height)) / 2);
			$pic_height = round($pic_height * $y_ratio, 0);
			$y_offset = round(($y_tmp - $pic_height) / 2, 0);
			//$y_offset = round((($t_width / $pic_ratio) - $t_height) / 2, 0);
		}
	}
	else
	{
		if ( ($pic_width <= $t_width) && ($pic_height <= $t_height) )
		{
			$dest_width = $pic_width;
			$dest_height = $pic_height;
			if ( ($t_path != '') && !file_exists($t_path) )
			{
				@mkdir ($t_path, 0777);
			}
			@copy($source_pic, $pic_thumbnail_fullpath);
			@chmod($pic_thumbnail_fullpath, 0755);
			return true;
		}
		else
		{
			if ($pic_ratio > $t_ratio)
			{
				$dest_height = round($t_width / $pic_ratio, 0);
			}
			else
			{
				$dest_width = round($t_height * $pic_ratio, 0);
			}
		}
	}

	$img_new = @imagecreatetruecolor($dest_width, $dest_height);
	if (!$img_new)
	{
		return false;
	}

	@imagealphablending($img_new, false);
	@imagecopyresampled($img_new, $img_tmp, 0, 0, $x_offset, $y_offset, $dest_width, $dest_height, $pic_width, $pic_height);
	@imagesavealpha($img_new, true);

	if ( ($t_path != '') && !file_exists($t_path) )
	{
		@mkdir ($t_path, 0777);
	}

	// If you want all thumbnails to be forced as JPG you can decomment these lines
	/*
	imagejpeg ($img_new, $pic_thumbnail_fullpath, '75');
	return true;
	exit;
	*/

	switch ($pic_filetype)
	{
		case 'jpg':
			@imagejpeg($img_new, $pic_thumbnail_fullpath, '75');
			break;
		case 'png':
			@imagepng($img_new, $pic_thumbnail_fullpath);
			break;
		case 'gif':
			@imagegif($img_new, $pic_thumbnail_fullpath);
			break;
		default:
			return false;
			exit;
	}
	@chmod($pic_thumbnail_fullpath, 0755);
	return true;
}

/*
* xml_output
* XML Creation
*/
function xml_output($xml_filename, $xml_body, $encoding_charset)
{
	// Generate XML - BEGIN
	$xml_header = '<' . '?xml version="1.0" encoding="' . $encoding_charset . '"?' . '>';
	$xml_footer = '';
	$xml_content = $xml_header . $xml_body . $xml_footer;
	$fp = fopen($xml_filename, 'w');
	@fwrite($fp, $xml_content);
	@fclose($fp);
	return true;
	// Generate XML - END
}


// Old Watermark functions

//$sourcefile = Filename of the picture into that $insertfile will be inserted.
//$insertfile = Filename of the picture that is to be inserted into $sourcefile.
//$targetfile = Filename of the modified picture.
//$transition = Intensity of the transition (in percent).
//$pos        = Position where $insertfile will be inserted in $sourcefile.
//          1 = top left
//          2 = top middle
//          3 = top right
//          4 = middle left
//          5 = middle
//          6 = middle right
//          7 = bottom left
//          8 = bottom middle
//          9 = bottom right
//

function mergePics($sourcefile, $insertfile, $pos = 0, $transition = 50, $pic_filetype)
{

	global $album_config;

	$insertfile_id = imageCreateFromPNG($insertfile);

	switch( $pic_filetype )
	{
		case 'jpg':
			$sourcefile_id = imageCreateFromJPEG($sourcefile);
			break;
		case 'png':
			$sourcefile_id = imageCreateFromPNG($sourcefile);
			break;
		default:
			break;
	}

	// Get the size of both pics
	$sourcefile_width = imageSX($sourcefile_id);
	$sourcefile_height = imageSY($sourcefile_id);
	$insertfile_width = imageSX($insertfile_id);
	$insertfile_height = imageSY($insertfile_id);

	switch( $pos )
	{
		case 1: // top left
			$dest_x = 0;
			$dest_y = 0;
			break;

		case 2: // top middle
			$dest_x = ( ( $sourcefile_width - $insertfile_width ) / 2 );
			$dest_y = 0;
			break;

		case 3: // top right
			$dest_x = $sourcefile_width - $insertfile_width;
			$dest_y = 0;
			break;

		case 4: // middle left
			$dest_x = 0;
			$dest_y = ( $sourcefile_height / 2 ) - ( $insertfile_height / 2 );
			break;

		case 5: // middle
			$dest_x = ( $sourcefile_width / 2 ) - ( $insertfile_width / 2 );
			$dest_y = ( $sourcefile_height / 2 ) - ( $insertfile_height / 2 );
			break;

		case 6: // middle right
			$dest_x = $sourcefile_width - $insertfile_width;
			$dest_y = ( $sourcefile_height / 2 ) - ( $insertfile_height / 2 );
			break;

		case 7: // bottom left
			$dest_x = 0;
			$dest_y = $sourcefile_height - $insertfile_height;
			break;

		case 8: // bottom middle
			$dest_x = ( ( $sourcefile_width - $insertfile_width ) / 2 );
			$dest_y = $sourcefile_height - $insertfile_height;
			break;

		case 9: // bottom right
			$dest_x = $sourcefile_width - $insertfile_width;
			$dest_y = $sourcefile_height - $insertfile_height;
			break;

		default:
			break;
	}

	// Merge the two pix
	imageCopyMerge($sourcefile_id, $insertfile_id, $dest_x, $dest_y, 0, 0, $insertfile_width, $insertfile_height, $transition);

	// Create the final image
	switch( $pic_filetype )
	{
		case 'jpg':
			imagejpeg($sourcefile_id, '', $album_config['thumbnail_quality']);
			break;
		case 'png':
			imagepng($sourcefile_id);
			break;
		default:
			break;
	}

	imageDestroy($sourcefile_id);
}

function mergeResizePics($sourcefile, $insertfile, $thumbnail_width, $thumbnail_height, $pos = 0, $transition = 50, $pic_filetype)
{

	global $album_config;

	switch( $pic_filetype )
	{
		case 'jpg':
			$sourcefile_id = imageCreateFromJPEG($sourcefile);
			break;
		case 'png':
			$sourcefile_id = imageCreateFromPNG($sourcefile);
			break;
		default:
			break;
	}

	$insertfile_id = imageCreateFromPNG($insertfile);

	// Get the size of both pics
	$sourcefile_width = imageSX($sourcefile_id);
	$sourcefile_height = imageSY($sourcefile_id);
	$insertfile_width = imageSX($insertfile_id);
	$insertfile_height = imageSY($insertfile_id);

	if ($album_config['gd_version'] == 1)
	{
		$thumbnail = @imageCreate($thumbnail_width, $thumbnail_height);
		@imageCopyResized($thumbnail, $sourcefile_id, 0, 0, 0, 0, $thumbnail_width, $thumbnail_height, $sourcefile_width, $sourcefile_height);
	}
	else
	{
		$thumbnail = @imageCreateTrueColor($thumbnail_width, $thumbnail_height);
		@imageCopyResampled($thumbnail, $sourcefile_id, 0, 0, 0, 0, $thumbnail_width, $thumbnail_height, $sourcefile_width, $sourcefile_height);
	}

	// Reset the size
	$sourcefile_width = $thumbnail_width;
	$sourcefile_height = $thumbnail_height;

	switch( $pos )
	{
		case 1: // top left
			$dest_x = 0;
			$dest_y = 0;
			break;

		case 2: // top middle
			$dest_x = ( ( $sourcefile_width - $insertfile_width ) / 2 );
			$dest_y = 0;
			break;

		case 3: // top right
			$dest_x = $sourcefile_width - $insertfile_width;
			$dest_y = 0;
			break;

		case 4: // middle left
			$dest_x = 0;
			$dest_y = ( $sourcefile_height / 2 ) - ( $insertfile_height / 2 );
			break;

		case 5: // middle
			$dest_x = ( $sourcefile_width / 2 ) - ( $insertfile_width / 2 );
			$dest_y = ( $sourcefile_height / 2 ) - ( $insertfile_height / 2 );
			break;

		case 6: // middle right
			$dest_x = $sourcefile_width - $insertfile_width;
			$dest_y = ( $sourcefile_height / 2 ) - ( $insertfile_height / 2 );
			break;

		case 7: // bottom left
			$dest_x = 0;
			$dest_y = $sourcefile_height - $insertfile_height;
			break;

		case 8: // bottom middle
			$dest_x = ( ( $sourcefile_width - $insertfile_width ) / 2 );
			$dest_y = $sourcefile_height - $insertfile_height;
			break;

		case 9: // bottom right
			$dest_x = $sourcefile_width - $insertfile_width;
			$dest_y = $sourcefile_height - $insertfile_height;
			break;

		default:
			break;
	}

	// Merge the two pix
	imageCopyMerge($thumbnail, $insertfile_id, $dest_x, $dest_y, 0, 0, $insertfile_width, $insertfile_height, $transition);
	imageDestroy($sourcefile_id);
	imageDestroy($insertfile_id);

	return $thumbnail;
}

?>