<?php
/**
*
* @package FAP
* @version $Id: otf_gallery.php
* @copyright (c) 2007 Mighty Gorgon
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/

define('IN_PHPBB', true);
$phpbb_root_path = './';
$phpEx = substr(strrchr(__FILE__, '.'), 1);
include($phpbb_root_path . 'common.' . $phpEx);

// Start session management
$user->session_begin();
$auth->acl($user->data);
$user->setup();

// Get general album information
if (!defined('ALBUM_INCLUDE_PATH'))
{
	define('ALBUM_INCLUDE_PATH', 'includes/fap/');
}
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'otf_config.' . $phpEx);
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'otf_functions.' . $phpEx);

$pic_id = request_var('pic_id', '');
$pic_cat = request_var('pic_cat', '');
$mode = request_var('mode', '');
$start = request_var('start', 0);

$upload_pics = false;
$cat_to_upload = false;

$pic_images = array();
$pic_cat_names = array();
$pic_file_names = array();
$pic_names = array();
$dir = @opendir(ALBUM_OTF_PATH);

//while( $file = @readdir($dir) )
while(false !== ($file = readdir($dir)))
{
	if( ($file != '.') && ($file != '..') && (!is_file(ALBUM_OTF_PATH . $file)) && (!is_link(ALBUM_OTF_PATH . $file)) )
	{
		$sub_dir = @opendir(ALBUM_OTF_PATH . $file);

		$pic_t_counter = 0;
		while( $sub_file = @readdir($sub_dir) )
		{
			//if ( ($sub_file != '.') && ($sub_file != '..') && (is_file($sub_file)) && (!is_link($sub_file)) )
			if ( ($sub_file != '.') && ($sub_file != '..') && (!is_link($sub_file)) )
			{
				$file_details = get_file_details($sub_file);
				if ( in_array(strtolower($file_details['ext']), $album_config['allowed_extensions']) )
				{
					$pic_images[$file][$pic_t_counter] = $file . '/' . $sub_file;
					$pic_cat_names[$file][$pic_t_counter] = $file;
					$pic_file_names[$file][$pic_t_counter] = $sub_file;
					$pic_names[$file][$pic_t_counter] = ucfirst(str_replace('_', ' ', preg_replace('/^(.*)\..*$/', '\1', $sub_file)));
					$pic_t_counter++;
				}
			}
		}
		$pic_images[$file]['pics_count'] = $pic_t_counter;
		@closedir($sub_dir);
	}
}

@closedir($dir);

@ksort($pic_images);
@reset($pic_images);

if( empty($pic_cat) )
{
	list($pic_cat) = each($pic_images);
}
@reset($pic_images);

$s_categories = '<select name="pic_cat">';
while( list($key) = each($pic_images) )
{
	$selected = ( $key == $pic_cat ) ? ' selected="selected"' : '';
	if( count($pic_images[$key]) )
	{
		$s_categories .= '<option value="' . $key . '"' . $selected . '>' . ( ($key == 'users_pics') ? $user->lang['USERS_PICS'] : ucfirst($key) ) . '</option>';
	}
}
$s_categories .= '</select>';

$pic_cat_reg = ereg_replace("[^A-Za-z0-9]", "_", $pic_cat);

$l_title = $user->lang['ALBUM_OTF'];
page_header($l_title);

$template->set_filenames(array('body' => 'otf_gallery_body.html'));

$pic_counter = 0;
$pics_per_page = $album_config['rows_per_page'] * $album_config['cols_per_page'];
$pic_start = $start;
$pic_end = min(($pic_start + $pics_per_page), $pic_images[$pic_cat]['pics_count']);
$pic_end_adj = $pic_end + ($pic_end % $album_config['cols_per_page']);
$pic_t_col = 0;

for($i = $pic_start; $i < $pic_end; $i++)
{
	if ($pic_t_col == 0)
	{
		$template->assign_block_vars('pic_row', array());
	}
	$pic_t_col++;
	if ($pic_t_col == ($album_config['cols_per_page']))
	{
		$pic_t_col = 0;
	}
	$pic_img_url_direct = append_sid(ALBUM_OTF_PATH . $pic_images[$pic_cat][$i]);
	$pic_img_url = append_sid('otf_pic.' . $phpEx . '?pic_cat=' . $pic_cat_names[$pic_cat][$i] . '&amp;pic_id=' . $pic_file_names[$pic_cat][$i]);
	$pic_img_thumb = append_sid('otf_thumbnail.' . $phpEx . '?pic_cat=' . $pic_cat_names[$pic_cat][$i] . '&amp;pic_id=' . $pic_file_names[$pic_cat][$i]);
	$pic_name = $pic_names[$pic_cat][$i];

	$template->assign_block_vars('pic_row.pic_column', array(
		'PIC_IMAGE' => $phpbb_root_path . $pic_img_url,
		'PIC_THUMB' => $phpbb_root_path . $pic_img_thumb,
		'PIC_COUNTER' => $i + 1,
		'PIC_BBCODE' => '[url=' . generate_board_url() . '/' . $pic_img_url . '][img]' . generate_board_url() . '/' . $pic_img_thumb . '[/img][/url]',
		'PIC_NAME' => $pic_name
		)
	);
}

$s_colspan = $album_config['cols_per_page'];
$s_colwidth = ( $s_colspan == 0 ) ? '100%' : floor(100 / $s_colspan) . '%';
$params[] = 'pic_cat=' . $pic_cat;
$pagination_url = append_sid($phpbb_root_path . 'otf_gallery.' . $phpEx, implode('&amp;', $params));

$template->assign_vars(array(
	'OTF_VERSION' => $album_config['otf_version'],
	'SELECTED_CAT' => $pic_cat,
	'SELECTED_CAT_REG' => $pic_cat_reg,
	'U_SLIDESHOW' => append_sid('otf_slideshow.' . $phpEx . '?pic_cat=' . $pic_cat),
	'S_CATEGORY_SELECT' => $s_categories,
	'S_COLSPAN' => $s_colspan,
	'S_COLWIDTH' => $s_colwidth,
	'S_ACTION' => append_sid('otf_gallery.' . $phpEx),
	'PAGINATION' => generate_pagination($pagination_url, $pic_images[$pic_cat]['pics_count'], $pics_per_page, $start),
	'PAGE_NUMBER' => on_page($pic_images[$pic_cat]['pics_count'], $pics_per_page, $start),
	'TOTAL_PICS' => $pic_images[$pic_cat]['pics_count'] . '&nbsp;' . $user->lang['PICS_IN_CAT'],
	)
);

page_footer();

?>