<?php
/**
*
* @package FAP
* @version $Id: otf_pic.php
* @copyright (c) 2007 Mighty Gorgon
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/

define('IN_PHPBB', true);
$phpbb_root_path = './';
$phpEx = substr(strrchr(__FILE__, '.'), 1);
include($phpbb_root_path . 'common.' . $phpEx);

// Start session management
$user->session_begin();
$auth->acl($user->data);
$user->setup();

// Get general album information
if (!defined('ALBUM_INCLUDE_PATH'))
{
	define('ALBUM_INCLUDE_PATH', 'includes/fap/');
}
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'otf_config.' . $phpEx);
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'otf_functions.' . $phpEx);
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'album_image_class.' . $phpEx);

if ( !$user->data['is_registered'] && ($album_config['show_images_guests'] == false) )
{
	generate_guests_img('not_allowed');
	return;
}

if ( $album_config['allow_hotlinks'] == false )
{
	$referer = (!empty($_SERVER['HTTP_REFERER'])) ? $_SERVER['HTTP_REFERER'] : getenv('HTTP_REFERER');
	if (!empty($referer))
	{
		if (check_referer($referer, $album_config['allowed_hotlinks']) == false)
		{
			generate_no_hotlink_img('no_hotlink');
			exit;
		}
	}
}

$pic_id = request_var('pic_id', '0');

if (empty($pic_id))
{
	trigger_error('PIC_NOT_SPECIFIED');
}

$pic_cat = request_var('pic_cat', '0');

if (empty($pic_cat))
{
	trigger_error('CAT_NOT_SPECIFIED');
}

$pic_filename = $pic_id;
$pic_fullpath = ALBUM_OTF_PATH . $pic_cat . '/' . $pic_filename;

$file_details = get_file_details($pic_filename);
$pic_title = $file_details['name'];
$pic_filetype = strtolower($file_details['ext']);
$pic_title_reg = ereg_replace("[^A-Za-z0-9]", '_', $pic_title);
$pic_filename_reg = $pic_title_reg . $album_config['thumb_x_suffix'] . '.' . $pic_filetype;

$pic_thumbnail = $pic_cat . '_' . $pic_title . '.' . $pic_filetype;
$pic_thumbnail_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail;

switch ($pic_filetype)
{
	case 'gif':
		$file_header = 'Content-type: image/gif';
		break;
	case 'jpeg':
	case 'jpg':
		$file_header = 'Content-type: image/jpeg';
		break;
	case 'png':
		$file_header = 'Content-type: image/png';
		break;
	default:
		generate_no_thumb_img($pic_title_reg);
		exit;
		break;
}

header($file_header);
header('Content-Disposition: filename=' . $pic_filename_reg);
readfile($pic_fullpath);
exit;

?>