<?php
/**
*
* @package FAP
* @version $Id: otf_slideshow.php
* @copyright (c) 2007 Mighty Gorgon
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/

define('IN_PHPBB', true);
$phpbb_root_path = './';
$phpEx = substr(strrchr(__FILE__, '.'), 1);
include($phpbb_root_path . 'common.' . $phpEx);

// Start session management
$user->session_begin();
$auth->acl($user->data);
$user->setup();

// Get general album information
if (!defined('ALBUM_INCLUDE_PATH'))
{
	define('ALBUM_INCLUDE_PATH', 'includes/fap/');
}
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'otf_config.' . $phpEx);
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'otf_functions.' . $phpEx);
// Page Keywords
$page_keywords = $album_config['page_keywords'];
// XML Filename
$xml_filename = $album_config['xml_filename'];

$pic_cat = request_var('pic_cat', '');

$pic_images = array();
$pic_cat_names = array();
$pic_file_names = array();
$pic_names = array();
$dir = @opendir(ALBUM_OTF_PATH);

//while( $file = @readdir($dir) )
while(false !== ($file = readdir($dir)))
{
	if( ($file != '.') && ($file != '..') && (!is_file(ALBUM_OTF_PATH . $file)) && (!is_link(ALBUM_OTF_PATH . $file)) )
	{
		$sub_dir = @opendir(ALBUM_OTF_PATH . $file);

		$pic_t_counter = 0;
		while( $sub_file = @readdir($sub_dir) )
		{
			if ( ($sub_file != '.') && ($sub_file != '..') && (!is_link($sub_file)) )
			{
				$file_details = get_file_details($sub_file);
				if ( in_array(strtolower($file_details['ext']), $album_config['allowed_extensions']) )
				{
					$pic_images[$file][$pic_t_counter] = $file . '/' . $sub_file;
					$pic_cat_names[$file][$pic_t_counter] = $file;
					$pic_file_names[$file][$pic_t_counter] = $sub_file;
					$pic_names[$file][$pic_t_counter] = ucfirst(str_replace("_", " ", preg_replace('/^(.*)\..*$/', '\1', $sub_file)));
					$pic_t_counter++;
				}
			}
		}
		$pic_images[$file]['pics_count'] = $pic_t_counter;
		@closedir($sub_dir);
	}
}

@closedir($dir);

@ksort($pic_images);
@reset($pic_images);

if( empty($pic_cat) )
{
	list($pic_cat) = each($pic_images);
}
@reset($pic_images);

$pic_cat_reg = ereg_replace("[^A-Za-z0-9]", "_", $pic_cat);

// Generate XML - BEGIN
$prog_name = 'OTF Gallery 1.0.0';
$verinfo = 'V100';
$encoding_charset = 'UTF-8';
$xml_path = ALBUM_XML_PATH;
$xml_file = $xml_path . $pic_cat_reg . '.xml';
$server_url = generate_board_url() . '/';
$xml_otf_header = '<' . '?xml version="1.0" encoding="' . $encoding_charset . '"?' . '>
<root>
	<images>
';
$xml_otf_body = '';
$xml_otf_footer = '	</images>
</root>';

for($i = 0; $i < $pic_images[$pic_cat]['pics_count']; $i++)
{
	$pic_name = $pic_names[$pic_cat][$i];
	$pic_img_url_direct = append_sid($server_url . ALBUM_OTF_PATH . $pic_images[$pic_cat][$i]);
	$pic_url_append = 'pic_cat=' . $pic_cat_names[$pic_cat][$i] . '&amp;pic_id=' . $pic_file_names[$pic_cat][$i];
	$pic_img_url = append_sid($server_url . 'otf_pic.' . $phpEx . '?' . $pic_url_append);
	$pic_img_thumb = append_sid($server_url . 'otf_thumbnail.' . $phpEx . '?' . $pic_url_append);
	$thumb_s_full_path = append_sid($server_url . 'otf_thumbnail.' . $phpEx . '?' . $pic_url_append . '&amp;t_type=s');
	$thumb_l_full_path = append_sid($server_url . 'otf_thumbnail.' . $phpEx . '?' . $pic_url_append . '&amp;t_type=l');
	$xml_otf_body .= '		<image thumb="' . $thumb_s_full_path . '" url="' . $thumb_l_full_path . '" description="' . $pic_name . '"></image>
';
}
$xml_content = $xml_otf_header . $xml_otf_body . $xml_otf_footer;

$fp = fopen($xml_file, 'w');
@fwrite($fp, $xml_content);
@fclose($fp);
// Generate XML - END

$tmp_xml = $xml_path . $pic_cat_reg . '.xml';
if (file_exists($tmp_xml))
{
	$xml_filename = $xml_path . $pic_cat_reg;
}
if (!empty($_GET['xml']))
{
	$tmp_xml = $_GET['xml'] . '.xml';
	if (file_exists($tmp_xml))
	{
		$xml_filename = $_GET['xml'];
	}
}

$l_title = $user->lang['ALBUM_OTF'];
page_header($l_title);
$template->set_filenames(array('body' => 'otf_slideshow_body.html'));
$template->assign_vars(array(
	'SS_PATH' => ALBUM_FILES_PATH,
	'OTF_VERSION' => $album_config['otf_version'],
	'KEYWORDS' => $page_keywords,
	'XML_FILENAME' => $xml_filename,
	)
);
page_footer();

?>