<?php
/**
*
* @package FAP
* @version $Id: otf_thumbnail.php
* @copyright (c) 2007 Mighty Gorgon
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/

define('IN_PHPBB', true);
$phpbb_root_path = './';
$phpEx = substr(strrchr(__FILE__, '.'), 1);
include($phpbb_root_path . 'common.' . $phpEx);

// Start session management
$user->session_begin();
$auth->acl($user->data);
$user->setup();

// Get general album information
if (!defined('ALBUM_INCLUDE_PATH'))
{
	define('ALBUM_INCLUDE_PATH', 'includes/fap/');
}
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'otf_config.' . $phpEx);
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'otf_functions.' . $phpEx);
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'album_image_class.' . $phpEx);

if ( !$user->data['is_registered'] && ($album_config['show_images_guests'] == false) )
{
	generate_guests_img('not_allowed');
	exit;
}

if ( $album_config['allow_hotlinks'] == false )
{
	$referer = (!empty($_SERVER['HTTP_REFERER'])) ? $_SERVER['HTTP_REFERER'] : getenv('HTTP_REFERER');
	if (!empty($referer))
	{
		if (check_referer($referer, $album_config['allowed_hotlinks']) == false)
		{
			generate_no_hotlink_img('no_hotlink');
			exit;
		}
	}
}

$thumb_type = request_var('t_type', '');
$pic_id = request_var('pic_id', '0');

if (empty($pic_id))
{
	trigger_error('PIC_NOT_SPECIFIED');
}

$pic_cat = request_var('pic_cat', '0');

if (empty($pic_cat))
{
	trigger_error('CAT_NOT_SPECIFIED');
}

switch ($thumb_type)
{
	case 's':
		$album_config['thumbs_x_path'] = $album_config['thumbs_s_path'];
		$album_config['thumb_x_suffix'] = $album_config['thumb_s_suffix'];
		$album_config['thumb_x_w'] = $album_config['thumb_s_w'];
		$album_config['thumb_x_h'] = $album_config['thumb_s_h'];
		$album_config['force_x_w_h'] = $album_config['force_s_w_h'];
		break;
	case 'm':
		$album_config['thumbs_x_path'] = $album_config['thumbs_m_path'];
		$album_config['thumb_x_suffix'] = $album_config['thumb_m_suffix'];
		$album_config['thumb_x_w'] = $album_config['thumb_m_w'];
		$album_config['thumb_x_h'] = $album_config['thumb_m_h'];
		$album_config['force_x_w_h'] = $album_config['force_m_w_h'];
		break;
	case 'l':
		$album_config['thumbs_x_path'] = $album_config['thumbs_l_path'];
		$album_config['thumb_x_suffix'] = $album_config['thumb_l_suffix'];
		$album_config['thumb_x_w'] = $album_config['thumb_l_w'];
		$album_config['thumb_x_h'] = $album_config['thumb_l_h'];
		$album_config['force_x_w_h'] = $album_config['force_l_w_h'];
		break;
}

$pic_filename = $pic_id;
$pic_fullpath = ALBUM_OTF_PATH . $pic_cat . '/' . $pic_filename;

$file_details = get_file_details($pic_filename);
$pic_title = $file_details['name'];
$pic_filetype = strtolower($file_details['ext']);
$pic_title_reg = ereg_replace("[^A-Za-z0-9]", '_', $pic_title);
$pic_filename_reg = $pic_title_reg . $album_config['thumb_x_suffix'] . '.' . $pic_filetype;

$pic_thumbnail = $pic_cat . '_' . $pic_title . $album_config['thumb_x_suffix'] . '.' . $pic_filetype;
$pic_thumbnail_fullpath = $album_config['thumbs_x_path'] . $pic_thumbnail;

if (!in_array($pic_filetype, $album_config['allowed_extensions']))
{
	generate_no_thumb_img($pic_title_reg);
	exit;
}

// --------------------------------
// Check thumbnail cache. If cache is available we will SEND & EXIT
// --------------------------------

if( ($album_config['thumbnail_cache'] == 1) && file_exists($pic_thumbnail_fullpath) )
{
	switch ($pic_filetype)
	{
		case 'gif':
			$file_header = 'Content-type: image/gif';
			break;
		case 'jpeg':
		case 'jpg':
			$file_header = 'Content-type: image/jpeg';
			break;
		case 'png':
			$file_header = 'Content-type: image/png';
			break;
		default:
			generate_no_thumb_img($pic_title_reg);
			exit;
			break;
	}
	header($file_header);
	header('Content-Disposition: filename=' . $pic_filename_reg);
	readfile($pic_thumbnail_fullpath);
	exit;
}

if( !file_exists($pic_fullpath) )
{
	trigger_error('PIC_NOT_EXIST');
}

$pic_size = @getimagesize($pic_fullpath);
$pic_width = $pic_size[0];
$pic_height = $pic_size[1];

if( ($pic_width < $album_config['thumb_x_w']) && ($pic_height < $album_config['thumb_x_h']) )
{
	switch ($pic_filetype)
	{
		case 'gif':
			$file_header = 'Content-type: image/gif';
			break;
		case 'jpeg':
		case 'jpg':
			$file_header = 'Content-type: image/jpeg';
			break;
		case 'png':
			$file_header = 'Content-type: image/png';
			break;
		default:
			generate_no_thumb_img($pic_title_reg);
			exit;
			break;
	}
	@copy($pic_fullpath, $pic_thumbnail_fullpath);
	@chmod($pic_thumbnail_fullpath, 0777);
	header($file_header);
	header('Content-Disposition: filename=' . $pic_filename_reg);
	readfile($pic_fullpath);
	exit;
}
else
{
	// --------------------------------
	// Cache is empty. Try to re-generate!
	// --------------------------------
	$t_width = $album_config['thumb_x_w'];
	$t_height = $album_config['thumb_x_h'];
	$pic_ratio = $pic_width / $pic_height;
	$t_ratio = $t_width / $t_height;
	$x_offset = 0;
	$y_offset = 0;
	$dest_width = $t_width;
	$dest_height = $t_height;
	$force_size = $album_config['force_x_w_h'];
	if ($force_size == true)
	{
		if ($pic_ratio > $t_ratio)
		{
			$x_tmp = $pic_width;
			$x_ratio = 1 - ( (($pic_width / $pic_height) - ($t_width / $t_height)) / 2 );
			$pic_width = round($pic_width * $x_ratio, 0);
			$x_offset = round(($x_tmp - $pic_width) / 2, 0);
			//$x_offset = round((($t_height * $pic_ratio) - $t_width) / 2, 0);
		}
		else
		{
			$y_tmp = $pic_height;
			$y_ratio = 1 - ( (($t_width / $t_height) - ($pic_width / $pic_height)) / 2);
			$pic_height = round($pic_height * $y_ratio, 0);
			$y_offset = round(($y_tmp - $pic_height) / 2, 0);
			//$y_offset = round((($t_width / $pic_ratio) - $t_height) / 2, 0);
		}
	}
	else
	{
		if ( ($pic_width <= $t_width) && ($pic_height <= $t_height) )
		{
			$dest_width = $pic_width;
			$dest_height = $pic_height;
		}
		else
		{
			if ($pic_ratio > $t_ratio)
			{
				$dest_height = round($t_width / $pic_ratio, 0);
			}
			else
			{
				$dest_width = round($t_height * $pic_ratio, 0);
			}
		}
	}

	// Old Thumbnails - BEGIN
	// Old thumbnail generation functions, for GD1 and some strange servers...
	if ( ($album_config['gd_version'] == 1) || ($album_config['use_old_pics_gen'] == 1) )
	{
		switch ($pic_filetype)
		{
			case 'gif':
				generate_no_thumb_img($pic_title_reg);
				exit;
				break;
		}
		$dh_delta = 0;
		if( $album_config['show_pic_size_on_thumb'] == 1)
		{
			$dh_delta = 16;
		}
		$thumbnail = ($album_config['gd_version'] == 1) ? @imagecreate($dest_width, $dest_height + $dh_delta) : @imagecreatetruecolor($dest_width, $dest_height + $dh_delta);

		$resize_function = ($album_config['gd_version'] == 1) ? 'imagecopyresized' : 'imagecopyresampled';

		@$resize_function($thumbnail, $pic_fullpath, 0, 0, $x_offset, $y_offset, $dest_width, $dest_height, $pic_width, $pic_height);

		if( $album_config['show_pic_size_on_thumb'] == 1)
		{
			$dimension_font = 1;
			$dimension_filesize = @filesize($pic_fullpath);
			$dimension_string = intval($pic_width) . 'x' . intval($pic_height) . '(' . intval($dimension_filesize / 1024) . 'KB)';
			$dimension_colour = ImageColorAllocate($thumbnail, 255, 255, 255);
			$dimension_height = imagefontheight($dimension_font);
			$dimension_width = imagefontwidth($dimension_font) * strlen($dimension_string);
			$dimension_x = ($dest_width - $dimension_width) / 2;
			$dimension_y = $dest_height + ((16 - $dimension_height) / 2);
			imagestring($thumbnail, 1, $dimension_x, $dimension_y, $dimension_string, $dimension_colour);
		}

		if ($album_config['thumbnail_cache'] == 1)
		{
			// ------------------------
			// Re-generate successfully. Write it to disk!
			// ------------------------
			switch ($pic_filetype)
			{
				case 'jpg':
					@imagejpeg($thumbnail, $pic_thumbnail_fullpath, $album_config['thumbnail_quality']);
					break;
				case 'png':
					@imagepng($thumbnail, $pic_thumbnail_fullpath);
					break;
			}
			@chmod($pic_thumbnail_fullpath, 0777);
		}

		// ----------------------------
		// After write to disk, donot forget to send to browser also
		// ----------------------------
		switch ($pic_filetype)
		{
			case 'jpg':
				@imagejpeg($thumbnail, '', $album_config['thumbnail_quality']);
				break;
			case 'png':
				@imagepng($thumbnail);
				break;
			default:
				generate_no_thumb_img($pic_title_reg);
				break;
		}
		exit;
	}
	// Old Thumbnails - END

	$Image = new ImgObj();

	if ($pic_filetype == 'jpg')
	{
		$Image->ReadSourceFileJPG($pic_fullpath);
	}
	else
	{
		$Image->ReadSourceFile($pic_fullpath);
	}

	$Image->Resize_Smart($dest_width, $dest_height, $album_config['force_x_w_h']);

	if( $album_config['show_pic_size_on_thumb'] == 1)
	{
		$dimension_string = intval($pic_width) . 'x' . intval($pic_height) . '(' . intval(filesize($pic_fullpath) / 1024) . 'KB)';
		$Image->Text($dimension_string);
	}

	if ($album_config['thumbnail_cache'] == 1)
	{
		if ($pic_filetype == 'jpg')
		{
			$Image->SendToFileJPG($pic_thumbnail_fullpath, $album_config['thumbnail_quality']);
		}
		else
		{
			$Image->SendToFile($pic_thumbnail_fullpath, $album_config['thumbnail_quality']);
		}
	}

	if ($pic_filetype == 'jpg')
	{
		$Image->SendToBrowserJPG($pic_title_reg, $pic_filetype, '', $album_config['thumb_x_suffix'], $album_config['thumbnail_quality']);
	}
	else
	{
		$Image->SendToBrowser($pic_title_reg, $pic_filetype, '', $album_config['thumb_x_suffix'], $album_config['thumbnail_quality']);
	}

	if ( $Image == true )
	{
		$Image->Destroy();
		exit;
	}
	else
	{
		$Image->Destroy();
		generate_no_thumb_img($pic_title_reg);
		exit;
	}
}

?>