<?php
/**
*
* @package FAP
* @version $Id: otf_upload.php
* @copyright (c) 2007 Mighty Gorgon
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/

define('IN_PHPBB', true);
$phpbb_root_path = './';
$phpEx = substr(strrchr(__FILE__, '.'), 1);
include($phpbb_root_path . 'common.' . $phpEx);

// Start session management
$user->session_begin();
$auth->acl($user->data);
$user->setup();

// Get general album information
if (!defined('ALBUM_INCLUDE_PATH'))
{
	define('ALBUM_INCLUDE_PATH', 'includes/fap/');
}
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'otf_config.' . $phpEx);
include($phpbb_root_path . ALBUM_INCLUDE_PATH . 'otf_functions.' . $phpEx);

$l_title = $user->lang['UPLOAD_IMAGE_LOCAL'];
page_header($l_title);

$upload_dir = POSTED_IMAGES_PATH;
$upload_dir_sub_url = ALBUM_FILES_PATH_FOLDER . ALBUM_OTF_PATH_FOLDER . POSTED_IMAGES_PATH_FOLDER;
$maxsize = ( intval($album_config['upload_maxsize']) * 1024);
$maxwidth = $album_config['upload_maxwidth'];
$maxheight = $album_config['upload_maxheight'];

if(isset($_FILES['userfile']))
{
	$file_details = get_file_details($_FILES['userfile']['name']);
	$filename = $file_details['name'];
	$extension = strtolower($file_details['ext']);

	if (!in_array($extension, $album_config['allowed_extensions']))
	{
		trigger_error($user->lang['UPLOAD_FAILURE'] . '<br /><br />' . $user->lang['ALLOWED_EXT'] . implode(', ', $album_config['allowed_extensions']));
	}

	if ( $user->data['user_id'] == ANONYMOUS )
	{
		$filename = 'guest_' . ereg_replace("[^A-Za-z0-9]", '_', $filename);
	}
	else
	{
		$filename = 'user_' . $user->data['user_id'] . '_' . ereg_replace("[^A-Za-z0-9]", '_', $filename);
	}
	while (file_exists($upload_dir . $filename . '.' . $extension))
	{
		$filename = $filename . '_' . time() . '_' . mt_rand(100000, 999999);
	}
	$filename_tmp = $_FILES['userfile']['tmp_name'];
	$file_size = $_FILES['userfile']['size'];

	if(empty($filename))
	{
		trigger_error($user->lang['UPLOAD_EMPTY']);
	}

	if($file_size > $maxsize)
	{
		trigger_error($user->lang['UPLOAD_FAILURE'] . '<br /><br />' . $user->lang['UPLOAD_FAILURE_TOO_BIG'] . '<br /><br />' . $user->lang['MAX_ALLOWED_SIZE'] . floor($maxsize / 1024) . 'SIZE_KB');
	}

	if(is_uploaded_file($filename_tmp))
	{
		move_uploaded_file($filename_tmp, $upload_dir . $filename . '.' . $extension);
	}

	$pic_size = @getimagesize($upload_dir . $filename . '.' . $extension);
	if( $pic_size == false )
	{
		unlink($upload_dir . $filename . '.' . $extension);
		trigger_error($user->lang['UPLOAD_FAILURE'] . '<br /><br />' . $user->lang['ERROR_ALLOWED_EXT'] . str_replace(',', ', ', $filetypes));
	}

	if ( ($pic_size[0] > $maxwidth) || ($pic_size[1] > $maxheight) )
	{
		unlink($upload_dir . $filename . '.' . $extension);
		die($pic_size[0] . 'x' . $pic_size[1]);
		trigger_error($user->lang['UPLOAD_FAILURE'] . '<br /><br />' . $user->lang['UPLOAD_FAILURE_TOO_BIG'] . '<br /><br />' . $user->lang['MAX_ALLOWED_DIMENSION'] . ($maxwidth . 'x' . $maxheight));
	}

	$template->set_filenames(array('body' => 'otf_uploaded_image_popup.html'));

	$pic_img_url_direct = append_sid(ALBUM_OTF_PATH . $filename . '.' . $extension);
	$pic_img_url = append_sid('otf_pic.' . $phpEx . '?pic_cat=' . POSTED_IMAGES_PATH_FOLDER_PLAIN . '&amp;pic_id=' . $filename . '.' . $extension);
	$pic_img_thumb = append_sid('otf_thumbnail.' . $phpEx . '?pic_cat=' . POSTED_IMAGES_PATH_FOLDER_PLAIN . '&amp;pic_id=' . $filename . '.' . $extension);

	$template->assign_vars(array(
		'S_ACTION' => append_sid($phpbb_root_path . 'otf_upload.' . $phpEx),
		'PIC_IMAGE' => $phpbb_root_path . $pic_img_url,
		'PIC_THUMB' => $phpbb_root_path . $pic_img_thumb,
		'PIC_BBCODE' => '[url=' . generate_board_url() . '/' . $pic_img_url . '][img]' . generate_board_url() . '/' . $pic_img_thumb . '[/img][/url]',
		)
	);
}
else
{
	$template->set_filenames(array('body' => 'otf_upload_image_popup.html'));

	$template->assign_vars(array(
		'S_ACTION' => append_sid($phpbb_root_path . 'otf_upload.' . $phpEx),
		'ALLOWED_EXT_FULL' => $user->lang['ALLOWED_EXT'] . implode(', ', $album_config['allowed_extensions']),
		'ALLOWED_SIZE_FULL' => $user->lang['MAX_ALLOWED_SIZE'] . floor($maxsize / 1024) . $user->lang['SIZE_KB'],
		'ALLOWED_DIMENSION_FULL' => $user->lang['MAX_ALLOWED_DIMENSION'] . ($maxwidth . 'x' . $maxheight),
		)
	);
}

page_footer();

?>