<?php
/**
*
* @package Mighty Gorgon - Icy Phoenix - Instant Gallery
* @version 1.0.0 - [2007/11/22]
* @copyright (c) 2007 Mighty Gorgon
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

// Page Title & Keywords
$page_title = 'Icy Phoenix - Instant Gallery';
$page_keywords = 'gallery,album,pictures,instant gallery,thumbnails,instant thumbnails,slideshow,flash gallery,flash slideshow,icy phoenix,mighty gorgon,flepstudio';

// Encoding Charset
$encoding_charset = 'UTF-8';

// Path for default style
$style_path = 'style_blue.css';

// XML Filename
$xml_filename = 'images';

// Thumbs [S=SMALL - M=MEDIUM - LARGE]
// Path for thumbs
$thumbs_s_path = '';
$thumbs_m_path = '';
$thumbs_l_path = '';

// Thumbs suffix
$thumb_s_suffix = '_thumb';
$thumb_m_suffix = '_mid';
$thumb_l_suffix = '_large';

// Thumbs Size [W=WIDTH - H=HEIGHT]
$thumb_s_w = '40';
$thumb_s_h = '40';
$thumb_m_w = '120';
$thumb_m_h = '90';
$thumb_l_w = '600';
$thumb_l_h = '450';

// Force Width & Height to be identical to the specified size (images is scaled then borders added)
// If FALSE then W & H are scaled proportionally to mantain aspect ratio
$force_s_w_h = true;
$force_m_w_h = false;
$force_l_w_h = false;

// Thumbs quality ratio
$thumb_quality = '75';

// Allowed extensions
$allowed_extensions = array('gif', 'jpg', 'jpeg', 'png');

// Use frame
$use_frame = false;

if (!empty($_GET['xml']))
{
	$tmp_xml = $_GET['xml'] . '.xml';
	if (file_exists($tmp_xml))
	{
		$xml_var = $_GET['xml'];
	}
	else
	{
		$xml_var = $xml_filename;
	}
// Output - Slideshow - BEGIN
?>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo($encoding_charset); ?>" />
	<meta name="generator" content="Icy Phoenix" />
	<meta name="author" content="Mighty Gorgon - FlepStudio" />
	<meta name="keywords" content="<?php echo($page_keywords); ?>" />
	<title><?php echo($page_title . ' :: ' . $_SERVER['REQUEST_URI']); ?></title>
	<script language="javascript">AC_FL_RunContent = 0;</script>
	<script src="AC_RunActiveContent.js" language="javascript"></script>
	<style type="text/css">
	<!--
	body {
		margin-left: 0px;
		margin-top: 0px;
		margin-right: 0px;
		margin-bottom: 0px;
		background-color: #003399;
	}
	-->
	</style>
</head>
<body>
<script language="javascript">
if (AC_FL_RunContent == 0)
{
	alert("This page requires AC_RunActiveContent.js.");
}
else
{
	AC_FL_RunContent(
		'id', 'slideshow',
		'name', 'slideshow',
		'src', 'slideshow',
		'movie', 'slideshow',
		'codebase', 'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0',
		'pluginspage', 'http://www.macromedia.com/go/getflashplayer',
		'width', '100%',
		'height', '100%',
		'align', 'middle',
		'quality', 'high',
		'scale', 'noscale',
		'salign', 'lt',
		'bgcolor', '#ffffff',
		'allowscriptaccess', 'sameDomain',
		'allowfullscreen', 'false',
		'flashvars', 'xml=<?php echo($xml_var); ?>'
	);
}
</script>
<noscript>
	<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0" width="100%" height="100%" id="slideshow" align="middle">
	<param name="bgcolor" value="#ffffff" />
	<param name="quality" value="high" />
	<param name="scale" value="noscale" />
	<param name="salign" value="lt" />
	<param name="allowScriptAccess" value="sameDomain" />
	<param name="allowFullScreen" value="false" />
	<param name="movie" value="slideshow.swf" />
	<param name="flashvars" value="xml=<?php echo($xml_var); ?>" />
	<embed src="slideshow.swf" quality="high" scale="noscale" salign="lt" bgcolor="#ffffff" width="100%" height="100%" name="slideshow" align="middle" allowScriptAccess="sameDomain" allowFullScreen="false" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" flashvars="xml=<?php echo($xml_var); ?>" />
	</object>
</noscript>
</body>
</html>
<?php
// Output - Slideshow - END
}
else
{
// Output - Icy Phoenix - Instant Gallery - BEGIN
ob_start();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo($encoding_charset); ?>" />
	<meta name="generator" content="Icy Phoenix" />
	<meta name="author" content="Mighty Gorgon - FlepStudio" />
	<meta name="keywords" content="<?php echo($page_keywords); ?>" />
	<title><?php echo($page_title . ' :: ' . $_SERVER['REQUEST_URI']); ?></title>
	<link rel="stylesheet" href="style_blue.css" type="text/css" />
	<!-- <script type="text/javascript" src="scripts.js"></script> -->
</head>
<body>

<div id="head">
<h1><a href="<?php echo('http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); ?>"><?php echo($page_title); ?></a></h1>
<h2><a href="<?php echo('http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . '?xml=' . $xml_filename); ?>">Slideshow</a></h2>
</div>

<?php ob_flush() ?>

<div id="box_content">

<?php

$file_details = array();
$xml_body = '<root>
	<images>
';
$dir = opendir('.');
while ($f = readdir($dir))
{
	if (($f != '.') && ($f != '..') && (is_file($f)) && (!is_link($f)))
	{
		$file_details = get_file_details($f);
		$thumb_s = $file_details['name'] . $thumb_s_suffix . '.' . $file_details['ext'];
		$thumb_s_full_path = (($thumbs_s_path == '') ? '' : ($thumbs_s_path . '/')) . $thumb_s;
		$thumb_m = $file_details['name'] . $thumb_m_suffix . '.' . $file_details['ext'];
		$thumb_m_full_path = (($thumbs_m_path == '') ? '' : ($thumbs_m_path . '/')) . $thumb_m;
		$thumb_l = $file_details['name'] . $thumb_l_suffix . '.' . $file_details['ext'];
		$thumb_l_full_path = (($thumbs_l_path == '') ? '' : ($thumbs_l_path . '/')) . $thumb_l;
		if (in_array($file_details['ext'], $allowed_extensions) && (strpos($f, $thumb_s_suffix . '.' . $file_details['ext']) === false) && (strpos($f, $thumb_m_suffix . '.' . $file_details['ext']) === false) && (strpos($f, $thumb_l_suffix . '.' . $file_details['ext']) === false))
		{
			if (!file_exists($thumb_s_full_path))
			{
				create_thumb($f, $thumb_s_w, $thumb_s_h, $thumb_s_suffix, $thumbs_s_path, $thumb_quality, $force_s_w_h);
			}
			if (!file_exists($thumb_m_full_path))
			{
				create_thumb($f, $thumb_m_w, $thumb_m_h, $thumb_m_suffix, $thumbs_m_path, $thumb_quality, $force_m_w_h);
			}
			if (!file_exists($thumb_l_full_path))
			{
				create_thumb($f, $thumb_l_w, $thumb_l_h, $thumb_l_suffix, $thumbs_l_path, $thumb_quality, $force_l_w_h);
			}
			$xml_body .= '		<image thumb="' . $thumb_s_full_path . '" url="' . $thumb_l_full_path . '" description="' . $f . '"></image>
';
			create_thumb_box($f, $thumb_m_full_path, $use_frame);
		}
	}
}
closedir($dir);

$xml_body .= '	</images>
</root>';
xml_output($xml_filename . '.xml', $xml_body, $encoding_charset);

ob_end_flush();

?>

</div>
<br />
<div id="footer">Instant Gallery powered by <a href="http://www.icyphoenix.com/">Icy Phoenix</a> &copy;2007 &amp; <a href="http://www.mightygorgon.com/">Mighty Gorgon</a><br />Elastic Gallery Slideshow powered by <a href="http://www.flepstudio.org/">FlepStudio</a></div>
</body>
</html>

<?php
// Output - Icy Phoenix - Instant Gallery - END
}


// FUNCTIONS

/*
Function any_url_exists to check whether a file exists on any domain.
*/
function any_url_exists($url)
{
	$a_url = parse_url($url);
	if (!isset($a_url['port']))
	{
		$a_url['port'] = 80;
	}
	$errno = 0;
	$errstr = '';
	$timeout = 30;
	if( (isset($a_url['host'])) && ($a_url['host'] != gethostbyname($a_url['host'])) )
	{
		$fid = fsockopen($a_url['host'], $a_url['port'], $errno, $errstr, $timeout);
		if (!$fid) return false;
		$page = isset($a_url['path']) ? $a_url['path'] : '';
		$page .= isset($a_url['query']) ? '?' . $a_url['query'] : '';
		fputs($fid, 'HEAD ' . $page . ' HTTP/1.0' . "\r\n" . 'Host: ' . $a_url['host'] . "\r\n\r\n");
		$head = fread($fid, 4096);
		fclose($fid);
		return preg_match('#^HTTP/.*\s+[200|302]+\s#i', $head);
	}
	else
	{
		return false;
	}
}

/*
Function get_full_image_info
*/
define ('IMAGE_WIDTH', 'width');
define ('IMAGE_HEIGHT', 'height');
define ('IMAGE_TYPE', 'type');
define ('IMAGE_ATTR', 'attr');
define ('IMAGE_BITS', 'bits');
define ('IMAGE_CHANNELS', 'channels');
define ('IMAGE_MIME', 'mime');

/**
 * mixed get_full_image_info( file $file [, string $out] )
 *
 * Returns information about $file.
 *
 * If the second argument is supplied, a string representing that information will be returned.
 *
 * Valid values for the second argument are IMAGE_WIDTH, 'width', IMAGE_HEIGHT, 'height', IMAGE_TYPE, 'type',
 * IMAGE_ATTR, 'attr', IMAGE_BITS, 'bits', IMAGE_CHANNELS, 'channels', IMAGE_MIME, and 'mime'.
 *
 * If only the first argument is supplied an array containing all the information is returned,
 * which will look like the following:
 *
 *    [width] => int (width),
 *    [height] => int (height),
 *    [type] => string (type),
 *    [attr] => string (attributes formatted for IMG tags),
 *    [bits] => int (bits),
 *    [channels] => int (channels),
 *    [mime] => string (mime-type)
 *
 * Returns false if $file is not a file, no arguments are supplied, $file is not an image, or otherwise fails.
 *
 **/
function get_full_image_info($file = null, $out = null)
{
	// If $file is not supplied or is not a file, warn the user and return false.
	//if (is_null($file) || !any_url_exists($file))
	if (is_null($file) || !is_file($file))
	{
		//echo '<p><b>Warning:</b> image_info() => first argument must be a file.</p>';
		//echo '<br /><br />' . $file . '<br /><br />';
		return false;
	}

	// Defines the keys we want instead of 0, 1, 2, 3, 'bits', 'channels', and 'mime'.
	$redefine_keys = array(
		'width',
		'height',
		'type',
		'attr',
		'bits',
		'channels',
		'mime',
	);

	// If $out is supplied, but is not a valid key, nullify it.
	if (!is_null($out) && !in_array($out, $redefine_keys))
	{
		$out = null;
	}

	// Assign usefull values for the third index.
	$types = array(
		1 => 'GIF',
		2 => 'JPG',
		3 => 'PNG',
		4 => 'SWF',
		5 => 'PSD',
		6 => 'BMP',
		7 => 'TIFF(intel byte order)',
		8 => 'TIFF(motorola byte order)',
		9 => 'JPC',
		10 => 'JP2',
		11 => 'JPX',
		12 => 'JB2',
		13 => 'SWC',
		14 => 'IFF',
		15 => 'WBMP',
		16 => 'XBM'
	);
	$temp = array();
	$data = array();

	// Get the image info using getimagesize().
	// If $temp fails to populate, warn the user and return false.
	if (!$temp = @getimagesize($file))
	{
		//echo '<p><b>Warning:</b> image_info() => first argument must be an image.</p>';
		return false;
	}

	// Get the values returned by getimagesize()
	$temp = array_values($temp);

	// Make an array using values from $redefine_keys as keys and values from $temp as values.
	foreach ($temp as $k => $v)
	{
		$data[$redefine_keys[$k]] = $v;
	}

	// Make 'type' useful.
	$data['type'] = $types[$data['type']];

	// Return the desired information.
	return !is_null($out) ? $data[$out] : $data;
}

/*
* get_file_details
* Get File Details: name, extension
*/
function get_file_details($file_name)
{
	$file_details = array();
	$file_tmp = str_replace ('http://', '', $file_name);
	$file_path[] = array();
	$file_path = explode('/', $file_tmp);
	$file_details['name_full'] = $file_path[(count(explode('/', $file_tmp))) - 1];
	$file_part = explode('.', strtolower($file_details['name_full']));
	$file_details['ext'] = $file_part[sizeof($file_part) - 1];
	$file_details['name'] = substr($file_details['name_full'], 0, strlen($file_details['name_full']) - strlen($file_details['ext']) - 1);
	return $file_details;
}

/*
* create_thumb
* Thumbnails Creation
*/
function create_thumb($source_pic, $t_width, $t_height, $t_suffix = '', $t_path = '', $t_quality = '75', $force_size = false)
{
	global $allowed_extensions;
	$file_details = array();
	$pic_fullpath = str_replace(array(' '), array('%20'), $source_pic);
	$file_details = get_file_details($source_pic);
	$pic_filename = $file_details['name_full'];
	$pic_title = $file_details['name'];
	$pic_filetype = $file_details['ext'];
	$pic_title_reg = preg_replace('/[^A-Za-z0-9]+/', '_', $pic_title);
	$pic_thumbnail = $pic_title . $t_suffix . '.' . $pic_filetype;
	if (!in_array($pic_filetype, $allowed_extensions))
	{
		return false;
	}

	$pic_size = get_full_image_info($source_pic);
	if( $pic_size == false )
	{
		return false;
	}

	$pic_width = $pic_size['width'];
	$pic_height = $pic_size['height'];
	$pic_filetype_new = strtolower($pic_size['type']);
	$pic_thumbnail_fullpath = ( ($t_path == '') ? '' : ($t_path . '/') ) . $pic_thumbnail;

	switch($pic_filetype_new)
	{
		case 'gif':
			$img_tmp = @imagecreatefromgif($source_pic);
			break;
		case 'jpg':
			$img_tmp = @imagecreatefromjpeg($source_pic);
			break;
		case 'png':
			$img_tmp = @imagecreatefrompng($source_pic);
			break;
		default:
			return false;
			break;
	}

	$pic_ratio = $pic_width / $pic_height;
	$t_ratio = $t_width / $t_height;
	$x_offset = 0;
	$y_offset = 0;
	$dest_width = $t_width;
	$dest_height = $t_height;
	if ($force_size == true)
	{
		if ($pic_ratio > $t_ratio)
		{
			$x_tmp = $pic_width;
			$x_ratio = 1 - ( (($pic_width / $pic_height) - ($t_width / $t_height)) / 2 );
			$pic_width = round($pic_width * $x_ratio, 0);
			$x_offset = round(($x_tmp - $pic_width) / 2, 0);
			//$x_offset = round((($t_height * $pic_ratio) - $t_width) / 2, 0);
		}
		else
		{
			$y_tmp = $pic_height;
			$y_ratio = 1 - ( (($t_width / $t_height) - ($pic_width / $pic_height)) / 2);
			$pic_height = round($pic_height * $y_ratio, 0);
			$y_offset = round(($y_tmp - $pic_height) / 2, 0);
			//$y_offset = round((($t_width / $pic_ratio) - $t_height) / 2, 0);
		}
	}
	else
	{
		if ( ($pic_width <= $t_width) && ($pic_height <= $t_height) )
		{
			$dest_width = $pic_width;
			$dest_height = $pic_height;
			if ( ($t_path != '') && !file_exists($t_path) )
			{
				@mkdir ($t_path, 0777);
			}
			@copy($source_pic, $pic_thumbnail_fullpath);
			@chmod($pic_thumbnail_fullpath, 0755);
			return true;
		}
		else
		{
			if ($pic_ratio > $t_ratio)
			{
				$dest_height = round($t_width / $pic_ratio, 0);
			}
			else
			{
				$dest_width = round($t_height * $pic_ratio, 0);
			}
		}
	}

	$img_new = @imagecreatetruecolor($dest_width, $dest_height);
	if (!$img_new)
	{
		return false;
	}

	@imagealphablending($img_new, false);
	@imagecopyresampled($img_new, $img_tmp, 0, 0, $x_offset, $y_offset, $dest_width, $dest_height, $pic_width, $pic_height);
	@imagesavealpha($img_new, true);

	if ( ($t_path != '') && !file_exists($t_path) )
	{
		@mkdir ($t_path, 0777);
	}

	// If you want all thumbnails to be forced as JPG you can decomment these lines
	/*
	imagejpeg ($img_new, $pic_thumbnail_fullpath, '75');
	return true;
	exit;
	*/

	switch ($pic_filetype)
	{
		case 'jpg':
			@imagejpeg($img_new, $pic_thumbnail_fullpath, '75');
			break;
		case 'png':
			@imagepng($img_new, $pic_thumbnail_fullpath);
			break;
		case 'gif':
			@imagegif($img_new, $pic_thumbnail_fullpath);
			break;
		default:
			return false;
			exit;
	}
	@chmod($pic_thumbnail_fullpath, 0755);
	return true;
}

/*
* create_thumb_box
* Thumb Box Creation
*/
function create_thumb_box($pic_full, $pic_thumb, $use_frame = false)
{
	$image_html = '<a href="' . $pic_full . '"><img src="' . $pic_thumb . '" alt="' . $pic_full . '" /></a>';
	if ($use_frame == true)
	{
		$image_html = '<center><table><tr><td><div class="picshadow"><div class="picframe">' . $image_html . '</div></div></td></tr></table></center>';
	}
	$image_box = '';
	$image_box .= '<div class="box">';
	$image_box .= '<div class="box-thumb">' . $image_html . '</div>';
	$image_box .= '<p>' . $pic_full . '</p>';
	//$image_box .= '<p><input class="post" size="20" maxlength="200" value="[url=http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . str_replace(' ', '%20', $pic_full) . '][img]http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . str_replace(' ', '%20', $pic_thumb) . '[/img][/url]" type="text" readonly="readonly" onClick="javascript:this.focus();this.select();" /></p>';
	$image_box .= '<p><textarea rows="1" cols="20" readonly="readonly" onClick="javascript:this.focus();this.select();">[url=http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . str_replace(' ', '%20', $pic_full) . '][img]http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . str_replace(' ', '%20', $pic_thumb) . '[/img][/url]</textarea></p>';
	$image_box .= '</div>';
	echo($image_box);
}

/*
* xml_output
* XML Creation
*/
function xml_output($xml_filename, $xml_body, $encoding_charset)
{
	// Generate XML - BEGIN
	$xml_header = '<' . '?xml version="1.0" encoding="' . $encoding_charset . '"?' . '>';
	$xml_footer = '';
	$xml_content = $xml_header . $xml_body . $xml_footer;
	$fp = fopen($xml_filename, 'w');
	@fwrite($fp, $xml_content);
	@fclose($fp);
	return true;
	// Generate XML - END
}

?>