<?php
/**
*
* @package Icy Phoenix
* @version $Id$
* @copyright (c) 2008 Icy Phoenix
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

if (!defined('IN_ICYPHOENIX'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

$lang['DEMO_VAR'] = 'DEMO VAR';
$lang['BBC_Overview'] = '<ul>
<li><span class="topic_ann"><b>Was ist Icy Phoenix?</b></span><br /></li>
<li><span class="topic_imp">Icy Phoenix ist ein CMS basierend auf phpBB (ein vollständig skalierbares und hoch anpassbares open-source Bulletin Board basierend auf php) zusätzlich vieler Änderungen und Code Integrationen welche dem Ganzen die Flexibilität verleiht. Die offizielle Homepage für phpBB ist <a class="post-url" href="http://www.phpbb.com/" target="_blank">www.phpbb.com</a>. Icy Phoenix hat einige Funktionen ursprünglich für <acronym title="phpBB eXpertS">phpBB XS Project</acronym> entwickelt, welches von Bicet gegründet wurde und dann von Bicet und Mighty Gorgon weiterentwickelt wurde. Icy Phoenix wurde von <a class="post-url" href="http://www.mightygorgon.com/" target="_blank">Mighty Gorgon</a> geschaffen, nachdem er das <acronym title="phpBB eXpertS">phpBB XS Project</acronym> verlassen hatte.</span><br /><br /></li>
<li><span class="topic_ann"><b>Was sind die Hauptmerkmale von Icy Phoenix?</b></span><br /></li>
<li>
<span class="topic_imp">Icy Phoenix hat viele Funktionen. Die meisten davon sind der <a class="post-url" href="http://www.icyphoenix.com/credits.php">Credits</a> auf dieser Seite aufgelistet. Die wichtigsten sind:</span><br />
<ul>
<li><span class="topic_imp">phpBB bulletin Board und Berechtigungssystem</span><br /></li>
<li><span class="topic_imp">CMS Funktion welche die Schaffung von neuen Seiten und Blöcken ermöglicht (einige dieser Funktionen stammen vom aufgegebenen IM Portal Projekt)</span><br /></li>
<li><span class="topic_imp">Übergreifende Template Integration zwischen allen Seitenabschnitten</span><br /></li>
<li><span class="topic_imp">Viele Funktionen können sofort benutzt werden: Foto-Galerie, Downloads, Wissensdatenbank, Links, Chat&hellip;</span><br /></li>
<li><span class="topic_imp">Startbereit für Mehrsprachigkeit und Mehrfach-Template</span><br /></li>
<li><span class="topic_imp">Nahezu 100% XHTML und CSS W3C konform</span><br /></li>
<li><span class="topic_imp">&hellip;und vieles mehr&hellip;</span><br /></li>
</ul>
<br /><br />
</li>
<li><span class="topic_ann"><b>Bietet Icy Phoenix Hilfestellung bei Bugs, Sicherheitsfragen und Verbesserungen?</b></span><br /></li>
<li><span class="topic_imp">Icy Phoenix ist ein Open-Source Projekt. Wie viele Open-Source Projekte wird es durch hilfsbereite Leute in deren Freizeit betreut. Im Moment gibt es mehrere Personen die bereit sind zu helfen und zu diesem Projekt beizutragen. Wir hoffen, dass diese Gemeinschaft weiter wächst und in der Lage sein wird, die notwendige Unterstützung an alle diese Benutzer zu geben, die Hilfe benötigen.</span><br /><br /></li>
<li><span class="topic_ann"><b>Ist Icy Phoenix einfach zu installieren und von anderen Foren umzuwandeln?</b></span><br /></li>
<li><span class="topic_imp">Icy Phoenix hat seine eigene Installations-Methode, welche den Benutzer Schritt für Schritt durch die Ersteinrichtung leitet. Es wurde eine Upgrade-Datei erstellt, um von einem Standard phpBB oder <acronym title="Icy Phoenix Vorgänger">phpBB XS</acronym> zu Icy Phoenix zu wechseln. Hoffentlich wird es bald eine Konvertierungs-Datei von jedem anderen Forum geben: im Moment ist der einzige Weg von anderen Forum-Systemen (premodded) zu wechseln, indem man erst zum standard phpBB wechselt (sofern dafür ein Verfahren geschrieben wurde) und dann zu Icy Phoenix upzugraden.</span><br /><br /></li>
<li><span class="topic_ann"><b>Hat Icy Phoenix viele Templates?</b></span><br /></li>
<li><span class="topic_imp">Ja, im Moment sind einige kostenlose Templates (einige davon mit unterschiedlichen Farbenvariationen) vorhanden und wir arbeiten weiterhin an Neuen. Wenn du an neuen Templates interessiert bist, solltest du regelmäßig das <a class="post-url" href="http://www.icyphoenix.com/" target="_blank">Support Forum</a> besuchen.</span><br /><br /></li>
<li><span class="topic_ann"><b>Ist Icy Phoenix mehrsprachig?</b></span><br /></li>
<li><span class="topic_imp">Englisch ist die Hauptsprache in Icy Phoenix, aber es wurde in andere Sprachen übersetzt (alphabetisch geordnet): deutsch, galicisch, holländisch, italienisch, katalanisch, serbisch, spanisch&hellip; und weitere werden folgen! Wenn du deine Sprache nicht in dieser Liste finden solltest, dann frage bitte im <a class="post-url" href="http://www.icyphoenix.com/" target="_blank">Support Forum</a>. Vielleicht arbeitet gerade jemand an dieser Übersetzung. Dann kannst du beim "Übersetzungs-Team" mitmachen, um deinen Beitrag zu leisten.</span><br /><br /></li>
<li><span class="topic_ann"><b>Wird Icy Phoenix upgraded auf phpBB 3?</b></span><br /></li>
<li><span class="topic_imp">Im Moment gibt es keine Überlegungen Icy Phoenix auf phpBB 3 upzugraden. Dafür gibt es einige Gründe. Wenn phpBB 3 lange genug und stabil laufen sollte, kann es sein, dass sich Dinge auch einmal ändern&hellip;</span><br /><br /></li>
<li><span class="topic_ann"><b>Darf ich dem Icy Phoenix Projekt beitreten?</b></span><br /></li>
<li><span class="topic_imp">Natürlich. Icy Phoenix ist ein Open-Source Projekt und jeder, der einen kontinuierlichen Beitrag dafür leisten möchte, kann sich für ein Team anmelden.</span><br /><br /></li>
</ul>';
$lang['BBC_License'] = '<b>Icy Phoenix</b>, welches von Mighty Gorgon entwickelt wurde, ist ein CMS basierend auf einer premodded Version von phpBB, verschiedener phpBB MODs und mehrerer Funktionen, die von Mighty Gorgon und dem Icy Phoenix Team entwickelt wurden. Da phpBB unter der GNU Lizenz freigegeben ist, ist Icy Phoenix auch unter der GNU Lizenz freigegeben (du kannst die Bedingungen hier nachlesen: <a class="post-url" href="http://www.icyphoenix.com/docs/COPYING" target="_blank">GNU</a>)<br /><br />
Credits für alle verwendeten MODs und ihre Autoren können unter diesem Link gefunden werden: <a class="post-url" href="http://www.icyphoenix.com/credits.php" target="_blank">Credits</a>.<br /><br />
phpBB &copy; 2008 <a class="post-url" href="http://www.phpbb.com/" target="_blank">phpBB Group</a>.<br />
Icy Phoenix &copy; 2008 <a class="post-url" href="http://www.icyphoenix.com/" target="_blank">Icy Phoenix Team</a>.';
$lang['BBC_Requirements'] = 'Bevor du Icy Phoenix installierst solltest du sicher sein, dass die <b>MINDESTANFORDERUNGEN</b> vorhanden sind:
<ul>
<li>Mindestens 20 MB freien Speicherplatz in dem Ordner, wo du Icy Phoenix installieren möchtest</li>
<li>Web Server mit PHP (4 oder höher) installiert und gestartet (läuft am besten mit Linux + Apache)</li>
<li>MySQL (3 oder höher) Datenbank mit mindestens 1 MB freien Speicherplatz (natürlich hängt die Größe davon ab, wie groß dein Forum sein wird&hellip; 1 MB ist genug, für die Anfangsinstallation)</li>
<li>Erlaubnis haben, CHMOD setzen zu können</li>
</ul>
<br /><br />
Die anderen Erfordernisse (selbst wenn nicht notwendiger Weise benötigt werden) sind für optimale Leistungen von Icy Phoenix empfohlen:
<ul>
<li>Webserver mit .htaccess-Fähigkeit</li>
<li>Apache Rewrite Mod installiert und gestartet</li>
<li>GD Bibliotheken (mindestens 2.0.28) installiert und gestartet</li>
<li>Register Globals auf OFF gesetzt</li>
</ul>';
$lang['BBC_Fresh_Installation'] = '<ol type="1">
<li>Entpacke das Icy Phoenix Paket in einen Ordner auf deiner Festplatte.</li>
<li>Kopiere alle Icy Phoenix Dateien in ein Verzeichnis auf deinem Webserver (z.B. /icyphoenix/)</li>
<li>
Setze die Berechtigung <span class="text_red">CHMOD 777</span> für die folgenden Dateien und Verzeichnisse:<br />
<ul>
<li><b>backup/</b></li>
<li><b>cache/</b></li>
<li><b>cache/sql/</b></li>
<li><b>cache/users/</b></li>
<li><b>ctracker/logfiles/logfile_attempt_counter.txt</b></li>
<li><b>ctracker/logfiles/logfile_blocklist.txt</b></li>
<li><b>ctracker/logfiles/logfile_debug_mode.txt</b></li>
<li><b>ctracker/logfiles/logfile_malformed_logins.txt</b></li>
<li><b>ctracker/logfiles/logfile_spammer.txt</b></li>
<li><b>ctracker/logfiles/logfile_worms.txt</b></li>
<li><b>downloads/</b></li>
<li><b>files/</b></li>
<li><b>files/album/</b></li>
<li><b>files/album/cache/</b></li>
<li><b>files/album/med_cache/</b></li>
<li><b>files/album/users/</b></li>
<li><b>files/album/wm_cache/</b></li>
<li><b>files/posted_images/</b></li>
<li><b>files/thumbs/</b></li>
<li><b>images/avatars/</b></li>
<li><b>logs/</b></li>
<li><b>pafiledb/uploads/</b></li>
<li><b>pafiledb/cache/</b></li>
<li><b>pafiledb/cache/templates/</b></li>
<li><b>pafiledb/cache/templates/mg_themes/</b></li>
<li><b>pafiledb/images/screenshots/</b></li>
</ul>
<br />
</li>
<li>
Setze die Berechtigung <span class="text_red">CHMOD 666</span> für die folgenden Dateien:<br />
<ul>
<li><b>includes/def_themes.php</b></li>
<li><b>includes/def_tree.php</b></li>
<li><b>includes/def_words.php</b></li>
<!-- <li><b>language/lang_*/lang_extend.php</b></li> -->
</ul>
<br />
</li>
<li>Führe die install.php aus dem install Ordner aus: <b>install/install.php</b> (z.B. <a class="post-url" href="http://www.meineseite.de/icyphoenix/install/install.php">http://www.meineseite.de/forum/install/install.php</a>)</li>
<li>Fülle alle Felder aus und folge dem Setup bis zum Ende.</li>
<li>Lösche das Verzeichnis <b>install</b> oder benenne es um.</li>
<li>Passe das an, was du anpassen möchtest, in Dateien und DB (einige Dateien müssen von Hand angepasst werden, die meisten Änderungen können im Admin-Bereich und CMS vorgenommen werden).</li>
<li>Genieße dein neues Forum <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Enjoy!" title="Enjoy!" />.</li>
</ol>';
$lang['BBC_Upgrade_phpbb'] = 'Wenn du bereits phpBB 2.0.23 oder älter verwendest, kannst du dein Forum einfach aktualisieren, indem du die folgenden Schritte durchführst:<br />
<ol type="1">
<li><span class="text_red">Erstelle ein vollständiges Backup aller Dateien und der Datenbank</span> (Wenn du kein Backup hast, frage nicht nach Support! <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" />)</li>
<li>Hast du ein Backup von allem? Wenn du kein Backup hast, gehe zum vorhergehenden Punkt zurück.</li>
<li>Kopiere deine aktuelle <b>config.php</b> und speichere sie an einem sicheren Ort.</li>
<li>Prüfe noch einmal, dass dein Backup in Ordnung ist und speichere es an einem sicheren Ort. <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" /></li>
<li>Melde dich als Administrator an.</li>
<li>Entpacke das Icy Phoenix Paket in einen Ordner auf deiner Festplatte.</li>
<li>Lade die Datei <b>update_to_ip.php</b> (sie ist im <b>install</b> Ordner) in das Root-Verzeichnis deines Webservers hoch und rufe sie im Browser auf (z.B. http://www.meineseite.de/forum/update_to_ip.php). Wichtig: Wenn die <b>update_to_ip.php</b> Datei sich nicht im Root deines phpBB befindet, wird das Update nicht richtig funktionieren.</li>
<li>Lösche die Datei <b>update_to_ip.php</b> wieder.</li>
<li>Löschen die folgenden Ordner (vergewissere dich, dass du keine Dateien für von dir installierte Mods benötigst. Aber für diesen Fall solltest du ein Backup haben <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" />):
<ul>
<li><b>admin</b></li>
<li><b>db</b></li>
<li><b>includes</b></li>
<li><b>language</b></li>
<li><b>templates</b></li>
</ul>
</li>
<li>Lösche <b>alle Dateien</b> außer <b>config.php</b> in dein phpBB Root (vergewissere dich, dass du keine Dateien für von dir installierte Mods benötigst. Aber für diesen Fall solltest du ein Backup haben <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" />).</li>
<li>Lade alle Icy Phoenix Dateien (alle außer <b>config.php</b>, <b>includes/def_tree.php</b> und <b>includes/def_words.php</b>) in dasselbe Verzeichnis hoch, wo dein phpBB installiert ist. Achte darauf, dass alle älteren Dateien mit den neuen ersetzt werden.</li>
<li>Setzte alle Berechtigungen wie bei Neuinstallation beschrieben.</li>
<li>Passe das an, was du anpassen möchtest, in Dateien und DB (einige Dateien müssen von Hand angepasst werden, die meisten Änderungen können im Admin-Bereich und CMS vorgenommen werden).</li>
<li>Entsperre dein Forum.</li>
<li>Genieße dein neues <b>Icy Phoenix</b> Forum <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Enjoy!" title="Enjoy!" />.</li>
</ol>';
$lang['BBC_Upgrade_XS'] = 'Wenn du bereits phpBB XS verwendest, kannst du dein Forum einfach aktualisieren, indem du die folgenden Schritte durchführst (basierend auf eine phpBB XS 058 Standard Installation):<br />
<ol type="1">
<li><span class="text_red">Erstelle ein vollständiges Backup aller Dateien und der Datenbank</span> (Wenn du kein Backup hast, frage nicht nach Support! <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" />)</li>
<li>Hast du ein Backup von allem? Wenn du kein Backup hast, gehe zum vorhergehenden Punkt zurück.</li>
<li>Kopiere deine aktuelle <b>.htaccess</b>, <b>config.php</b>, <b>includes/def_themes.php</b>, <b>includes/def_tree.php</b>, <b>includes/def_words.php</b> und speichere sie an einem sicheren Ort.</li>
<li>Prüfe noch einmal, dass dein Backup in Ordnung ist und speichere es an einem sicheren Ort. <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" /></li>
<li>Melde dich als Administrator an.</li>
<li>Sperre dein Forum.</li>
<li>Entpacke das Icy Phoenix Paket in einen Ordner auf deiner Festplatte.</li>
<li>Lade die Datei <b>update_to_ip.php</b> (sie ist im <b>install</b> Ordner) in das Root-Verzeichnis deines Webservers hoch und rufe sie im Browser auf (z.B. http://www.meineseite.de/forum/update_to_ip.php). Wichtig: Wenn die <b>update_to_ip.php</b> Datei sich nicht im Root deines phpBB XS befindet, wird das Update nicht richtig funktionieren.</li>
<li>Lösche die Datei <b>update_to_ip.php</b> wieder.</li>
<li>Verschiebe die folgenden Ordner
<ul>
<li><b>album_mod/upload/*.*</b> ==> <b>files/album/*.*</b></li>
</ul>
</li>
<li>Löschen die folgenden Ordner (vergewissere dich, dass du keine Dateien für von dir installierte Mods benötigst. Aber für diesen Fall solltest du ein Backup haben <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" />):
<ul>
<li><b>adm</b></li>
<li><b>album_mod</b></li>
<li><b>attach_mod</b></li>
<li><b>bb_usage_stats</b></li>
<li><b>blocks</b></li>
<li><b>captcha</b></li>
<li><b>ctracker</b></li>
<li><b>db</b></li>
<li><b>docs</b></li>
<li><b>errors</b></li>
<li><b>hl</b></li>
<li><b>includes</b> (alle außer <b>includes/def_tree.php</b> und <b>includes/def_words.php</b>)</li>
<li><b>language</b></li>
<li><b>mo</b></li>
<li><b>mods</b></li>
<li><b>stat_modules</b></li>
<li><b>templates</b></li>
<li><b>xs_mod</b></li>
</ul>
</li>
<li>Lösche <b>alle Dateien</b> außer <b>config.php</b> in dein phpBB XS Root (vergewissere dich, dass du keine Dateien für von dir installierte Mods benötigst. Aber für diesen Fall solltest du ein Backup haben <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" />).</li>
<li>Lade alle Icy Phoenix Dateien (alle außer <b>config.php</b>, <b>includes/def_tree.php</b> and <b>includes/def_words.php</b>) in dasselbe Verzeichnis hoch, wo dein phpBB XS installiert ist. Achte darauf, dass alle älteren Dateien mit den neuen ersetzt werden.</li>
<li>Setzte alle Berechtigungen wie bei Neuinstallation beschrieben.</li>
<li>Passe das an, was du anpassen möchtest, in Dateien und DB (einige Dateien müssen von Hand angepasst werden, die meisten Änderungen können im Admin-Bereich und CMS vorgenommen werden).</li>
<li>Entsperre dein Forum.</li>
<li>Genieße dein neues <b>Icy Phoenix</b> Forum <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Enjoy!" title="Enjoy!" />.</li>
</ol>';
$lang['BBC_Upgrade_IP'] = 'Wenn du bereits Icy Phoenix 1.0.9.9 oder höher verwendest, kannst du dein Forum einfach aktualisieren, indem du die folgenden Schritte durchführst:<br />
<ol type="1">
<li><span class="text_red">Erstelle ein vollständiges Backup aller Dateien und der Datenbank</span> (Wenn du kein Backup hast, frage nicht nach Support! <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" />)</li>
<li>Hast du ein Backup von allem? Wenn du kein Backup hast, gehe zum vorhergehenden Punkt zurück.</li>
<li>Kopiere deine aktuelle <b>.htaccess</b>, <b>config.php</b>, <b>includes/def_themes.php</b>, <b>includes/def_tree.php</b>, <b>includes/def_words.php</b> und speichere sie an einem sicheren Ort.</li>
<li>Prüfe noch einmal, dass dein Backup in Ordnung ist und speichere es an einem sicheren Ort. <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" /></li>
<li>Melde dich als Administrator an.</li>
<li>Sperre dein Forum.</li>
<li>Entpacke das Icy Phoenix Paket in einen Ordner auf deiner Festplatte.</li>
<li>Lade die Datei <b>update_to_ip.php</b> (sie ist im <b>install</b> Ordner) in das Root-Verzeichnis deines Webservers hoch und rufe sie im Browser auf (z.B. http://www.meineseite.de/forum/update_to_ip.php). Wichtig: Wenn die <b>update_to_ip.php</b> Datei sich nicht im Root deines Icy Phoenix befindet, wird das Update nicht richtig funktionieren.</li>
<li>Lösche die Datei <b>update_to_ip.php</b> wieder.</li>
<li>Löschen die folgenden Ordner (vergewissere dich, dass du keine Dateien für von dir installierte Mods benötigst. Aber für diesen Fall solltest du ein Backup haben <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" />):
<ul>
<li><b>adm</b></li>
<li><b>includes</b> (alle außer <b>includes/def_themes.php</b>, <b>includes/def_tree.php</b> und <b>includes/def_words.php</b>)</li>
<li><b>language</b></li>
<li><b>templates</b></li>
</ul>
</li>
<li>Lösche <b>alle Dateien</b> außer <b>config.php</b> in dein phpBB XS Root (vergewissere dich, dass du keine Dateien für von dir installierte Mods benötigst. Aber für diesen Fall solltest du ein Backup haben <<img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Backup Regeln!" title="Backup Regeln!" />.</li>
<li>Lade alle Icy Phoenix Dateien (alle außer <b>config.php</b>, <b>includes/def_themes.php</b>, <b>includes/def_tree.php</b> und <b>includes/def_words.php</b>) in dasselbe Verzeichnis hoch, wo dein Icy Phoenix installiert ist. Achte darauf, dass alle älteren Dateien mit den neuen ersetzt werden.</li>
<li>Setzte alle Berechtigungen wie bei Neuinstallation beschrieben.</li>
<li>Passe das an, was du anpassen möchtest, in Dateien und DB (einige Dateien müssen von Hand angepasst werden, die meisten Änderungen können im Admin-Bereich und CMS vorgenommen werden).</li>
<li>Entsperre dein Forum.</li>
<li>Genieße dein neues <b>Icy Phoenix</b> Forum <img src="http://www.icyphoenix.com/images/smiles/icon_mrgreen.gif" alt="Enjoy!" title="Enjoy!" />.</li>
</ol>';

?>