<?php
/**
*
* phpbb3_lc.php [English]
*
* @package language convertor
* @version $Id: phpbb3_lc.php,v 0.1.0 2007/07/28
* @copyright (c) 2007 Mighty Gorgon
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

// Include your lang file here or copy your lang vars below and then run the file from your browser!

//include('lang_test.php');

//============================================
// LANG VARS - BEGIN
//============================================

/*
$lang['Test_01'] = 'Testing...';
$lang['Test_02'] = 'Testing...';
*/

//============================================
// LANG VARS - END
//============================================

$output_to_file = false;
$output_to_browser_html = false;

if( is_array($lang) )
{

	$txt_output = '';

	$txt_header = '';
	$txt_header .= "\n";
	$txt_header .= 'if (empty($lang) || !is_array($lang))' . "\n";
	$txt_header .= '{' . "\n" . '';
	$txt_header .= "\t" . '$lang = array();' . "\n";
	$txt_header .= '}' . "\n";
	$txt_header .= "\n";
	$txt_header .= '$lang = array_merge($lang, array(' . "\n";

	$txt_footer = '';
	$txt_footer .= "\t" . ')' . "\n";
	$txt_footer .= ');' . "\n";

	if ($output_to_browser_html == true)
	{
		$html_output = '';

		$html_header = '';
		$html_header .= '<br />';
		$html_header .= 'if (empty($lang) || !is_array($lang))<br />';
		$html_header .= '{<br />';
		$html_header .= '&nbsp;&nbsp;$lang = array();<br />';
		$html_header .= '}<br />';
		$html_header .= '<br />';
		$html_header .= '$lang = array_merge($lang, array(<br />';

		$html_footer = '';
		$html_footer .= '&nbsp;&nbsp;)<br />';
		$html_footer .= ');<br />';
	}

	while( list($k, $v) = each($lang) )
	{
		$txt_output .= "\t" . '\'' . strtoupper($k) . '\' => \'' . addslashes($v) . '\',' . "\n";

		if ($output_to_browser_html == true)
		{
			$html_output .= '&nbsp;&nbsp;\'' . strtoupper($k) . '\' => \'' . htmlspecialchars(str_replace("'", "\'", $v)) . '\',<br />';
		}
	}
	@reset($lang);

	$txt_output = '<' . '?php' . "\n" . $txt_header . $txt_output . $txt_footer . "\n" . '?' . '>';

	if ($output_to_browser_html == true)
	{
		$html_output = '&lt;?php<br />' . $html_header . $html_output . $html_footer . '<br />?&gt;';
	}
}
else
{
	$txt_output = '<' . '?php' . "\n" . '//No lang vars found' . "\n" . '?' . '>';

	if ($output_to_browser_html == true)
	{
		$html_output = '<strong>No lang vars found!!!</strong>';
	}
}

if ($output_to_file == true)
{
	$f = fopen('autogenerated_lang_file_rename_me.php', 'w');
	@fputs($f, $txt_output);
	@fclose($f);
}

if ( isset($_GET['download']) )
{
	header('Content-Type: text/plain');
	header('Content-Length: ' . strlen($txt_output));
	header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Content-Disposition: attachment; filename="autogenerated_lang_file_rename_me.php"');
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	header('Pragma: public');
	echo $txt_output;
	exit;
}

?>

<html>
<head>
<title>phpBB 3 Lang Convertor</title>
<meta http-equiv="Content-Type" content="text/html; charset=windows-1252" />

<style type="text/css">
body { background-color: #EEEEEE; font-family: "Trebuchet MS", Verdana, Arial, Helvetica, sans-serif; }

a { color: #445599; text-decoration: none }
a:hover { color: #DD3333; text-decoration: underline }
a:active { color: #DD3333; text-decoration: underline }
/*a:visited { color: #DD3333; text-decoration: underline }*/

.header { color: #DD3333;}
.copyright { color: #666666; font-size: 10px;}
.attention { color: #228844;}
.disclaimer { font-size: 10px; color: #999999;}

.gensmall { font-size: 10px;}
.genmed { font-size: 11px;}
.gen { font-size: 12px;}
.genlarge { font-size: 18px;}
.genbig { font-size: 24px;}

.head1 { font-weight: bold; color: #DD3333; }
.head2 { font-weight: bold; color: #FF8866; }
.head3 { font-weight: bold; color: #228844; }

.forumline { background-color: #FFFFFF; border: 1px #224488 solid; margin-left: 5px; margin-right: 5px; padding: 10px; }

.row1, .row2 { background-color: #F8F8F8; border: solid 1px #FFFFFF; border-right-color: #DDDDDD; border-bottom-color: #DDDDDD; }

.post-text { font-size: 12px; }

input, textarea, select { color: #333333; }
input.button { background-color: #FFFFFF; border: solid 1px #BBBBBB; border-left-color: #CCCCCC; border-top-color: #CCCCCC; color: #666666; }
input.button:hover { color: #000000; border-left-color: #AAAAAA; border-top-color: #AAAAAA; border-right-color: #999999; border-bottom-color: #999999; }
input.post, textarea, select, input.liteoption { border: solid 1px #224488; color: #666666; background-color: #F8F8F8; }
input.mainoption { border: solid 1px #666666; color: #656565; background-color: #F8F8F8; }
* html input.post, * html textarea, * html select, * html input.liteoption { color: #333333; border: solid 1px #224488; }
* html input.mainoption { color: #000000; border: solid 1px #444444; font-weight: bold; }
input.post:hover, textarea:hover, select:hover, select:focus, input.liteoption:hover, input.mainoption:hover { border: solid 1px #DD3333; color: #666666; background-color: #FAFAFA; }
input.post:focus, textarea:focus { border: solid 1px #444444; color: #000000; }
input.post:focus, select:focus, input.mainoption:focus, input.liteoption:focus { background-color: #E7E7E7; }
textarea:focus { background-color: #F4F4F4; border: solid 1px #DD3333; }
</style>
</head>

<body>
<br />
<div class="forumline">
	<div class="post-text">

<?php
if ($output_to_browser_html == true)
{
	echo $html_output;
}
else
{
?>

<textarea name="message" rows="15" cols="35" wrap="virtual" style="width:100%;" tabindex="1" class="post"><?php echo $txt_output; ?></textarea>

<?php
}
?>
	<br /><br />
	<a href="phpbb3_lc.php?download=true" target="_blank">Download as a file</a>
	</div>
</div>
<div class="forumline" style="margin-top:5px;"><div class="copyright" style="text-align:center;">phpBB 3 Lang Convertor by <a href="http://www.icyphoenix.com" target="_blank">Mighty Gorgon</a></div></div>
</body>
</html>