/*
 * Decompiled with CFR 0.152.
 */
package JUpload.actions;

import JUpload.Messages;
import JUpload.swingVersion.JUpload;
import JUpload.swingVersion.WalkerThread;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import sun.awt.image.codec.JPEGImageEncoderImpl;

public class CaptureScreenAction
implements ActionListener {
    public void actionPerformed(ActionEvent e) {
        this.iterateScreenDevices();
    }

    private void iterateScreenDevices() {
        Object device;
        if (!Configurator.getCaptureScreen()) {
            return;
        }
        Object[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length > 1 && (device = JOptionPane.showInputDialog(JUpload.getInstance(), Messages.getString("CaptureScreenAction.SelectScreens"), Messages.getString("CaptureScreenAction.WindowTitle"), 3, null, devices, devices)) != null && device instanceof GraphicsDevice) {
            this.captureScreen((GraphicsDevice)device);
            return;
        }
        if (devices.length == 1) {
            this.captureScreen(devices[0]);
        }
        if (devices.length == 0) {
            JOptionPane.showMessageDialog(JUpload.getInstance(), Messages.getString("CaptureScreenAction.NoScreensFound"), Messages.getString("CaptureScreenAction.ErrorWindowTitle"), 0);
        }
    }

    private void captureScreen(final GraphicsDevice device) {
        if (device.getType() != 0) {
            Debug.println(this, device.getIDstring() + " is not a raster screen.");
            return;
        }
        final int delay = Configurator.getCaptureScreenDelay();
        Timer timer = new Timer();
        if (delay != 0) {
            String msg = Messages.getString("capturescreen.delayMessage", new Integer(delay));
            JOptionPane.showMessageDialog(null, msg);
            TimerTask beepTask = new TimerTask(){
                private int counter = 0;

                public void run() {
                    Toolkit.getDefaultToolkit().beep();
                    ++this.counter;
                    if (this.counter >= delay) {
                        this.cancel();
                    }
                }
            };
            timer.schedule(beepTask, 0L, 1000L);
        }
        TimerTask captureTask = new TimerTask(){

            public void run() {
                CaptureScreenAction.this.doCapture(device);
            }
        };
        timer.schedule(captureTask, delay * 1000);
    }

    void doCapture(GraphicsDevice device) {
        try {
            if (device == null) {
                device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
            Robot robot = new Robot(device);
            Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle screenRect = new Rectangle(screenDimension.width, screenDimension.height);
            BufferedImage screenImage = robot.createScreenCapture(screenRect);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JPEGImageEncoderImpl ie = new JPEGImageEncoderImpl((OutputStream)baos);
            ie.encode(screenImage);
            MyFile screenFile = new MyFile(File.createTempFile(Messages.getString("HTTPPostRequest.screenshot.prefix"), Messages.getString("HTTPPostRequest.screenshot.suffix")));
            FileOutputStream fos = new FileOutputStream(screenFile);
            fos.write(baos.toByteArray());
            fos.close();
            screenFile.deleteOnExit();
            screenFile.setVirtualRelativePathname(screenFile.getName());
            screenFile.setVirtualData(baos.toByteArray());
            screenFile.setVirtual(true);
            WalkerThread.getInstance().addFiles(new MyFile[]{screenFile});
        }
        catch (Exception e) {
            throw new RuntimeException("Error capturing screen and sending file to JUpload", e);
        }
    }
}

