/*
 * Decompiled with CFR 0.152.
 */
package JUpload;

import JUpload.Messages;
import JUpload.ProgressInformationObject;
import JUpload.ProgressListener;
import JUpload.swingVersion.JUpload;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Frame;
import java.awt.Label;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class startup
extends Applet {
    static final Logger logger = Logger.getLogger((class$JUpload$startup == null ? (class$JUpload$startup = startup.class$("JUpload.startup")) : class$JUpload$startup).getName());
    public AppletContext m_Context;
    public JSObject jsBrowserWindow;
    public String javascriptAddListenerName;
    public String javascriptAddedListenerName;
    public String javascriptRemoveListenerName;
    public String javascriptUploadListenerName;
    public String javascriptUploadedName;
    public boolean javascriptAddListenerRegistered = false;
    public boolean javascriptAddedListenerRegistered = false;
    public boolean javascriptRemoveListenerRegistered;
    public boolean javascriptUploadListenerRegistered;
    public boolean javascriptUploadedRegistered;
    JUpload jup;
    private boolean running = false;
    private static startup instance;
    static /* synthetic */ Class class$JUpload$startup;

    public startup() {
        logger.info("startup()");
        instance = this;
    }

    public String getAppletInfo() {
        return Configurator.strBanner;
    }

    public void debugInfo() {
        Properties systemProperties = null;
        try {
            systemProperties = System.getProperties();
        }
        catch (Exception e) {
            Frame messageframe = new Frame(Messages.getString("startup.0"));
            messageframe.add(new Label(Messages.getString("startup.1")));
            this.debug(Messages.getString("startup.2"));
            this.stop();
            return;
        }
        Enumeration<Object> strKeys = systemProperties.keys();
        while (strKeys.hasMoreElements()) {
            String strKey = (String)strKeys.nextElement();
            String strValue = systemProperties.getProperty(strKey);
            this.debug("  >> " + strKey + " = [" + strValue + "]");
        }
    }

    public void init() {
        logger.info("init()");
        try {
            this.m_Context = this.getAppletContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jsClickAdd() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                startup.this.jup.jsClickAdd();
                return null;
            }
        });
    }

    public void jsCaptureScreenshot() {
        logger.info("jsCaptureScreenshot()");
        long startTime = System.currentTimeMillis();
        if (this.jup != null && this.jup.isReady()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    logger.info("Delegating to real JUpload...");
                    startup.this.jup.jsCaptureScreenshot();
                    return null;
                }
            });
        }
        long endTime = System.currentTimeMillis();
        logger.info("jsCaptureScreenshoot() took " + (endTime - startTime) + "ms");
    }

    public void jsPasteClipboardImage() {
        long startTime = System.currentTimeMillis();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                startup.this.jup.jsPasteClipboardImage();
                return null;
            }
        });
        long endTime = System.currentTimeMillis();
        Debug.println(this, "jsPasteClipboardImage() took " + (endTime - startTime) + "ms");
    }

    public void jsClickRemove() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                startup.this.jup.jsClickRemove();
                return null;
            }
        });
    }

    public void jsClickUpload() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                startup.this.jup.jsClickUpload();
                return null;
            }
        });
    }

    public void jsClickStop() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                startup.this.jup.jsClickStop();
                return null;
            }
        });
    }

    public String jsGetFileAt(final int i) {
        String file = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return startup.this.jup.jsGetFileAt(i);
            }
        });
        return file;
    }

    public int jsGetFileNumber() {
        Integer i = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Integer i2 = startup.this.jup.jsGetFileNumber();
                Debug.println(this, "jsGetFileNumber() returning " + i2 + " files");
                return i2;
            }
        });
        return i;
    }

    public void jsRemoveFileAt(final int i) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                startup.this.jup.jsRemoveFileAt(i);
                return null;
            }
        });
    }

    public int jsGetFileSizeAt(final int i) {
        Integer size = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return startup.this.jup.jsGetFileSizeAt(i);
            }
        });
        return size;
    }

    public int jsGetTotalProgressbarValue() {
        Integer size = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return startup.this.jup.jsGetTotalProgressbarValue();
            }
        });
        return size;
    }

    public Boolean jsIsReady() {
        logger.info("JavaScript call: jsIsReady()");
        if (this.jup == null) {
            return Boolean.FALSE;
        }
        Boolean flag = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(startup.this.jup.isReady());
            }
        });
        return flag;
    }

    public void jsRegisterAddListener(String funcName) {
        this.javascriptAddListenerRegistered = true;
        this.javascriptAddListenerName = funcName;
    }

    public void jsRegisterAddedListener(String funcName) {
        this.javascriptAddedListenerRegistered = true;
        this.javascriptAddedListenerName = funcName;
    }

    public void jsRegisterRemoveListener(String funcName) {
        this.javascriptRemoveListenerRegistered = true;
        this.javascriptRemoveListenerName = funcName;
    }

    public void jsRegisterUploadListener(String funcName) {
        this.javascriptUploadListenerRegistered = true;
        this.javascriptUploadListenerName = funcName;
    }

    public void jsRegisterProgressListener(final String funcName) {
        this.getJUpload().addProgressMeterListener(new ProgressListener(){

            public void valueChanged(ProgressInformationObject pio) {
                startup.this.jsBrowserWindow.call(funcName, "changed", pio.getTotalPercentage());
            }

            public void startProgress() {
                startup.this.jsBrowserWindow.call(funcName, "start");
            }

            public void stopProgress() {
                startup.this.jsBrowserWindow.call(funcName, "stop");
            }
        });
    }

    public void jsRegisterUploaded(String funcName) {
        this.javascriptUploadedRegistered = true;
        this.javascriptUploadedName = funcName;
    }

    public void start() {
        logger.info("start()");
        if (this.running) {
            return;
        }
        this.running = true;
        this.debug("startup() start()");
        this.debug("Retrieving javascript window..." + this);
        String jsObjectClassString = "netscape.javascript.JSObject";
        boolean jsObjectFound = false;
        this.jsBrowserWindow = null;
        String errMsg = "No JavaScript LiveConnect found: ";
        try {
            Class<?> jsObjectClass = Class.forName(jsObjectClassString);
            Debug.println(this, "jsObject:" + jsObjectClass);
            jsObjectFound = true;
        }
        catch (ClassNotFoundException e1) {
            System.out.println(errMsg + e1.getMessage());
        }
        catch (UnsatisfiedLinkError e2) {
            System.out.println(errMsg + e2.getMessage());
        }
        catch (NoClassDefFoundError e3) {
            System.out.println(errMsg + e3.getMessage());
        }
        if (jsObjectFound) {
            try {
                this.jsBrowserWindow = JSObject.getWindow((Applet)this);
            }
            catch (Exception e) {
                if (e instanceof JSException) {
                    JSException jse = (JSException)e;
                    System.err.println("JSException:" + jse);
                    System.err.println(" Message:" + jse.getLocalizedMessage());
                    System.err.println(" Message:" + jse.getMessage());
                    System.err.println(" Cause:" + jse.getCause());
                }
                e.printStackTrace();
            }
            this.debug("Retrieved:" + this.jsBrowserWindow);
        } else {
            Debug.println(this, "No Javascript found. Disabling LiveConnect support");
        }
        if (null != this.getParameter("checkJavaVersion")) {
            if (this.getParameter("checkJavaVersion").equalsIgnoreCase("true") || this.getParameter("checkJavaVersion").equalsIgnoreCase("1") || this.getParameter("checkJavaVersion").equalsIgnoreCase("on") || !this.getParameter("checkJavaVersion").equalsIgnoreCase("yes")) {
                // empty if block
            }
            this.debug("startup() start() checking for java version...");
            if (this.checkJavaVersion()) {
                this.jup = new JUpload(this);
            }
        } else {
            this.debug("startup() start() no check for java version...checkJavaVersion parameter not found");
            this.jup = new JUpload(this);
        }
    }

    public void stop() {
        logger.info("stop()");
        if (null != this.jup) {
            this.jup.stop();
        }
        this.running = false;
    }

    private boolean checkJavaVersion() {
        String javaVersion = System.getProperty("java.class.version");
        int dbJavaVersion = Integer.parseInt(javaVersion.substring(0, 2));
        return true;
    }

    private void debug(String s) {
        if (null != this.getParameter("debug") && (this.getParameter("debug").equalsIgnoreCase("true") || this.getParameter("debug").equalsIgnoreCase("1") || this.getParameter("debug").equalsIgnoreCase("on") || this.getParameter("debug").equalsIgnoreCase("yes"))) {
            System.out.println(s);
        }
    }

    public JUpload getJUpload() {
        return this.jup;
    }

    public static startup getInstance() {
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

