/*
 * Decompiled with CFR 0.152.
 */
package JUpload.swingVersion;

import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import java.util.Vector;

public class UploadJob {
    Vector queuedFiles = new Vector();
    private long iCurrentRequestSize = 0L;
    private long iMaxTotalRequestSize = Configurator.getMaxTotalRequestSize();
    private int iMaxFilesPerRequest = Configurator.getMaxFilesPerRequest();

    UploadJob() {
    }

    public boolean hasSpaceFor(MyFile t_file) {
        if (t_file == null) {
            throw new NullPointerException();
        }
        if (this.iMaxFilesPerRequest != -1 && this.queuedFiles.size() >= this.iMaxFilesPerRequest) {
            Debug.println(this, "Queue reached file number maximum " + this.iMaxFilesPerRequest);
            return false;
        }
        if (this.iMaxTotalRequestSize != -1L && this.iCurrentRequestSize + t_file.length() >= this.iMaxTotalRequestSize) {
            Debug.println(this, "Queue reached file size maximum of " + this.iMaxTotalRequestSize + " with " + this.iCurrentRequestSize);
            return false;
        }
        return true;
    }

    public void addFile(MyFile file) throws Exception {
        this.queuedFiles.add(file);
        this.iCurrentRequestSize += file.length();
        file.setJob(this);
        Debug.println(this, "Added " + file + " to job. Job has now " + this.queuedFiles.size() + " files and a size of " + this.iCurrentRequestSize);
    }

    public Vector getFiles() {
        return this.queuedFiles;
    }
}

