/*
 * Decompiled with CFR 0.152.
 */
package JUpload.utilities;

import JUpload.utilities.Configurator;
import java.security.AccessControlException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyConfig {
    private static final Logger LOGGER = Logger.getLogger((class$JUpload$utilities$ProxyConfig == null ? (class$JUpload$utilities$ProxyConfig = ProxyConfig.class$("JUpload.utilities.ProxyConfig")) : class$JUpload$utilities$ProxyConfig).getName());
    private static final int TYPE_DIRECT = 0;
    private static final int TYPE_MANUAL = 1;
    private static final int TYPE_AUTOMATIC = 2;
    private static final int TYPE_BROWSER = 3;
    public static String strProxySettings;
    public static boolean useProxy;
    public static String proxyHostnamePort;
    public static String proxyHostname;
    public static String proxyPort;
    static /* synthetic */ Class class$JUpload$utilities$ProxyConfig;

    public static void readConfiguration() {
        switch (ProxyConfig.getType()) {
            case 1: {
                ProxyConfig.readManualConfiguration();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                useProxy = false;
                proxyHostname = null;
                proxyHostnamePort = null;
                proxyPort = null;
            }
        }
    }

    private static void readManualConfiguration() {
        String strHttpProxyHost;
        StringTokenizer st2;
        String strProtocol;
        StringTokenizer st3;
        String strKey;
        StringTokenizer st;
        try {
            strProxySettings = System.getProperty("javaplugin.proxy.settings");
        }
        catch (AccessControlException ace) {
            LOGGER.log(Level.WARNING, ace.getMessage(), ace);
        }
        if (null != strProxySettings) {
            LOGGER.finer("Trying to read settings from [" + strProxySettings + "]");
            st = new StringTokenizer(strProxySettings, ";,");
            while (st.hasMoreTokens()) {
                strKey = st.nextToken();
                st3 = new StringTokenizer(strKey, "=");
                strProtocol = st3.nextToken();
                if (!strProtocol.equalsIgnoreCase(Configurator.getActionURL().getProtocol())) continue;
                proxyHostnamePort = st3.nextToken();
                st2 = new StringTokenizer(proxyHostnamePort, ":");
                proxyHostname = st2.nextToken();
                proxyPort = st2.nextToken();
                useProxy = true;
            }
        }
        if (null != (strProxySettings = System.getProperty("javaplugin.proxy.config.list"))) {
            st = new StringTokenizer(strProxySettings, ",;");
            while (st.hasMoreTokens()) {
                strKey = st.nextToken();
                if (!st.hasMoreTokens()) break;
                st.nextToken();
                st3 = new StringTokenizer(strKey, "=");
                strProtocol = st3.nextToken();
                if (strProtocol.equalsIgnoreCase(Configurator.getActionURL().getProtocol())) {
                    proxyHostnamePort = st3.nextToken();
                    st2 = new StringTokenizer(proxyHostnamePort, ":");
                    proxyHostname = st2.nextToken();
                    proxyPort = st2.hasMoreTokens() ? st2.nextToken() : "80";
                    useProxy = true;
                }
                if (st.hasMoreTokens()) continue;
            }
        }
        if (null != (strHttpProxyHost = System.getProperty("http.proxyHost")) && !strHttpProxyHost.equalsIgnoreCase("")) {
            useProxy = true;
            proxyHostname = System.getProperty("http.proxyHost");
            proxyPort = System.getProperty("http.proxyPort");
        }
        if (!Configurator.getUseProxy()) {
            LOGGER.warning("Disabling proxy due to configuration parameter 'useProxy=false'");
            useProxy = false;
        }
        LOGGER.info("Proxy Configuration: " + useProxy);
        LOGGER.info("Proxy Configuration: Hostname: " + proxyHostname);
        LOGGER.info("Proxy Configuration: Port: " + proxyPort);
    }

    private static int getType() {
        String key = "javaplugin.proxy.config.type";
        String value = System.getProperty(key);
        if (value == null) {
            return 0;
        }
        String trimmed = value.trim().toLowerCase();
        if ("manual".equals(trimmed)) {
            return 1;
        }
        if ("direct".equals(trimmed)) {
            return 0;
        }
        if ("browser".equals(trimmed)) {
            return 3;
        }
        if ("automatic".equals(trimmed)) {
            return 2;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        useProxy = false;
    }
}

