/*
 * Decompiled with CFR 0.152.
 */
package JUpload.actions;

import JUpload.Messages;
import JUpload.clipboard.ClipboardUtil;
import JUpload.swingVersion.WalkerThread;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import sun.awt.image.codec.JPEGImageEncoderImpl;

public class ClipboardPasteAction
implements ActionListener {
    public void actionPerformed(ActionEvent e) {
        try {
            this.queueClipboardImage();
            this.queueClipboardFiles();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void queueClipboardFiles() {
        List list = ClipboardUtil.getClipboardFiles();
        if (list == null) {
            return;
        }
        MyFile[] myFiles = new MyFile[list.size()];
        for (int i = 0; i < myFiles.length; ++i) {
            myFiles[i] = new MyFile((File)list.get(i));
        }
        WalkerThread.getInstance().addFiles(myFiles);
    }

    private void queueClipboardImage() throws Exception {
        long startTime = System.currentTimeMillis();
        BufferedImage bi = ClipboardUtil.getClipboardImage();
        long endTime = System.currentTimeMillis();
        Debug.println(this, "Retrieving clipboard took " + (endTime - startTime) + "ms");
        if (bi == null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JPEGImageEncoderImpl ie = new JPEGImageEncoderImpl((OutputStream)baos);
        startTime = System.currentTimeMillis();
        ie.encode(bi);
        endTime = System.currentTimeMillis();
        Debug.println(this, "Compressing to JPEG took " + (endTime - startTime) + "ms");
        MyFile screenFile = new MyFile(File.createTempFile(Messages.getString("ClipboardPasteAction.filename.prefix"), Messages.getString("ClipboardPasteAction.filename.suffix")));
        screenFile.setVirtualData(baos.toByteArray());
        screenFile.setVirtualRelativePathname(screenFile.getName());
        screenFile.setVirtual(true);
        WalkerThread.getInstance().addFiles(new MyFile[]{screenFile});
    }
}

