/*
 * Decompiled with CFR 0.152.
 */
package JUpload.actions;

import JUpload.Messages;
import JUpload.utilities.Configurator;
import JUpload.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class SettingsAction
implements ActionListener {
    Properties props;
    Properties defaultprops;
    Object[] keynames;

    public void actionPerformed(ActionEvent e) {
        JFrame frame = new JFrame(Messages.getString("SettingsAction.WindowTitle"));
        frame.setSize(640, 480);
        frame.setDefaultCloseOperation(2);
        JPanel upperPanel = this.createUpperPanel();
        JPanel lowerPanel = this.createLowerPanel(frame);
        frame.getContentPane().add((Component)upperPanel, "Center");
        frame.getContentPane().add((Component)lowerPanel, "South");
        this.props = Configurator.getProperties();
        this.defaultprops = Configurator.getDefaultProperties();
        Utils.centerOnScreen(frame);
        frame.setVisible(true);
        this.keynames = this.props.keySet().toArray();
        Arrays.sort(this.keynames);
    }

    private JPanel createUpperPanel() {
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BorderLayout());
        AbstractTableModel dm = new AbstractTableModel(){

            public int getColumnCount() {
                return 3;
            }

            public int getRowCount() {
                if (SettingsAction.this.props == null) {
                    return 0;
                }
                return SettingsAction.this.props.size();
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return Messages.getString("SettingsAction.KeyName");
                    }
                    case 1: {
                        return Messages.getString("SettingsAction.CurrentValue");
                    }
                    case 2: {
                        return Messages.getString("SettingsAction.DefaultValue");
                    }
                }
                return super.getColumnName(column);
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        if (SettingsAction.this.keynames == null) break;
                        return SettingsAction.this.keynames[rowIndex];
                    }
                    case 1: {
                        Object val;
                        if (SettingsAction.this.props == null || (val = this.getValueAt(rowIndex, 0)) == null) break;
                        return SettingsAction.this.props.get(val);
                    }
                    case 2: {
                        Object val;
                        if (SettingsAction.this.defaultprops == null || (val = this.getValueAt(rowIndex, 0)) == null) break;
                        return SettingsAction.this.defaultprops.get(val);
                    }
                }
                return null;
            }

            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex != 1) {
                    return;
                }
                String key = (String)SettingsAction.this.props.keySet().toArray()[rowIndex];
                SettingsAction.this.props.setProperty(key, aValue.toString());
                this.fireTableChanged(new TableModelEvent(this));
            }
        };
        JTable table = new JTable(dm);
        JScrollPane scrollpane = new JScrollPane(table);
        upperPanel.add((Component)scrollpane, "Center");
        return upperPanel;
    }

    private JPanel createLowerPanel(final JFrame frame) {
        JPanel lowerPanel = new JPanel();
        JButton btnClose = new JButton("OK");
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e1) {
                if (e1 != null) {
                    frame.dispose();
                }
            }
        });
        lowerPanel.add(btnClose);
        return lowerPanel;
    }
}

