/*
 * Decompiled with CFR 0.152.
 */
package JUpload.gui;

import JUpload.swingVersion.IFileSelectionListener;
import JUpload.swingVersion.IQueueView;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLConnection;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class RealtimeResponsePanel
extends JPanel
implements HyperlinkListener,
IFileSelectionListener {
    private static final long serialVersionUID = 3976738081695412528L;
    JEditorPane contentPane = new JEditorPane();
    private JScrollPane scroller;
    private boolean responseReceived;

    public RealtimeResponsePanel() {
        this.contentPane.setContentType("text/html");
        this.contentPane.setEditorKit(new HTMLEditorKit());
        this.contentPane.setEditable(false);
        this.contentPane.addHyperlinkListener(this);
        this.scroller = new JScrollPane(this.contentPane);
        if (Configurator.getRemoveBorders()) {
            this.scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller, "Center");
        this.validate();
    }

    public void addResponse(String buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.trim().equals("")) {
            return;
        }
        try {
            this.contentPane.setContentType("text/html");
            this.contentPane.setText(buffer);
            this.responseReceived = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RealtimeResponsePanel.this.contentPane.setCaretPosition(RealtimeResponsePanel.this.contentPane.getDocument().getLength());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        Debug.println(this, "User hovers a link: " + e.getURL());
        if (e.getURL() == null) {
            System.err.println("Invalid relative link, please use <base href=''> in your HTML header.");
            return;
        }
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
                return;
            }
            try {
                pane.setPage(e.getURL());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void selectionChanged(ListSelectionEvent e) {
        if (this.responseReceived) {
            return;
        }
        Object source = e.getSource();
        if (source instanceof IQueueView) {
            IQueueView view = (IQueueView)source;
            Object[] selected = view.getSelected();
            if (selected == null || selected.length == 0) {
                return;
            }
            Object first = selected[0];
            if (first instanceof MyFile) {
                MyFile file = (MyFile)first;
                try {
                    String ct = URLConnection.guessContentTypeFromName(file.getName());
                    if (ct != null && ct.startsWith("image")) {
                        StringBuffer imgTag = new StringBuffer();
                        imgTag.append("<html>");
                        imgTag.append("<img src=\"");
                        imgTag.append(file.toURL().toExternalForm());
                        imgTag.append("\"");
                        imgTag.append("\">");
                        imgTag.append("</html>");
                        this.contentPane.setContentType("text/html");
                        this.contentPane.setText(imgTag.toString());
                        return;
                    }
                    if (ct != null && ct.startsWith("text")) {
                        this.contentPane.setContentType(ct);
                        this.contentPane.setPage(file.toURL());
                        return;
                    }
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

