/*
 * Decompiled with CFR 0.152.
 */
package JUpload.http;

import JUpload.http.UrlUtils;
import JUpload.utilities.Base64;
import JUpload.utilities.Configurator;
import JUpload.utilities.MyFile;
import JUpload.utilities.ProxyConfig;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MimeHeader {
    private MyFile fFile;
    private String boundary;
    private String newline = "\r\n";
    private String tagName;

    public MimeHeader(MyFile f) {
        this.fFile = f;
    }

    MimeHeader(MyFile f, String tagname, String t_boundary) {
        this.fFile = f;
        this.tagName = tagname;
        this.boundary = t_boundary;
    }

    public long getContentLength() {
        return this.fFile.length();
    }

    public MyFile getFile() {
        return this.fFile;
    }

    public String getFooter() {
        String strFooter = this.newline + "--" + this.boundary;
        return strFooter;
    }

    public String getHeadHeader(String strHost) {
        String strHeadHeader = "";
        String strRessourceURI = this.getFile().getRelativeFilename();
        String queryString = "";
        if (!Configurator.getPUTQueryString().equals("")) {
            queryString = "?" + Configurator.getPUTQueryString();
        }
        strHeadHeader = ProxyConfig.useProxy ? strHeadHeader + "HEAD " + Configurator.getActionURL() + UrlUtils.encodeURL(strRessourceURI) + queryString + " HTTP/1.1" + this.newline : strHeadHeader + "HEAD " + Configurator.getActionURL().getPath() + UrlUtils.encodeURL(strRessourceURI) + queryString + " HTTP/1.1" + this.newline;
        strHeadHeader = strHeadHeader + "Host: " + strHost + this.newline;
        strHeadHeader = strHeadHeader + "User-Agent: " + Configurator.strUserAgent + this.newline;
        strHeadHeader = strHeadHeader + "Connection: keep-alive" + this.newline;
        if (ProxyConfig.useProxy) {
            strHeadHeader = strHeadHeader + "Proxy-Connection: keep-alive" + this.newline;
        }
        strHeadHeader = strHeadHeader + this.newline;
        return strHeadHeader;
    }

    public String getHeader() {
        String strHeader = this.newline;
        strHeader = strHeader + "Content-Disposition: form-data";
        strHeader = strHeader + "; ";
        strHeader = strHeader + "name=\"";
        strHeader = strHeader + this.tagName;
        strHeader = strHeader + "\"";
        strHeader = strHeader + "; ";
        strHeader = strHeader + "filename=\"";
        strHeader = this.fFile.isVirtual() ? strHeader + this.fFile.getVirtualFilename() : strHeader + this.fFile.getName();
        strHeader = strHeader + "\"";
        if (Configurator.getSendLastModificationDate()) {
            Date lastmod = new Date(this.fFile.lastModified());
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            strHeader = strHeader + "; ";
            strHeader = strHeader + "modification-date=\"";
            strHeader = strHeader + sdf.format(lastmod);
            strHeader = strHeader + "\"";
        }
        strHeader = strHeader + this.newline;
        if (Configurator.getUseRecursivePaths() && Configurator.getOverwriteContentType()) {
            String relPath;
            if (Configurator.getUseAbsolutePaths()) {
                relPath = this.fFile.getAbsolutePath();
            } else {
                relPath = this.fFile.getRelativeFilename();
                if (this.fFile.isVirtual()) {
                    relPath = this.fFile.getVirtualRelativePathname();
                }
            }
            byte[] relPathBytes = Base64.encode(relPath.getBytes());
            String relPathBytesString = new String(relPathBytes);
            strHeader = strHeader + "Content-Type: jupload/" + relPathBytesString + this.newline;
        } else {
            strHeader = strHeader + "Content-Type: " + this.getContentType() + this.newline;
        }
        strHeader = strHeader + "Content-Length: " + this.fFile.length();
        strHeader = strHeader + this.newline;
        if (!Configurator.getSkipNewlineAfterHeader()) {
            strHeader = strHeader + this.newline;
        }
        return strHeader;
    }

    public String getLastFooter() {
        StringBuffer strFooter = new StringBuffer();
        strFooter.append(this.newline);
        strFooter.append("--");
        strFooter.append(this.boundary);
        strFooter.append("--");
        strFooter.append(this.newline);
        return strFooter.toString();
    }

    public String getPutHeader(String strHost, long maxlength, long offset) {
        String strPutHeader = "";
        String strRessourceURI = this.getFile().getRelativeFilename();
        String URI2 = "";
        URI2 = ProxyConfig.useProxy ? Configurator.getActionURL() + UrlUtils.encodeURL(strRessourceURI) : Configurator.getActionURL().getPath() + UrlUtils.encodeURL(strRessourceURI);
        if (!Configurator.getPUTQueryString().equals("")) {
            URI2 = URI2 + "?" + Configurator.getPUTQueryString();
        }
        strPutHeader = strPutHeader + "PUT " + URI2 + " HTTP/1.1" + this.newline;
        strPutHeader = strPutHeader + "Host: " + strHost + this.newline;
        strPutHeader = strPutHeader + "User-Agent: JUpload (www.jupload.biz)" + this.newline;
        long len = 0L;
        len = this.getContentLength() <= maxlength ? this.getContentLength() : maxlength;
        if (offset + maxlength > this.getContentLength()) {
            len = this.getContentLength() - offset;
        }
        strPutHeader = strPutHeader + "From: info@jupload.biz";
        strPutHeader = strPutHeader + this.newline;
        strPutHeader = strPutHeader + "Accept: text/*;q=1.0, */*;q=0.0";
        strPutHeader = strPutHeader + this.newline;
        strPutHeader = strPutHeader + "Cache-Control: no-cache";
        strPutHeader = strPutHeader + this.newline;
        strPutHeader = strPutHeader + "Pragma: no-cache";
        strPutHeader = strPutHeader + this.newline;
        strPutHeader = strPutHeader + "Content-Length: " + len + this.newline;
        strPutHeader = strPutHeader + this.getContentRange(offset, len);
        strPutHeader = strPutHeader + "Content-Type: " + this.getContentType() + this.newline;
        strPutHeader = strPutHeader + "Connection: keep-alive" + this.newline;
        if (ProxyConfig.useProxy) {
            strPutHeader = strPutHeader + "Proxy-Connection: keep-alive" + this.newline;
        }
        strPutHeader = strPutHeader + this.newline;
        return strPutHeader;
    }

    protected String getContentRange(long offset, long len) {
        String contentRange = "Content-Range: bytes " + offset + "-" + (offset + len - 1L) + "/" + this.getContentLength() + this.newline;
        return contentRange;
    }

    public int length() {
        return this.getHeader().length();
    }

    private String getContentType() {
        String ext = this.fFile.getName().toLowerCase();
        String[][] mimes = new String[][]{{"application/andrew-inset", "ez"}, {"application/mac-binhex40", "hqx"}, {"application/mac-compactpro", "cpt"}, {"application/msword", "doc"}, {"application/octet-stream", "bin", "dms", "lha", "lzh", "exe", "class", "so", "dll"}, {"application/oda", "oda"}, {"application/pdf", "pdf"}, {"application/postscript", "ai", "eps", "ps"}, {"application/smil", "smi", "smil"}, {"application/vnd.wap.wbxml", "wbxml"}, {"application/vnd.wap.wmlc", "wmlc"}, {"application/vnd.wap.wmlscriptc", "wmlsc"}, {"application/x-bcpio", "bcpio"}, {"application/x-cdlink", "vcd"}, {"application/x-chess-pgn", "pgn"}, {"application/x-cpio", "cpio"}, {"application/x-csh", "csh"}, {"application/x-director", "dcr", "dir", "dxr"}, {"application/x-dvi", "dvi"}, {"application/x-futuresplash", "spl"}, {"application/x-gtar", "gtar"}, {"application/x-hdf", "hdf"}, {"application/x-javascript", "js"}, {"application/x-koan", "skp", "skd", "skt", "skm"}, {"application/x-latex", "latex"}, {"application/x-netcdf", "nc", "cdf"}, {"application/x-sh", "sh"}, {"application/x-shar", "shar"}, {"application/x-shockwave-flash", "swf"}, {"application/x-stuffit", "sit"}, {"application/x-sv4cpio", "sv4cpio"}, {"application/x-sv4crc", "sv4crc"}, {"application/x-tar", "tar"}, {"application/x-tcl", "tcl"}, {"application/x-tex", "tex"}, {"application/x-texinfo", "texinfo", "texi"}, {"application/x-troff", "t", "tr", "roff"}, {"application/x-troff-man", "man"}, {"application/x-troff-me", "me"}, {"application/x-troff-ms", "ms"}, {"application/x-ustar", "ustar"}, {"application/x-wais-source", "src"}, {"application/xhtml+xml", "xhtml", "xht"}, {"application/zip", "zip"}, {"audio/basic", "au", "snd"}, {"audio/midi", "mid", "midi", "kar"}, {"audio/mpeg", "mpga", "mp2", "mp3"}, {"audio/x-aiff", "aif", "aiff", "aifc"}, {"audio/x-mpegurl", "m3u"}, {"audio/x-pn-realaudio", "ram", "rm"}, {"audio/x-pn-realaudio-plugin", "rpm"}, {"audio/x-realaudio", "ra"}, {"audio/x-wav", "wav"}, {"chemical/x-pdb", "pdb"}, {"chemical/x-xyz", "xyz"}, {"image/bmp", "bmp"}, {"image/gif", "gif"}, {"image/ief", "ief"}, {"image/jpeg", "jpeg", "jpg", "jpe"}, {"image/png", "png"}, {"image/tiff", "tiff", "tif"}, {"image/vnd.djvu", "djvu", "djv"}, {"image/vnd.wap.wbmp", "wbmp"}, {"image/x-cmu-raster", "ras"}, {"image/x-portable-anymap", "pnm"}, {"image/x-portable-bitmap", "pbm"}, {"image/x-portable-graymap", "pgm"}, {"image/x-portable-pixmap", "ppm"}, {"image/x-rgb", "rgb"}, {"image/x-xbitmap", "xbm"}, {"image/x-xpixmap", "xpm"}, {"image/x-xwindowdump", "xwd"}, {"model/iges", "igs", "iges"}, {"model/mesh", "msh", "mesh", "silo"}, {"model/vrml", "wrl", "vrml"}, {"text/css", "css"}, {"text/html", "html", "htm"}, {"text/plain", "asc", "txt"}, {"text/richtext", "rtx"}, {"text/rtf", "rtf"}, {"text/sgml", "sgml", "sgm"}, {"text/tab-separated-values", "tsv"}, {"text/vnd.wap.wml", "wml"}, {"text/vnd.wap.wmlscript", "wmls"}, {"text/x-setext", "etx"}, {"text/xml", "xml", "xsl"}, {"video/mpeg", "mpeg", "mpg", "mpe"}, {"video/quicktime", "qt", "mov"}, {"video/vnd.mpegurl", "mxu"}, {"video/x-msvideo", "avi"}, {"video/x-sgi-movie", "movie"}, {"x-conference/x-cooltalk", "ice"}};
        String type = "application/octet-stream";
        for (int i = 0; i < mimes.length; ++i) {
            for (int j = 1; j < mimes[i].length; ++j) {
                if (!ext.endsWith(mimes[i][j])) continue;
                type = mimes[i][0];
            }
        }
        return type;
    }
}

