/*
 * Decompiled with CFR 0.152.
 */
package JUpload.network;

import JUpload.Messages;
import JUpload.swingVersion.JUpload;
import JUpload.utilities.Configurator;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;

public class NoTrustManager
implements X509TrustManager {
    private HashMap m_acceptedCertificates = new HashMap();

    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
    }

    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        for (int i = 0; i < arg0.length; ++i) {
            this.checkCertificate(arg0[i]);
        }
    }

    private void checkCertificate(X509Certificate cert) throws CertificateException {
        if (Configurator.getAlwaysAcceptCertificates()) {
            this.accept(cert);
            return;
        }
        if (!this.isAccepted(cert)) {
            if (this.askUser(cert)) {
                this.accept(cert);
            } else {
                throw new CertificateException(Messages.getString("NoTrustManager.0"));
            }
        }
    }

    private boolean askUser(X509Certificate cert) {
        if (JUpload.getInstance().isTrustedCert(cert)) {
            return true;
        }
        String strMessage = Messages.getString("NoTrustManager.1") + this.wordwrap(cert.getIssuerDN().getName()) + Messages.getString("NoTrustManager.2") + Messages.getString("NoTrustManager.3") + this.wordwrap(cert.getSubjectDN().getName());
        int rc = JOptionPane.showConfirmDialog(JUpload.getInstance(), Messages.getString("NoTrustManager.4") + strMessage, Messages.getString("NoTrustManager.5"), 0);
        if (rc == 0) {
            JUpload.getInstance().addTrustedCerts(cert);
            return true;
        }
        return false;
    }

    private String wordwrap(String t_str) {
        char char1 = ",".charAt(0);
        char char2 = "\n".charAt(0);
        String a_str = t_str;
        while (!(a_str = (t_str = a_str).replace(char1, char2)).equals(t_str)) {
        }
        return t_str;
    }

    private void accept(X509Certificate cert) {
        this.m_acceptedCertificates.put(cert.getPublicKey(), cert);
    }

    private boolean isAccepted(X509Certificate cert) {
        return this.m_acceptedCertificates.containsKey(cert.getPublicKey());
    }

    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

