/*
 * Decompiled with CFR 0.152.
 */
package JUpload.queuefilter;

import JUpload.Messages;
import JUpload.utilities.Configurator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionParser {
    private HashMap m_variables = new HashMap();

    public void setVariable(String t_variable, int t_value) {
        if (!this.m_variables.containsKey(t_variable)) {
            this.m_variables.put(t_variable, Integer.toString(t_value));
        }
    }

    public boolean parse(String t_Expression) {
        try {
            t_Expression = t_Expression.toLowerCase();
            t_Expression = this.removeWhitespaces(t_Expression);
            t_Expression = this.replaceVariables(t_Expression);
            t_Expression = this.searchOperators(t_Expression);
            int loopCounter = 0;
            do {
                if (Configurator.getDebug()) {
                    System.out.println("Expression parser:" + t_Expression);
                }
                ++loopCounter;
                t_Expression = this.calc(t_Expression, "1and1", "1");
                t_Expression = this.calc(t_Expression, "0and0", "0");
                t_Expression = this.calc(t_Expression, "0and1", "0");
                t_Expression = this.calc(t_Expression, "1and0", "0");
                t_Expression = this.calc(t_Expression, "1or1", "1");
                t_Expression = this.calc(t_Expression, "0or0", "0");
                t_Expression = this.calc(t_Expression, "0or1", "1");
                t_Expression = this.calc(t_Expression, "1or0", "1");
                t_Expression = this.calc(t_Expression, "!0", "1");
                t_Expression = this.calc(t_Expression, "!1", "0");
                t_Expression = t_Expression.replaceAll("\\(1\\)", "1");
                if ((t_Expression = t_Expression.replaceAll("\\(0\\)", "0")).equals("1")) {
                    return true;
                }
                if (!t_Expression.equals("0")) continue;
                return false;
            } while (loopCounter < 1000);
            System.err.println(Messages.getString("ExpressionParser.errormessage.dimensionfilter") + t_Expression);
        }
        catch (Exception e) {
            System.err.println(Messages.getString("ExpressionParser.errormessage.expression") + t_Expression);
            System.err.println(Messages.getString("ExpressionParser.errormessage.prefix") + e.getMessage());
        }
        return false;
    }

    private String calc(String expression, String calc, String result) {
        Pattern pattern = Pattern.compile(calc);
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            String group = matcher.group();
            expression = expression.replaceAll(group, result);
        }
        return expression;
    }

    private String searchOperators(String expression) {
        Pattern pattern = Pattern.compile("[-]?[0123456789]*[<>=]*[-]?[1234567890]*");
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            String group = matcher.group();
            if (group.equals("")) continue;
            StringTokenizer stok = new StringTokenizer(group, "<>=!");
            String zahl1 = stok.nextToken();
            String zahl2 = stok.nextToken();
            int izahl1 = Integer.parseInt(zahl1);
            int izahl2 = Integer.parseInt(zahl2);
            boolean OP_LESSER = false;
            boolean OP_GREATER = false;
            boolean OP_EQUALS = false;
            if (group.indexOf(60) >= 0) {
                OP_LESSER = true;
            }
            if (group.indexOf(62) >= 0) {
                OP_GREATER = true;
            }
            if (group.indexOf(61) >= 0) {
                OP_EQUALS = true;
            }
            String result = "0";
            if (OP_LESSER && izahl1 < izahl2) {
                result = "1";
            }
            if (OP_GREATER && izahl1 > izahl2) {
                result = "1";
            }
            if (OP_EQUALS && izahl1 == izahl2) {
                result = "1";
            }
            expression = expression.replaceAll(group, result);
        }
        return expression;
    }

    private String replaceVariables(String t_Expression) {
        Set keySet = this.m_variables.keySet();
        Iterator keyIter = keySet.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String value = (String)this.m_variables.get(key);
            t_Expression = t_Expression.replaceAll(key, value);
        }
        return t_Expression;
    }

    private String removeWhitespaces(String str) {
        return str.replaceAll(" ", "");
    }
}

