/*
 * Decompiled with CFR 0.152.
 */
package JUpload.utilities;

import JUpload.Messages;
import JUpload.swingVersion.IQueueListener;
import JUpload.swingVersion.IQueueView;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;

public class QueueSelectedFiles {
    private DefaultListModel listModel = new DefaultListModel();
    private List queueListeners = new ArrayList();
    private List queueViews = new ArrayList();

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    public void addFile(MyFile newFile) throws Exception {
        if (Configurator.getPreventDoubles() && this.listModel.contains(newFile)) {
            Debug.println(this, "preventing duplicate file in queue:" + newFile);
            throw new Exception(Messages.getString("QueueSelectedFiles.0"));
        }
        this.listModel.addElement(newFile);
        this.notifyListenersChanging();
    }

    public void removeFile(MyFile file) {
        this.listModel.removeElement(file);
        this.notifyListenersChanging();
    }

    public void removeFileAt(int i) {
        this.listModel.removeElementAt(i);
        this.notifyListenersChanging();
    }

    public MyFile getFileAt(int i) {
        if (this.listModel.size() == 0) {
            return null;
        }
        if (this.listModel.size() > i) {
            return (MyFile)this.listModel.getElementAt(i);
        }
        return null;
    }

    public int size() {
        return this.listModel.size();
    }

    public void removeUploadedFiles() {
        for (int i = this.listModel.size() - 1; i >= 0; --i) {
            MyFile myFile = (MyFile)this.listModel.get(i);
            if (!myFile.isUploaded()) continue;
            this.listModel.remove(i);
        }
        this.notifyListenersChanged();
    }

    public void removeAllFiles() {
        this.listModel.clear();
        this.notifyListenersChanged();
    }

    public void notifyListenersChanging() {
        Iterator iter = this.queueListeners.iterator();
        while (iter.hasNext()) {
            IQueueListener listener = (IQueueListener)iter.next();
            listener.queueChanging(this.listModel);
        }
    }

    public void notifyListenersChanged() {
        Iterator iter = this.queueListeners.iterator();
        while (iter.hasNext()) {
            IQueueListener listener = (IQueueListener)iter.next();
            listener.queueChanged(this.listModel);
        }
        this.notifyQueueViews();
    }

    private void notifyQueueViews() {
        Iterator iter = this.queueViews.iterator();
        while (iter.hasNext()) {
            IQueueView view = (IQueueView)iter.next();
            view.update();
        }
    }

    public void addQueueListener(IQueueListener t_listener) {
        this.queueListeners.add(t_listener);
    }

    public void addView(IQueueView queueView) {
        this.queueViews.add(queueView);
    }

    public Object[] getSelected() {
        ArrayList<Object> selected = new ArrayList<Object>();
        Iterator iter = this.queueViews.iterator();
        while (iter.hasNext()) {
            IQueueView queueView = (IQueueView)iter.next();
            Object[] sel = queueView.getSelected();
            if (sel == null) continue;
            for (int i = 0; i < sel.length; ++i) {
                Object object = sel[i];
                selected.add(object);
            }
        }
        return selected.toArray();
    }

    public void removeSelected() {
        Iterator iter = this.queueViews.iterator();
        while (iter.hasNext()) {
            IQueueView queueView = (IQueueView)iter.next();
            Object[] sel = queueView.getSelected();
            if (sel != null) {
                for (int i = 0; i < sel.length; ++i) {
                    Object object = sel[i];
                    this.listModel.removeElement(object);
                }
            }
            queueView.removeSelected();
        }
        this.notifyQueueViews();
    }
}

