<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album.php,v 1.22 2008/02/08 10:47:59 orynider Exp $
* @copyright (c) 2007 [orynider@rdslink.ro, OryNider] Mx-Publisher Development Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

/******************************************************************
 *                            MODIFICATIONS
 *                           ---------------
 *   started		: Saturday, January 18, 2004
 *   copyright	:  Volodymyr (CLowN) Skoryk
 *   email		: blaatimmy72@yahoo.com
 *   version		: 1.5
 *
 *	 MODIFICATIONS:
 *		-added images to rating, insted of number for rating
 *		-added random pictures
 *		-added highest rated pictures (@ MarkFulton.com)
 *		-coment # for categories
 *		-last comment in categories
 *		-modified for mx_smartor by MXP Team
 *		-modified as MXP Addon based on FAP by Mighty Gorgon
 *
 *******************************************************************/

//
// ERROR HANDLING
//
//error_reporting( E_ALL );
//ini_set('display_errors', '1');

$phpEx = substr(strrchr(__FILE__, '.'), 1);

if (@file_exists( './viewtopic.' . $phpEx )) // -------------------------------------------- phpBB MOD MODE
{
	define('MXBB_MODULE', false);
	define('IN_PHPBB', true);
	
	$phpbb_root_path = $module_root_path = './';
	$mx_mod_path = $phpbb_root_path . 'mx_mod/';
	
	include($phpbb_root_path . 'common.' . $phpEx);
	include($mx_mod_path . "includes/functions_required.$phpEx");
	
	//Check if forum_hack is installed
	if (!isset($mx_root_path))
	{
		$mx_root_path = './';
		@define('IN_PORTAL', true);
		include_once($mx_mod_path . "includes/mx_constants.$phpEx");
		include_once($mx_mod_path . "includes/shared/phpbb2/includes/functions.$phpEx");
	}
	else
	{
		@define('IN_PORTAL', true);
		include_once($mx_root_path . "includes/mx_constants.$phpEx");
		include_once($mx_root_path . "includes/shared/phpbb2/includes/functions.$phpEx");

		//Redefine mx_root_path to include phpbb page_tail.php
		$mx_root_path = $phpbb_root_path;
	}
	
	require($mx_mod_path . "includes/functions_core.$phpEx");
	require($mx_mod_path . "includes/functions_styles.$phpEx");
	
	//Check for cash mod
	if (file_exists($phpbb_root_path . 'includes/functions_cash.'.$phpEx))
	{
		define('IN_CASHMOD', true);
	}

	//@ini_set( 'display_errors', '1' );
	error_reporting (E_ERROR | E_WARNING | E_PARSE); // This will NOT report uninitialized variables
	//error_reporting(E_ALL & ~E_NOTICE);

	define( 'PAGE_KB', -502 ); // If this id generates a conflict with other mods, change it ;)

	//
	// Instatiate the mx_cache class
	//
	$mx_cache = new mx_cache();
	
	//
	// Get mxBB config settings
	//
	//$portal_config = $mx_cache->obtain_mxbb_config();

	//
	// instatiate the mx_request_vars class
	//
	$mx_request_vars = new mx_request_vars();
	
	//
	// Page selector
	//
	$page_id = $mx_request_vars->request('page', MX_TYPE_INT, 1);

	$is_block = false;
	
	//
	// instatiate the mx_user class
	//
	$mx_user = new mx_user();

	if (file_exists("./modcp.$phpEx")) // phpBB2
	{
		define('PORTAL_BACKEND', 'phpbb2');
		$tplEx = 'tpl';
		
		//
		// Start user session
		// - populate $userdata and $lang
		//
		$mx_user->init($user_ip, $page_id, false);
		//init_userprefs($userdata);
		$mx_user->init_style(); //Overwrite template class

		/*
		$mx_user->set_module_default_style('_core'); // For compatibility with core 2.8.x
		if (!$userdata['user_level'] == ADMIN)
		{
			die('Only admins may run this script!!!');
		}
		*/
		include_once($phpbb_root_path . 'includes/bbcode.' . $phpEx);
		include_once($phpbb_root_path . 'includes/functions_post.' . $phpEx);
		
	}
	else if (@file_exists("./mcp.$phpEx")) // phpBB3
	{
		define('PORTAL_BACKEND', 'phpbb3');
		$tplEx = 'html';
		
		//
		// Start user session
		// - populate $userdata and $lang
		//
		$mx_user->init($user_ip, $page_id, false);
		$user->setup();
		//
		// End session management
		//

		/*
		$mx_user->set_module_default_style('_core'); // For compatibility with core 2.8.x
		if ($userdata['user_type'] != USER_FOUNDER)
		{
			die('Only admins may run this script!!!');
		}
		*/
		include_once($mx_mod_path . "includes/shared/phpbb2/includes/bbcode.$phpEx");
		include_once($mx_mod_path . "includes/shared/phpbb2/includes/functions_post.$phpEx");
	}
	else
	{
		die('Copy this file in phpbb_root_path were is your viewtopic.php file!!!');
	}
}
else
{
	if( !defined('IN_PORTAL') || !is_object($mx_block))
	{
		define('IN_PORTAL', true);
		$mx_root_path = '../../';
		$module_root_path = './';

		//
		// Let's include some stuff...
		//
		$phpEx = substr(strrchr(__FILE__, '.'), 1);
		include_once($mx_root_path . 'common.' . $phpEx);
		//
		// Start session management
		//
		$mx_user->init($user_ip, PAGE_INDEX); 
		//
		// End session management
		//
		$block_id = ( !empty($HTTP_GET_VARS['block_id']) ) ? $HTTP_GET_VARS['block_id'] : $HTTP_POST_VARS['id'];
		if( empty($block_id) )
		{
			$sql = "SELECT * FROM " . BLOCK_TABLE . "  WHERE block_title = 'Smartor_album' LIMIT 1";
			if(!$result = $db->sql_query($sql))
			{
				mx_message_die(GENERAL_ERROR, "Could not query Smartor_Album module information", "", __LINE__, __FILE__, $sql);
			}
			$row = $db->sql_fetchrow($result);
			$block_id = $row['block_id'];
		}
		$is_block = FALSE;
	}
	else
	{
		//
		// Read block Configuration
		$title = $mx_block->block_info['block_title'];
		$block_size = ( isset($block_size) && !empty($block_size) ? $block_size : '100%' );

		$is_block = true;	
		  
	  	global $images, $is_block;
	}
}

//
// Get general album information
//
$album_root_path = $module_root_path . 'album_mod/';
include($album_root_path . 'album_common.'.$phpEx);

//
// Nav switch for mx
//
// ---------------------
// Check $album_user_id
// ---------------------
if (isset ($_POST['user_id']))
{
	$album_user_id = intval($_POST['user_id']);
}
elseif (isset ($_GET['user_id']))
{
	$album_user_id = intval($_GET['user_id']);
}
else
{
	//  if no user_id was supplied then we aren't going to show a personal gallery category
	$album_user_id = $userdata['user_id'];
}

//
// Mode setting
//
$mode = $mx_request_vars->request('smartor_mode', MX_TYPE_NO_TAGS, 'album_index');

if ( $mode == 'album_cat' )
{
	 include($album_root_path. 'modules/album_cat.'.$phpEx);
}
else if ( $mode == 'album_comment' )
{
 	include($album_root_path. 'modules/album_comment.'.$phpEx);
}
else if ( $mode == 'album_comment_delete')
{
	 include($album_root_path. 'modules/album_comment_delete.'.$phpEx);
}
else if ( $mode == 'album_comment_edit' )
{
	 include($album_root_path. 'modules/album_comment_edit.'.$phpEx);
}
else if ( $mode == 'album_delete' )
{
	 include($album_root_path. 'modules/album_delete.'.$phpEx);
}
else if ( $mode == 'album_edit' )
{
	 include($album_root_path. 'modules/album_edit.'.$phpEx);
}
else if ( $mode == 'album_hotornot' )
{
	 include($album_root_path. 'modules/album_hotornot.'.$phpEx);
}
else if ( $mode == 'album_modcp' )
{
	 include($album_root_path. 'modules/album_modcp.'.$phpEx);
}
else if ( $mode == 'album_page' )
{
	 include($album_root_path. 'modules/album_page.'.$phpEx);
}
else if ( $mode == 'album_personal' )
{
	 include($album_root_path. 'modules/album_personal.'.$phpEx);
}
else if ( $mode == 'album_personal_index' )
{
	 include($album_root_path. 'modules/album_personal_index.'.$phpEx);
}
else if ( $mode == 'album_pic' )
{
	error_reporting(0); //Errors will coupt thumbnalis
	include($album_root_path. 'modules/album_pic.'.$phpEx);
}
else if ( $mode == 'album_picm' )
{
	error_reporting(0); //Errors will coupt thumbnalis
	include($album_root_path. 'modules/album_picm.'.$phpEx);
}
else if ( $mode == 'album_rate' )
{
	 include($album_root_path. 'modules/album_rate.'.$phpEx);
}
else if ( $mode == 'album_search' )
{
	 include($album_root_path. 'modules/album_search.'.$phpEx);
}
else if ( $mode == 'album_showpage' )
{
	 include($album_root_path. 'modules/album_showpage.'.$phpEx);
}
else if ( $mode == 'album_thumbnail' )
{
	error_reporting(0); //Errors will coupt thumbnalis
	include($album_root_path. 'modules/album_thumbnail.'.$phpEx);
}
else if ( $mode == 'album_otf_thumbnail' )
{
	error_reporting(0); //Errors will coupt thumbnalis
	include($album_root_path. 'modules/album_otf_thumbnail.'.$phpEx);
}
else if ( $mode == 'album_upload' )
{
	include($album_root_path. 'modules/album_upload.'.$phpEx);
}
else if ( $mode == 'album_download' )
{
	 include($album_root_path. 'modules/album_download.'.$phpEx);
}
else if ( $mode == 'album_otf' )
{
	 include($album_root_path. 'modules/album_otf.'.$phpEx);
}
else if ( $mode == 'album_personal_cat_admin' )
{
	 include($album_root_path. 'modules/album_personal_cat_admin.'.$phpEx);
}
else if ( $mode == 'album_pic_nuffed' )
{
	 include($album_root_path. 'modules/album_pic_nuffed.'.$phpEx);
}
else if ( $mode == 'album_rdf' )
{
	 include($album_root_path. 'modules/album_rdf.'.$phpEx);
}
else if ( $mode == 'album_rss' )
{
	error_reporting(0); //Errors will coupt xml
	include($album_root_path. 'modules/album_rss.'.$phpEx);
}
else if ( $mode == 'album_allpics' )
{
	 include($album_root_path. 'modules/album_allpics.'.$phpEx);
}
else if ( $mode == 'smilies' )
{
	generate_smilies_album('window', PAGE_ALBUM_PICTURE);
	exit;
}
else if ( $mode == 'album_jupload' )
{
	error_reporting(0); //Errors will coupt xml
	include($album_root_path. 'modules/album_jupload.'.$phpEx);
}
else if ( $mode == 'random_personal_thumbnail' )
{
	error_reporting(0); //Errors will coupt thumbnalis
	include($album_root_path. 'modules/album_personal_random.'.$phpEx);
}
else if(!is_object($mx_block) && MXBB_MODULE)
{
	die("Hacking attempt");
}
else
{
	if ($album_user_id != ALBUM_PUBLIC_GALLERY)
	{
		$cat_id = ALBUM_ROOT_CATEGORY;

		if (isset ($_POST['mode']))
		{
			$album_view_mode = strtolower($_POST['smartor_mode']);
		}
		elseif (isset ($_GET['smartor_mode']))
		{
			$album_view_mode = strtolower($_GET['smartor_mode']);
		}
		else
		{
			$album_view_mode = ALBUM_VIEW_LIST;
		}
		// make sure that it only contains some valid value
		switch ($album_view_mode)
		{
			case ALBUM_VIEW_ALL:
				$album_view_mode = ALBUM_VIEW_ALL;
				break;
			case ALBUM_VIEW_LIST:
				$album_view_mode = ALBUM_VIEW_LIST;
				break;
			default:
				$album_view_mode = '';
		}

		if (isset ($_POST['cat_id']))
		{
			$cat_id = intval($_POST['cat_id']);
		}
		elseif (isset ($_GET['cat_id']))
		{
			$cat_id = intval($_GET['cat_id']);
		}

		if ($album_user_id < 1)
		{
			if (!$userdata['session_logged_in'])
			{
				$album_user_id = $userdata['user_id'];
				// mx_redirect(append_sid($mx_root_path . "login.php?redirect=" . this_smartor_mxurl(), true));
			}
			else
			{
				$album_user_id = $userdata['user_id'];
				// mx_redirect(append_sid(this_smartor_mxurl()));
			}
		}

		if ($cat_id != ALBUM_ROOT_CATEGORY && $cat_id != album_get_personal_root_id($album_user_id))
		{
			mx_redirect(append_sid(this_smartor_mxurl("smartor_mode=album_cat")));
		}
	}


	$catrows = array ();
	$options = ($album_view_mode == ALBUM_VIEW_LIST ) ? ALBUM_READ_ALL_CATEGORIES|ALBUM_AUTH_VIEW : ALBUM_AUTH_VIEW;
	$catrows = album_read_tree($album_user_id, $options);

	album_read_tree($album_user_id);
	$album_nav_cat_desc = album_make_nav_tree($cat_id, this_smartor_mxurl("smartor_mode=album_cat"), "nav" , $album_user_id);
	if ($album_nav_cat_desc != '')
	{
		$album_nav_cat_desc = ALBUM_NAV_ARROW . $album_nav_cat_desc;
	}
	// ------------------------------------------------------------------
	// Build allowed category-list (for recent pics after here)
	// $catrows array now stores all categories which this user can view.
	// ------------------------------------------------------------------
	$allowed_cat = ''; // For Recent Public Pics below
	for ($i = 0; $i < count($catrows); $i ++)
	{
		// ------------------------------------------------
		//  Fix by Phea
		// ------------------------------------------------
		$tmpAccess = album_user_access($catrows[$i]['cat_id'], 0, ALBUM_AUTH_VIEW, 0, 0, 0, 0, 0); // VIEW 
		if ($tmpAccess['view'] == 1)
		{ 
			// ------------------------------------------------ 
			// build list of allowd category id's 
			// ------------------------------------------------ 
			$allowed_cat .= ($allowed_cat == '') ? $catrows[$i]['cat_id'] : ','.$catrows[$i]['cat_id']; 
		} 
	}
	//
	// END of Categories Index
	//

	// ------------------------------------------------------------
	// Build the sort method and sort order information
	// ------------------------------------------------------------

	if (isset ($_GET['start']))
	{
		$start = intval($_GET['start']);
	}
	elseif (isset ($_POST['start']))
	{
		$start = intval($_POST['start']);
	}
	else
	{
		$start = 0;
	}

	if (isset ($_GET['sort_method']))
	{
		switch ($_GET['sort_method'])
		{
			case 'pic_time' :
				$sort_method = 'pic_time';
				break;
			case 'pic_title' :
				$sort_method = 'pic_title';
				break;
			case 'username' :
				$sort_method = 'username';
				break;
			case 'pic_view_count' :
				$sort_method = 'pic_view_count';
				break;
			case 'rating' :
				$sort_method = 'rating';
				break;
			case 'comments' :
				$sort_method = 'comments';
				break;
			case 'new_comment' :
				$sort_method = 'new_comment';
				break;
			default :
				$sort_method = $album_config['sort_method'];
		}
	}
	elseif (isset ($_POST['sort_method']))
	{
		switch ($_POST['sort_method'])
		{
			case 'pic_time' :
				$sort_method = 'pic_time';
				break;
			case 'pic_title' :
				$sort_method = 'pic_title';
				break;
			case 'username' :
				$sort_method = 'username';
				break;
			case 'pic_view_count' :
				$sort_method = 'pic_view_count';
				break;
			case 'rating' :
				$sort_method = 'rating';
				break;
			case 'comments' :
				$sort_method = 'comments';
				break;
			case 'new_comment' :
				$sort_method = 'new_comment';
				break;
			default :
				$sort_method = $album_config['sort_method'];
		}
	}
	else
	{
		$sort_method = $album_config['sort_method'];
	}

	if (isset ($_GET['sort_order']))
	{
		switch ($_GET['sort_order'])
		{
			case 'ASC' :
				$sort_order = 'ASC';
				break;
			case 'DESC' :
				$sort_order = 'DESC';
				break;
			default :
				$sort_order = $album_config['sort_order'];
		}
	}
	elseif (isset ($_POST['sort_order']))
	{
		switch ($_POST['sort_order'])
		{
			case 'ASC' :
				$sort_order = 'ASC';
				break;
			case 'DESC' :
				$sort_order = 'DESC';
				break;
			default :
				$sort_order = $album_config['sort_order'];
		}
	}
	else
	{
		$sort_order = $album_config['sort_order'];
	}

	// ---------------------------
	// additional sorting options
	// ---------------------------
	if ($album_user_id != ALBUM_PUBLIC_GALLERY)
	{
		$sort_rating_option = '';
		$sort_comments_option = '';
		$sort_new_comment_option = '';

		if ($album_config['rate'] == 1)
		{
			$sort_rating_option = '<option value="rating" ';
			$sort_rating_option .= ($sort_method == 'rating') ? 'selected="selected"' : '';
			$sort_rating_option .= '>'.$lang['Rating'].'</option>';
		}
		if ($album_config['comment'] == 1)
		{
			$sort_comments_option = '<option value="comments" ';
			$sort_comments_option .= ($sort_method == 'comments') ? 'selected="selected"' : '';
			$sort_comments_option .= '>'.$lang['Comments'].'</option>';

			$sort_new_comment_option = '<option value="new_comment" ';
			$sort_new_comment_option .= ($sort_method == 'new_comment') ? 'selected="selected"' : '';
			$sort_new_comment_option .= '>'.$lang['New_Comment'].'</option>';
		}
	}

	/*
	+-----------------------
	| Start output the page
	+-----------------------
	*/

	$page_title = $lang['Album'];

		if ( !is_object($mx_block))
	 	{
			include($mx_root_path . 'includes/page_header.'.$phpEx);
	 	}

		$template->set_filenames(array(
			'body' => 'album_index_body.tpl')
		);

		$cols = ($album_sp_config['img_cols'] == 0 ? 4 : $album_sp_config['img_cols']);
		$cols_width = (100 / $cols) . '%';


		// Last Comments
		if ($album_config['show_last_comments'] == 1)
		{
			album_build_last_comments_info($allowed_cat);
		}

		// Recent Public Pics
		if ($album_sp_config['disp_late'] == 1)
		{
			album_build_recent_pics($allowed_cat);
		}

		// Highest Rated Pics
		if ($album_sp_config['disp_high'] == 1)
		{
			album_build_highest_rated_pics($allowed_cat);
		}

		// Most Viewed Pics
		if ($album_sp_config['disp_mostv'] == 1)
		{
			album_build_most_viewed_pics($allowed_cat);
		}

		//Random Pics
		if ($album_sp_config['disp_rand'] == 1)
		{
			album_build_random_pics($allowed_cat);
		}

		$otf_link = ( $userdata['user_level'] == ADMIN ) ? append_sid(this_smartor_mxurl("smartor_mode=album_otf" . '&sid=' . $userdata['session_id'])) : append_sid(this_smartor_mxurl("smartor_mode=album_otf"));

		$template->assign_vars(array(
			'ALBUM_NAV' => $album_nav_cat_desc,
			'S_COLS' => $cols,
			'S_COL_WIDTH' => $cols_width,
			'TARGET_BLANK' => ($album_config['fullpic_popup']) ? 'target="_blank"' : '',
			'L_RAND_PICS' => $lang['Random_Public_Pics'],
			'L_RANDOM_PUBLIC_PICS' => $lang['Random_Public_Pics'],
			'L_HI_RATINGS' => $lang['Toprated_Public_Pics'],
			'L_TOPRATED_PUBLIC_PICS' => $lang['Toprated_Public_Pics'],
			'L_RECENT_PUBLIC_PICS' => $lang['Recent_Public_Pics'],
			'L_MOST_VIEWED' => $lang['Most_Public_Pics'],
			'L_NO_PICS' => $lang['No_Pics'],
			'L_PIC_TITLE' => $lang['Pic_Image'],
			'L_PIC_ID' => $lang['Pic_ID'],
			'L_VIEW' => $lang['View'],
			'L_POSTER' => $lang['Pic_Poster'],
			'L_POSTED' => $lang['Posted'],

			'L_ALBUM_ALLPICS' => $lang['All_Picture_List_Of_User'],
			'L_ALBUM_OTF' => $lang['Pic_Gallery'],
			'U_ALBUM_ALLPICS' => append_sid(this_smartor_mxurl("smartor_mode=album_allpics")),
			'OTF_LINK' => $otf_link,
			'U_ALBUM_OTF' => $otf_link,
			)
		);

	// it's a personal gallery, and in the root folder
	/*
	else
	{
		if ($album_view_mode == ALBUM_VIEW_LIST)
		{
			include ($album_root_path . 'album_memberlist.' . $phpEx);
		}
		else
		{
			// include our special personal gallery files
			// this file holds all the code to handle personal galleries
			// except moderation and management of personal gallery categories.
			include ($album_root_path . 'album_personal.' . $phpEx);
		}
	}
	*/

	album_display_index($album_user_id, ALBUM_ROOT_CATEGORY, true, true, true);

	// Generate the page
	$template->pparse('body');

	if ( !is_object($mx_block))
	{
		include($mx_root_path . 'includes/page_tail.'.$phpEx);
	}
}
?>