<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_common.php,v 1.22 2008/02/08 10:47:59 orynider Exp $
* @copyright (c) 2003 [smartor_xp@hotmail.com, Smartor] mxBB Development Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

if ( !defined('IN_PORTAL') )
{
	die('Hacking attempt');
}

if ( !defined('IN_ALBUM') )
{
	define('IN_ALBUM', true);
}

if ( !defined('ALBUM_MOD_PATH') )
{
	define('ALBUM_MOD_PATH', 'album_mod/');
}

include_once($album_root_path . 'includes/album_constants.'.$phpEx);

// Cache settings
$use_cache = 1;

//
// Get Album Config
//
if (($mx_cache->get('album_config')) && ($use_cache))
{
	$album_config = $mx_cache->get('album_config');
}
else
{
	$sql = "SELECT * FROM " . ALBUM_CONFIG_TABLE;

	if (!($result = $db->sql_query($sql)))
	{
		if (!function_exists('mx_message_die'))
		{
			die("Couldnt query smartor album config information, Allso this hosting or server is using a cache optimizer not compatible with MX-Publisher or just lost connection to database wile query.");
		}
		else
		{
			mx_message_die( GENERAL_ERROR, 'Couldnt query smartor album config information', '', __LINE__, __FILE__, $sql );
		}
	}

	while ($row = $db->sql_fetchrow($result))
	{
		$album_config_name = $row['config_name'];
		$album_config_value = $row['config_value'];
		$album_config[$album_config_name] = $album_config_value;
	}
	$db->sql_freeresult($result);

	if ($use_cache)
	{
		$mx_cache->put('album_config', $album_config);
	}
}

//get SP config info
if (($mx_cache->get('album_sp_config')) && ($use_cache))
{
	$album_sp_config = $mx_cache->get('album_sp_config');
}
else
{
	$sql = "SELECT * FROM " . ALBUM_SP_CONFIG_TABLE;

	if (!($result = $db->sql_query($sql)))
	{
		if (!function_exists('mx_message_die'))
		{
			die("Couldnt query smartor album sp config information, Allso this hosting or server is using a cache optimizer not compatible with MX-Publisher or just lost connection to database wile query.");
		}
		else
		{
			mx_message_die( GENERAL_ERROR, 'Couldnt query smartor album sp config information', '', __LINE__, __FILE__, $sql );
		}
	}

	while ($row = $db->sql_fetchrow($result))
	{
		$album_sp_config_name = $row['config_name'];
		$album_sp_config_value = $row['config_value'];
		$album_sp_config[$album_sp_config_name] = $album_sp_config_value;
	}
	$db->sql_freeresult($result);

	if ($use_cache)
	{
		$mx_cache->put('album_sp_config', $album_sp_config);
	}
}
//end get SP config info

if($album_config['album_debug_mode'] == 1)
{
	$GLOBALS['album_debug_enabled'] = true;
}
else
{
	$GLOBALS['album_debug_enabled'] = false;
}

if ($album_config['show_img_no_gd'] == 1)
{
	//$thumb_size = 'width="' . $album_config['thumbnail_size'] . '" height="' . $album_config['thumbnail_size'] . '"';
	$thumb_size = 'width="' . $album_config['thumbnail_size'] . '"';
}
else
{
	$thumb_size = '';
}

if ( (intval($album_config['set_memory']) > '0') && (intval($album_config['set_memory']) < '17') )
{
	@ini_set('memory_limit', intval($album_config['set_memory']) . 'M');
}

if ($album_config['show_inline_copyright'] == 0)
{
	/*
	$album_copyright = '<div align="center" class="gensmall" style="font-family: Verdana, Arial, Helvetica, sans-serif; letter-spacing: -1px"><b>Photo Album Powered by</b><br />';
	$album_copyright .= 'Photo Album 2' . $album_config['album_version'] . '&nbsp;&copy;&nbsp;2002-2003&nbsp;<a href="http://smartor.is-root.com" target="_blank">Smartor</a><br />';
	$album_copyright .= 'Volodymyr (CLowN) Skoryk\'s SP1 Addon 1.5.1<br />';
	$album_copyright .= 'IdleVoid\'s Album Category Hierarchy 1.3.0<br />';
	$album_copyright .= '<a href="http://www.mightygorgon.com" target="_blank">Mighty Gorgon</a> Full Album Pack ' . $album_config['fap_version'];
	$album_copyright .= '</div>';
	*/
	$album_copyright = '<div align="center" class="gensmall" style="font-family: Verdana, Arial, Helvetica, sans-serif; letter-spacing: -1px">';
	$album_copyright .= 'Photo Album Powered by:&nbsp;<a href="http://www.mightygorgon.com" target="_blank">Mighty Gorgon</a> Full Album Pack ' . $album_config['fap_version'] . '&nbsp;&copy;&nbsp;2006 is modified by <a href="http://www.mx-system.com/">MX-Team</a><br />';
	$album_copyright .= '[based on <a href="http://smartor.is-root.com" target="_blank">Smartor</a> Photo Album plus IdleVoid\'s Album CH &amp; CLowN SP1]';
	$album_copyright .= '</div>';
}
else
{
	$album_copyright = '<div align="center" class="gensmall" style="font-family: Verdana, Arial, Helvetica, sans-serif; letter-spacing: -1px">';
	$album_copyright .= 'Photo Album Powered by:&nbsp;<a href="http://www.mightygorgon.com" target="_blank">Mighty Gorgon</a> Full Album Pack ' . $album_config['fap_version'] . '&nbsp;&copy;&nbsp;2006 is modified by <a href="http://www.mx-system.com/">MX-Team</a>';
	$album_copyright .= '&nbsp;[based on <a href="http://smartor.is-root.com" target="_blank">Smartor</a> Photo Album plus IdleVoid\'s Album CH &amp; CLowN SP1]';
	$album_copyright .= '</div>';
}

if ($album_config['lb_preview'] == 0)
{
	$preview_lb_div = '';
}
else
{
	$preview_lb_div = '<script language="JavaScript" type="text/javascript" src="' . ALBUM_MOD_PATH . 'fap_loader.js"></script>';
	$preview_lb_div .= '<div id="preview_div" style="display: none; position: absolute; z-index: 110; left: -600px; top: -600px;">';
	$preview_lb_div .= '	<div class="border_preview" style="width: ' . $album_sp_config['midthumb_width'] . 'px; height: ' . $album_sp_config['midthumb_height'] . 'px;">';
	$preview_lb_div .= '		<div id="loader_container" style="display: none; visibility: hidden;">';
	$preview_lb_div .= '			<div id="loader">';
	$preview_lb_div .= '				<div align="center">Loading preview...</div>';
	$preview_lb_div .= '				<div id="loader_bg">';
	$preview_lb_div .= '					<div id="progress" style="left: 96px; width: 16px;"></div>';
	$preview_lb_div .= '				</div>';
	$preview_lb_div .= '			</div>';
	$preview_lb_div .= '		</div>';
	$preview_lb_div .= '		Preview';
	$preview_lb_div .= '		<div class="preview_temp_load">';
	$preview_lb_div .= '			<img onload="javascript:remove_loading();" src="" alt="" border="0" />';
	$preview_lb_div .= '		</div>';
	$preview_lb_div .= '	</div>';
	$preview_lb_div .= '</div>';
	$preview_lb_div .= '<br /><br />';
}

if (!isset($album_root_path) || empty($album_root_path))
{
	$album_root_path = $module_root_path . ALBUM_MOD_PATH . '';
} 

include_once($album_root_path . 'includes/album_integration.' . $phpEx);
include_once($album_root_path . 'includes/album_functions.' . $phpEx);
include_once($album_root_path . 'includes/clown_album_functions.' . $phpEx);
//
// Set ALBUM Version
//
$template->assign_vars(array(
	'NAV_SEP' => $lang['Nav_Separator'],
	'NAV_DOT' => '&#8226;',
	'IMG_ALBUM_FOLDER' => $images['pm_outbox'],
	'IMG_ALBUM_SUBFOLDER' => $images['pm_inbox'],
	'IMG_ALBUM_FOLDER_SMALL' => $images['folder'],
	'IMG_ALBUM_FOLDER_SMALL_NEW' => $images['folder_new'],
	'IMG_ALBUM_SUBFOLDER_SMALL' => $images['icon_minipost'],
	'IMG_ALBUM_SUBFOLDER_SMALL_NEW' => $images['icon_minipost_new'],
	'IMG_ALBUM_FOLDER_NEW' => $images['pm_savebox'],
	'IMG_ALBUM_FOLDER_SS' => $images['pm_sentbox'],
	'IMG_SLIDESHOW' => $images['icon_latest_reply'],
	'IMG_SLIDESHOW_NEW' => $images['icon_newest_reply'],
	'IMG_DOT_ORANGE' => '<img src="' . $images['orange_dot'] . '" align="middle" />',
	'IMG_DOT_BLUE' => '<img src="' . $images['blue_dot'] . '" align="middle" />',
	'IMG_DOT_GREEN' => '<img src="' . $images['green_dot'] . '" align="middle" />',
	'IMG_DOT_YELLOW' => '<img src="' . $images['yellow_dot'] . '" align="middle" />',
	'SPACER' => $images['spacer'],

	'CURRENT_TIME' => sprintf($lang['Current_time'], create_date($board_config['default_dateformat'], time(), $board_config['board_timezone'])),

	'THUMB_SIZE' => $thumb_size,
	'MIDTHUMB_W' => $album_sp_config['midthumb_width'],
	'MIDTHUMB_H' => $album_sp_config['midthumb_height'],
	'PREVIEW_LB_DIV' => $preview_lb_div,

	'ALBUM_VERSION' => '2' . $album_config['album_version'],
	'ALBUM_VERSION_INFO' =>	'This script (Smartor Album v. 2.00 :: mxBB-Portal Module 2006, with Volodymyr (CLowN) Skoryks SP1 addon) is modified by <a href="http://www.mx-system.com/">MX-Team</a> ',
	'ALBUM_COPYRIGHT' => $preview_lb_div . $album_copyright,

	'PAFILEDB_SEARCH_ACTION' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_search&page=" . $page_id)),
	'PAFILEDB_SEARCH_HIDDEN' => '<input type="hidden" name="smartor_mode" value="album_search"><input type="hidden" name="page" value="' . $page_id. '">',
	'U_ALBUM_SEARCH' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_search")),
	'U_ALBUM_UPLOAD' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_upload")),

	'U_ALBUM_SMILIES' => mx_append_sid($module_root_path . "album." . $phpEx . "?smartor_mode=album_showpage&mode=smilies" . '&sid=' . $userdata['session_id']),
	'MODULE_PATH'	=> $module_root_path,

	'L_RSS' => ( !empty($lang['Rss_Feed']) ? $lang['Rss_Feed'] : 'RSS Feed' ),
	'U_ALBUM_RDF' => mx_append_sid($module_root_path . "album." . $phpEx . "?smartor_mode=album_rdf" . '&sid=' . $userdata['session_id']),
	'U_ALBUM_RSS' => mx_append_sid($module_root_path . "album." . $phpEx . "?smartor_mode=album_rss" . '&sid=' . $userdata['session_id']),

	'L_INDEX' => '<<',
	'U_INDEX' => mx_append_sid($mx_root_path . "index.".$phpEx),
	'L_USERNAME' => $lang['Username'],
       'L_DESCRIPTION' => $lang['Description'],
	'L_PIC_NAME' => $lang['Pic_Name'],
	'L_NO_PICS' => $lang['No_Pics'],
	'L_PIC_TITLE' => $lang['Pic_Title'],
	'L_VIEW' => $lang['View'],
	'L_POSTER' => $lang['Poster'],
	'L_POSTED' => $lang['Posted'],
	'L_GO' => $lang['Go'],
	'L_COMMENTS' => $lang['Comments'],
	'L_LAST_COMMENT' => $lang['Last_Comment'],
	'L_LAST_COMMENTS' => $lang['Last_Comments'],
	'L_SEARCH' => $lang['Search'],
	'L_SEARCH_CONTENTS' => $lang['Search_Contents'],
	'L_SEARCH_MATCHES' => $lang['Search_Matches'],
	'L_ALBUM_INDEX' => $lang['Album'],
	'L_ALBUM' => $lang['Photo_Album'],
	'U_ALBUM' => mx_append_sid(this_smartor_mxurl()),
	'U_MX_ALBUM' => mx_append_sid(this_fap_portalurl())
	)
);

if ($album_config['album_bbcode'] == 1)
{
	include_once($album_root_path . 'includes/album_bbcode.' . $phpEx);
}

include_once($album_root_path . 'includes/album_hierarchy_functions.' . $phpEx);

?>