<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_hotornot.php,v 1.1.2.3 2008/03/13 08:27:30 orynider Exp $
* @copyright (c) 2003 [smartor_xp@hotmail.com, Smartor] Mx-Publisher Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

// MX
if ( !defined('IN_PORTAL') )
{
	die("Hacking attempt");
}

$rate_point = intval($HTTP_POST_VARS['hon_rating']);

//if user havent rated a picture, show page, else update database
if ($rate_point < 1 || $rate_point > 10)
{
	include($album_root_path . 'album_common.'.$phpEx);

	// ------------------------------------
	// get a random pic from album
	// ------------------------------------ 
	if ($album_sp_config['hon_rate_where'] == '')
	{
		$sql = "SELECT `pic_id`  FROM " . ALBUM_TABLE . " ORDER BY RAND() LIMIT 1";
	}
	else
	{
		$sql = "SELECT `pic_id`  FROM " . ALBUM_TABLE . " WHERE pic_cat_id IN (" . $album_sp_config['hon_rate_where'] . ") ORDER BY RAND() LIMIT 1";
	}
	        
	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
	}
	$pic_id_temp = $db->sql_fetchrow($result);
	$pic_id = $pic_id_temp['pic_id'];


	// ------------------------------------
	// Get this pic info
	// ------------------------------------

	$sql = "SELECT p.*, u.user_id, u.username, r.rate_pic_id, AVG(r.rate_point) AS rating, COUNT(DISTINCT c.comment_id) AS comments
			FROM ". ALBUM_TABLE ." AS p
				LEFT JOIN ". USERS_TABLE ." AS u ON p.pic_user_id = u.user_id
				LEFT JOIN ". ALBUM_RATE_TABLE ." AS r ON p.pic_id = r.rate_pic_id
				LEFT JOIN ". ALBUM_COMMENT_TABLE ." AS c ON p.pic_id = c.comment_pic_id
			WHERE pic_id = '$pic_id'
			GROUP BY p.pic_id";
	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
	}
	$thispic = $db->sql_fetchrow($result);

	$cat_id = $thispic['pic_cat_id'];
	$user_id = $thispic['pic_user_id'];

	if( empty($thispic) or !file_exists(ALBUM_UPLOAD_PATH . $pic_filename) )
	{
		mx_message_die(GENERAL_ERROR, $lang['Pic_not_exist']);
	}


	// ------------------------------------
	// Get the current Category Info
	// ------------------------------------

	if ($cat_id != PERSONAL_GALLERY)
	{
		$sql = "SELECT *
				FROM ". ALBUM_CAT_TABLE ."
				WHERE cat_id = '$cat_id'";
		if( !($result = $db->sql_query($sql)) )
		{
			mx_message_die(GENERAL_ERROR, 'Could not query category information', '', __LINE__, __FILE__, $sql);
		}

		$thiscat = $db->sql_fetchrow($result);
	}
	else
	{
		$thiscat = init_personal_gallery_cat($user_id);
	}

	if (empty($thiscat))
	{
		mx_message_die(GENERAL_ERROR, $lang['Category_not_exist']);
	}


	// ------------------------------------
	// Check the permissions
	// ------------------------------------
	if ($album_sp_config['hon_rate_users'] == 0)
	{
		$album_user_access = album_user_access($cat_id, $thiscat, 1, 0, 0, 0, 0, 0); // VIEW


		if ($album_user_access['view'] == 0)
		{
			if (!$userdata['session_logged_in'])
			{
				mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
				redirect(mx_append_sid($phpbb_root_path ."login.$phpEx?redirect=album.php?smartor_mode=album_hotornot"));
			}
			else
			{
				mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
			}
		}
	}



	// ------------------------------------
	// Check Pic Approval
	// ------------------------------------

	if ($userdata['user_level'] != ADMIN)
	{
		if( ($thiscat['cat_approval'] == ADMIN) or (($thiscat['cat_approval'] == MOD) and !$album_user_access['moderator']) )
		{
			if ($thispic['pic_approval'] != 1)
			{
				mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
			}
		}
	}


	/*
	+----------------------------------------------------------
	| Main work here...
	+----------------------------------------------------------
	*/

	//
	// Start output of page
	//
	$page_title = $lang['Album'];
	 if ( !$is_block )
 {
	include($mx_root_path . 'includes/page_header.'.$phpEx);
 }


	$template->set_filenames(array(
		'body' => 'album_hon.tpl')
	);

	if( ($thispic['pic_user_id'] == ALBUM_GUEST) or ($thispic['username'] == '') )
	{
		$poster = ($thispic['pic_username'] == '') ? $lang['Guest'] : $thispic['pic_username'];
	}
	else
	{
		$poster = '<a href="'. mx_append_sid($phpbb_root_path ."profile.$phpEx?mode=viewprofile&amp;". POST_USERS_URL .'='. $thispic['user_id']) .'">'. $thispic['username'] .'</a>';
	}

	//deside how user wants to show their rating
	$image_rating = ImageRating($thispic['rating']);
		
	//hot or not rating
	if ( CanRated($pic_id, $userdata['user_id']))
	{
		$template->assign_block_vars('hon_rating', array());	
			
		for ($i = 0; $i < $album_config['rate_scale']; $i++)
		{   
			$template->assign_block_vars('hon_rating.hon_row', array(
				'VALUE' => ($i + 1)));
		}
	}
	else
	{
		$template->assign_block_vars('hon_rating_cant', array());
	}
	
	$template->assign_vars(array(
		'CAT_TITLE' => $thiscat['cat_title'],
		'U_VIEW_CAT' => ($cat_id != PERSONAL_GALLERY) ? mx_append_sid(this_smartor_mxurl("smartor_mode=album_cat&cat_id=$cat_id")) : mx_append_sid(this_smartor_mxurl("smartor_mode=album_personal&user_id=$user_id")),

		'U_PIC' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_pic&pic_id=$pic_id")),

		'PIC_TITLE' => $thispic['pic_title'],
		'PIC_DESC' => nl2br($thispic['pic_desc']),

		'POSTER' => $poster,

		'PIC_TIME' => create_date($board_config['default_dateformat'], $thispic['pic_time'], $board_config['board_timezone']),

		'PIC_VIEW' => $thispic['pic_view_count'],

		'PIC_RATING' => $image_rating,

		'PIC_COMMENTS' => $thispic['comments'],

		'U_COMMENT' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=$pic_id")),

		'L_RATING' => $lang['Rating'],
		'L_PIC_TITLE' => $lang['Pic_Title'] . $album_config['clown_rateType'],
		'L_PIC_DESC' => $lang['Pic_Desc'],
		'L_POSTER' => $lang['Poster'],
		'L_POSTED' => $lang['Posted'],
		'L_VIEW' => $lang['View'],
		'L_COMMENTS' => $lang['Comments'])
	);

	if ($album_config['rate'])
	{
		$template->assign_block_vars('rate_switch', array());
	}

	if ($album_config['comment'])
	{
		$template->assign_block_vars('comment_switch', array());
	}

	//
	// Generate the page
	//
	$template->pparse('body');

	 if ( !$is_block )
 {
	include($mx_root_path . 'includes/page_tail.'.$phpEx);
 }

}
else
{
	if ($album_sp_config['hon_rate_sep'] == 1)
	{
		$rate_user_id = $userdata['user_id'];
		$rate_user_ip = $userdata['session_ip'];
		
		$sql = "INSERT INTO ". ALBUM_RATE_TABLE ." (rate_pic_id, rate_user_id, rate_user_ip, rate_sp_point)
				VALUES ('$pic_id', '$rate_user_id', '$rate_user_ip', '$rate_point')";

		if( !$result = $db->sql_query($sql) )
		{
			mx_message_die(GENERAL_ERROR, 'Could not insert new rating', '', __LINE__, __FILE__, $sql);
		}
		
			mx_message_die(GENERAL_ERROR,"updated the SP record succsessfully");
	}
	else
	{
		$rate_user_id = $userdata['user_id'];
		$rate_user_ip = $userdata['session_ip'];
		
		$sql = "INSERT INTO ". ALBUM_RATE_TABLE ." (rate_pic_id, rate_user_id, rate_user_ip, rate_point)
				VALUES ('$pic_id', '$rate_user_id', '$rate_user_ip', '$rate_point')";

		if( !$result = $db->sql_query($sql) )
		{
			mx_message_die(GENERAL_ERROR, 'Could not insert new rating', '', __LINE__, __FILE__, $sql);
		}
		
			mx_message_die(GENERAL_ERROR,"updated the record succsessfully");
	}
}


// +--------------------------------------------------------+
// |  Powered by Photo Album 2.x.x (c) 2002-2003 Smartor    |
// |  with Volodymyr (CLowN) Skoryk's Service Pack 1  2003 |
// +--------------------------------------------------------+

?>