<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_otf_thumbnail.php,v 1.1.2.3 2008/03/13 08:27:31 orynider Exp $
* @copyright (c) 2002-2006 [Smartor, Volodymyr (CLowN) Skoryk, IdleVoid, Jon Ohlsson] Mx-Publisher Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

// MX
if ( !defined('IN_PORTAL') )
{
	die("Hacking attempt");
}

include_once($album_root_path . 'includes/album_image_class.' . $phpEx);

// ------------------------------------
// Check the request
// ------------------------------------
if( isset($_GET['pic_id']) )
{
	$pic_id = $_GET['pic_id'];
}
elseif( isset($_POST['pic_id']) )
{
	$pic_id = $_POST['pic_id'];
}
else
{
	mx_message_die(GENERAL_MESSAGE, 'No pics specified');
}

if( isset($_GET['pic_cat']) )
{
	$pic_cat = $_GET['pic_cat'];
}
elseif( isset($_POST['pic_cat']) )
{
	$pic_cat = $_POST['pic_cat'];
}
else
{
	mx_message_die(GENERAL_MESSAGE, 'No cat specified');
}

$pic_filename = $pic_id;
$pic_fullpath = ALBUM_UPLOAD_PATH . 'otf/' . $pic_cat . '/' . $pic_filename;
// $pic_thumbnail = $pic_cat . '_' . $pic_filename;
$pic_thumbnail = $pic_filename;
$pic_thumbnail_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail;
$pic_filetype = strtolower(substr($pic_filename, strlen($pic_filename) - 4, 4));
$pic_title = ucfirst(substr($pic_filename, 0, strlen($pic_filename) - 4));
$pic_title_reg = ereg_replace("[^A-Za-z0-9]", "_", $pic_title);

switch ($pic_filetype)
{
	case '.gif':
		break;
	case '.jpg':
		break;
	case '.png':
		break;
	default:
		header('Content-type: image/jpeg');
		header("Content-Disposition: filename=thumb_posted_" . $pic_title_reg . $pic_filetype);
		readfile($images['no_thumbnail']);
		exit;
		break;
}

// --------------------------------
// Check thumbnail cache. If cache is available we will SEND & EXIT
// --------------------------------

if( ($album_config['thumbnail_cache'] == 1) && file_exists($pic_thumbnail_fullpath) )
{
	/*
	$Image = new ImgObj();
	$Image->ReadSourceFile($pic_thumbnail_fullpath);
	$Image->SendToBrowser($pic_title_reg, $pic_filetype, 'thumb_', '', $album_config['thumbnail_quality']);
	$Image->Destroy();
	exit;
	*/
	switch ($pic_filetype)
	{
		case '.gif':
			$file_header = 'Content-type: image/gif';
			break;
		case '.jpg':
			$file_header = 'Content-type: image/jpeg';
			break;
		case '.png':
			$file_header = 'Content-type: image/png';
			break;
		default:
			header('Content-type: image/jpeg');
			header("Content-Disposition: filename=thumb_" . $pic_title_reg . $pic_filetype);
			readfile($images['no_thumbnail']);
			exit;
			break;
	}
	header($file_header);
	header("Content-Disposition: filename=thumb_" .$pic_title_reg . $pic_filetype);
	readfile($pic_thumbnail_fullpath);
	exit;
}

if( !file_exists($pic_fullpath) )
{
	mx_message_die(GENERAL_MESSAGE, $lang['Pic_not_exist']);
}

$pic_size = @getimagesize($pic_fullpath);
$pic_width = $pic_size[0];
$pic_height = $pic_size[1];

if( ($pic_width < $album_config['thumbnail_size']) && ($pic_height < $album_config['thumbnail_size']) )
{
	/*
	$Image = new ImgObj();
	$Image->ReadSourceFile($pic_fullpath);
	$Image->SendToBrowser($pic_title_reg, $pic_filetype, '', '', $album_config['thumbnail_quality']);
	$Image->Destroy();
	exit;
	*/
	switch ($pic_filetype)
	{
		case '.gif':
			$file_header = 'Content-type: image/gif';
			break;
		case '.jpg':
			$file_header = 'Content-type: image/jpeg';
			break;
		case '.png':
			$file_header = 'Content-type: image/png';
			break;
		default:
			header('Content-type: image/jpeg');
			header("Content-Disposition: filename=thumb_" . $pic_title_reg . $pic_filetype);
			readfile($images['no_thumbnail']);
			exit;
			break;
	}
	header($file_header);
	header("Content-Disposition: filename=thumb_" .$pic_title_reg . $pic_filetype);
	readfile($pic_fullpath);
	exit;
}
else
{
	// --------------------------------
	// Cache is empty. Try to re-generate!
	// --------------------------------
	if ($pic_width > $pic_height)
	{
		$thumbnail_width = $album_config['thumbnail_size'];
		$thumbnail_height = $album_config['thumbnail_size'] * ($pic_height/$pic_width);
	}
	else
	{
		$thumbnail_height = $album_config['thumbnail_size'];
		$thumbnail_width = $album_config['thumbnail_size'] * ($pic_width/$pic_height);
	}

	// Old Thumbnails - BEGIN
	// Old thumbnail generation functions, for GD1 and some strange servers...
	if ( ($album_config['gd_version'] == 1) || ($album_config['use_old_pics_gen'] == 1) )
	{
		switch ($pic_filetype)
		{
			case '.gif':
				header('Content-type: image/jpeg');
				header("Content-Disposition: filename=thumb_" . $pic_title_reg . $pic_filetype);
				readfile($images['no_thumbnail']);
				exit;
				break;
		}
		if( $album_config['show_pic_size_on_thumb'] == 1)
		{
			$thumbnail = ($album_config['gd_version'] == 1) ? @imagecreate($thumbnail_width, $thumbnail_height + 16) : @imagecreatetruecolor($thumbnail_width, $thumbnail_height + 16);
		}
		else
		{
			$thumbnail = ($album_config['gd_version'] == 1) ? @imagecreate($thumbnail_width, $thumbnail_height) : @imagecreatetruecolor($thumbnail_width, $thumbnail_height);
		}

		$resize_function = ($album_config['gd_version'] == 1) ? 'imagecopyresized' : 'imagecopyresampled';

		@$resize_function($thumbnail, $pic_fullpath, 0, 0, 0, 0, $thumbnail_width, $thumbnail_height, $pic_width, $pic_height);

		if( $album_config['show_pic_size_on_thumb'] == 1)
		{
			$dimension_font = 1;
			$dimension_filesize = filesize(ALBUM_UPLOAD_PATH . $pic_filename);
			$dimension_string = intval($pic_width) . 'x' . intval($pic_height) . '(' . intval($dimension_filesize / 1024) . 'KB)';
			$dimension_colour = ImageColorAllocate($thumbnail, 255, 255, 255);
			$dimension_height = imagefontheight($dimension_font);
			$dimension_width = imagefontwidth($dimension_font) * strlen($dimension_string);
			$dimension_x = ($thumbnail_width - $dimension_width) / 2;
			$dimension_y = $thumbnail_height + ((16 - $dimension_height) / 2);
			imagestring($thumbnail, 1, $dimension_x, $dimension_y, $dimension_string, $dimension_colour);
		}

		if ($album_config['thumbnail_cache'] == 1)
		{
			// ------------------------
			// Re-generate successfully. Write it to disk!
			// ------------------------
			switch ($pic_filetype)
			{
				case '.jpg':
					@imagejpeg($thumbnail, $pic_thumbnail_new_fullpath, $album_config['thumbnail_quality']);
					break;
				case '.png':
					@imagepng($thumbnail, $pic_thumbnail_new_fullpath);
					break;
			}
			@chmod($pic_thumbnail_new_fullpath, 0777);
		}

		// ----------------------------
		// After write to disk, donot forget to send to browser also
		// ----------------------------
		switch ($pic_filetype)
		{
			case '.jpg':
				@imagejpeg($thumbnail, '', $album_config['thumbnail_quality']);
				break;
			case '.png':
				@imagepng($thumbnail);
				break;
			default:
				header('Content-type: image/jpeg');
				header("Content-Disposition: filename=thumb_" . $pic_title_reg . $pic_filetype);
				readfile($images['no_thumbnail']);
				break;
		}
		exit;
	}
	// Old Thumbnails - END

	$Image = new ImgObj();

	if ($pic_filetype == '.jpg')
	{
		$Image->ReadSourceFileJPG($pic_fullpath);
	}
	else
	{
		$Image->ReadSourceFile($pic_fullpath);
	}

	$Image->Resize($thumbnail_width, $thumbnail_height);
	
	if( $album_config['show_pic_size_on_thumb'] == 1)
	{
		$dimension_string = intval($pic_width) . 'x' . intval($pic_height) . '(' . intval(filesize($pic_fullpath) / 1024) . 'KB)';
		$Image->Text($dimension_string);
	}
	
	if ($album_config['thumbnail_cache'] == 1)
	{
		if ($pic_filetype == '.jpg')
		{
			$Image->SendToFileJPG($pic_thumbnail_fullpath, $album_config['thumbnail_quality']);
		}
		else
		{
			$Image->SendToFile($pic_thumbnail_fullpath, $album_config['thumbnail_quality']);
		}
		//$Image->SendToFile($pic_thumbnail_fullpath, $album_config['thumbnail_quality']);
		//@chmod($pic_thumbnail_fullpath, 0777);
	}
	
	if ($pic_filetype == '.jpg')
	{
		$Image->SendToBrowserJPG($pic_title_reg, $pic_filetype, 'thumb_', '', $album_config['thumbnail_quality']);
	}
	else
	{
		$Image->SendToBrowser($pic_title_reg, $pic_filetype, 'thumb_', '', $album_config['thumbnail_quality']);
	}
	
	if ( $Image == true )
	{
		$Image->Destroy();
		exit;
	}
	else
	{
		$Image->Destroy();
		header('Content-type: image/jpeg');
		header("Content-Disposition: filename=thumb_" . $pic_title_reg . $pic_filetype);
		readfile($images['no_thumbnail']);
		exit;
	}
}

?>