<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_pic.php,v 1.1.2.3 2008/03/13 08:27:32 orynider Exp $
* @copyright (c) 2003 [smartor_xp@hotmail.com, Smartor] Mx-Publisher Development Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/ 

// MX
if ( !defined('IN_PORTAL') )
{
	die("Hacking attempt");
}



//include_once($album_root_path . 'album_common.'.$phpEx);
require($album_root_path . 'includes/album_image_class.' . $phpEx);

// ------------------------------------
// Check the request
// ------------------------------------
if( isset($_GET['pic_id']) )
{
	$pic_id = intval($_GET['pic_id']);
}
elseif( isset($_POST['pic_id']) )
{
	$pic_id = intval($_POST['pic_id']);
}
else
{
	mx_message_die(GENERAL_MESSAGE, 'No pics specified');
	//die('No pics specified');
}

// ------------------------------------
// Get this pic info and current Category Info
// ------------------------------------
if (($mx_cache->get('thispic'.$pic_id)) && ($use_cache))
{
	$thispic = $mx_cache->get('thispic'.$pic_id);
}
else
{
	$sql = "SELECT * FROM " . ALBUM_TABLE . "  WHERE pic_id = '$pic_id'";

	if (!($result = $db->sql_query($sql)))
	{
		if (!function_exists('mx_message_die'))
		{
			die("Couldnt query smartor album pic information, Allso this hosting or server is using a cache optimizer not compatible with MX-Publisher or just lost connection to database wile query.");
		}
		else
		{
			mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
		}
	}
	
	$thispic = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);

	if ($use_cache)
	{
		$mx_cache->put('thispic'.$pic_id, $thispic);
	}
}

$cat_id = $thispic['pic_cat_id'];
$album_user_id = $thispic['cat_user_id'];

$pic_filename = $thispic['pic_filename'];
$pic_filetype = strtolower(substr($pic_filename, strlen($pic_filename) - 4, 4));
$pic_fullpath = ALBUM_UPLOAD_PATH . $pic_filename;
$pic_wm_fullpath = ALBUM_WM_CACHE_PATH . 'full_' . $pic_filename;
$pic_title = $thispic['pic_title'];
$pic_title_reg = ereg_replace("[^A-Za-z0-9]", "_", $pic_title);
$apply_wm = false;
$wm_file = ALBUM_WM_FILE;

if( ($album_sp_config['use_watermark'] == true) && ($userdata['user_level'] != ADMIN) && ( (!$userdata['session_logged_in']) || ($album_sp_config['wut_users'] == 1) ) )
{
	$apply_wm = true;
	$wm_file = (file_exists($thispic['cat_wm']) ? $thispic['cat_wm'] : ALBUM_WM_FILE);
}

if( empty($thispic) || !file_exists($pic_fullpath) )
{
	mx_message_die(GENERAL_MESSAGE, $lang['Pic_not_exist']);
}

// ------------------------------------
// Get the current Category Info
// ------------------------------------

if ($cat_id != PERSONAL_GALLERY)
{
	$sql = "SELECT *
			FROM ". ALBUM_CAT_TABLE ."
			WHERE cat_id = '$cat_id'";
	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query category information', '', __LINE__, __FILE__, $sql);
	}

	$thiscat = $db->sql_fetchrow($result);
}
else
{
	$thiscat = init_personal_gallery_cat($user_id);
}

// ------------------------------------
// Check the permissions
// ------------------------------------
$album_user_access = album_permissions($album_user_id, $cat_id, ALBUM_AUTH_VIEW, $thispic);

$auth_data = album_user_access($cat_id, $thiscat, 1, 0, 1, 1, 1, 1);

if (($auth_data['view'] == 0) && ($album_user_access['view'] == false))
{
	mx_message_die(GENERAL_MESSAGE, $lang['Not_Authorised']);
}

// ------------------------------------
// Check Pic Approval
// ------------------------------------
if ( $userdata['user_level'] != ADMIN )
{
	if ( ($thispic['cat_approval'] == ADMIN) || (($thispic['cat_approval'] == MOD) && !$album_user_access['moderator']) )
	{
		if ($thispic['pic_approval'] !== 1)
		{
			mx_message_die(GENERAL_MESSAGE, $lang['Not_Authorised']);
		}
	}
}

// ------------------------------------
// Check hotlink
// ------------------------------------
if ( ($album_config['hotlink_prevent'] == true) && (isset($HTTP_SERVER_VARS['HTTP_REFERER'])) )
{
	$check_referer = explode('?', $HTTP_SERVER_VARS['HTTP_REFERER']);
	$check_referer = trim($check_referer[0]);

	$good_referers = array();

	if ($album_config['hotlink_allowed'] != '')
	{
		$good_referers = explode(',', $album_config['hotlink_allowed']);
	}

	$good_referers[] = $board_config['server_name'] . $board_config['script_path'];

	$errored = true;

	for ($i = 0; $i < count($good_referers); $i++)
	{
		$good_referers[$i] = trim($good_referers[$i]);

		if ( (strstr($check_referer, $good_referers[$i])) && ($good_referers[$i] != '') )
		{
			$errored = false;
		}
	}

	if ( $errored )
	{
		mx_message_die(GENERAL_MESSAGE, $lang['Not_Authorised']);
		/*
		header('Content-type: image/jpeg');
		header('Content-Disposition: filename=' . $pic_title_reg . $pic_filetype);
		readfile($images['no_thumbnail']);
		exit;
		*/
	}
}

/*
+----------------------------------------------------------
| Main work here...
+----------------------------------------------------------
*/

// ------------------------------------
// Increase view counter
// ------------------------------------
$sql = "UPDATE ". ALBUM_TABLE ."
			SET pic_view_count = pic_view_count + 1
			WHERE pic_id = '$pic_id'";
if( !$result = $db->sql_query($sql) )
{
	mx_message_die(GENERAL_ERROR, 'Could not update pic information', '', __LINE__, __FILE__, $sql);
}

// ------------------------------------
// Okay, now we can send image to the browser
// ------------------------------------
switch ($pic_filetype)
{
	case '.gif':
		$file_header = 'Content-type: image/gif';
		break;
	case '.jpg':
		$file_header = 'Content-type: image/jpeg';
		break;
	case '.png':
		$file_header = 'Content-type: image/png';
		break;
	default:
		header('Content-type: image/jpeg');
		header('Content-Disposition: filename=' . $pic_title_reg . $pic_filetype);
		readfile($images['no_thumbnail']);
		exit;
		break;
}

if ( (($pic_filetype == '.jpg') || ($pic_filetype == '.png')) && ($apply_wm == false) )
{
	header($file_header);
	header('Content-Disposition: filename=' .$pic_title_reg . $pic_filetype);
	readfile($pic_fullpath);
	exit;
}

if ( $pic_filetype == '.gif' )
{
	header($file_header);
	header('Content-Disposition: filename=' . $pic_title_reg . $pic_filetype);
	readfile($pic_fullpath);
	exit;
}

if( ($apply_wm == true) && file_exists($pic_wm_fullpath) )
{
	header($file_header);
	header('Content-Disposition: filename=' . $pic_title_reg . $pic_filetype);
	readfile($pic_wm_fullpath);
	exit;
}

// Old Thumbnails - BEGIN
// Old thumbnail generation functions, for GD1 and some strange servers...
if ( ($album_config['gd_version'] == 1) || ($album_config['use_old_pics_gen'] == 1) )
{
	// MG Watermark - BEGIN
	if ( $apply_wm == true )
	{
		$wm_position = ( ($album_sp_config['disp_watermark_at'] > 0) && ($album_sp_config['disp_watermark_at'] < 10) ) ? $album_sp_config['disp_watermark_at'] : 5;
		$wm_transition = 50;
		mergePics($pic_fullpath, $wm_file, $wm_position, $wm_transition, $pic_filetype);
	}
	else
	{
		readfile($pic_fullpath);
	}
	// MG Watermark - END
	exit;
}
// Old Thumbnails - END

$Image = new ImgObj();

if ($pic_filetype == '.jpg')
{
	$Image->ReadSourceFileJPG($pic_fullpath);
}
else
{
	$Image->ReadSourceFile($pic_fullpath);
}

if ( $apply_wm == true )
{
	$wm_position = ( ($album_sp_config['disp_watermark_at'] > 0) && ($album_sp_config['disp_watermark_at'] < 10) ) ? $album_sp_config['disp_watermark_at'] : 5;
	$wm_maxsize = 50;
	$wm_transition = 75;
	$Image->WatermarkPos($wm_file, $wm_position, $wm_maxsize, $wm_transition);
	$Image->SendToFile($pic_wm_fullpath, $album_config['thumbnail_quality']);
	@chmod($pic_wm_fullpath, 0777);
}

if ($pic_filetype == '.jpg')
{
	$Image->SendToBrowserJPG($pic_title_reg, $pic_filetype, '', '', $album_config['thumbnail_quality']);
}
else
{
	$Image->SendToBrowser($pic_title_reg, $pic_filetype, '', '', $album_config['thumbnail_quality']);
}

$Image->Destroy();
exit;

?>