<?php 
/**
*
* @package mx_mod
* @version $Id: functions_required.php,v 1.2 2008/03/13 07:14:28 orynider Exp $
* @copyright (c) 2002-2006 mxBB Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
* @link http://www.mxbb.net
*
*/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}


if(!function_exists('mx_message_die'))
{
	/**
	 * General replacement for die().
	 *
	 * This is general replacement for die(), allows templated
	 * output in users (or default) language, etc.
	 * $msg_code can be one of these constants:
	 * - GENERAL_MESSAGE : Use for any simple text message, eg. results of an operation, authorisation failures, etc.
	 * - GENERAL ERROR : Use for any error which occurs _AFTER_ the common.php include and session code, ie. most errors in pages/functions
	 * - CRITICAL_MESSAGE : Used when basic config data is available but a session may not exist, eg. banned users
	 * - CRITICAL_ERROR : Used when config data cannot be obtained, eg no database connection. Should _not_ be used in 99.5% of cases.
	 *
	 * @param integer $msg_code
	 * @param string $msg_text
	 * @param string $msg_title
	 * @param string $err_line
	 * @param string $err_file
	 * @param string $sql
	 */
	function mx_message_die($msg_code, $msg_text = '', $msg_title = '', $err_line = '', $err_file = '', $sql = '')
	{
		global $db, $template, $board_config, $theme, $lang, $phpEx, $phpbb_root_path, $nav_links, $gen_simple_header, $images, $mx_root_path, $module_root_path;
		global $userdata, $user_ip, $session_length;
		global $mx_starttime, $mx_page, $mx_block, $mx_user, $mx_request_vars, $mx_cache, $tplEx;

		static $msg_history;

		if ( !defined('PORTAL_BACKEND') )
		{
			if ( @file_exists($phpbb_root_path . "modcp.$phpEx") )
			{
				define('PORTAL_BACKEND', 'phpbb2');
			}
			else if ( @file_exists($phpbb_root_path . "mcp.$phpEx") )
			{
				define('PORTAL_BACKEND', 'phpbb3');
			}
		}

		//$default_lang = $mx_user->get_old_lang($board_config['default_lang']);
		$default_lang = ($mx_user->lang['default_lang']) ? $mx_user->lang['default_lang'] : $board_config['default_lang'];

		if( !isset($msg_history) )
		{
			$msg_history = array();
		}
		$msg_history[] = array(
			'msg_code'	=> $msg_code,
			'msg_text'	=> $msg_text,
			'msg_title'	=> $msg_title,
			'err_line'	=> $err_line,
			'err_file'	=> $err_file,
			'sql'		=> $sql
		);

		if(defined('HAS_DIED'))
		{
			//
			// This message is printed at the end of the report.
			// Of course, you can change it to suit your own needs. ;-)
			//
			$custom_error_message = 'Please, contact the %swebmaster%s. Thank you.';
			if ( !empty($board_config) && !empty($board_config['board_email']) )
			{
				$custom_error_message = sprintf($custom_error_message, '<a href="mailto:' . $board_config['board_email'] . '">', '</a>');
			}
			else
			{
				$custom_error_message = sprintf($custom_error_message, '', '');
			}
			echo "<html>\n<body>\n<b>Critical Error!</b><br />\nmx_message_die() was called multiple times.<br />&nbsp;<hr />";
			for( $i = 0; $i < count($msg_history); $i++ )
			{
				echo '<b>Error #' . ($i+1) . "</b>\n<br />\n";
				if( !empty($msg_history[$i]['msg_title']) )
				{
					echo '<b>' . $msg_history[$i]['msg_title'] . "</b>\n<br />\n";
				}
				echo $msg_history[$i]['msg_text'] . "\n<br /><br />\n";
				if( !empty($msg_history[$i]['err_line']) )
				{
					echo '<b>Line :</b> ' . $msg_history[$i]['err_line'] . '<br /><b>File :</b> ' . $msg_history[$i]['err_file'] . "</b>\n<br />\n";
				}
				if( !empty($msg_history[$i]['sql']) )
				{
					echo '<b>SQL :</b> ' . $msg_history[$i]['sql'] . "\n<br />\n";
				}
				echo "&nbsp;<hr />\n";
			}
			echo $custom_error_message . '<hr /><br clear="all">';
			die("</body>\n</html>");
		}

		define('HAS_DIED', 1);

		$sql_store = $sql;

		//
		// Get SQL error if we are debugging. Do this as soon as possible to prevent
		// subsequent queries from overwriting the status of sql_error()
		//
		if ( DEBUG && ( $msg_code == GENERAL_ERROR || $msg_code == CRITICAL_ERROR ) )
		{
			$sql_error = $db->sql_error();

			$debug_text = '';

			if ( $sql_error['message'] != '' )
			{
				$debug_text .= '<br /><br />SQL Error : ' . $sql_error['code'] . ' ' . $sql_error['message'];
			}

			if ( $sql_store != '' )
			{
				$debug_text .= "<br /><br />$sql_store";
			}

			if ( $err_line != '' && $err_file != '' )
			{
				$debug_text .= '</br /><br />Line : ' . $err_line . '<br />File : ' . $err_file;
			}
		}

		//Security check
		if( !is_object($mx_user) && !is_object($mx_page) && !is_object($mx_request_vars))
		{
			die('Hacking attempt, or couldn\'t initalize the main classes required to call mx_message_die().');
		}

		if( !is_object($mx_user))
		{
			$mx_user = new mx_user();
		}

		if( !is_object($mx_page))
		{
			$mx_page = new mx_page();
		}

		if( !is_object($mx_request_vars))
		{
			$mx_request_vars = new mx_request_vars();
		}

		if ( empty($page_id) && $mx_request_vars->is_request('portalpage') )
		{
			$page_id = $mx_request_vars->request('portalpage', MX_TYPE_INT, 1);
		}
		else if ( empty($page_id) )
		{
			$page_id = $mx_request_vars->request('page', MX_TYPE_INT, 1);
		}

		if (!$page_id)
		{
			$page_id = 1;
		}

		//
		// Start user session
		// - populate $userdata and $lang
		//
		if( empty($userdata) && ( $msg_code == GENERAL_MESSAGE || $msg_code == GENERAL_ERROR ) )
		{
			$mx_user->init($user_ip, $page_id, false);
		}

		//
		// Load and instatiate CORE (page) and block classes
		//
		//$mx_page->init( $page_id );

		$default_lang = ($mx_user->lang['default_lang']) ? $mx_user->get_old_lang($mx_user->lang['default_lang']) : $board_config['default_lang'];

		if ( empty($default_lang) )
		{
			// - populate $default_lang
			$default_lang= 'english';
		}

		switch (PORTAL_BACKEND)
		{
			case 'internal':
			case 'phpbb3':
				$lang_path = $mx_root_path . 'includes/shared/phpbb2/language/';
				break;
			case 'phpbb2':
				$lang_path = $phpbb_root_path . 'language/';
			break;
			default:
				$lang_path = $phpbb_root_path . 'language/';
		}

		//
		// If the header hasn't been output then do it
		//
		if ( !defined('HEADER_INC') && $msg_code != CRITICAL_ERROR )
		{
			if ( empty($lang) || empty($lang['Board_disable']) )
			{
				if ((@include $lang_path . "lang_" . $default_lang . "/lang_main.$phpEx") === false)
				{
					if ((@include $lang_path . "lang_english/lang_main.$phpEx") === false)
					{
						die('Language file (mx_message_die) ' . $lang_path . "lang_" . $default_lang . "/lang_main.$phpEx" . ' couldn\'t be opened.');
					}
				}

				if ((@include $mx_root_path . "language/lang_" . $default_lang . "/lang_main.$phpEx") === false)
				{
					if ((@include $mx_root_path . "language/lang_english/lang_main.$phpEx") === false)
					{
						die('Language file (mx_message_die) ' . $mx_root_path . "language/lang_" . $default_lang . "/lang_main.$phpEx" . ' couldn\'t be opened.');
					}
				}
			}

			$mx_page->page_title = !empty($msg_title) ? $msg_title : $lang['Information'];

			if( !is_object($template) )
			{
				switch (PORTAL_BACKEND)
				{
					case 'internal':
					case 'phpbb2':
						$mx_user->init_style();
					break;
					case 'phpbb3':
						$mx_user->init_style();
					break;
				}
			}

			//
			// Load the Page Header
			//
			if ( !defined('IN_ADMIN') )
			{
				include($mx_root_path . 'includes/page_header.'.$phpEx);
			}
			else
			{
				include($mx_root_path . 'admin/page_header_admin.'.$phpEx);
			}
		}

		switch($msg_code)
		{
			case GENERAL_MESSAGE:
				if ( $msg_title == '' )
				{
					$msg_title = $lang['Information'];
				}
				break;

			case CRITICAL_MESSAGE:
				if ( $msg_title == '' )
				{
					$msg_title = $lang['Critical_Information'];
				}
				break;

			case GENERAL_ERROR:
				if ( $msg_text == '' )
				{
					$msg_text = $lang['An_error_occured'];
				}

				if ( $msg_title == '' )
				{
					$msg_title = $lang['General_Error'];
				}
				break;

			case CRITICAL_ERROR:
				//
				// Critical errors mean we cannot rely on _ANY_ DB information being
				// available so we're going to dump out a simple echo'd statement
				//
				if ((@include($lang_path . "lang_" . $default_lang . "/lang_main.$phpEx")) === false)
				{
					if ((@include($lang_path . "lang_english/lang_main.$phpEx")) === false)
					{
						$phpbb_lang_error = 'Language file ' . $lang_path . "lang_" . $default_lang . "/lang_main.$phpEx" . ' couldn\'t be opened.';
					}
					else
					{
						$phpbb_lang_error = false;
					}
				}

				if ((@include($mx_root_path . "language/lang_" . $default_lang . "/lang_main.$phpEx")) === false)
				{
					if ((@include($mx_root_path . "language/lang_english/lang_main.$phpEx")) === false)
					{
						$mx_lang_error = 'Language file ' . $mx_root_path . "language/lang_" . $default_lang . "/lang_main.$phpEx" . ' couldn\'t be opened.';
					}
					else
					{
						$mx_lang_error = false;
					}
				}

				if ($msg_text == '')
				{
					$msg_text = $lang['A_critical_error'];
				}

				if ($msg_title == '')
				{
					$msg_title = 'MX-Publisher : <b>' . $lang['Critical_Error'] . '</b>';
				}
				break;
		}


		//
		// Add on DEBUG info if we've enabled debug mode and this is an error. This
		// prevents debug info being output for general messages should DEBUG be
		// set TRUE by accident (preventing confusion for the end user!)
		//
		if ( DEBUG && ( $msg_code == GENERAL_ERROR || $msg_code == CRITICAL_ERROR ) )
		{
			if ( $debug_text != '' )
			{
				$msg_text = $msg_text . '<br /><br /><b><u>DEBUG MODE</u></b> ' . $debug_text;
			}
		}

		if ($phpbb_lang_error)
		{
			$msg_text = $msg_text . '<br /><br /><b><u>ALLSO</u></b> ' . $phpbb_lang_error;
		}

		if ($mx_lang_error)
		{
			$msg_text = $msg_text . '<br /><br /><b><u>ALLSO</u></b> ' . $mx_lang_error;
		}

		if ( $msg_code != CRITICAL_ERROR )
		{
			if ( !empty($lang[$msg_text]) )
			{
				$msg_text = $lang[$msg_text];
			}

			if ( !defined('IN_ADMIN') )
			{
				$message_file = $mx_block->full_page ? 'full_page_body.tpl' : 'message_body.tpl';
				$template->set_filenames(array(
					'message_body' => $message_file)
				);
			}
			else
			{
				$template->set_filenames(array( 'message_body' => 'admin/admin_message_body.tpl') );
			}

			//
			// Fix for correcting possible "bad" links to phpBB
			//
			if (!(strpos($msg_text, 'href') === false))
			{
				$msg_text = str_replace('<a href="index', '<a href="'.$phpbb_root_path.'index', $msg_text);
				$msg_text = str_replace('<a href="viewforum', '<a href="'.$phpbb_root_path.'viewforum', $msg_text);
				$msg_text = str_replace('<a href="viewtopic', '<a href="'.$phpbb_root_path.'viewtopic', $msg_text);
				$msg_text = str_replace('<a href="modcp', '<a href="'.$phpbb_root_path.'modcp', $msg_text);
				$msg_text = str_replace('<a href="groupcp', '<a href="'.$phpbb_root_path.'groupcp', $msg_text);
				$msg_text = str_replace('<a href="posting', '<a href="'.$phpbb_root_path.'posting', $msg_text);

			}

			$template->assign_vars(array(
				'MESSAGE_TITLE' => $msg_title,
				'MESSAGE_TEXT' => $msg_text)
			);

			ob_start();
			$template->pparse('message_body');
			$phpbb_output = ob_get_contents();
			ob_end_clean();
			$phpbb_output = str_replace('"templates/'.$theme['template_name'], '"' . $phpbb_root_path . 'templates/'.$theme['template_name'], $phpbb_output);
			echo($phpbb_output);
			unset($phpbb_output);

			if ( !defined('IN_ADMIN') )
			{
				include($mx_root_path . 'includes/page_tail.'.$phpEx);
			}
			else
			{
				include($mx_root_path . 'admin/page_footer_admin.'.$phpEx);
			}
		}
		else
		{
			echo "<html>\n<body>\n" . $msg_title . "\n<br /><br />\n" . $msg_text . "</body>\n</html>";
		}

		exit;
	}
}
/**
* Append session id to url
*
* @param string $url The url the session id needs to be appended to (can have params)
* @param mixed $params String or array of additional url parameters
* @param bool $is_amp Is url using &amp; (true) or & (false)
* @param string $session_id Possibility to use a custom session id instead of the global one
*
* Examples:
* <code>
* mx_append_sid("{$phpbb_root_path}viewtopic.$phpEx?t=1&amp;f=2", false, true);
* mx_append_sid("{$phpbb_root_path}viewtopic.$phpEx", 't=1&amp;f=2', true);
* mx_append_sid("{$phpbb_root_path}viewtopic.$phpEx", 't=1&f=2', false);
* mx_append_sid("{$phpbb_root_path}viewtopic.$phpEx", array('t' => 1, 'f' => 2));
* </code>
*/
if(!function_exists('mx3_append_sid'))
{
	function mx3_append_sid($url, $params = false, $is_amp = true, $session_id = false, $mod_rewrite_only = false)
	{
		global $_SID, $_EXTRA_URL, $portal_config, $mx_mod_rewrite;

		// Assign sid if session id is not specified
		if ($session_id === false)
		{
			$session_id = $_SID;
		}

		if ( is_array($session_id) )
		{
			$session_id = $mx_user->session_id;
		}

		$amp_delim = ($is_amp) ? '&amp;' : '&';
		$url_delim = (strpos($url, '?') === false) ? '?' : $amp_delim;

		// Appending custom url parameter?
		$append_url = (!empty($_EXTRA_URL)) ? implode($amp_delim, $_EXTRA_URL) : '';

		// Is mod_rewrite enabled? If so, do some url rewrites...
		if (is_object($mx_mod_rewrite))
		{
			$url = $mx_mod_rewrite->encode($url);
		}

		// Replaces same function in mx_sessions_phpbbx.php
		if ($mod_rewrite_only)
		{
			return $url;
		}

		$anchor = '';
		if (strpos($url, '#') !== false)
		{
			list($url, $anchor) = explode('#', $url, 2);
			$anchor = '#' . $anchor;
		}
		else if (!is_array($params) && strpos($params, '#') !== false)
		{
			list($params, $anchor) = explode('#', $params, 2);
			$anchor = '#' . $anchor;
		}

		// Use the short variant if possible ;)
		if ($params === false)
		{
			// Append session id
			if (!$session_id)
			{
				return $url . (($append_url) ? $url_delim . $append_url : '') . $anchor;
			}
			else
			{
				return $url . (($append_url) ? $url_delim . $append_url . $amp_delim : $url_delim) . 'sid=' . $session_id . $anchor;
			}
		}

		// Build string if parameters are specified as array
		if (is_array($params))
		{
			$output = array();

			foreach ($params as $key => $item)
			{
				if ($item === NULL)
				{
					continue;
				}

				if ($key == '#')
				{
					$anchor = '#' . $item;
					continue;
				}

				$output[] = $key . '=' . $item;
			}

			$params = implode($amp_delim, $output);
		}

		// Append session id and parameters (even if they are empty)
		// If parameters are empty, the developer can still append his/her parameters without caring about the delimiter
		return $url . (($append_url) ? $url_delim . $append_url . $amp_delim : $url_delim) . $params . ((!$session_id) ? '' : $amp_delim . 'sid=' . $session_id) . $anchor;
	}
}
if(!function_exists('mx_append_sid'))
{
	function mx_append_sid($url, $non_html_amp = false, $mod_rewrite_only = false)
	{
		global $SID, $_SID, $mx_mod_rewrite;

		/*
		// Is mod_rewrite enabled? If so, do some url rewrites...
		if (is_object($mx_mod_rewrite))
		{
			$url = $mx_mod_rewrite->encode($url);
		}

		// Replaces same function in mx_sessions_phpbbx.php
		if ($mod_rewrite_only)
		{
			return $url;
		}
		*/

		if ( !empty($_SID) && !preg_match('#sid=#', $url) )
		{
			$url .= ( ( strpos($url, '?') !== false ) ?  ( ( $non_html_amp ) ? '&' : '&amp;' ) : '?' ) . $_SID;
		}
		
		if ( !empty($SID) && !preg_match('#sid=#', $url) )
		{
			$url .= ( ( strpos($url, '?') !== false ) ?  ( ( $non_html_amp ) ? '&' : '&amp;' ) : '?' ) . $SID;
		}

		return $url;
	}
}

/**
 * Redirect.
 *
 * mxBB version of phpBB redirect().
 *
 * @param string $url
 * @param string $redirect_msg
 * @param string $redirect_link
 */
if(!function_exists('mx_redirect'))
{
	function mx_redirect($url, $redirect_msg = '', $redirect_link = '')
	{
		global $db, $lang;

		if ( empty($redirect_msg) )
		{
			$redirect_msg = $lang['Page_Not_Authorised'];
		}
		if ( empty($redirect_link) )
		{
			$redirect_link = $lang['Redirect_login'];
		}

		if ( defined('HEADER_INC') )
		{
			$message = $redirect_msg . '<br /><br />' . sprintf($redirect_link, '<a href="' . PHPBB_URL . $url . '">', "</a>") . '<br /><br />';
			mx_message_die(GENERAL_MESSAGE, $message);
		}

		//
		// Save any possible changes made in session variables, otherwise we will loose them.
		// See comments here:
		// http://www.php.net/session
		// http://www.php.net/session_write_close
		//
		@session_write_close();
		@session_start();

		if ( !empty($db) )
		{
			@$db->sql_close();
		}

		if ( strstr(urldecode($url), "\n") || strstr(urldecode($url), "\r") )
		{
			mx_message_die(GENERAL_ERROR, 'Tried to redirect to potentially insecure url.');
		}

		// Redirect via an HTML form for PITA webservers
		if ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) )
		{
			header('Refresh: 0; URL=' . PHPBB_URL . $url);
			echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html><head><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><meta http-equiv="refresh" content="0; url=' . PHPBB_URL . $url . '"><title>Redirect</title></head><body><div align="center">If your browser does not support meta redirection please click <a href="' . PHPBB_URL . $url . '">HERE</a> to be redirected</div></body></html>';
			exit;
		}

		// Behave as per HTTP/1.1 spec for others
		header('Location: ' . PHPBB_URL . $url);
		exit;
	}
}
/**
 * Get groups
 *
 * @param unknown_type $sel_id
 * @param unknown_type $field_entry
 * @param unknown_type $group_rowset
 * @return unknown
 */
if(!function_exists('mx_get_groups'))
{
	function mx_get_groups($sel_id, $field_entry = 'auth_view_group', $group_rowset = array())
	{
	 	global $db, $lang;

	 	if (empty($group_rowset))
	 	{
			$sql = "SELECT group_id, group_name
				FROM " . GROUPS_TABLE . "
				WHERE group_single_user <> " . TRUE . "
				ORDER BY group_name";

			if( !($result = @$db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, "Couldn't get list of groups", '', __LINE__, __FILE__, $sql);
			}

			$group_rowset = @$db->sql_fetchrowset($result);
	 	}

		$grouplist = '<select name="'.$field_entry.'">';
		$grouplist .= '<option value="0">' . $lang['Select_group'] . '</option>';

		if ($group_rowset)
		{
			foreach($group_rowset as $key => $row)
			{
				$selected = ( $sel_id == $row['group_id'] ? ' selected="selected"' : '' );
				$grouplist .= '<option value="' .$row['group_id'] . '"' . $selected . '>' . $row['group_name'] . '</option>';
			}
		}
		else
		{
				$row = @$db->sql_fetchrow($result);
				$selected = ( $sel_id == $row['group_id'] ? ' selected="selected"' : '' );
				$grouplist .= '<option value="' .$row['group_id'] . '"' . $selected . '>' . $row['group_name'] . '</option>';
		}
	 	$db->sql_freeresult($result);

		$grouplist .= '</select>';
		return $grouplist;
	}
}

/**
 * Is group member?
 *
 * Validates if user belongs to group included in group_ids list.
 * Also, adds all usergroups to userdata array.
 *
 * @param unknown_type $group_ids
 * @param unknown_type $group_mod_mode
 * @return unknown
 */
if(!function_exists('mx_is_group_member'))
{
	function mx_is_group_member($group_ids = '', $group_mod_mode = false)
	{
		global $userdata, $db;

		if( empty($group_ids) )
		{
			return false;
		}

		//
		// Try to reuse group_id results.
		//
		$userdata_key = 'mx_usergroups' . ( $group_mod_mode ? '_mod' : '' ) . $userdata['user_id'];

		if( empty($userdata[$userdata_key]) )
		{
			if( $group_mod_mode )	// Get the groups the user is moderator of.
			{
				$sql = "SELECT group_id FROM " . GROUPS_TABLE . "
					WHERE group_moderator = '" . $userdata['user_id'] . "' AND group_single_user = 0";
			}
			else					// Get the groups the user is member of.
			{
				$sql = "SELECT group_id FROM " . USER_GROUP_TABLE . "
					WHERE user_id = '" . $userdata['user_id'] . "' AND user_pending = 0";
			}
			if ( !($result = $db->sql_query($sql, 300)) )
			{
				mx_message_die(GENERAL_ERROR, "Could not query group rights information");
			}
			$userdata[$userdata_key] = $db->sql_fetchrowset($result);
			$db->sql_freeresult($result);
		}

		$group_ids_array = explode(',', $group_ids);

		for( $i = 0; $i < count($userdata[$userdata_key]); $i++ )
		{
			if( in_array($userdata[$userdata_key][$i]['group_id'], $group_ids_array) )
			{
				return true;
			}
		}
		return false;
	}
}

/**
 * Get langcode.
 *
 * This function loops all meta langcodes, to convert internal MX-Publisher lang to standard langcode
 *
 */
if(!function_exists('mx_get_langcode'))
{
	function mx_get_langcode()
	{
		global $userdata, $mx_mod_path, $board_config, $phpEx;

		//
		// Load language file.
		//
		if( @file_exists($mx_mod_path . 'language/lang_' . $board_config['default_lang'] . '/lang_meta.' . $phpEx) )
		{
			include($mx_mod_path . 'language/lang_' . $board_config['default_lang'] . '/lang_meta.' . $phpEx);
		}
		else
		{
			include($mx_mod_path . 'language/lang_english/lang_meta.' . $phpEx);
		}

		foreach ($lang['mx_meta']['langcode'] as $langcode => $mxbbLang)
		{
			if ( strtolower($mxbbLang) == $userdata['user_lang'] )
			{
				return $langcode;
			}
		}
	}
}

/**
 * Generate Pagination.
 *
 * Pagination routine, generates page number sequence.
 * Only difference from standard phpbb function is you can use more settings.
 *
 * @param string $base_url
 * @param integer $num_items
 * @param integer $per_page
 * @param integer $start_item
 * @param boolean $add_prevnext_text
 * @param boolean $use_next_symbol
 * @param boolean $use_previous_symbol
 * @param boolean $add_preinfo_text
 * @param integer $name_id
 * @return string (html)
 */
if(!function_exists('mx_generate_pagination'))
{
	function mx_generate_pagination($base_url, $num_items, $per_page, $start_item, $add_prevnext_text = TRUE, $use_next_symbol = false,$use_previous_symbol = false,$add_preinfo_text = TRUE, $name_id = 'start')
	{
		global $lang;

		$total_pages = ceil($num_items/$per_page);

		if ( $total_pages == 1 )
		{
			return '';
		}

		$previous_string = $use_next_symbol ? '&laquo;' : $lang['Previous'];
		$next_string = $use_previous_symbol ? '&raquo;' : $lang['Next'];

		$class = 'class="mx_pagination" onmouseover="if(this.className){this.className=\'mx_pagination_over\';}" onmouseout="if(this.className){this.className=\'mx_pagination\';}"';

		$on_page = floor($start_item / $per_page) + 1;

		$page_string = '';
		if ( $total_pages > 10 )
		{
			$init_page_max = ( $total_pages > 3 ) ? 3 : $total_pages;

			for($i = 1; $i < $init_page_max + 1; $i++)
			{
				$page_string .= ( $i == $on_page ) ? '<b class="mx_pagination_sele">' . $i . '</b>' : '<a '.$class.' href="' . mx_append_sid($base_url . "&amp;".$name_id."=" . ( ( $i - 1 ) * $per_page ) ) . '">' . $i . '</a>';
				if ( $i <  $init_page_max )
				{
					$page_string .= ",";
				}
			}

			if ( $total_pages > 3 )
			{
				if ( $on_page > 1  && $on_page < $total_pages )
				{
					$page_string .= ( $on_page > 5 ) ? ' ... ' : ',';

					$init_page_min = ( $on_page > 4 ) ? $on_page : 5;
					$init_page_max = ( $on_page < $total_pages - 4 ) ? $on_page : $total_pages - 4;

					for($i = $init_page_min - 1; $i < $init_page_max + 2; $i++)
					{
						$page_string .= ($i == $on_page) ? '<b class="mx_pagination_sele">' . $i . '</b>' : '<a '.$class.' href="' . mx_append_sid($base_url . "&amp;".$name_id."=" . ( ( $i - 1 ) * $per_page ) ) . '">' . $i . '</a>';
						if ( $i <  $init_page_max + 1 )
						{
							$page_string .= ',';
						}
					}

					$page_string .= ( $on_page < $total_pages - 4 ) ? ' ... ' : ', ';
				}
				else
				{
					$page_string .= ' ... ';
				}

				for($i = $total_pages - 2; $i < $total_pages + 1; $i++)
				{
					$page_string .= ( $i == $on_page ) ? '<b class="mx_pagination_sele">' . $i . '</b>'  : '<a '.$class.' href="' . mx_append_sid($base_url . "&amp;".$name_id."=" . ( ( $i - 1 ) * $per_page ) ) . '">' . $i . '</a>';
					if( $i <  $total_pages )
					{
						$page_string .= ",";
					}
				}
			}
		}
		else
		{
			for($i = 1; $i < $total_pages + 1; $i++)
			{
				$page_string .= ( $i == $on_page ) ? '<b class="mx_pagination_sele">' . $i . '</b>' : '<a '.$class.' href="' . mx_append_sid($base_url . "&amp;".$name_id."=" . ( ( $i - 1 ) * $per_page ) ) . '">' . $i . '</a>';
				if ( $i <  $total_pages )
				{
					$page_string .= ',';
				}
			}
		}

		if ( $add_prevnext_text )
		{
			if ( $on_page > 1 )
			{
				$page_string = ' <a '.$class.' href="' . mx_append_sid($base_url . "&amp;".$name_id."=" . ( ( $on_page - 2 ) * $per_page ) ) . '">' . $previous_string . '</a>&nbsp;' . $page_string;
			}

			if ( $on_page < $total_pages )
			{
				$page_string .= '&nbsp;<a '.$class.' href="' . mx_append_sid($base_url . "&amp;".$name_id."=" . ( $on_page * $per_page ) ) . '">' . $next_string . '</a>';
			}

		}
		$pre_text = $add_preinfo_text ? $lang['Goto_page'] : '';
		$page_string = $pre_text . ' ' . $page_string;

		return $page_string;
	}
}

/**
* Our own generator of random values
* This uses a constantly changing value as the base for generating the values
* The board wide setting is updated once per page if this code is called
* With thanks to Anthrax101 for the inspiration on this one
* Added in phpBB 2.0.20
*/
if(!function_exists('mx_dss_rand'))
{
	function mx_dss_rand()
	{
		global $db, $portal_config, $board_config, $dss_seeded;

		if($dss_seeded !== true)
		{
			switch (PORTAL_BACKEND)
			{
				case 'internal':

				$val = $portal_config['rand_seed'] . microtime();
				$val = md5($val);
				$portal_config['rand_seed'] = md5($portal_config['rand_seed'] . $val . 'a');

				$sql = "UPDATE " . PORTAL_TABLE . " SET
					rand_seed = '" . $portal_config['rand_seed'] . "'
					WHERE portal_id = '1'";
					break;
					break;

				case 'phpbb2':
				case 'phpbb3':

				$val = $board_config['rand_seed'] . microtime();
				$val = md5($val);
				$board_config['rand_seed'] = md5($board_config['rand_seed'] . $val . 'a');

				$sql = "UPDATE " . CONFIG_TABLE . " SET
					config_value = '" . $board_config['rand_seed'] . "'
					WHERE config_name = 'rand_seed'";
					break;
			}

			if( !$db->sql_query($sql) )
			{
				mx_message_die(GENERAL_ERROR, "Unable to reseed PRNG", "", __LINE__, __FILE__, $sql);
			}

			$dss_seeded = true;
		}

		return substr($val, 4, 16);
	}
}

/**
 * phpBB Smilies pass.
 *
 * Hacking smilies_pass from phpbb/includes/bbcode.php
 *
 * @param string $message
 * @return string
 *
*/
if(!function_exists('mx_smilies_pass'))
{
	function mx_smilies_pass($message)
	{
		static $orig, $repl;
		global $board_config, $mx_root_path, $phpbb_root_path, $phpEx;

		switch (PORTAL_BACKEND)
		{
			case 'internal':
				$smiley_path_url = PHPBB_URL; //change this to PORTAL_URL when shared folder will be removed
				$smiley_url = 'smile_url';
				break;
			case 'phpbb2':
				$smiley_path_url = PHPBB_URL;
				$smiley_url = 'smile_url';
				break;
			case 'phpbb3':
				$smiley_path_url = PHPBB_URL;
				$smiley_url = 'smiley_url';
				$board_config['smilies_path'] = str_replace("smiles", "smilies", $board_config['smilies_path']);
				break;
		}

		$smilies_path = $board_config['smilies_path'];
		$board_config['smilies_path'] = $smiley_path_url . $board_config['smilies_path'];

		if (!isset($orig))
		{
			global $db;
			$orig = $repl = array();

			$sql = 'SELECT * FROM ' . SMILIES_TABLE;
			if( !$result = $db->sql_query($sql) )
			{
				mx_message_die(GENERAL_ERROR, "Couldn't obtain smilies data", "", __LINE__, __FILE__, $sql);
			}

			$smilies = $db->sql_fetchrowset($result);

			if (count($smilies))
			{
				@usort($smilies, 'smiley_sort');
			}

			for ($i = 0; $i < count($smilies); $i++)
			{
				$orig[] = "/(?<=.\W|\W.|^\W)" . preg_quote($smilies[$i]['code'], "/") . "(?=.\W|\W.|\W$)/";
				$repl[] = '<img src="'. $board_config['smilies_path'] . '/' . $smilies[$i][$smiley_url] . '" alt="' . $smilies[$i]['emoticon'] . '" border="0" />';
			}
		}

		if (count($orig))
		{
			$message = preg_replace($orig, $repl, ' ' . $message . ' ');
			$message = substr($message, 1, -1);
		}

		$board_config['smilies_path'] = $smilies_path;

		return $message;
	}
}

/**
 * Generate phpBB smilies.
 *
 * Hacking generate_smilies from phpbb/includes/functions_post.php
 *
 * @param string $mode
 * @param integer $page_id
 */
if(!function_exists('mx_generate_smilies'))
{
	function mx_generate_smilies($mode, $page_id)
	{
		global $mx_page, $board_config, $template, $mx_root_path, $phpbb_root_path, $phpEx;

		if( !function_exists('generate_smilies') )
		{
			mx_page::load_file('functions_post');
		}

		$smilies_path = $board_config['smilies_path'];
		$board_config['smilies_path'] = PHPBB_URL . $board_config['smilies_path'];
		generate_smilies($mode, $page_id);
		$board_config['smilies_path'] = $smilies_path;
		$template->assign_vars(array(
			'U_MORE_SMILIES' => mx3_append_sid(PHPBB_URL . "posting.$phpEx", "mode=smilies"))
		);
	}
}

/**
 * Return data from table.
 *
 * This function returns data from table, where field value matches id (and field2 value matches id2).
 *
 * @access public
 * @param string $table target
 * @param string $idfield  field
 * @param string $id needle
 * @param string $idfield2 additional field (optional)
 * @param string $id2 needle
 * @return array results
 */
if(!function_exists('mx_get_info'))
{
	function mx_get_info($table, $idfield = '', $id = 0, $idfield2 = '', $id2 = 0)
	{
		global $db;

		$sql = "SELECT * FROM $table WHERE $idfield = '$id'";
		$sql .= ( $idfield2 != '' && $id2 != '' ) ? " AND $idfield2 = '$id2'" : '';
		$sql .= ' LIMIT 1';
		if( !($result = $db->sql_query($sql)) )
		{
			mx_message_die(GENERAL_ERROR, "Couldn't get $table information", '', __LINE__, __FILE__, $sql);
		}
		$return = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);
		return $return;
	}
}
/**
 * Return number of results, if exists.
 *
 * This function returns the number of results, where field value matches id.
 *
 * @access public
 * @param string $table target
 * @param string $idfield field
 * @param string $id needle
 * @return array array('number', num_of_results)
 */
if(!function_exists('mx_get_exists'))
{
	function mx_get_exists($table, $idfield = '', $id = 0)
	{
		global $db;

		$sql = "SELECT COUNT(*) AS total FROM $table WHERE $idfield = '$id'";
		if( !($result = $db->sql_query($sql)) )
		{
			mx_message_die(GENERAL_ERROR, "Couldn't get block/Column information", '', __LINE__, __FILE__, $sql);
		}
		$count = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		$count = $count['total'];
		return array('number' => $count);
	}
}
/**
 * Get html select list - from array().
 *
 * This function generates and returns a html select list (name = $nameselect).
 *
 * @access public
 * @param string $name_select select name
 * @param array $row source data
 * @param string $id needle
 * @param boolean $full_list expanded or dropdown list
 * @return unknown
 */
if(!function_exists('get_list_static'))
{
	function get_list_static($name_select, $row, $id, $full_list = true)
	{
		$rows_count = ( count($row) < '25' ) ? count($row) : '25';
		$full_list_true = $full_list ? ' size="' . $rows_count . '"' : '';

		$column_list = '<select name="' . $name_select .'" ' . $full_list_true . '>';
		foreach( $row as $idfield => $namefield )
		{
			$selected = ( $idfield == $id ) ? ' selected="selected"' : '';
			$column_list .= '<option value="' . $idfield . '"' . $selected . '>' . $namefield . "</option>\n";
		}
		$column_list .= '</select>';

		unset($row);
		return $column_list;
	}
}
/**
 * Get html select list - from db query.
 *
 * This function generates and returns a html select list (name = $nameselect) with option labels $namefield,
 * with data from $table, (where $idfield2 matches $id2).
 * Use $select=true to select where $idfield value matches $id.
 * <code>
 * 	<select name=$nameselect>
 * 		// $idfield = $id
 * 		<option value=$idfield selected="selected">$namefield</option>
 * 		// $idfield != $id
 * 		<option value=$idfield >$namefield</option>
 * 		<option value=$idfield >$namefield</option>
 * 		<option value=$idfield >$namefield</option>
 * 	</select>
 * </code>
 *
 * @access public
 * @param string $name_select select name
 * @param string $table target
 * @param string $idfield field
 * @param string $namefield option labels
 * @param string $id needle
 * @param boolean $select select idfiled = id
 * @param string $idfield2 field
 * @param string $id2 needle
 * @return string (html)
 */
if(!function_exists('mx_get_list'))
{
	function mx_get_list($name_select, $table, $idfield, $namefield, $id, $select = false, $idfield2 = '' , $id2 = '')
	{
		global $db;

		$sql = "SELECT * FROM $table";
		if( !$select )
		{
			$sql .= " WHERE $idfield <> $id";
		}
		if( !$select && !empty($id2) )
		{
			$sql .= " AND $idfield2 = $id2";
		}
		if( $select && !empty($id2) )
		{
			$sql .= " WHERE $idfield2 = $id2";
		}
		$sql .= " ORDER BY $namefield";

		if( !($result = $db->sql_query($sql)) )
		{
			mx_message_die(GENERAL_ERROR, "Couldn't get list of Column/blocks", '', __LINE__, __FILE__, $sql);
		}

		$column_list = '<select name="' . $name_select . '">';
		while( $row = $db->sql_fetchrow($result) )
		{
			$selected = ( $row[$idfield] == $id ) ? ' selected="selected"' : '';
			$column_list .= '<option value="' . $row[$idfield] . '"' . $selected . '>' . $row[$namefield] . "</option>\n";
		}
		$column_list .= '</select>';

		unset($row);
		$db->sql_freeresult($result);

		return $column_list;
	}
}
/**
 * Get html mutiple select list - from db query.
 *
 * This function generates and returns a html multiple select list (name = $nameselect) with option labels $namefield ($namefield2),
 * with data from $table. Use $select=true to select where $idfield value matches list($id).
 * <code>
 * 	<select name=$nameselect multiple="multiple">
 * 		// $idfield in list($id)
 * 		<option value=$idfield selected="selected">$namefield ($namefield2)</option>
 * 		// $idfield in list($id)
 * 		<option value=$idfield selected="selected">$namefield ($namefield2)</option>
 * 		// $idfield not in list($id)
 * 		<option value=$idfield >$namefield ($namefield2) ($namefield2)</option>
 * 		<option value=$idfield >$namefield ($namefield2) ($namefield2)</option>
 * 	</select>
 * </code>
 *
 * @access public
 * @param string $name_select select name
 * @param string $table target
 * @param string $idfield field
 * @param string $namefield option labels
 * @param array $id_list needle array
 * @param boolean $select select select idfiled = list(id)
 * @param string $namefield2 option labels desc
 * @return string (html)
 */
if(!function_exists('get_list_multiple'))
{
	function get_list_multiple($name_select, $table, $idfield, $namefield, $id_list, $select, $namefield2 = '')
	{
		global $db;

		$sql = "SELECT * FROM $table";
		if( !$select )
		{
			$sql .= " WHERE $idfield NOT IN ( $id_list )";
		}
		$sql .= " ORDER BY $namefield";

		if( !($result = $db->sql_query($sql)) )
		{
			mx_message_die(GENERAL_ERROR, "Couldn't get list of Column/blocks", '', __LINE__, __FILE__, $sql);
		}

		$id_list = explode(',', $id_list);
		$rows_count = $db->sql_numrows($result);
		$rows_count = ( $rows_count < '25' ) ? $rows_count : '25';

		$column_list = '<select name="' . $name_select . '" size="' . $rows_count . '" multiple="multiple">';
		while( $row = $db->sql_fetchrow($result) )
		{
			$namefield_desc = !empty($row[$namefield2]) ? ' (' . $row[$namefield2] . ')' : '';
			$selected = ( in_array($row[$idfield], $id_list) ) ? ' selected="selected"' : '';
			$column_list .= '<option value="' . $row[$idfield] . '"' . $selected . '>' . $row[$namefield] . $namefield_desc . "</option>\n";
		}
		$column_list .= '</select>';

		unset($row);
		$db->sql_freeresult($result);
		return $column_list;
	}
}
/**
 * Get html select list - from db query - with formatted output.
 *
 * This function generates and returns a html select list (name = $nameselect). Supported $type options are:
 * - page_list
 * - function_list
 * - block_list
 * - dyn_block_list
 * Or the function generates a block_list for given $function_file.
 *
 * @access public
 * @param string $type list types
 * @param string $id needle
 * @param string $name_select select name
 * @param string $function_file get block_list for $function_file
 * @param boolean $multiple_select
 * @param string $function_file2 get block_list also for $function_file2
 * @return string (html)
 */
if(!function_exists('get_list_formatted'))
{
	function get_list_formatted($type, $id, $name_select = '', $function_file = '', $multiple_select = false, $function_file2 = '')
	{
		global $db, $lang;

		if( $type == 'page_list' )
		{
			//
			// get pages dropdown
			//
			$name_select = empty($name_select) ? 'page_id' : $name_select;
			$idfield = 'page_id';
			$namefield = 'page_name';
			$descfield = 'page_desc';

			$sql = "SELECT *
				FROM " . PAGE_TABLE . "
				ORDER BY page_name ASC, page_desc ASC";
		}
		elseif( $type == 'function_list' )
		{
			//
			// get functions dropdown
			//
			$name_select = 'function_id';
			$idfield = 'function_id';
			$namefield = 'function_name';

			$sql = "SELECT function_admin, fnc.function_name, fnc.function_id, fnc.function_desc, fnc.module_id, mdl.module_name, mdl.module_id, mdl.module_desc
				FROM " . FUNCTION_TABLE . " fnc,
					" . MODULE_TABLE . " mdl
				WHERE mdl.module_id = fnc.module_id
				ORDER BY mdl.module_name ASC, fnc.function_name ASC";
		}
		elseif( $type == 'block_list' )
		{
			//
			// get all blocks dropdown (optionally filtering by function_file)
			//
			$idfield = 'block_id';
			$namefield = 'block_title';
			$descfield = 'block_desc';

			$function_file_filter_temp = ( !empty($function_file2) ? " OR fnc.function_file = '$function_file2'" : '' );
			$function_file_filter = ( !empty($function_file) ? " AND ( fnc.function_file = '$function_file' ".$function_file_filter_temp.")" : '' );

			$sql = "SELECT blk.*, function_admin, fnc.function_name, fnc.function_id, fnc.function_desc, fnc.module_id, mdl.module_name, mdl.module_id, mdl.module_desc
				FROM " . BLOCK_TABLE . " blk,
					" . FUNCTION_TABLE . " fnc,
					" . MODULE_TABLE . " mdl
				WHERE blk.function_id = fnc.function_id
					AND mdl.module_id = fnc.module_id
					$function_file_filter
				ORDER BY mdl.module_name ASC, fnc.function_name ASC";
		}
		elseif( $type == 'dyn_block_list' )
		{
			//
			// get all dynamic blocks dropdown (2.8)
			//
			$idfield = 'block_id';
			$namefield = 'block_title';
			$descfield = 'block_desc';

			$sql = "SELECT blk.*, function_admin, fnc.function_name, fnc.function_id, fnc.function_desc, fnc.module_id, mdl.module_name, mdl.module_id, mdl.module_desc
				FROM " . BLOCK_TABLE . " blk,
					" . FUNCTION_TABLE . " fnc,
					" . MODULE_TABLE . " mdl
				WHERE blk.function_id = fnc.function_id
					AND mdl.module_id = fnc.module_id
					AND fnc.function_file = 'mx_dynamic.php'
				ORDER BY mdl.module_name ASC, fnc.function_name ASC";
		}

		if( !($result = $db->sql_query($sql)) )
		{
			//mx_message_die(GENERAL_ERROR, "Couldn't get list of Column/blocks", '', __LINE__, __FILE__, $sql);
		}

		if ($multiple_select)
		{
			$multiple_select_option = 'multiple="multiple"';
		}

		$column_list = '<select name="' . $name_select . '" '.$multiple_select_option.'>';
		if( $type == 'page_list' )
		{
			$column_list .= '<option value="0">' . "- not selected</option>\n";
		}

		if( $total_blocks = $db->sql_numrows($result) )
		{
			$row = $db->sql_fetchrowset($result);
		}

		for( $j = 0; $j < $total_blocks; $j++ )
		{
			if( $row[$j]['module_name'] != $row[$j-1]['module_name'] )
			{
				$column_list .= '<option value="">' . 'Module: ' . $row[$j]['module_name'] . '----------' . "</option>\n";
			}

			if( $type == 'block_list' )
			{
				if( $row[$j]['function_name'] != $row[$j-1]['function_name'] )
				{
					$block_type = $row[$j]['function_name'] . ': ';
				}
			}
			else
			{
				$block_type = '';
			}

			if( !empty($descfield) )
			{
				$block_description_str = !empty($row[$j][$descfield]) ? ' (' . $row[$j][$descfield] . ')' : ' (no desc)';
			}
			else
			{
				$block_description_str = '';
			}

			$selected = ( $row[$j][$idfield] == $id ) ? ' selected="selected"' : '';
			$column_list .= '<option value="' . $row[$j][$idfield] . '"' . $selected . '>&nbsp;&nbsp;- ' . $block_type . $row[$j][$namefield] . $block_description_str . "</option>\n";
		}
		$column_list .= '</select>';

		unset($row);
		$db->sql_freeresult($result);
		return $column_list;
	}
}
/**
 * Get simple html select list - from db query.
 *
 * This function generates and returns a html select list (name = $nameselect) with option labels $namefield,
 * with data from $table. Use $select=true to select where $idfield value matches $id.
 * <code>
 * 	<select name=$nameselect>
 * 		// $idfield = $id
 * 		<option value=$idfield selected="selected">$namefield</option>
 * 		// $idfield != $id
 * 		<option value=$idfield >$namefield</option>
 * 		<option value=$idfield >$namefield</option>
 * 		<option value=$idfield >$namefield</option>
 * 	</select>
 * </code>
 * Note: This function auto inserts a top option 'not selected'.
 *
 * @access public
 * @param string $name_select select name
 * @param string $table target
 * @param string $idfield field
 * @param string $namefield option labels
 * @param string $id needle
 * @param boolean $select select idfield = id
 * @return string (html)
 */
if(!function_exists('get_list_opt'))
{
	function get_list_opt($name_select, $table, $idfield, $namefield, $id, $select)
	{
		global $db, $lang;

		$sql = "SELECT * FROM $table";
		if( ! $select )
		{
			$sql .= " WHERE $idfield <> $id";
		}
		$sql .= " ORDER BY $namefield";

		if( !($result = $db->sql_query($sql)) )
		{
			mx_message_die(GENERAL_ERROR, "Couldn't get list of Column/blocks", '', __LINE__, __FILE__, $sql);
		}

		$column_list = '<select name="'. $name_select . '">';
		$selected = ( $id == 0 ) ? ' selected="selected"' : '';
		$column_list .= '<option value="0"' . $selected . '>' . $lang['Not_Specified'] . "</option>\n";
		while( $row = $db->sql_fetchrow($result) )
		{
			$selected = ( $row[$idfield] == $id ) ? ' selected="selected"' : '';
			$column_list .= "<option value=\"$row[$idfield]\"$selected>" . $row[$namefield] . "</option>\n";
		}
		$column_list .= '</select>';

		unset($row);
		$db->sql_freeresult($result);
		return $column_list;
	}
}
/**
 * Generate MX-Publisher URL, with arguments.
 *
 * This function returns a MX-Publisher URL with GET vars, and accepts any number of parwise arguments.
 *
 * @access public
 * @return string (url)
 */
if(!function_exists('mx_url'))
{
	function mx_url()
	{
		global $SID;

		$numargs = func_num_args();
		$url = $PHP_SELF . '?' . $_SERVER['QUERY_STRING'];
		$url = parse_url($url);

		$url_array = array();
		if( ! empty($url['query']) )
		{
			$url_array = explode('&', $url['query']);
		}

		$arg_list = func_get_args();

		// Check for each option if exists in the parameter list
		for( $i = 0; $i < $numargs; $i++ )
		{
			$option = $arg_list[$i];
			$i++;
			$value = $arg_list[$i];
			// If not exists in the parameter list then add the parameter
			$opt_fund = false;
			for( $j = 0; $j < count($url_array); $j++ )
			{
				$tmp = explode('=', $url_array[$j]);
				if( $option == $tmp[0] )
				{
					$url_array[$j] = $option . '=' . $value ;
					$opt_fund = true;
				}
			}
			if( !$opt_fund )
			{
				$next = count($url_array);
				$url_array[$next] = $option . '=' . $value ;
			}
		}

		$url = $url['path'];

		// Build the parameter list
		if( !strpos($url, '?') )
		{
			$url .= '?';
		}

		$url .= implode('&', $url_array);
		/*
		for ($j = 0; $j < count($url_array); $j++)
		{
			if( $j < count($url_array) -1 )
			{
			$url .= $url_array[$j] . "&"  ;
			}
			else
			{
			$url .= $url_array[$j];
			}
		}
		*/
		$url = str_replace('?&', '?', $url);
		$url = str_replace('.php&', ".php?", $url);
		return $url;
	}
}
/**
 * Generate MX-Publisher URL, with arguments.
 *
 * This function returns a MX-Publisher URL with GET vars, and accepts arguments in the $args array().
 *
 * @access public
 * @param array $args source arguments
 * @param boolean $force_standalone_mode nonstandard file
 * @param string $file optional nonstandard file
 * @return string (url)
 */
if(!function_exists('mx_this_url'))
{
	function mx_this_url($args = '', $force_standalone_mode = false, $file = '')
	{
		global $mx_root_path, $module_root_path, $page_id, $phpEx, $is_block;

		if( $force_standalone_mode )
		{
			$mxurl = ( $file == '' ? "./" : $file . '/' ) . ( $args == '' ? '' : '?' . $args );
		}
		else
		{
			$mxurl = $mx_root_path . 'index.' . $phpEx;
			if( is_numeric($page_id) )
			{
				$mxurl .= '?page=' . $page_id . ( $args == '' ? '' : '&amp;' . $args );
			}
			else
			{
				$mxurl = "./" . ( $args == '' ? '' : '?' . $args );
			}
		}
		return $mxurl;
	}
}
// THE END
?>