<?php
/**
 *
 * @package phpBB Mod - mx_mod
 * @version $Id: mx_mod_install.php,v 1.2 2008/03/12 05:05:02 orynider Exp $
 * @copyright (c) 2002-2006 [Jon Ohlsson, Mohd Basri, wGEric, PHP Arena, pafileDB, CRLin] mxBB Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
 *
 */

$phpEx = substr(strrchr(__FILE__, '.'), 1);

if ( !defined('PORTAL_BACKEND') && @file_exists( './viewtopic.' . $phpEx ) ) // -------------------------------------------- phpBB MOD MODE
{
	define( 'MXBB_MODULE', false );
	define( 'IN_PHPBB', true );
	
	if (file_exists("./modcp.$phpEx")) // phpBB2
	{
		define('PORTAL_BACKEND', 'phpbb2');
	}
	else if (@file_exists("./mcp.$phpEx")) // phpBB3
	{
		define('PORTAL_BACKEND', 'phpbb3');
	}
	
	$phpbb_root_path = $module_root_path = './';
	$mx_mod_path = $phpbb_root_path . 'mx_mod/';
	
	include($phpbb_root_path . 'common.' . $phpEx);
	include($mx_mod_path . "includes/functions_required.$phpEx");
	
	//Check if forum_hack is installed
	if (!isset($mx_root_path))
	{
		$mx_root_path = './';
		@define('IN_PORTAL', true);
		include_once($mx_mod_path . "includes/mx_constants.$phpEx");
		include_once($mx_mod_path . "includes/shared/phpbb2/includes/functions.$phpEx");
	}
	else
	{
		@define('IN_PORTAL', true);
		include_once($mx_root_path . "includes/mx_constants.$phpEx");
		include_once($mx_root_path . "includes/shared/phpbb2/includes/functions.$phpEx");
	}
	
	require($mx_mod_path . "includes/functions_core.$phpEx");
	require($mx_mod_path . "includes/functions_styles.$phpEx");

	//Check for cash mod
	if (file_exists($phpbb_root_path . 'includes/functions_cash.'.$phpEx))
	{
		define('IN_CASHMOD', true);
	}

	//@ini_set( 'display_errors', '1' );
	error_reporting (E_ERROR | E_WARNING | E_PARSE); // This will NOT report uninitialized variables
	//error_reporting(E_ALL & ~E_NOTICE);

	define( 'PAGE_KB', -502 ); // If this id generates a conflict with other mods, change it ;)

	//
	// Instatiate the mx_cache class
	//
	$mx_cache = new mx_cache();
	
	//
	// Get mxBB config settings
	//
	//$portal_config = $mx_cache->obtain_mxbb_config();

	//
	// instatiate the mx_request_vars class
	//
	$mx_request_vars = new mx_request_vars();
	
	//
	// Page selector
	//
	$page_id = $mx_request_vars->request('page', MX_TYPE_INT, 1);
	
	//
	// instatiate the mx_user class
	//
	$mx_user = new mx_user();

	$is_block = false;
	
	if (PORTAL_BACKEND == 'phpbb2') // phpBB2
	{
		define('PORTAL_BACKEND', 'phpbb2');
		$tplEx = 'tpl';

		//
		// Start user session
		// - populate $userdata and $lang
		//
		$mx_user->init($user_ip, $page_id, false);
		init_userprefs($userdata);
		//$mx_user->init_style(); //Overwrite template class

		$mx_user->set_module_default_style('prosilver'); // For compatibility with core 2.8.x
		
		if (!$userdata['user_level'] == ADMIN)
		{
			die('Only admins may run this script!!!');
		}
		
	}
	else if (PORTAL_BACKEND == 'phpbb3') // phpBB3
	{
		$tplEx = 'html';
		
		//
		// Start user session
		// - populate $userdata and $lang
		//
		$mx_user->init($user_ip, $page_id, false);
		$user->setup();
		//
		// End session management
		//

		$mx_user->set_module_default_style('prosilver'); // For compatibility with core 2.8.x

		if ($userdata['user_type'] != USER_FOUNDER)
		{
			die('Only admins may run this script!!!');
		}
	}
	else
	{
		die('Copy this file in phpbb_root_path were is your viewtopic.php file!!!');
	}
}
else // --------------------------------------------------------------------------------- mxBB Module MODE
{
	define( 'MXBB_MODULE', true );

	if ( !function_exists( 'read_block_config' ) )
	{
		define( 'IN_PORTAL', true );
		$mx_root_path 		= './../../';
		$module_root_path 	= './';

		$phpEx = substr(strrchr(__FILE__, '.'), 1);
		include_once( $mx_root_path . 'common.' . $phpEx );

		// Start session management
		$mx_user->init($user_ip, PAGE_INDEX);
		// End session management

		define( 'MXBB_27x', file_exists( $mx_root_path . 'mx_login.' . $phpEx ) );
	}
	else
	{
		if( !defined('IN_PORTAL') || !is_object($mx_block))
		{
			die("Hacking attempt");
		}

		//
		// Read Block Settings (default mode)
		//
		$title = !empty( $mx_block->block_info['block_title'] ) ? $mx_block->block_info['block_title'] : $lang['KB_title'];
		$desc = $mx_block->block_info['block_desc'];
		$block_size = ( isset( $block_size ) && !empty( $block_size ) ? $block_size : '100%' );

		//Check for cash mod
		if (file_exists($phpbb_root_path . 'includes/functions_cash.'.$phpEx))
		{
			define('IN_CASHMOD', true);
		}

		$is_block = true;
		global $images;
	}
	define( 'MXBB_27x', @file_exists( $mx_root_path . 'mx_login.'.$phpEx ) );
}

//
// Check if mx_common Mod is prezent
//
if (!file_exists($mx_mod_path . "includes/functions_admincp.$phpEx"))
{
	die('mx mod is not uploaded!!!');
}
else
{
	require($mx_mod_path . "includes/functions_admincp.$phpEx");
}

$portal_config['portal_id'] = '1';
$portal_config['portal_name'] = $board_config['sitename'];

$script_name = preg_replace('/^\/?(.*?)\/?$/', '\1', trim($board_config['script_path']));
$server_name = trim($board_config['server_name']);
$server_protocol = ( $board_config['cookie_secure'] ) ? 'https://' : 'http://';
$server_port = ( $board_config['server_port'] <> 80 ) ? ':' . trim($board_config['server_port']) . '/' : '/';

$portal_config['portal_phpbb_url'] = $server_protocol . $server_name . $server_port . $script_name;

$portal_config['portal_url'] = $portal_config['portal_phpbb_url'];
$portal_config['portal_version'] = '2.8.2';
$portal_config['default_admin_style'] = $board_config['default_style'];
$portal_config['default_style'] = $board_config['default_style'];
$portal_config['overall_header'] = 'overall_header.tpl';
$portal_config['overall_footer'] = 'overall_footer.tpl';
$portal_config['main_layout'] = 'mx_main_layout.tpl';
$portal_config['navigation_block'] = '0';
$portal_config['top_phpbb_links'] = '0';
$portal_config['mx_use_cache'] = '1';
$portal_config['portal_recached'] = '0';
$portal_config['mod_rewrite'] = '0';
$portal_config['portal_backend'] = PORTAL_BACKEND;

while( list($key, $value) = @each($portal_config) )
{
	if (is_array($value))
	{
		foreach( $value as $key2 => $val2 )
		{
			$portal_config[$key][$key2] = $val2;
		}
	}

}

$page_title = 'Mx Mod';

switch (PORTAL_BACKEND)
{
	case 'internal':
	case 'phpbb2':
		include($phpbb_root_path . 'includes/page_header.'.$phpEx);
		$modtemplate = new mx_Template($mx_mod_path . 'styles');
		$modtemplate->set_filenames( array( // #
			'body' => 'install_body.html'
		));
		$modtemplate->assign_vars( array( //# 
			'CSS_COLOR_H1' => 'color: #767676;',
			'CSS_CONTENT_H1' => 'color: #115098;'
		));
		break;
	case 'phpbb3':
		$template->set_custom_template($mx_mod_path . 'styles/prosilver', 'mx_mod');
		$template->set_filenames( array(
			'header' => 'install_header.html',
			'body' => 'install_body.html',
			'footer' => 'install_footer.html'
		));
		$template->assign_var('CSS_STYLESHEET', $phpbb_root_path . 'adm/style/admin.css');
		break;
}


$template->assign_vars( array(
	'L_MX_MOD_INSTALL_TITLE' => $page_title,
	'L_MX_MOD_TITLE' => 'Installing/Upgrading',
	'MX_MOD_PATH' => $mx_mod_path,
));


!defined('MX_CONFIG_TABLE') ? define('MX_CONFIG_TABLE', $table_prefix . 'mx_config') : false;

$sql = array();

// If fresh install
if ( !$result = @$db->sql_query( "SELECT config_name from " . MX_CONFIG_TABLE ) )
{
	$message = "<b>This is a fresh install!</b><br/><br/>";

	$sql[] = "DROP TABLE IF EXISTS " . MX_CONFIG_TABLE;

	$sql[] = "CREATE TABLE ".MX_CONFIG_TABLE." (
			config_name varchar(255) NOT NULL,
			config_value varchar(255) NOT NULL,
			PRIMARY KEY (config_name)
			)";

	//
	// Insert Configs
	//
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('portal_id', '" . $portal_config['portal_id'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('portal_name', '" . $portal_config['portal_name'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('portal_phpbb_url', '" . $portal_config['portal_phpbb_url'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('portal_url', '" . $portal_config['portal_url'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('portal_version', '" . $portal_config['portal_version'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('default_admin_style', '" . $portal_config['default_admin_style'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('default_style', '" . $portal_config['default_style'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('overall_header', '" . $portal_config['overall_header'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('overall_footer', '" . $portal_config['overall_footer'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('main_layout', '" . $portal_config['main_layout'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('navigation_block', '" . $portal_config['navigation_block'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('top_phpbb_links', '" . $portal_config['top_phpbb_links'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('mx_use_cache', '" . $portal_config['mx_use_cache'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('portal_recached', '" . $portal_config['portal_recached'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('mod_rewrite', '" . $portal_config['mod_rewrite'] . "')";
	$sql[] = "INSERT INTO " . MX_CONFIG_TABLE . " VALUES ('portal_backend', '" . $portal_config['portal_backend'] . "')";

	$message .= mx_do_install_upgrade($sql);

	$message .= "<br/><br/>";

}
else
{

	$message .= "<b>Allready installed...</b><br/><br/>";

}
if( file_exists($mx_mod_path . "includes/functions_core." . $phpEx) )
{
	$mx_cache->trash();
	$mx_cache->update();
	$mx_cache->unload();
	$message .= '<b>Your cache files have been generated...</b><br/><br/>';
}


switch (PORTAL_BACKEND)
{
	case 'internal':
	case 'phpbb2':
		$modtemplate->assign_var('INSTALL_MESSAGE', $message);
		$modtemplate->pparse('body');
		include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
	break;
	case 'phpbb3':
		$template->assign_var('INSTALL_MESSAGE', $message);
		$template->display('header');
		$template->display('body');
		$template->display('footer');
		//page_footer();
	break;
}


?>