<?php
/**
*
* @package phpBB Mod - FAP
* @version $Id: music_db_install.php,v 1.1 2008/03/13 04:21:40 orynider Exp $
* @copyright (c) 2002-2006 [Jon Ohlsson, Mohd Basri, wGEric, PHP Arena, pafileDB, CRLin] mxBB Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

$phpEx = substr(strrchr(__FILE__, '.'), 1);

if ( !defined('PORTAL_BACKEND') && @file_exists( './viewtopic.' . $phpEx ) ) // -------------------------------------------- phpBB MOD MODE
{
	define( 'MXBB_MODULE', false );
	define( 'IN_PHPBB', true );
	
	$phpbb_root_path = $module_root_path = './';
	$mx_mod_path = $phpbb_root_path . 'mx_mod/';
	
	include($phpbb_root_path . 'common.' . $phpEx);
	include($mx_mod_path . "includes/functions_required.$phpEx");
	
	//Check if forum_hack is installed
	if (!isset($mx_root_path))
	{
		$mx_root_path = './';
		@define('IN_PORTAL', true);
		include_once($mx_mod_path . "includes/mx_constants.$phpEx");
		include_once($mx_mod_path . "includes/shared/phpbb2/includes/functions.$phpEx");
	}
	else
	{
		@define('IN_PORTAL', true);
		include_once($mx_root_path . "includes/mx_constants.$phpEx");
		include_once($mx_root_path . "includes/shared/phpbb2/includes/functions.$phpEx");
	}
	
	require($mx_mod_path . "includes/functions_core.$phpEx");
	require($mx_mod_path . "includes/functions_styles.$phpEx");
	
	//Check for cash mod
	if (file_exists($phpbb_root_path . 'includes/functions_cash.'.$phpEx))
	{
		define('IN_CASHMOD', true);
	}

	//@ini_set( 'display_errors', '1' );
	error_reporting (E_ERROR | E_WARNING | E_PARSE); // This will NOT report uninitialized variables
	//error_reporting(E_ALL & ~E_NOTICE);

	define( 'PAGE_KB', -502 ); // If this id generates a conflict with other mods, change it ;)

	//
	// Instatiate the mx_cache class
	//
	$mx_cache = new mx_cache();
	
	//
	// Get mxBB config settings
	//
	//$portal_config = $mx_cache->obtain_mxbb_config();

	//
	// instatiate the mx_request_vars class
	//
	$mx_request_vars = new mx_request_vars();
	
	//
	// Page selector
	//
	$page_id = $mx_request_vars->request('page', MX_TYPE_INT, 1);

	$is_block = false;
	
	//
	// instatiate the mx_user class
	//
	$mx_user = new mx_user();

	if (file_exists("./modcp.$phpEx")) // phpBB2
	{
		define('PORTAL_BACKEND', 'phpbb2');
		$tplEx = 'tpl';
		
		//
		// Start user session
		// - populate $userdata and $lang
		//
		$mx_user->init($user_ip, $page_id, false);
		init_userprefs($userdata);

		$mx_user->set_module_default_style('prosilver'); // For compatibility with core 2.8.x
		
		if (!$userdata['user_level'] == ADMIN)
		{
			die('Only admins may run this script!!!');
		}
		
	}
	else if (@file_exists("./mcp.$phpEx")) // phpBB3
	{
		define('PORTAL_BACKEND', 'phpbb3');
		$tplEx = 'html';
		
		//
		// Start user session
		// - populate $userdata and $lang
		//
		$mx_user->init($user_ip, $page_id, false);
		$user->setup();
		//
		// End session management
		//

		$mx_user->set_module_default_style('prosilver'); // For compatibility with core 2.8.x

		if ($userdata['user_type'] != USER_FOUNDER)
		{
			die('Only admins may run this script!!!');
		}
	}
	else
	{
		die('Copy this file in phpbb_root_path were is your viewtopic.php file!!!');
	}
}
else // --------------------------------------------------------------------------------- mxBB Module MODE
{
	define( 'MXBB_MODULE', true );

	if ( !function_exists( 'read_block_config' ) )
	{
		define( 'IN_PORTAL', true );
		$mx_root_path 		= './../../';
		$module_root_path 	= './';

		$phpEx = substr(strrchr(__FILE__, '.'), 1);
		include_once( $mx_root_path . 'common.' . $phpEx );

		// Start session management
		$mx_user->init($user_ip, PAGE_INDEX);
		// End session management

		define( 'MXBB_27x', file_exists( $mx_root_path . 'mx_login.' . $phpEx ) );
	}
	else
	{
		if( !defined('IN_PORTAL') || !is_object($mx_block))
		{
			die("Hacking attempt");
		}

		//
		// Read Block Settings (default mode)
		//
		$title = !empty( $mx_block->block_info['block_title'] ) ? $mx_block->block_info['block_title'] : $lang['KB_title'];
		$desc = $mx_block->block_info['block_desc'];
		$block_size = ( isset( $block_size ) && !empty( $block_size ) ? $block_size : '100%' );

		//Check for cash mod
		if (file_exists($phpbb_root_path . 'includes/functions_cash.'.$phpEx))
		{
			define('IN_CASHMOD', true);
		}

		$is_block = true;
		global $images;
	}
	define( 'MXBB_27x', @file_exists( $mx_root_path . 'mx_login.'.$phpEx ) );
}

//
// Check if mx_common Mod is prezent
//
if (!file_exists($mx_mod_path . "includes/functions_admincp.$phpEx"))
{
	die('mx mod is not uploaded!!!');
}
else
{
	require($mx_mod_path . "includes/functions_admincp.$phpEx");
}

//
// Check if mx_common Mod is prezent
//
if ( !file_exists( $mx_mod_path . 'includes/' . 'functions_admincp.' . $phpEx ) )
{
	die('mx_mod folder is not uploaded!!!');
}
else
{
	include_once( $mx_mod_path . 'includes/' . 'functions_admincp.' . $phpEx );
	include_once( $mx_mod_path . 'includes/functions_required.' . $phpEx );
}

$page_title = 'Installing/Upgrading Album Mod';
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

// If upgrading from old album mod
if( $result = $db->sql_query("SELECT config_name from ".$table_prefix."album_config"))
{ 
	$message = "<b>Upgrading!...to use Clown SP...from old mx album </b><br/><br/>";

	$sql = array();

	$sql[] = "RENAME TABLE ".$table_prefix."album TO ".$table_prefix."smartor_album";
	$sql[] = "RENAME TABLE ".$table_prefix."album_rate TO ".$table_prefix."smartor_album_rate";
	$sql[] = "RENAME TABLE ".$table_prefix."album_comment TO ".$table_prefix."smartor_album_comment";
	$sql[] = "RENAME TABLE ".$table_prefix."album_cat TO ".$table_prefix."smartor_album_cat";
	$sql[] = "RENAME TABLE ".$table_prefix."album_config TO ".$table_prefix."smartor_album_config";

	$sql[] = "CREATE TABLE ".$table_prefix."smartor_album_sp_config (
		config_name varchar(255) NOT NULL,
		config_value varchar(255) NOT NULL,
		PRIMARY KEY (config_name)
		) TYPE=MyISAM";

	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_late', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('rate_type', '2')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_high', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_mostv', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_rand', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('img_rows', '2')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('img_cols', '3')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('use_watermark', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('wut_users', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_watermark_at', '3')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('hon_rate_times', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('hon_rate_sep', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('hon_rate_where', '')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('hon_rate_users', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('midthumb_use', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('midthumb_height', '500')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('midthumb_width', '500')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('midthumb_cache', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('jaime_lettering', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('fap_version', '1.4.1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_thumb', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_total_pics', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_total_comments', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_comments', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_last_comment', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_last_pic', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_pics', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_recent_in_subcats', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_recent_instead_of_nopics', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('line_break_subcats', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_subcats', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_allow_gallery_mod', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_allow_sub_categories', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_sub_category_limit', '-1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_show_subcats_in_index', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_show_recent_in_subcats', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_show_recent_instead_of_nopics', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_personal_gallery_link', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_category_sorting', 'cat_order')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_category_sorting_direction', 'ASC')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_debug_mode', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_all_in_personal_gallery', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('new_pic_check_interval', '1M')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('index_enable_supercells', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('email_notification', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_download', '2')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_slideshow', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_pic_size_on_thumb', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_files_to_upload', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_pregenerated_fields', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('dynamic_fields', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('pregenerate_fields', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('propercase_pic_title', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_last_pic_lv', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_pics_approval', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_img_no_gd', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('dynamic_pic_resampling', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_file_size_resampling', '1024000')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('switch_nuffload', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('path_to_bin', './modules/mx_smartor/cgi-bin/')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('perl_uploader', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_progress_bar', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('close_on_finish', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_pause', '5')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('simple_format', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('multiple_uploads', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_uploads', '5')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('zip_uploads', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_pic', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_width', '600')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_height', '600')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_quality', '70')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_pics_nav', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_inline_copyright', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_nuffimage', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_sepia_bw', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_allow_avatar_gallery', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_gif_mid_thumb', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('slideshow_script', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_exif', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_bbcode', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('quick_thumbs', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('set_memory', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('lb_preview', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('use_old_pics_gen', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_last_comments', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_mooshow', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_integration', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('override_default_pages', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('index', '5')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('invert_nav_arrows', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_otf_link', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_all_pics_link', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_personal_galleries_link', '1')";
	$sql[] = "ALTER TABLE ".$table_prefix."smartor_album_rate ADD  rate_hon_point TINYINT(3) DEFAULT '0' NOT NULL";
	$sql[] = "ALTER TABLE ".$table_prefix."smartor_album_cat ADD cat_wm TEXT AFTER cat_desc";
	$sql[] = "ALTER TABLE ".$table_prefix."smartor_album_cat ADD cat_parent MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0' AFTER cat_approval";
	$sql[] = "ALTER TABLE ".$table_prefix."smartor_album_cat ADD cat_user_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0' AFTER cat_parent";
	$sql[] = "ALTER TABLE ".$table_prefix."smartor_album_comment ADD comment_cat_id int(11) NOT NULL default '0' AFTER comment_pic_id";
	$n = 0;

	$message .= "<b>OK...</b><br /><br />";

while($sql[$n])
{
	$message .= ($mods[$n-1] != $mods[$n]) ? '<p><b><font size=3>'.$mods[$n].'</font></b><br />' : '';
	if(!$result = $db->sql_query($sql[$n]))
	{
		$message .= '<b><font color=#FF0000>[Error or Already added]</font></b> line: '.($n+1).' , '.$sql[$n].'<br />';
	}
	else
	{
		$message .='<b><font color=#0000fF>[Added/Updated]</font></b> line: '.($n+1).' , '.$sql[$n].'<br />';
	}
	$n++;
}
}

//
// If fresh install
//
elseif(!$result = $db->sql_query("SELECT config_name from ".$table_prefix."smartor_album_sp_config"))
{ 
	$message = "<b>This is a fresh install!</b><br/><br/>";

	$sql = array();

	$sql[] = "CREATE TABLE ".$table_prefix."smartor_album (
		pic_id int(11) UNSIGNED NOT NULL auto_increment,
		pic_filename varchar(255) NOT NULL,
		pic_thumbnail varchar(255),
		pic_title varchar(255) NOT NULL,
		pic_desc text,
		pic_user_id mediumint(8) NOT NULL,
		pic_username varchar(32),
		pic_user_ip char(8) NOT NULL DEFAULT '0',
		pic_time int(11) UNSIGNED NOT NULL,
		pic_cat_id mediumint(8) UNSIGNED NOT NULL DEFAULT '1',
		pic_view_count int(11) UNSIGNED NOT NULL DEFAULT '0',
		pic_lock tinyint(3) NOT NULL DEFAULT '0',
		pic_approval tinyint(3) NOT NULL DEFAULT '1',
		PRIMARY KEY (pic_id),
		KEY pic_cat_id (pic_cat_id),
		KEY pic_user_id (pic_user_id),
		KEY pic_time (pic_time)
		) TYPE=MyISAM";

	$sql[] = "CREATE TABLE ".$table_prefix."smartor_album_rate (
		rate_pic_id int(11) UNSIGNED NOT NULL,
		rate_user_id mediumint(8) NOT NULL,
		rate_user_ip char(8) NOT NULL,
		rate_point tinyint(3) UNSIGNED NOT NULL,
		KEY rate_pic_id (rate_pic_id),
		KEY rate_user_id (rate_user_id),
		KEY rate_user_ip (rate_user_ip),
		KEY rate_point (rate_point)
		) TYPE=MyISAM";

	$sql[] = "CREATE TABLE ".$table_prefix."smartor_album_comment (
		comment_id int(11) UNSIGNED NOT NULL auto_increment,
		comment_pic_id int(11) UNSIGNED NOT NULL,
  		comment_cat_id int(11) NOT NULL default '0',
		comment_user_id mediumint(8) NOT NULL,
		comment_username varchar(32),
		comment_user_ip char(8) NOT NULL,
		comment_time int(11) UNSIGNED NOT NULL,
		comment_text TEXT,
		comment_edit_time int(11) UNSIGNED,
		comment_edit_count smallint(5) UNSIGNED NOT NULL DEFAULT '0',
		comment_edit_user_id mediumint(8),
		PRIMARY KEY(comment_id),
		KEY comment_pic_id (comment_pic_id),
		KEY comment_user_id (comment_user_id),
		KEY comment_user_ip (comment_user_ip),
		KEY comment_time (comment_time)
		) TYPE=MyISAM";


	$sql[] = "CREATE TABLE ".$table_prefix."smartor_album_cat (
		cat_id mediumint(8) UNSIGNED NOT NULL auto_increment,
		cat_title varchar(255) NOT NULL,
		cat_desc text,
		cat_wm text,
		cat_order mediumint(8) NOT NULL,
		cat_view_level tinyint(3) NOT NULL DEFAULT '-1',
		cat_upload_level tinyint(3) NOT NULL DEFAULT '0',
		cat_rate_level tinyint(3) NOT NULL DEFAULT '0',
		cat_comment_level tinyint(3) NOT NULL DEFAULT '0',
		cat_edit_level tinyint(3) NOT NULL DEFAULT '0',
		cat_delete_level tinyint(3) NOT NULL DEFAULT '2',
		cat_view_groups varchar(255),
		cat_upload_groups varchar(255),
		cat_rate_groups varchar(255),
		cat_comment_groups varchar(255),
		cat_edit_groups varchar(255),
		cat_delete_groups varchar(255),
		cat_moderator_groups varchar(255),
		cat_approval tinyint(3) NOT NULL DEFAULT '0',
		cat_parent mediumint(8) unsigned default '0',
		cat_user_id mediumint(8) unsigned default '0',
		PRIMARY KEY (cat_id),
		KEY cat_order (cat_order)
		) TYPE=MyISAM";

	$sql[] = "CREATE TABLE ".$table_prefix."smartor_album_config (
		config_name varchar(255) NOT NULL,
		config_value varchar(255) NOT NULL,
		PRIMARY KEY (config_name)
		) TYPE=MyISAM";

	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_pics', '1024')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('user_pics_limit', '50')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('mod_pics_limit', '250')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_file_size', '128000')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_width', '1024')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_height', '768')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('rows_per_page', '3')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('cols_per_page', '4')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('fullpic_popup', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('thumbnail_quality', '50')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('thumbnail_size', '150')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('thumbnail_cache', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('sort_method', 'pic_time')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('sort_order', 'DESC')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('jpg_allowed', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('png_allowed', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('gif_allowed', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('desc_length', '512')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('hotlink_prevent', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('hotlink_allowed', 'smartor.is-root.com')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_gallery', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_gallery_private', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_gallery_limit', '10')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_gallery_view', '-1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('rate', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('rate_scale', '10')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('comment', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('gd_version', '2')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_version', '.0.54')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('fap_version', '1.4.1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_thumb', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_total_pics', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_total_comments', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_comments', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_last_comment', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_last_pic', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_pics', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_recent_in_subcats', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_recent_instead_of_nopics', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('line_break_subcats', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_subcats', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_allow_gallery_mod', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_allow_sub_categories', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_sub_category_limit', '-1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_show_subcats_in_index', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_show_recent_in_subcats', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_show_recent_instead_of_nopics', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_personal_gallery_link', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_category_sorting', 'cat_order')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_category_sorting_direction', 'ASC')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_debug_mode', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_all_in_personal_gallery', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('new_pic_check_interval', '1M')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('index_enable_supercells', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('email_notification', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_download', '2')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_slideshow', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_pic_size_on_thumb', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_files_to_upload', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_pregenerated_fields', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('dynamic_fields', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('pregenerate_fields', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('propercase_pic_title', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_last_pic_lv', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_pics_approval', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_img_no_gd', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('dynamic_pic_resampling', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_file_size_resampling', '1024000')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('switch_nuffload', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('path_to_bin', './modules/mx_smartor/cgi-bin/')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('perl_uploader', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_progress_bar', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('close_on_finish', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_pause', '5')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('simple_format', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('multiple_uploads', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_uploads', '5')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('zip_uploads', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_pic', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_width', '600')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_height', '600')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_quality', '70')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_pics_nav', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_inline_copyright', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_nuffimage', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_sepia_bw', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_allow_avatar_gallery', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_gif_mid_thumb', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('slideshow_script', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_exif', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_bbcode', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('quick_thumbs', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('set_memory', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('lb_preview', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('use_old_pics_gen', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_last_comments', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_mooshow', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_integration', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('override_default_pages', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('index', '5')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('invert_nav_arrows', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_otf_link', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_all_pics_link', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_personal_galleries_link', '1')";

	$sql[] = "CREATE TABLE ".$table_prefix."smartor_album_sp_config (
		config_name varchar(255) NOT NULL,
		config_value varchar(255) NOT NULL,
		PRIMARY KEY (config_name)
		) TYPE=MyISAM";

	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_late', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('rate_type', '2')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_high', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_mostv', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_rand', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('img_rows', '2')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('img_cols', '3')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('use_watermark', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('wut_users', '0')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_watermark_at', '3')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('hon_rate_times', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('hon_rate_sep', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('hon_rate_where', '')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('hon_rate_users', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('midthumb_use', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('midthumb_height', '500')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('midthumb_width', '500')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('midthumb_cache', '1')";
	$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('jaime_lettering', '0')";

	$sql[] = "ALTER TABLE ".$table_prefix."smartor_album_rate ADD  rate_hon_point TINYINT(3) DEFAULT '0' NOT NULL";


	$message .= mx_do_install_upgrade( $sql );
}
else
{

	//
	// Upgrade checks
	//
	$upgrade_2000 = 0;
	$upgrade_2001 = 0;

	//
	// validate before 2.00
	//
	$result = $db->sql_query( "SELECT config_value from " . $table_prefix . "smartor_album_config WHERE config_name = 'enable_integration'" );
	if ( $db->sql_numrows( $result ) == 0 )
	{
		$upgrade_2000 = 1;
	}

	$result = $db->sql_query( "SELECT config_value from " . $table_prefix . "smartor_album_config WHERE config_name = 'show_otf_link'" );
	if ( $db->sql_numrows( $result ) == 0 )
	{
		$upgrade_2001 = 1;
	}

	$message = "<b>Upgrading!</b><br/><br/>";

	if ( $upgrade_2000 == 1 )
	{
		$message .= "<b>Upgrading to v. 2.00 Beta 1...</b><br/><br/>";

		$sql[] = "UPDATE ". $table_prefix ."smartor_album_config
			SET config_value = '0.54'
			WHERE config_name = 'album_version'";
		$sql[] = "ALTER TABLE ".$table_prefix."smartor_album_cat ADD cat_wm TEXT AFTER cat_desc";
		$sql[] = "ALTER TABLE ".$table_prefix."smartor_album_cat ADD cat_parent MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0' AFTER cat_approval";
		$sql[] = "ALTER TABLE ".$table_prefix."smartor_album_cat ADD cat_user_id MEDIUMINT(8) UNSIGNED NOT NULL DEFAULT '0' AFTER cat_parent";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('fap_version', '1.4.0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_thumb', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_total_pics', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_total_comments', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_comments', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_last_comment', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_last_pic', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_pics', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_recent_in_subcats', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_recent_instead_of_nopics', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('line_break_subcats', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_subcats', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_allow_gallery_mod', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_allow_sub_categories', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_sub_category_limit', '-1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_show_subcats_in_index', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_show_recent_in_subcats', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_show_recent_instead_of_nopics', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_personal_gallery_link', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_category_sorting', 'cat_order')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_category_sorting_direction', 'ASC')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_debug_mode', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_all_in_personal_gallery', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('new_pic_check_interval', '1M')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('index_enable_supercells', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('email_notification', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_download', '2')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_slideshow', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_pic_size_on_thumb', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_files_to_upload', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_pregenerated_fields', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('dynamic_fields', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('pregenerate_fields', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('propercase_pic_title', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_index_last_pic_lv', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_pics_approval', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_img_no_gd', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('dynamic_pic_resampling', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_file_size_resampling', '1024000')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('switch_nuffload', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('path_to_bin', './modules/mx_smartor/cgi-bin/')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('perl_uploader', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_progress_bar', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('close_on_finish', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_pause', '5')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('simple_format', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('multiple_uploads', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('max_uploads', '5')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('zip_uploads', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_pic', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_width', '600')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_height', '600')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('resize_quality', '70')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_pics_nav', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_inline_copyright', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_nuffimage', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_sepia_bw', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('personal_allow_avatar_gallery', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_gif_mid_thumb', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('slideshow_script', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_exif', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('album_bbcode', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('quick_thumbs', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('set_memory', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('lb_preview', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('use_old_pics_gen', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_last_comments', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_mooshow', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('enable_integration', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('override_default_pages', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('index', '5')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_sp_config VALUES ('disp_mostv', '1')";
	}
	if ( $upgrade_2001 == 1 )
	{
		$message .= "<b>Upgrading to v. 2.00 Beta 2...</b><br/><br/>";
		$sql[] = "UPDATE ". $table_prefix ."smartor_album_config
			SET config_value = '1.4.1'
			WHERE config_name = 'fap_version'";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('invert_nav_arrows', '0')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_otf_link', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_all_pics_link', '1')";
		$sql[] = "INSERT INTO ".$table_prefix."smartor_album_config VALUES ('show_personal_galleries_link', '1')";
		$sql[] = "ALTER TABLE ".$table_prefix."smartor_album_comment ADD comment_cat_id int(11) NOT NULL default '0' AFTER comment_pic_id";
	}
	else
	{
		$message .= "<b>Nothing to upgrade...</b><br/><br/>";
	}

	$sql[] = "UPDATE " . $table_prefix . "module" . "
				    SET module_version  = '" . $mx_module_version . "',
				      module_copy  = '" . $mx_module_copy . "'
				    WHERE module_id = '" . $mx_module_id . "'";

	$message .= mx_do_install_upgrade( $sql );
}

echo "<br /><br />";
echo "<table  width=\"90%\" align=\"center\" cellpadding=\"4\" cellspacing=\"1\" border=\"0\" class=\"forumline\">";
echo "<tr><th class=\"thHead\" align=\"center\">Mod Installation/Upgrading/Uninstalling Information - mod specific db tables</th></tr>";
echo "<tr><td class=\"row1\"  align=\"left\"><span class=\"gen\">" . $message . "</span></td></tr>";
echo "</table><br />";


include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>