<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_personal_random.php,v 1.1.2.3 2008/03/13 08:27:32 orynider Exp $
* @copyright (c) 2003 [smartor_xp@hotmail.com, Smartor] Mx-Publisher Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

// MX
if ( !defined('IN_PORTAL') )
{
	die("Hacking attempt");
}

require($album_root_path . 'includes/album_image_class.'.$phpEx);


// ------------------------------------
// Check the request
// ------------------------------------
if( isset($HTTP_POST_VARS['user_id']) )
{
	$user_id = intval($HTTP_POST_VARS['user_id']);
}
else if( isset($HTTP_GET_VARS['user_id']) )
{
	$user_id = intval($HTTP_GET_VARS['user_id']);
}
else
{
	$user_id = $userdata['user_id'];
	//$user_id = '2';
}
//
// END check request
//


// ------------------------------------
// Check $user_id
// ------------------------------------

if( ($user_id < 1) and (!$userdata['session_logged_in']) )
{
	$user_id = ANONYMOUS;
}


// ------------------------------------
// Get the username of this gallery's owner
// ------------------------------------

$sql = "SELECT username
		FROM ". USERS_TABLE ."
		WHERE user_id = $user_id";

if( !($result = $db->sql_query($sql)) )
{
	mx_message_die(GENERAL_ERROR, 'Could not get the username of this category owner', '', __LINE__, __FILE__, $sql);
}

$row = $db->sql_fetchrow($result);

$username = $row['username'];

if( empty($username) )
{
	$username = ( !empty($userdata['username']) ? $userdata['username'] : $lang['Guest'] );
}



// ------------------------------------
// Check Permissions
// ------------------------------------
$personal_gallery_access = personal_gallery_access(1,1);
//
// END check permissions
//



// ------------------------------------
// Build the thumbnail page
// ------------------------------------

if( isset($HTTP_GET_VARS['start']) )
{
	$start = intval($HTTP_GET_VARS['start']);
}
else if( isset($HTTP_POST_VARS['start']) )
{
	$start = intval($HTTP_POST_VARS['start']);
}
else
{
	$start = 0;
}

if( isset($HTTP_GET_VARS['sort_method']) )
{
	switch ($HTTP_GET_VARS['sort_method'])
	{
		case 'pic_title':
			$sort_method = 'pic_title';
			break;
		case 'pic_view_count':
			$sort_method = 'pic_view_count';
			break;
		case 'rating':
			$sort_method = 'rating';
			break;
		case 'comments':
			$sort_method = 'comments';
			break;
		case 'new_comment':
			$sort_method = 'new_comment';
			break;
		default:
			$sort_method = $album_config['sort_method'];
	}
}
else if( isset($HTTP_POST_VARS['sort_method']) )
{
	switch ($HTTP_POST_VARS['sort_method'])
	{
		case 'pic_title':
			$sort_method = 'pic_title';
			break;
		case 'pic_view_count':
			$sort_method = 'pic_view_count';
			break;
		case 'rating':
			$sort_method = 'rating';
			break;
		case 'comments':
			$sort_method = 'comments';
			break;
		case 'new_comment':
			$sort_method = 'new_comment';
			break;
		default:
			$sort_method = $album_config['sort_method'];
	}
}
else
{
	$sort_method = $album_config['sort_method'];
}

if( isset($HTTP_GET_VARS['sort_order']) )
{
	switch ($HTTP_GET_VARS['sort_order'])
	{
		case 'ASC':
			$sort_order = 'ASC';
			break;
		case 'DESC':
			$sort_order = 'DESC';
			break;
		default:
			$sort_order = $album_config['sort_order'];
	}
}
else if( isset($HTTP_POST_VARS['sort_order']) )
{
	switch ($HTTP_POST_VARS['sort_order'])
	{
		case 'ASC':
			$sort_order = 'ASC';
			break;
		case 'DESC':
			$sort_order = 'DESC';
			break;
		default:
			$sort_order = $album_config['sort_order'];
	}
}
else
{
	$sort_order = $album_config['sort_order'];
}

$pics_per_page = $album_config['rows_per_page'] * $album_config['cols_per_page'];


// ------------------------------------
// Count Pics
// ------------------------------------

$sql = "SELECT COUNT(pic_id) AS count
		FROM ". ALBUM_TABLE ."
		WHERE pic_cat_id = ". PERSONAL_GALLERY ."
			AND pic_user_id = $user_id";
if( !($result = $db->sql_query($sql)) )
{
	mx_message_die(GENERAL_ERROR, 'Could not count pics', '', __LINE__, __FILE__, $sql);
}

$row = $db->sql_fetchrow($result);

$total_pics = $row['count'];


// ------------------------------------
// Build up
// ------------------------------------

if ($total_pics > 0)
{
	$limit_sql = ($start == 0) ? $pics_per_page : $start .','. $pics_per_page;

	$sql = "SELECT p.pic_id, p.pic_title, p.pic_desc, p.pic_user_id, p.pic_user_ip, p.pic_time, p.pic_view_count, p.pic_lock, r.rate_pic_id, AVG(r.rate_point) AS rating, COUNT(DISTINCT c.comment_id) AS comments, MAX(c.comment_id) as new_comment
			FROM ". ALBUM_TABLE ." AS p
				LEFT JOIN ". ALBUM_RATE_TABLE ." AS r ON p.pic_id = r.rate_pic_id
				LEFT JOIN ". ALBUM_COMMENT_TABLE ." AS c ON p.pic_id = c.comment_pic_id
			WHERE p.pic_cat_id = ". PERSONAL_GALLERY ."
				AND p.pic_user_id = $user_id
			GROUP BY p.pic_id
			ORDER BY $sort_method $sort_order
			LIMIT $limit_sql";
	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query pics information', '', __LINE__, __FILE__, $sql);
	}

	$picrow = array();

	while( $row = $db->sql_fetchrow($result) )
	{
		$picrow[] = $row;
	}


	// --------------------------------
	// Thumbnails table
	// --------------------------------

	for ($i = 0; $i < count($picrow); $i += $album_config['cols_per_page'])
	{
		$template->assign_block_vars('picrow', array());

		for ($j = $i; $j < ($i + $album_config['cols_per_page']); $j++)
		{
			if( $j >= count($picrow) )
			{
				break;
			}
				$avatar_number = rand(1,$j);
				$upic = ($album_config['fullpic_popup']) ? mx_append_sid(this_smartor_mxurl("smartor_mode=album_pic&pic_id=". $picrow[$avatar_number]['pic_id'])) : mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=". $picrow[$j]['pic_id']));
				$thumnail = mx_append_sid('album.' . $phpEx . "?smartor_mode=album_thumbnail&pic_id=". $picrow[$avatar_number]['pic_id'], TRUE);
				$pic_id = $picrow[$avatar_number]['pic_id'];
 
			}
	}


}
elseif( isset($_GET['pic_id']) )
{
	$pic_id = intval($_GET['pic_id']);
}
elseif( isset($_POST['pic_id']) )
{
	$pic_id = intval($_POST['pic_id']);
}
else
{
	$pic_id = '0';
}

// ------------------------------------
// Get this pic info and current category info
// ------------------------------------

if ($pic_id == '0')
{
	$thispic = '0';
}
elseif ($cat_id != PERSONAL_GALLERY)
{
	$sql = "SELECT p.*, c.*
		FROM ". ALBUM_TABLE ." AS p, ". ALBUM_CAT_TABLE ." AS c
		WHERE p.pic_id = '$pic_id'
			AND c.cat_id = p.pic_cat_id";

	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
	}
	$thispic = $db->sql_fetchrow($result);
	//$db->sql_freeresult($result);
}
else
{
	$sql = "SELECT *
		FROM ". ALBUM_TABLE ."
		WHERE pic_id = '$pic_id'";
	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
	}
	$thispic = $db->sql_fetchrow($result);
}


if ($pic_id == '0')
{
	$cat_id = PERSONAL_GALLERY;
	$album_user_id = '1';

	$pic_filename = 'anonymouse.png';
	$pic_filetype = strtolower(substr($pic_filename, strlen($pic_filename) - 4, 4));
	$pic_fullpath = ALBUM_UPLOAD_PATH . $pic_filename;
	$pic_thumbnail_new = md5($pic_filename) . $pic_filetype;
	$pic_thumbnail = ( $thispic['pic_thumbnail'] == '' ) ? $pic_thumbnail_new : $thispic['pic_thumbnail'];
	//$pic_thumbnail = ( $thispic['pic_thumbnail'] == '' ) ? $pic_filename : $thispic['pic_thumbnail'];
	$pic_thumbnail_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail;
	$pic_thumbnail_new_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail_new;
	$pic_title = $thispic['pic_title'];
	$pic_title_reg = ereg_replace("[^A-Za-z0-9]", "_", $pic_title);
}
else
{
	$cat_id = $thispic['pic_cat_id'];
	$album_user_id = $thispic['cat_user_id'];

	$pic_filename = $thispic['pic_filename'];
	$pic_filetype = strtolower(substr($pic_filename, strlen($pic_filename) - 4, 4));
	$pic_fullpath = ALBUM_UPLOAD_PATH . $pic_filename;
	$pic_thumbnail_new = md5($pic_filename) . $pic_filetype;
	$pic_thumbnail = ( $thispic['pic_thumbnail'] == '' ) ? $pic_thumbnail_new : $thispic['pic_thumbnail'];
	//$pic_thumbnail = ( $thispic['pic_thumbnail'] == '' ) ? $pic_filename : $thispic['pic_thumbnail'];
	$pic_thumbnail_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail;
	$pic_thumbnail_new_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail_new;
	$pic_title = $thispic['pic_title'];
	$pic_title_reg = ereg_replace("[^A-Za-z0-9]", "_", $pic_title);
}
if( !file_exists($pic_fullpath) )
{
	mx_message_die(GENERAL_MESSAGE, $lang['Pic_not_exist'] . $pic_fullpath);
}

/*
// ------------------------------------
// Check the permissions
// ------------------------------------
$album_user_access = album_permissions($album_user_id, $cat_id, ALBUM_AUTH_VIEW, $thispic);

// ------------------------------------
// Check Pic Approval
// ------------------------------------
if ( $userdata['user_level'] != ADMIN )
{
	if ( ($thispic['cat_approval'] == ADMIN) || (($thispic['cat_approval'] == MOD) && !$album_user_access['moderator']) )
	{
		if ( $thispic['pic_approval'] != 1 )
		{
			mx_message_die(GENERAL_MESSAGE, $lang['Not_Authorised']);
		}
	}
}
*/

/*
// ------------------------------------
// Check hotlink
// ------------------------------------
if ( ($album_config['hotlink_prevent'] == true) && (isset($HTTP_SERVER_VARS['HTTP_REFERER'])) )
{
	$check_referer = explode('?', $HTTP_SERVER_VARS['HTTP_REFERER']);
	$check_referer = trim($check_referer[0]);

	$good_referers = array();

	if ($album_config['hotlink_allowed'] != '')
	{
		$good_referers = explode(',', $album_config['hotlink_allowed']);
	}

	$good_referers[] = $board_config['server_name'] . $board_config['script_path'];

	$errored = true;

	for ($i = 0; $i < count($good_referers); $i++)
	{
		$good_referers[$i] = trim($good_referers[$i]);

		if ( (strstr($check_referer, $good_referers[$i])) && ($good_referers[$i] != '') )
		{
			$errored = false;
		}
	}

	if ( $errored )
	{
		mx_message_die(GENERAL_MESSAGE, $lang['Not_Authorised']);
	}
}
*/

/*
+----------------------------------------------------------
| Main work here...
+----------------------------------------------------------
*/

// --------------------------------
// Check thumbnail cache. If cache is available we will SEND & EXIT
// --------------------------------
switch ($pic_filetype)
{
	case '.gif':
		$file_header = 'Content-type: image/gif';
		break;
	case '.jpg':
		$file_header = 'Content-type: image/jpeg';
		break;
	case '.png':
		$file_header = 'Content-type: image/png';
		break;
	default:
		header('Content-type: image/jpeg');
		header("Content-Disposition: filename=thumb_" . $pic_title_reg . $pic_filetype);
		readfile(!empty($images['no_thumbnail']) ? $images['no_thumbnail'] : $module_root_path . 'templates/'. $theme['template_name'] . '/images/nothumbnail.jpg');
		exit;
		break;
}

if( ($album_config['thumbnail_cache'] == true) && file_exists($pic_thumbnail_fullpath) )
{
	header($file_header);
	header("Content-Disposition: filename=thumb_" .$pic_title_reg . $pic_filetype);
	readfile($pic_thumbnail_fullpath);
	exit;
}

$pic_size = @getimagesize($pic_fullpath);
$pic_width = $pic_size[0];
$pic_height = $pic_size[1];

if( ($pic_width < $album_config['thumbnail_size']) && ($pic_height < $album_config['thumbnail_size']) )
{
	header($file_header);
	header("Content-Disposition: filename=thumb_" .$pic_title_reg . $pic_filetype);
	readfile($pic_fullpath);
	exit;
}
else
{

	// --------------------------------
	// Cache is empty. Try to re-generate!
	// --------------------------------
	if ($pic_width > $pic_height)
	{
		$thumbnail_width = $album_config['thumbnail_size'];
		$thumbnail_height = $album_config['thumbnail_size'] * ($pic_height / $pic_width);
	}
	else
	{
		$thumbnail_height = $album_config['thumbnail_size'];
		$thumbnail_width = $album_config['thumbnail_size'] * ($pic_width / $pic_height);
	}

	// Old Thumbnails - BEGIN
	// Old thumbnail generation functions, for GD1 and some strange servers...
	if ( ($album_config['gd_version'] == 1) || ($album_config['use_old_pics_gen'] == 1) )
	{
		switch ($pic_filetype)
		{
			case '.gif':
				header('Content-type: image/jpeg');
				header("Content-Disposition: filename=thumb_" . $pic_title_reg . $pic_filetype);
				readfile(!empty($images['no_thumbnail']) ? $images['no_thumbnail'] : $mx_module_path . 'templates/'. $theme['template_name'] . '/images/nothumbnail.jpg');
				exit;
				break;
		}


		$thumbnail = ($album_config['gd_version'] == 1) ? @imagecreate($thumbnail_width, $thumbnail_height) : @imagecreatetruecolor($thumbnail_width, $thumbnail_height);


		$resize_function = ($album_config['gd_version'] == 1) ? 'imagecopyresized' : 'imagecopyresampled';

		@$resize_function($thumbnail, $pic_fullpath, 0, 0, 0, 0, $thumbnail_width, $thumbnail_height, $pic_width, $pic_height);



		if ($album_config['thumbnail_cache'] == 1)
		{
			// ------------------------
			// Re-generate successfully. Write it to disk!
			// ------------------------
			switch ($pic_filetype)
			{
				case '.jpg':
					@imagejpeg($thumbnail, $pic_thumbnail_new_fullpath, $album_config['thumbnail_quality']);
					break;
				case '.png':
					@imagepng($thumbnail, $pic_thumbnail_new_fullpath);
					break;
			}
			@chmod($pic_thumbnail_new_fullpath, 0777);
		}

		// ----------------------------
		// After write to disk, donot forget to send to browser also
		// ----------------------------
		switch ($pic_filetype)
		{
			case '.jpg':
				@imagejpeg($thumbnail, '', $album_config['thumbnail_quality']);
				break;
			case '.png':
				@imagepng($thumbnail);
				break;
			default:
				header('Content-type: image/jpeg');
				header("Content-Disposition: filename=thumb_" . $pic_title_reg . $pic_filetype);
				readfile(!empty($images['no_thumbnail']) ? $images['no_thumbnail'] : $mx_module_path . 'templates/'. $theme['template_name'] . '/images/nothumbnail.jpg');
				break;
		}
		exit;
	}
	// Old Thumbnails - END

	$Image = new ImgObj();

	if ($pic_filetype == '.jpg')
	{
		$Image->ReadSourceFileJPG($pic_fullpath);
	}
	else
	{
		$Image->ReadSourceFile($pic_fullpath);
	}

	$Image->Resize($thumbnail_width, $thumbnail_height);


	if ($album_config['thumbnail_cache'] == true)
	{
		if ($pic_filetype == '.jpg')
		{
			$Image->SendToFileJPG($pic_thumbnail_new_fullpath, $album_config['thumbnail_quality']);
		}
		else
		{
			$Image->SendToFile($pic_thumbnail_new_fullpath, $album_config['thumbnail_quality']);
		}
		//$Image->SendToFile($pic_thumbnail_fullpath, $album_config['thumbnail_quality']);
		//@chmod($pic_thumbnail_fullpath, 0777);
		
		$sql = "UPDATE ". ALBUM_TABLE ."
			SET pic_thumbnail = '" . $pic_thumbnail_new . "'
			WHERE pic_id = '" . $pic_id . "'";
		if( !$result = $db->sql_query($sql) )
		{
			mx_message_die(GENERAL_ERROR, 'Could not update pic information', '', __LINE__, __FILE__, $sql);
		}
	}

	if ($pic_filetype == '.jpg')
	{
		$Image->SendToBrowserJPG($pic_title_reg, $pic_filetype, 'thumb_', '', $album_config['thumbnail_quality']);
	}
	else
	{
		$Image->SendToBrowser($pic_title_reg, $pic_filetype, 'thumb_', '', $album_config['thumbnail_quality']);
	}

	if ( $Image == true )
	{
		$Image->Destroy();
		exit;
	}
	else
	{
		$Image->Destroy();
		header('Content-type: image/jpeg');
		header("Content-Disposition: filename=thumb_" . $pic_title_reg . $pic_filetype);
		readfile(!empty($images['no_thumbnail']) ? $images['no_thumbnail'] : $module_root_path . 'templates/'. $theme['template_name'] . '/images/nothumbnail.jpg');
		exit;
	}
}

header("Location:" . $pic_thumbnail_fullpath);

?>