<?php 
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_rss.php,v 1.1.2.3 2008/03/13 08:27:32 orynider Exp $
* @copyright (c) 2007 [orynider@rdslink.ro, OryNider] Mx-Publisher Development Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

// ------------------------------------------------------------------------- //
// RSS Feed for Smartor's Album v1.0 					     //
// modifyed by OryNider for mx_smartor 2.0				     //
// ------------------------------------------------------------------------- //
// Copyright (C) DaMysterious    14.06.2004                                  //
// http://damysterious.xs4all.nl/                                            //
// ------------------------------------------------------------------------- //
// This program is free software; you can redistribute it and/or modify      //
// it under the terms of the GNU General Public License as published by      //
// the Free Software Foundation; either version 2 of the License, or         //
// (at your option) any later version.                                       //
// ------------------------------------------------------------------------- //
// This little tool allows you to show the latest added picture from         //
// your album via RRS-Feed.						     //
//									     //										
// ------------------------------------------------------------------------- //

// MX
if ( !defined('IN_PORTAL') )
{
	die("Hacking attempt");
}

function getmicrotime()
{
	list($usec, $sec) = explode(" ", microtime());
	return ((float)$usec + (float)$sec);
}


// XML and nocaching headers
// header ('Cache-Control: private, pre-check=0, post-check=0, max-age=0');
header ('Expires: ' . gmdate('D, d M Y H:i:s', time()) . ' GMT');
header ('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header ('Content-Type: text/xml');

// Includes of phpBB scripts
$phpEx = substr(strrchr(__FILE__, '.'), 1);
// include_once($mx_root_path . 'common.'.$phpEx);

define('ALBUM_MOD_PATH', 'album_mod/');

// Get general album information
if (!isset($album_root_path) || empty($album_root_path))
{
	$album_root_path = $module_root_path . ALBUM_MOD_PATH . '';
}

include_once($album_root_path . 'album_common.'.$phpEx);

//
// Start session management
//
//$mx_user->init($user_ip, PAGE_INDEX);
//
// End session management
//

$time_start = getmicrotime();


// Create main board url (some code borrowed from functions_post.php)
$script_name = preg_replace('/^\/?(.*?)\/?$/', '\1', trim($board_config['script_path']));
$site = 'index.php';
$index = this_fap_rssurl();
$thumbs = this_album_rssurl("smartor_mode=album_thumbnail");
$server_name = trim($board_config['server_name']);
$server_protocol = ( $board_config['cookie_secure'] ) ? 'https://' : 'http://';
$server_port = ( $board_config['server_port'] <> 80 ) ? ':' . trim($board_config['server_port']) . '/' : '/';
$site_name = strip_tags($board_config['sitename']);
$site_description = strip_tags($board_config['site_desc']);

// Change below to point to your rss-logo
$logo = 'logo.gif';
// Change above to point to your rss-logo


if (!isset($images['logo_url']) || empty($images['logo_url']))
{
	$images['logo_url'] = PORTAL_URL . 'templates/' . $theme['template_name'] . '/images/' . $logo;
}
elseif (!isset($theme['template_name']) || empty($theme['template_name']))
{
	$images['logo_url'] = PORTAL_URL . 'templates/subSilver/images/' . $logo;
}


$index_site = PORTAL_URL . $site;
$index_url = PORTAL_URL . $index;
$thumb_url = PORTAL_URL . $thumbs;
$rss_time = date('D, j M Y G:i:s T',$time_start);

$board_config['sitename'] = str_replace("&","&amp;",$board_config['sitename']);
$board_config['site_desc'] = str_replace("&","&amp;",$board_config['site_desc']);

$rss = "<?xml version=\"1.0\" encoding=\"ISO-8859-2\" ?>
<rss version=\"2.0\">
<channel>
    <title>" . $board_config['sitename'] . " Album (XXX needs registering)</title>
    <link>" . $index_url . "</link>
    <description>" . $board_config['site_desc'] . "</description>  
	<language>en-us</language>
	<generator>Mx Smartor Album FAP - Module, version 2.0.0</generator>
	<pubDate>". $rss_time ."</pubDate>
	<image> 
		<title>" . $board_config['sitename'] . "</title>
		<link>" . $index_site . "</link>
		<description>" . $board_config['site_desc'] . "</description>
		<url>" . $images['logo_url'] . "</url>
	</image>  
";


// If not set, set the output count to 50
$count = ( isset($HTTP_GET_VARS['c']) ) ? intval($HTTP_GET_VARS['c']) : 25;
$count = ( $count == 0 ) ? 25 : $count;

// BEGIN Recent Photo
// Start check permissions
$sql_allowed_cat="";
$check_sel=($admin_mode)?0:1;
if($userdata['user_level']<>ADMIN)
{
	$album_user_access=personal_gallery_access(true,false);
	$not_allowed_cat=($album_user_access['view']==1 )?'':'0';
	$sql = "SELECT c.*
		FROM ". ALBUM_CAT_TABLE ." AS c
		WHERE cat_id <> 0";
	if( !($result = $db->sql_query($sql)) )
	{
        die("Could not query categories list");
	}
	while( $row = $db->sql_fetchrow($result) )
	{
		$album_user_access = album_user_access($row['cat_id'], $row, 1, 0, 0, 0, 0, 0); // VIEW
		if($admin_mode)
		{
			if (($album_user_access['moderator']!=1) or ($row['cat_approval'] != MOD)) $not_allowed_cat .= ($not_allowed_cat == '') ? $row['cat_id'] : ',' . $row['cat_id'];
		}
		else
		{
			if ($album_user_access['view'] != 1) $not_allowed_cat .= ($not_allowed_cat == '') ? $row['cat_id'] : ',' . $row['cat_id'];
		}
	}
	$sql_not_allowed_cat=(empty($not_allowed_cat))?"":"AND pic_cat_id NOT IN ($not_allowed_cat)";
}
// End check permissions
$NotErrorFlag=false;
$sql_limit_time="";
if (!$no_limit and isset($HTTP_SERVER_VARS['HTTP_IF_MODIFIED_SINCE'])) {
		$NotErrorFlag=true;
		$NotModifiedSince=strtotime($HTTP_SERVER_VARS['HTTP_IF_MODIFIED_SINCE']);
		if($NotModifiedSince>0){
			 $sql_limit_time="AND pic_time > ".$NotModifiedSince;
             $sql_limit_comment_time="AND comment_time > ".$NotModifiedSince;
			 }
} 

$sql = "SELECT pic_id, pic_title, pic_time, pic_desc, pic_username, pic_cat_id, pic_approval, cat_title
	FROM ".ALBUM_TABLE. " LEFT JOIN ".ALBUM_CAT_TABLE." ON (cat_id = pic_cat_id)
	WHERE pic_approval=$check_sel
	$sql_not_allowed_cat $sql_cat_where $sql_limit_time
	ORDER  BY pic_time DESC
	LIMIT $count";

	$picrow = $db->sql_query($sql);

if ( !$picrow )
{
    die("Failed obtaining list of active pictures");
}
else
{
    $topics = $db->sql_fetchrowset($picrow);
}
$LastPostTime=0;
if ( count($topics) == 0 )
{
    die("No pictures found");
}
else
{
    // $topics contains all interesting data
    for ($i = 0; $i < count($topics); $i++)
    {
        $title = $topics[$i]['pic_title'];
        $title = str_replace("&","&amp;",$title);
        $url = $index_url . "&amp;" . "pic_id=" . $topics[$i]['pic_id']  . $picrow[$i]['pic_id'];
        $thumb = $thumb_url . "&amp;" . "pic_id=" . $topics[$i]['pic_id']  . $picrow[$i]['pic_id'];
    	$description = '<a href="' . $url . '"><img src="' . $thumb . '" border="1" vspace="2" hspace="2" align="left" ></a>';
    	//$description = htmlspecialchars($entry_data[$i]['entry_text']);
    	$description = htmlentities($description);
	$description .= $lang['Pic_Desc'].": ".nl2br($topics[$i]['pic_desc']);
        $pic_time = date('D, j M Y G:i:s T',$topics[$i]['pic_time']);

        $rss .= "
<item>
	<title>" . $title . "</title>
	<link>" . $url . "</link>
	<description>" . $description ."</description>
	<pubDate>". $pic_time ."</pubDate>            
</item>
";
    }
}

// Create RDF footer
$rss .= "
</channel>
</rss>";

// Discritics Replace
$rss = str_replace("&auml;","",$rss);
$rss = str_replace("&ouml;","",$rss);
$rss = str_replace("&uuml;","",$rss);

// Output the RDF
echo $rss;

?> 