<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: admin_album_personal.php,v 1.13 2008/02/08 10:47:59 orynider Exp $
* @copyright (c) 2003 [smartor_xp@hotmail.com, Smartor] Mx-Publisher Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

$phpEx = substr(strrchr(__FILE__, '.'), 1);

if ( @file_exists( './../viewtopic.' . $phpEx ) ) // -------------------------------------------- phpBB MOD MODE
{
	define('MXBB_MODULE', false);
	define('IN_PHPBB', true);
	
	$phpbb_root_path = $module_root_path = './../';
	$mx_mod_path = $phpbb_root_path . 'mx_mod/';
	
	require_once($mx_mod_path . "includes/functions_required.$phpEx");
	
	@define('IN_PORTAL', true);
	
	//Check if forum_hack is installed
	if (!isset($mx_root_path))
	{
		$mx_root_path = './../';

		include_once($mx_mod_path . "includes/mx_constants.$phpEx");
		include_once($mx_mod_path . "includes/shared/phpbb2/includes/functions.$phpEx");
	}
	
	require_once($mx_mod_path . "includes/functions_core.$phpEx");
	
	//Check for cash mod
	if (file_exists($phpbb_root_path . 'includes/functions_cash.'.$phpEx))
	{
		define('IN_CASHMOD', true);
	}

	//@ini_set( 'display_errors', '1' );
	error_reporting (E_ERROR | E_WARNING | E_PARSE); // This will NOT report uninitialized variables
	//error_reporting(E_ALL & ~E_NOTICE);

	define( 'PAGE_MUSIC', -506 ); // If this id generates a conflict with other mods, change it ;)

	//
	// Instatiate the mx_cache class
	//
	$mx_cache = new mx_cache();
	
	//
	// instatiate the mx_request_vars class
	//
	$mx_request_vars = new mx_request_vars();
	

	//
	// instatiate the mx_user class
	//
	//$mx_user = new mx_user();

	//
	// Left Pane Paths
	//
	$setmodules_admin_path = '';
	$setmodules_module_path = "./../";
	
	if (file_exists($phpbb_root_path."modcp.$phpEx")) // phpBB2
	{
		define('PORTAL_BACKEND', 'phpbb2');
		$tplEx = 'tpl';
	}
	else if (@file_exists($phpbb_root_path."mcp.$phpEx")) // phpBB3
	{
		define('PORTAL_BACKEND', 'phpbb3');
		$tplEx = 'html';
	}
}
else
{
	define( 'IN_PORTAL', 1 );
	define( 'MXBB_MODULE', true );

	//
	// Main paths
	//
	$mx_root_path = './../../../';
	$module_root_path = './../../../modules/mx_smartor/';

	$setmodules_admin_path = 'modules/mx_smartor/admin/';

	define( 'MXBB_27x', file_exists( $mx_root_path . 'mx_login.php' ) );

	$phpEx = substr(strrchr(__FILE__, '.'), 1);
}


if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Smartor_Album']['Personal_Galleries'] = $setmodules_admin_path . $filename;
	return;
}

//
// Let's set the root dir for phpBB
//
$album_root_path = $module_root_path . 'album_mod/';
require($mx_root_path . 'admin/pagestart.' . $phpEx);

if ( !MXBB_MODULE )
{
	require_once($mx_mod_path . "includes/functions_styles.$phpEx");

	$mx_user = new mx_user();	// instatiate the mx_user class
	
	//
	// Define basic constants
	//
	$mx_user->page_id = 1;
	$mx_user->user_ip = $user_ip;
	$mx_user->_init_userprefs();
}

require($module_root_path . 'album_mod/album_common.'.$phpEx);

// **********************************************************************
// Read language definition
// **********************************************************************
if ( !file_exists($album_root_path . "language/lang_" . $board_config['default_lang'] . "/lang_admin.$phpEx"))
{
	include($album_root_path . "language/lang_english/lang_admin.$phpEx");
}
else
{
	include($album_root_path . "language/lang_" . $board_config['default_lang'] . "/lang_admin.$phpEx");
}

if ( !file_exists($album_root_path . "language/lang_" . $board_config['default_lang'] . "/lang_main.$phpEx"))
{
	include($album_root_path . "language/lang_english/lang_main.$phpEx");
}
else
{
	include($album_root_path . "language/lang_" . $board_config['default_lang'] . "/lang_main.$phpEx");
}

if( !isset($_POST['submit']) )
{
	$template->set_filenames(array(
		'body' => $acp_prefix . 'album_personal_body.tpl')
	);

	// Get the list of phpBB usergroups
	$sql = "SELECT group_id, group_name
			FROM " . GROUPS_TABLE . "
			WHERE group_single_user <> " . TRUE ."
			ORDER BY group_name ASC";
	if ( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, "Couldn't get group list", "", __LINE__, __FILE__, $sql);
	}

	while( $row = $db->sql_fetchrow($result) )
	{
		$groupdata[] = $row;
	}

	// Get the current album settings for non created personal galleries
	$sql = "SELECT *
			FROM ". ALBUM_CONFIG_TABLE ."
			WHERE config_name = 'personal_gallery_private'";
	if ( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, "Couldn't get Album info", "", __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);
	$private_groups = explode(',', $row['config_value']);

	// Since all personal galleries have the same private/moderator settings we fetch the first personal gallery and not all.
	$sql = "SELECT cat_id, cat_title, cat_view_groups, cat_upload_groups, cat_rate_groups, cat_comment_groups, cat_edit_groups, cat_delete_groups, cat_moderator_groups
			FROM ". ALBUM_CAT_TABLE ."
			WHERE cat_parent = 0 and cat_user_id != 0
			LIMIT 1";

	if( !$result = $db->sql_query($sql) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not get Category information', '', __LINE__, __FILE__, $sql);
	}

	$thiscat = $db->sql_fetchrow($result);

	$view_groups = @explode(',', $thiscat['cat_view_groups']);
	$upload_groups = @explode(',', $thiscat['cat_upload_groups']);
	$rate_groups = @explode(',', $thiscat['cat_rate_groups']);
	$comment_groups = @explode(',', $thiscat['cat_comment_groups']);
	$edit_groups = @explode(',', $thiscat['cat_edit_groups']);
	$delete_groups = @explode(',', $thiscat['cat_delete_groups']);

	$moderator_groups = @explode(',', $thiscat['cat_moderator_groups']);

	for($i = 0; $i < count($groupdata); $i++)
	{
		$template->assign_block_vars('creation_grouprow', array(
			'GROUP_ID' => $groupdata[$i]['group_id'],
			'GROUP_NAME' => $groupdata[$i]['group_name'],
			'PRIVATE_CHECKED' => (in_array($groupdata[$i]['group_id'], $private_groups)) ? 'checked="checked"' : ''
			) //end array
		);
		$template->assign_block_vars('grouprow', array(
			'GROUP_ID' => $groupdata[$i]['group_id'],
			'GROUP_NAME' => $groupdata[$i]['group_name'],
			'VIEW_CHECKED' => (in_array($groupdata[$i]['group_id'], $view_groups)) ? 'checked="checked"' : '',
			'UPLOAD_CHECKED' => (in_array($groupdata[$i]['group_id'], $upload_groups)) ? 'checked="checked"' : '',
			'RATE_CHECKED' => (in_array($groupdata[$i]['group_id'], $rate_groups)) ? 'checked="checked"' : '',
			'COMMENT_CHECKED' => (in_array($groupdata[$i]['group_id'], $comment_groups)) ? 'checked="checked"' : '',
			'EDIT_CHECKED' => (in_array($groupdata[$i]['group_id'], $edit_groups)) ? 'checked="checked"' : '',
			'DELETE_CHECKED' => (in_array($groupdata[$i]['group_id'], $delete_groups)) ? 'checked="checked"' : '',
			'MODERATOR_CHECKED' => (in_array($groupdata[$i]['group_id'], $moderator_groups)) ? 'checked="checked"' : '')
		);
	}

	$template->assign_vars(array(
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_ALBUM_PERSONAL_TITLE' => ( !empty($lang['Album_personal_gallery_title']) ? $lang['Album_personal_gallery_title'] : 'Personal Gallery' ),
		'L_ALBUM_PERSONAL_EXPLAIN' => ( !empty($lang['Album_personal_gallery_explain']) ? $lang['Album_personal_gallery_explain'] : 'On this page, you can choose which usergroups have right to create and view personal galleries. These settings only affect when you set "PRIVATE" for "Allowed to create personal gallery for users" or "Who can view personal galleries" in Album Configuration screen' ),
		'L_ALBUM_AUTH_EXPLAIN' => $lang['Album_Personal_Auth_Explain'],
		'L_GROUP_CONTROL' => $lang['Auth_Control_Group'],
		'L_GROUPS' => $lang['Usergroups'],
		'L_VIEW' => $lang['View'],
		'L_UPLOAD' => $lang['Upload'],
		'L_RATE' => $lang['Rate'],
		'L_COMMENT' => $lang['Comment'],
		'L_EDIT' => $lang['Edit'],
		'L_DELETE' => $lang['Delete'],
		'L_IS_MODERATOR' => $lang['Is_Moderator'],
		'L_PRIVATE_ACCESS' => $lang['Private_access'],
		'S_ALBUM_ACTION' => mx_append_sid('admin_album_personal.'.$phpEx)
		)
	);

	$template->pparse('body');

	include($mx_root_path . 'admin/page_footer_admin.'.$phpEx);
}
else
{
	// Now we update the datatabase
	$private_groups = @implode(',', $_POST['private']);
	$view_groups = @implode(',', $_POST['view']);
	$upload_groups = @implode(',', $_POST['upload']);
	$rate_groups = @implode(',', $_POST['rate']);
	$comment_groups = @implode(',', $_POST['comment']);
	$edit_groups = @implode(',', $_POST['edit']);
	$delete_groups = @implode(',', $_POST['delete']);
	$moderator_groups = @implode(',', $_POST['moderator']);
	
	// album config for non created personal galleries	
	$sql = "UPDATE ". ALBUM_CONFIG_TABLE ."
			SET config_value = '$private_groups'
			WHERE config_name = 'personal_gallery_private'";
	if ( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not update Album config table', '', __LINE__, __FILE__, $sql);
	}

	$sql = "UPDATE ". ALBUM_CAT_TABLE ."
		SET cat_view_groups = '$view_groups', cat_upload_groups = '$upload_groups', cat_rate_groups = '$rate_groups', cat_comment_groups = '$comment_groups', cat_edit_groups = '$edit_groups', cat_delete_groups = '$delete_groups', cat_moderator_groups = '$moderator_groups'
		WHERE cat_user_id != 0";

	if ( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not update personal gallery group information table', '', __LINE__, __FILE__, $sql);
	}

	// okay, return a message...
	$message = $lang['Album_personal_successfully'] . '<br /><br />' . sprintf($lang['Click_return_album_personal'], '<a href="' . mx_append_sid("admin_album_personal.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . mx_append_sid($mx_root_path . "admin/index.$phpEx?pane=right") . '">', '</a>');

	mx_message_die(GENERAL_MESSAGE, $message);
}

?>