<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_constants.php,v 1.1.2.6 2008/03/14 12:36:50 orynider Exp $
* @copyright (c) 2003 [smartor_xp@hotmail.com, Smartor] mxBB Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

 /***************************************************************************
 *
 *   MODIFICATION:
 *   -inserted few extra session handlings
 *   -inserted SP table constant
 *   -inserted medium thumb path constant
 *
 ***************************************************************************/

if ( !defined('IN_PORTAL') )
{
	die('Hacking attempt');
}

if ( !MXBB_MODULE )
{
	define('PORTAL_URL', $portal_config['portal_url']);
	define('PHPBB_URL', PORTAL_URL);

	$mx_table_prefix = $table_prefix;
	$is_block = false; // This also makes the script work for phpBB ;)
}

// -------------------------------------------------------------------------
// Extend User Style with module lang and images
// Usage:  $mx_user->extend(LANG, IMAGES)
// Switches:
// - LANG: MX_LANG_MAIN (default), MX_LANG_ADMIN, MX_LANG_ALL, MX_LANG_NONE
// - IMAGES: MX_IMAGES (default), MX_IMAGES_NONE
//
// Extend page with additional header or footer data
// Examples:
//	$mx_page->add_css_file(); // Include style dependent *.css file, eg module_path/template_path/template/theme.css
//	$mx_page->add_js_file( 'includes/js.js' ); // Relative to module_root
//	$mx_page->add_header_text( 'header text' );
//	$mx_page->add_footer_text( 'includes/test.txt', true ); // Relative to module_root
//  Note: Included text from file (last example), will evaluate $theme and $mx_block->info variables.
if (!MXBB_MODULE)
{
	if (!defined( 'IN_ADMIN' ))
	{
		$mx_user->set_module_cfg_name('mx_smartor');
		$mx_user->set_module_lang_path($module_root_path . 'album_mod/');
		$mx_user->extend(MX_LANG_ALL, MX_IMAGES);
	}
}
else
{
	if (!$_GET['print']) // Do not "fix" with reuest wrapper!!
	{
		$mx_user->set_module_default_style('_core'); // For compatibility with core 2.8.x
	}

	if (is_object($mx_page))
	{
		$mx_user->extend(MX_LANG_ALL, MX_IMAGES);
	}
}

$mx_page->add_css_file('mx_smartor.css'); // Include style dependent *.css file, eg module_path/template_path/template/theme.css
$mx_page->add_js_file('album_mod/fap_loader.js'); // Relative to module_root

// Album Tables
!defined('ALBUM_TABLE') ? define('ALBUM_TABLE', $mx_table_prefix.'smartor_album') : false;
!defined('ALBUM_CAT_TABLE') ? define('ALBUM_CAT_TABLE', $mx_table_prefix.'smartor_album_cat') : false;
!defined('ALBUM_CONFIG_TABLE') ? define('ALBUM_CONFIG_TABLE', $mx_table_prefix.'smartor_album_config') : false;
!defined('ALBUM_COMMENT_TABLE') ? define('ALBUM_COMMENT_TABLE', $mx_table_prefix.'smartor_album_comment') : false;
!defined('ALBUM_RATE_TABLE') ? define('ALBUM_RATE_TABLE', $mx_table_prefix.'smartor_album_rate') : false;
!defined('ALBUM_SP_CONFIG_TABLE') ? define('ALBUM_SP_CONFIG_TABLE', $mx_table_prefix.'smartor_album_sp_config') : false;

@define('PAGE_ALBUM', -50);	// for Session Handling
@define('PAGE_ALBUM_PERSONAL', -51);
@define('PAGE_ALBUM_PICTURE', -52);
@define('PAGE_ALBUM_SEARCH', -53);

define('PERSONAL_GALLERY', 0); // pic_cat_id <- do NOT change this value
define('ALBUM_NAV_ARROW','&nbsp;&raquo;&nbsp;');
define('ALBUM_DATA_ALREADY_READ', -127);

define('ALBUM_ROOT_CATEGORY', -1);
define('ALBUM_PUBLIC_GALLERY', 0);

// Special album jumpbox/selection values
define('ALBUM_JUMPBOX_SEPERATOR', -99999900);
define('ALBUM_JUMPBOX_DELETE', -99999901);
define('ALBUM_JUMPBOX_USERS_GALLERY', -99999902);
define('ALBUM_JUMPBOX_PUBLIC_GALLERY', -99999903);

// Permission rights defined flags
define('ALBUM_AUTH_VIEW', 1);
define('ALBUM_AUTH_UPLOAD', 2);
define('ALBUM_AUTH_CREATE_PERSONAL', 2);
define('ALBUM_AUTH_RATE', 4);
define('ALBUM_AUTH_COMMENT', 8);
define('ALBUM_AUTH_EDIT', 16);
define('ALBUM_AUTH_DELETE', 32);
define('ALBUM_AUTH_MODERATOR', 64);
define('ALBUM_AUTH_MANAGE_PERSONAL_CATEGORIES', 128);

// Special 'predefined' combinations
define('ALBUM_AUTH_ALL', 255);
define('ALBUM_AUTH_VIEW_AND_UPLOAD', 3);

// Used to indicate if you are going to read both public & personal album categories
define('ALBUM_READ_ALL_CATEGORIES', 512);
define('ALBUM_CREATE_CAT_ID_LIST', 1024);

// Select/jumpbox defined flags
define('ALBUM_SELECTBOX_INCLUDE_ALL', 1);
define('ALBUM_SELECTBOX_INCLUDE_ROOT', 2);
define('ALBUM_SELECTBOX_DELETING', 4);
define('ALBUM_SELECTBOX_ALL', 7); // all three options
define('ALBUM_VIEW_ALL', 'all');
define('ALBUM_VIEW_ALL_PICS', 'allpics');
define('ALBUM_VIEW_LIST', 'list');
define('ALBUM_VIEW_NORMAL', '');
define('ALBUM_LISTTYPE_PICTURES', 'pic');
define('ALBUM_LISTTYPE_COMMENTS', 'comment');
define('ALBUM_LISTTYPE_RATINGS', 'rating');

define('ALBUM_INCLUDE_PARENT_ID', true);
define('ALBUM_EXCLUDE_PARENT_ID', false);

// User Levels for Album system <- do NOT change these values
define('ALBUM_ANONYMOUS', -1);
define('ALBUM_GUEST', -1);

define('ALBUM_USER', 0);
define('ALBUM_ADMIN', 1);
define('ALBUM_MOD', 2);
define('ALBUM_PRIVATE', 3);

!defined('PAGE_ALBUM') ? define('PAGE_ALBUM', -502) : false;

//Redefine some GD constants
!defined('IMAGETYPE_PNG') ? define('IMAGETYPE_PNG', 3) : false;
!defined('IMAGETYPE_JPEG') ? define('IMAGETYPE_JPEG', 2) : false;
!defined('IMAGETYPE_GIF') ? define('IMAGETYPE_GIF', 1) : false;

!defined('IMG_PNG') ? define('IMG_PNG', IMAGETYPE_PNG) : false;
!defined('IMG_JPG') ? define('IMG_JPG', IMAGETYPE_JPEG) : false;
!defined('IMG_GIF') ? define('IMG_GIF', IMAGETYPE_GIF) : false;

if ( !MXBB_MODULE )
{
	// Path (trailing slash required)
	define('ALBUM_UPLOAD_PATH', $module_root_path . 'album_mod/upload/');
	define('ALBUM_OTF_PATH', $module_root_path . 'album_mod/upload/otf/');
	define('ALBUM_JUPLOAD_PATH', $module_root_path . 'album_mod/upload/jupload/');
	define('ALBUM_CACHE_PATH', $module_root_path . 'album_mod/upload/cache/');
	define('ALBUM_MED_CACHE_PATH', $module_root_path . 'album_mod/upload/med_cache/');
	define('ALBUM_WM_CACHE_PATH', $module_root_path . 'album_mod/upload/wm_cache/');
	define('ALBUM_WM_FILE', $module_root_path . 'album_mod/mark_fap.png');

}
else
{
	// Path (trailing slash required)
	define('ALBUM_UPLOAD_PATH', $module_root_path . 'upload/');
	define('ALBUM_OTF_PATH', $module_root_path . 'upload/otf/');
	define('ALBUM_JUPLOAD_PATH', $module_root_path . 'upload/jupload/');
	define('ALBUM_CACHE_PATH', $module_root_path . 'upload/cache/');
	define('ALBUM_MED_CACHE_PATH', $module_root_path . 'upload/med_cache/');
	define('ALBUM_WM_CACHE_PATH', $module_root_path . 'upload/wm_cache/');
	define('ALBUM_WM_FILE', $module_root_path . 'album_mod/mark_fap.png');
}
?>