<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_cat.php,v 1.1.2.3 2008/03/13 08:27:29 orynider Exp $
* @copyright (c) 2003 [smartor_xp@hotmail.com, Smartor] Mx-Publisher Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

// MX
if (!defined('IN_PORTAL'))
{
	die("Hacking attempt");
}

if (!defined('ALBUM_MOD_PATH'))
{
	define('ALBUM_MOD_PATH', 'album_mod/');
}

if (!isset($album_root_path) || empty($album_root_path))
{
	$album_root_path = $module_root_path . ALBUM_MOD_PATH . '';
}

// ------------------------------------
// Check the request
// ------------------------------------
// Check $album_user_id
// ------------------------------------
if( isset($_POST['user_id']) )
{
	$album_user_id = intval($_POST['user_id']);
}
elseif( isset($_GET['user_id']) )
{
	$album_user_id = intval($_GET['user_id']);
}
else
{
	// if no user_id was supplied then we aren't going to show a personal gallery category
	$album_user_id = ALBUM_PUBLIC_GALLERY;
}
// Check $cat_id
// ------------------------------------
if( isset($HTTP_POST_VARS['cat_id']) )
{
	$cat_id = intval($HTTP_POST_VARS['cat_id']);
}
else if( isset($HTTP_GET_VARS['cat_id']) )
{
	$cat_id = intval($HTTP_GET_VARS['cat_id']);
}
else
{
	mx_message_die(GENERAL_ERROR, 'No categories specified');
}

if (isset ($_POST['smartor_mode']))
{
	$album_view_mode = strtolower($_POST['smartor_mode']);
}
elseif (isset ($_GET['smartor_mode']))
{
	$album_view_mode = strtolower($_GET['smartor_mode']);
}
// make sure that it only contains some valid value
switch ($album_view_mode)
{
	case ALBUM_VIEW_ALL:
		$album_view_mode = ALBUM_VIEW_ALL;
		break;
	case ALBUM_VIEW_LIST:
		$album_view_mode = ALBUM_VIEW_LIST;
		break;
	default:
		$album_view_mode = '';
}
//
// END check request
//


if ($cat_id == PERSONAL_GALLERY)
{
	mx_redirect(mx_append_sid(this_smartor_mxurl("smartor_mode=album_personal")));
}


// Beginning of Jaime's Initials Mod
$letters = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');

// If the variable $initial is set, get all images beggining with $initial
// If $initial is "other" get all images not beggining with any letter
// If $initial is "all" get all images
// If $initial is not set, get all images

$other = 0;
$all = 0;
$where = '';

if ( !empty($_GET['initial']) || !empty($_POST['initial']) )
{
	$initial = ( !empty($_POST['initial']) ) ? $_POST['initial'] : $_GET['initial'];

	if ($initial == 'other') 
   	{ 
      		$other = 1; 
      		foreach ($letters as $let) 
      		{ 
         		$jaime_lettering .= " AND p.pic_title NOT LIKE '" . $let . "%' "; 
      		} 
   	}
	elseif ($initial == 'all')
	{
		$all = 1;
		$jaime_lettering = '';
	}
	else	// if $initial is set and it is not all and is not other -> it is a letter
	{
		$initial_letter = $initial{0};
		$initial = ( $initial != "" ) ? "'" . $initial_letter . "%'" : "'A%'";
		$jaime_lettering = " AND p.pic_title LIKE " . $initial;

	}
}
else	// if initial is not set
{
	$all = 1;
	$jaime_lettering = '';
}
// End of of Jaime's Initials Mod

// ------------------------------------
// Get this cat info (watch out Jaime's Initials Mod includes $jaime_lettering in the query)
// ------------------------------------

// ------------------------------------
// Get this cat info
// ------------------------------------
$sql = "SELECT c.*, COUNT(p.pic_id) AS count
		FROM ". ALBUM_CAT_TABLE ." AS c LEFT JOIN ". ALBUM_TABLE ." AS p ON c.cat_id = p.pic_cat_id
		WHERE c.cat_id <> 0
		$jaime_lettering
		GROUP BY c.cat_id
		ORDER BY cat_order";
if( !($result = $db->sql_query($sql)) )
{
	mx_message_die(GENERAL_ERROR, 'Could not query category information', '', __LINE__, __FILE__, $sql);
}

$thiscat = array(); // this category
$catrows = array(); // all categories for jumpbox
$auth_data  = array(); // the authothentication data for current category for current user

while( $row = $db->sql_fetchrow($result) )
{
	$album_user_access = album_user_access($row['cat_id'], $row, 1, 0, 0, 0, 0, 0); // VIEW
	if ($album_user_access['view'] == 1)
	{
		$catrows[] = $row;

		if( $row['cat_id'] == $cat_id )
		{
			$thiscat = $row;
			$auth_data = album_user_access($cat_id, $row, 1, 1, 1, 1, 1, 1); // ALL
			$total_pics = $thiscat['count'];
		}
	}
}

if (empty($thiscat))
{
	mx_message_die(GENERAL_MESSAGE, $lang['Category_not_exist']);
}

//
// END cat info
//


// ------------------------------------
// Check permissions
// ------------------------------------
if( !$auth_data['view'] )
{
	if (!$userdata['session_logged_in'])
	{
		mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
		redirect(mx_append_sid($phpbb_root_path . "login.$phpEx?redirect=album.php&smartor_mode=album_cat&cat_id=$cat_id"));		
	}
	else
	{
		mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
	}
}
//
// END check permissions
//


// ------------------------------------
// Build Auth List
// ------------------------------------
$auth_key = array_keys($auth_data);

$auth_list = '';
for ($i = 0; $i < (count($auth_data) - 1); $i++) // ignore MODERATOR in this loop
{
	//
	// we should skip a loop if RATE and COMMENT is disabled
	//
	if( ( ($album_config['rate'] == 0) and ($auth_key[$i] == 'rate') ) or ( ($album_config['comment'] == 0) and ($auth_key[$i] == 'comment') ) )
	{
		continue;
	}

	$auth_list .= ($auth_data[$auth_key[$i]] == 1) ? $lang['Album_'. $auth_key[$i] .'_can'] : $lang['Album_'. $auth_key[$i] .'_cannot'];
	$auth_list .= '<br />';
}

// add Moderator Control Panel here
if( ($userdata['user_level'] == ADMIN) or ($auth_data['moderator'] == 1) )
{
	$auth_list .= sprintf($lang['Album_moderate_can'], '<a href="'. mx_append_sid(this_smartor_mxurl("smartor_mode=album_modcp&cat_id=$cat_id")) .'">', '</a>');
}

//
// END Auth List
//


// ------------------------------------
// Build Moderators List
// ------------------------------------

$grouprows = array();
$moderators_list = '';

if ($thiscat['cat_moderator_groups'] != '')
{
	// Get the namelist of moderator usergroups
	$sql = "SELECT group_id, group_name, group_type, group_single_user
			FROM " . GROUPS_TABLE . "
			WHERE group_single_user <> 1
				AND group_type <> ". GROUP_HIDDEN ."
				AND group_id IN (". $thiscat['cat_moderator_groups'] .")
			ORDER BY group_name ASC";
	if ( !$result = $db->sql_query($sql) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not get group list', '', __LINE__, __FILE__, $sql);
	}

	while( $row = $db->sql_fetchrow($result) )
	{
		$grouprows[] = $row;
	}

	if( count($grouprows) > 0 )
	{
		for ($j = 0; $j < count($grouprows); $j++)
		{
			$group_link = '<a href="'. mx_append_sid($phpbb_root_path . "groupcp.$phpEx?". POST_GROUPS_URL .'='. $grouprows[$j]['group_id']) .'">'. $grouprows[$j]['group_name'] .'</a>';

			$moderators_list .= ($moderators_list == '') ? $group_link : ', ' . $group_link;
		}
	}
}

if( empty($moderators_list) )
{
	$moderators_list = $lang['None'];
}
//
// END Moderator List
//


// ------------------------------------
// Build the thumbnail page
// ------------------------------------

if( isset($HTTP_GET_VARS['start']) )
{
	$start = intval($HTTP_GET_VARS['start']);
}
else if( isset($HTTP_POST_VARS['start']) )
{
	$start = intval($HTTP_POST_VARS['start']);
}
else
{
	$start = 0;
}

if( isset($_GET['sort_method']) )
{
	switch ($_GET['sort_method'])
	{
		case 'pic_time':
			$sort_method = 'p.pic_time';
			break;
		case 'p.pic_time':
			$sort_method = 'p.pic_time';
			break;
		case 'pic_title':
			$sort_method = 'p.pic_title';
			break;
		case 'p.pic_title':
			$sort_method = 'p.pic_title';
			break;
		case 'username':
			$sort_method = 'u.username';
			break;
		case 'u.username':
			$sort_method = 'u.username';
			break;
		case 'pic_view_count':
			$sort_method = 'p.pic_view_count';
			break;
		case 'p.pic_view_count':
			$sort_method = 'p.pic_view_count';
			break;
		case 'rating':
			$sort_method = 'rating';
			break;
		case 'comments':
			$sort_method = 'comments';
			break;
		case 'new_comment':
			$sort_method = 'new_comment';
			break;
		default:
			$sort_method = $album_config['sort_method'];
	}
}
elseif( isset($_POST['sort_method']) )
{
	switch ($_POST['sort_method'])
	{
		case 'pic_time':
			$sort_method = 'p.pic_time';
			break;
		case 'p.pic_time':
			$sort_method = 'p.pic_time';
			break;
		case 'pic_title':
			$sort_method = 'p.pic_title';
			break;
		case 'p.pic_title':
			$sort_method = 'p.pic_title';
			break;
		case 'username':
			$sort_method = 'u.username';
			break;
		case 'u.username':
			$sort_method = 'u.username';
			break;
		case 'pic_view_count':
			$sort_method = 'p.pic_view_count';
			break;
		case 'p.pic_view_count':
			$sort_method = 'p.pic_view_count';
			break;
		case 'rating':
			$sort_method = 'rating';
			break;
		case 'comments':
			$sort_method = 'comments';
			break;
		case 'new_comment':
			$sort_method = 'new_comment';
			break;
		default:
			$sort_method = $album_config['sort_method'];
	}
}
else
{
	$sort_method = $album_config['sort_method'];
}

if( isset($HTTP_GET_VARS['sort_order']) )
{
	switch ($HTTP_GET_VARS['sort_order'])
	{
		case 'ASC':
			$sort_order = 'ASC';
			break;
		case 'DESC':
			$sort_order = 'DESC';
			break;
		default:
			$sort_order = $album_config['sort_order'];
	}
}
else if( isset($HTTP_POST_VARS['sort_order']) )
{
	switch ($HTTP_POST_VARS['sort_order'])
	{
		case 'ASC':
			$sort_order = 'ASC';
			break;
		case 'DESC':
			$sort_order = 'DESC';
			break;
		default:
			$sort_order = $album_config['sort_order'];
	}
}
else
{
	$sort_order = $album_config['sort_order'];
}



$pics_per_page = $album_config['rows_per_page'] * $album_config['cols_per_page'];

/*
if ($total_pics > 0)
{
	$limit_sql = ($start == 0) ? $pics_per_page : $start .','. $pics_per_page;

	$pic_approval_sql = 'AND p.pic_approval = 1';
	if ($thiscat['cat_approval'] != ALBUM_USER)
	{
		if( ($userdata['user_level'] == ADMIN) or (($auth_data['moderator'] == 1) and ($thiscat['cat_approval'] == ALBUM_MOD)) )
		{
			$pic_approval_sql = '';
		}
	}
echo 'jaime_lettering:' . $jaime_lettering;
// watch out Jaime's Initials Mod includes $jaime_lettering in the query

	$sql = "SELECT p.pic_id, p.pic_title, p.pic_desc, p.pic_user_id, p.pic_user_ip, p.pic_username, p.pic_time, p.pic_cat_id, p.pic_view_count, p.pic_lock, p.pic_approval, u.user_id, u.username, r.rate_pic_id, AVG(r.rate_point) AS rating, COUNT(DISTINCT c.comment_id) AS comments, MAX(c.comment_id) as new_comment
			FROM ". ALBUM_TABLE ." AS p
				LEFT JOIN ". USERS_TABLE ." AS u ON p.pic_user_id = u.user_id
				LEFT JOIN ". ALBUM_RATE_TABLE ." AS r ON p.pic_id = r.rate_pic_id
				LEFT JOIN ". ALBUM_COMMENT_TABLE ." AS c ON p.pic_id = c.comment_pic_id
			WHERE p.pic_cat_id = '$cat_id' 
			$pic_approval_sql
			$jaime_lettering
			GROUP BY p.pic_id
			ORDER BY $sort_method $sort_order
			LIMIT $limit_sql";
	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query pics information', '', __LINE__, __FILE__, $sql);
	}

	$picrow = array();

	while( $row = $db->sql_fetchrow($result) )
	{
		$picrow[] = $row;
	}


	for ($i = 0; $i < count($picrow); $i += $album_config['cols_per_page'])
	{
		$template->assign_block_vars('picrow', array());

		for ($j = $i; $j < ($i + $album_config['cols_per_page']); $j++)
		{
			if( $j >= count($picrow) )
			{
				break;
			}

			if ($thiscat['cat_approval'] != ALBUM_USER)
			{
				if( ($userdata['user_level'] == ADMIN) or (($auth_data['moderator'] == 1) and ($thiscat['cat_approval'] == ALBUM_MOD)) )
				{
					$approval_mode = ($picrow[$j]['pic_approval'] == 0) ? 'approval' : 'unapproval';

					$approval_link = '<a href="'. mx_append_sid(this_smartor_mxurl("smartor_mode=album_modcp&mode=$approval_mode&pic_id=". $picrow[$j]['pic_id'])) .'">';

					$approval_link .= ($picrow[$j]['pic_approval'] == 0) ? '<b>'. $lang['Approve'] .'</b>' : $lang['Unapprove'];

					$approval_link .= '</a>';
				}
				else
				{
					$approval_link = '';
				}
			}
			else
			{
				$approval_link = '';
			}

			$template->assign_block_vars('picrow.piccol', array(
				'TITLE' => $picrow[$j]['pic_title'],
				'U_PIC' => ($album_config['fullpic_popup']) ? mx_append_sid(this_smartor_mxurl("smartor_mode=album_pic&pic_id=". $picrow[$j]['pic_id'])) : mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=". $picrow[$j]['pic_id'])),
				'THUMBNAIL' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_thumbnail&pic_id=". $picrow[$j]['pic_id'], TRUE)),
				'DESC' => $picrow[$j]['pic_desc'],
				'APPROVAL' => $approval_link,
				)
			);

			if( ($picrow[$j]['user_id'] == ALBUM_GUEST) or ($picrow[$j]['username'] == '') )
			{
				$pic_poster = ($picrow[$j]['pic_username'] == '') ? $lang['Guest'] : $picrow[$j]['pic_username'];
			}
			else
			{
				$pic_poster = '<a href="'. mx_append_sid($phpbb_root_path . "profile?mode=viewprofile&". POST_USERS_URL .'='. $picrow[$j]['user_id']) .'">'. $picrow[$j]['username'] .'</a>';
			}
			
			$image_rating = ImageRating( $picrow[$j]['rating']);
			
			$template->assign_block_vars('picrow.pic_detail', array(
				'TITLE' => $picrow[$j]['pic_title'],
				'POSTER' => $pic_poster,
				'TIME' => create_date($board_config['default_dateformat'], $picrow[$j]['pic_time'], $board_config['board_timezone']),

				'VIEW' => $picrow[$j]['pic_view_count'],

				'RATING' => ($album_config['rate'] == 1) ? ( $lang['Rating'] . ': ' . $image_rating . '<br />') : '',

				'COMMENTS' => ($album_config['comment'] == 1) ? ( $lang['Comments'] . ': ' . $picrow[$j]['comments'] . '<br />') : '',

				'EDIT' => ( ( $auth_data['edit'] and ($picrow[$j]['pic_user_id'] == $userdata['user_id']) ) or ($auth_data['moderator'] and ($thiscat['cat_edit_level'] != ALBUM_ADMIN) ) or ($userdata['user_level'] == ADMIN) ) ? '<a href="'. mx_append_sid(this_smartor_mxurl("smartor_mode=album_edit&pic_id=". $picrow[$j]['pic_id'])) . '">' . $lang['Edit_pic'] . '</a>' : '',

				'DELETE' => ( ( $auth_data['delete'] and ($picrow[$j]['pic_user_id'] == $userdata['user_id']) ) or ($auth_data['moderator'] and ($thiscat['cat_delete_level'] != ALBUM_ADMIN) ) or ($userdata['user_level'] == ADMIN) ) ? '<a href="'. mx_append_sid(this_smartor_mxurl("smartor_mode=album_delete&pic_id=". $picrow[$j]['pic_id'])) . '">' . $lang['Delete_pic'] . '</a>' : '',

				'MOVE' => ($auth_data['moderator']) ? '<a href="'. mx_append_sid(this_smartor_mxurl("smartor_mode=album_modcp&mode=move&pic_id=". $picrow[$j]['pic_id'])) .'">'. $lang['Move'] .'</a>' : '',

				'LOCK' => ($auth_data['moderator']) ? '<a href="'. mx_append_sid(this_smartor_mxurl("smartor_mode=album_modcp&mode=". (($picrow[$j]['pic_lock'] == 0) ? 'lock' : 'unlock') ."&pic_id=". $picrow[$j]['pic_id'])) .'">'. (($picrow[$j]['pic_lock'] == 0) ? $lang['Lock'] : $lang['Unlock']) .'</a>' : '',

//				'IP' => ($userdata['user_level'] == ADMIN) ? $lang['IP_Address'] . ': <a href="http://www.nic.com/cgi-bin/whois.cgi?query=' . decode_ip($picrow[$j]['pic_user_ip']) . '" target="_blank">' . decode_ip($picrow[$j]['pic_user_ip']) .'</a><br />' : ''
				)
			);
		}
	}

// (watch out Jaime's Initials Mod includes $initial in the pagination link)
$initial_mode =  isset($HTTP_GET_VARS['initial']) ? $HTTP_GET_VARS['initial'] : 'all';
	$template->assign_vars(array(
		'PAGINATION' => mx_generate_pagination(mx_append_sid(this_fap_portalurl("smartor_mode=album_cat&cat_id=$cat_id&sort_method=$sort_method&sort_order=$sort_order&initial=$initial_mode")), $total_pics, $pics_per_page, $start),
		'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $pics_per_page ) + 1 ), ceil( $total_pics / $pics_per_page ))
		)
	);
}
else
{
	$template->assign_block_vars('index_pics_block.no_pics', array());
}
*/



// ------------------------------------
// additional sorting options
// ------------------------------------

$sort_rating_option = '';
$sort_username_option = '';
$sort_comments_option = '';
$sort_new_comment_option = '';
if( $album_config['rate'] == 1 )
{
	$sort_rating_option = '<option value="rating" ';
	$sort_rating_option .= ($sort_method == 'rating') ? 'selected="selected"' : '';
	$sort_rating_option .= '>' . $lang['Rating'] .'</option>';
}
if( $album_config['comment'] == 1 )
{
	$sort_comments_option = '<option value="comments" ';
	$sort_comments_option .= ($sort_method == 'comments') ? 'selected="selected"' : '';
	$sort_comments_option .= '>' . $lang['Comments'] .'</option>';

	$sort_new_comment_option = '<option value="new_comment" ';
	$sort_new_comment_option .= ($sort_method == 'new_comment') ? 'selected="selected"' : '';
	$sort_new_comment_option .= '>' . $lang['New_Comment'] .'</option>';
}

if( $album_user_id == ALBUM_PUBLIC_GALLERY )
{
	$sort_username_option = '<option value="username" ';
	$sort_username_option .= ($sort_method == 'pic_user_id') ? 'selected="selected"' : '';
	$sort_username_option .= '>' . $lang['Sort_Username'] .'</option>';
}

// ------------------------------------
// Build Jumpbox
// ------------------------------------
$album_jumpbox = album_build_jumpbox($cat_id, $album_user_id);
// END build jumpbox

global $images;

$current_template_images = $module_root_path . "templates/". $theme['template_name'] ."/images";


$upload_img = $images['upload_pic'];
$jupload_img = $images['jupload_pic'];
$download_img = $images['download_pic'];
$download_all_img = $images['download_all_pic'];

// $upload_link = mx_append_sid(album_append_uid("album_upload.$phpEx?cat_id=$cat_id"));
$upload_link =mx_append_sid(this_smartor_mxurl("smartor_mode=album_upload&cat_id=" . $cat_id));
$jupload_link =mx_append_sid(this_smartor_mxurl("smartor_mode=album_jupload&cat_id=" . $cat_id));
$upload_full_link = '<a href="' . $upload_link . '"><img src="' . $upload_img .'" alt="' . $lang['Upload_Pic'] . '" title="' . $lang['Upload_Pic'] . '" align="middle" border="0" /></a>';
$jupload_full_link = '<a href="' . $jupload_link . '"><img src="' . $jupload_img .'" alt="' . $lang['JUpload_Pic'] . '" title="' . $lang['JUpload_Pic'] . '" align="middle" border="0" /></a>';

// $download_link = mx_append_sid(album_append_uid('album_download.' . $phpEx . '?cat_id=' . $cat_id . ( ($sort_method != '') ? '&sort_method=' . $sort_method : '' ) . ( ($sort_order != '') ? '&sort_order=' . $sort_order : '' ) . ( ($start != '') ? '&start=' . $start : '' )));
// $download_link =mx_append_sid(this_smartor_mxurl("smartor_mode=album_download" . '&cat_id=' . $cat_id . ( ($sort_method != '') ? '&sort_method=' . $sort_method : '' ) . ( ($sort_order != '') ? '&sort_order=' . $sort_order : '' ) . ( ($start != '') ? '&start=' . $start : '' )));
$download_link =mx_append_sid($module_root_path . 'album.' . $phpEx . '?smartor_mode=album_download' . '&cat_id=' . $cat_id . ( ($sort_method != '') ? '&sort_method=' . $sort_method : '' ) . ( ($sort_order != '') ? '&sort_order=' . $sort_order : '' ) . ( ($start != '') ? '&start=' . $start : '' ));
$download_full_link = '<a href="' . $download_link . '"><img src="' . $download_img . '" alt="' . $lang['Download_page'] . '" title="' . $lang['Download_page'] . '" align="middle" border="0" /></a>';

// $download_all_link = mx_append_sid(album_append_uid('album_download.' . $phpEx . '?cat_id=' . $cat_id . ( ($sort_method != '') ? '&sort_method=' . $sort_method : '' ) . ( ($sort_order != '') ? '&sort_order=' . $sort_order : '' ) . '&download_all_pics=true'));
$download_all_link =mx_append_sid(this_smartor_mxurl("smartor_mode=album_download" . '&cat_id=' . $cat_id . ( ($sort_method != '') ? '&sort_method=' . $sort_method : '' ) . ( ($sort_order != '') ? '&sort_order=' . $sort_order : '' ) . '&download_all_pics=true'));
$download_all_full_link = '<a href="' . $download_all_link . '"><img src="' . $download_all_img . '" alt="' . $lang['Download_page'] . '" title="' . $lang['Download_page'] . '" align="middle" border="0" /></a>';

if( $auth_data['upload'] == true )
{
	$enable_picture_upload_switch = true;
	$template->assign_block_vars('enable_picture_upload', array());
}

// Enable download only for own personal galleries
//if ($thiscat['cat_user_id'] == $userdata['user_id'])
if( (($userdata['user_level'] == ADMIN) || (($album_config['show_download'] == 1) && ($auth_data['upload'] == true)) || (($album_config['show_download'] == 2)) ) && ($total_pics > 0))
{
	$enable_picture_download_switch = true;
	$template->assign_block_vars('enable_picture_download', array());
}


//
// Start output of page
//
$page_title = $lang['Album'];

if ( !$is_block )
{
	include($mx_root_path . 'includes/page_header.'.$phpEx);
}
 
$base_url = this_smartor_mxurl("smartor_mode=album_cat&cat_id=$cat_id&sort_method=$sort_method&sort_order=$sort_order&initial=");

$initial_links = '';
$letters = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');

foreach ( $letters as $letter )
{
	if ( ($initial_letter == $letter) && ($other == 0) && ($all == 0) )
	{
		$initial_links .=  '<b>' . $letter . '</b>&nbsp;';
	}
	else
	{
		$initial_links .= '<a href="' . mx_append_sid($base_url . $letter) . '">'. $letter . '</a>&nbsp;';
	}
}

$l_other = ( !empty( $lang['Other'] ) ? $lang['Other'] : 'Other'  );

if ( $other == 1 )
{
	$initial_links .=  '<b>'. $l_other . '</b>&nbsp;';
}
else
{
	$initial_links .= '<a href="' . mx_append_sid($base_url . "other") . '">'. $l_other . '</a>&nbsp;';
}

$l_all = ( !empty( $lang['All'] ) ? $lang['All'] : 'All'  );

if ( $all == 1 )
{
	$initial_links .=  '<b>'. $l_all . '</b>&nbsp;';
}
else
{
	$initial_links .= '<a href="' . mx_append_sid($base_url . "all") . '">'. $l_all . '</a>&nbsp;';
}
 
$template->set_filenames(array(
	'body' => 'album_cat_body.tpl')
);

if ($total_pics > 0)
{
	album_build_picture_table($album_user_id, $cat_id, $thiscat, $auth_data, $start, $sort_method, $sort_order, $total_pics);
		

	// Last Comments
	if ($album_config['show_last_comments'] == 1)
	{
		album_build_last_comments_info($allowed_cat);
	}

	// Recent Public Pics
	if ($album_config['show_recent_in_subcats'] == 1)
	{
		album_build_recent_pics($allowed_cat);
	}

	// Most Viewed Pics
	if ($album_config['disp_mostv'] == 1)
	{
		album_build_most_viewed_pics($allowed_cat);
	}
}
else
{
	// ------------------------------------
	// Build Recent Public Pics
	// ------------------------------------
	$has_sub_cats = album_has_sub_cats($cat_id);
	if ($has_sub_cats && $album_config['show_recent_instead_of_nopics'] == 1)
	{
		album_build_recent_pics($allowed_cat);
	}
	else
	{
		$template->assign_block_vars('index_pics_block', array());
		$template->assign_block_vars('index_pics_block.no_pics', array());
		$template->assign_block_vars('index_pics_block.enable_gallery_title', array());
	}
}
//
// END thumbnails table
//

album_read_tree($album_user_id);
$album_nav_cat_desc = album_make_nav_tree($cat_id, this_smartor_mxurl("smartor_mode=album_cat"), 'nav' , $album_user_id);
if ($album_nav_cat_desc != '')
{
	$album_nav_cat_desc = ALBUM_NAV_ARROW . $album_nav_cat_desc;
}

// Maybe we should also add a new check to see if user really can upload or not
// this is not even in the original code by smartor
	

$template->assign_vars(array(
	'ALBUM_NAV' => $album_nav_cat_desc,
	'L_ALBUM' => $lang['Album'],
		
	'U_VIEW_CAT' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_cat&cat_id=$cat_id")),
	'CAT_TITLE' => $thiscat['cat_title'],

	// 'SLIDESHOW' => '[<a href="' . mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage" . "&pic_id=" . $last_pic_id . "&slideshow=5")) . '">' . $lang['Slideshow'] . '</a>]',


	'ALBUM_NAVIGATION_ARROW' => ALBUM_NAV_ARROW,
	'NAV_CAT_DESC' => $album_nav_cat_desc,

	'L_MODERATORS' => $lang['Moderators'],
	'MODERATORS' => $moderators_list,

	'U_UPLOAD_PIC' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_upload&cat_id=" . $cat_id)),
	'UPLOAD_PIC_IMG' => $images['upload_pic'],
	'L_UPLOAD_PIC' => $lang['Upload_Pic'],
	'UPLOAD_FULL_LINK' => $upload_full_link,
	'JUPLOAD_FULL_LINK' => $jupload_full_link,

	'U_JUPLOAD_PIC' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_jupload&cat_id=" . $cat_id)), 
	'JUPLOAD_PIC_IMG' => $images['jupload_pic'], 
	'L_JUPLOAD_PIC' => $lang['JUpload_Pic'],

	'L_ALBUM_ALLPICS' => $lang['All_Picture_List_Of_User'],
	'L_ALBUM_OTF' => $lang['Pic_Gallery'],
	'U_ALBUM_ALLPICS' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_allpics")),
	'U_ALBUM_OTF' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_otf")),
	
	'L_DOWNLOAD_PICS' => $lang['Download_pics'],
	'L_DOWNLOAD_PAGE' => $lang['Download_page'],
	'U_DOWNLOAD' => $download_link,
	'DOWNLOAD_PIC_IMG' => $download_img,
	'DOWNLOAD_FULL_LINK' => $download_full_link,
	'U_DOWNLOAD_ALL' => $download_all_link,
	'DOWNLOAD_ALL_PIC_IMG' => $download_all_img,
	'DOWNLOAD_ALL_FULL_LINK' => $download_all_full_link,

	'U_MANAGE_PIC' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_personal_cat_admin&cat_id=$cat_id")),
	'MANAGE_PIC_IMG' => $images['manage_pic'],
	'L_MANAGE_PIC' => $lang['manage_Pic'],

	'L_CATEGORY' => $lang['Category'],

	'L_NO_PICS' => $lang['No_Pics'],
	'L_RECENT_PUBLIC_PICS' => $lang['Recent_Public_Pics'],
	'L_HI_RATINGS' => $lang['Highest_Rated_Pictures'],
	'L_MOST_VIEWED' => $lang['Most_Viewed_Pictures'],
	
	'S_COLS' => $album_config['cols_per_page'],
	'S_COL_WIDTH' => (100/$album_config['cols_per_page']) . '%',

	'L_VIEW' => $lang['View'],
	'L_POSTER' => $lang['Poster'],
	'L_POSTED' => $lang['Posted'],

	'ALBUM_JUMPBOX' => $album_jumpbox,

	'NAV_SEP' => $lang['Nav_Separator'],

	'S_ALBUM_ACTION' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_cat&cat_id=$cat_id")),

	'TARGET_BLANK' => ($album_config['fullpic_popup']) ? 'target="_blank"' : '',

	'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'L_ORDER' => $lang['Order'],
	'L_SORT' => $lang['Sort'],

	'L_TIME' => $lang['Time'],
	'L_PIC_TITLE' => $lang['Pic_Title'],
	'L_PIC_ID' => $lang['Pic_ID'],
	'L_USERNAME' => $lang['Sort_Username'],

	'SORT_TIME' => ($sort_method == 'pic_time') ? 'selected="selected"' : '',
	'SORT_PIC_TITLE' => ($sort_method == 'pic_title') ? 'selected="selected"' : '',
	'SORT_USERNAME' => ($sort_method == 'pic_user_id') ? 'selected="selected"' : '',
	'SORT_VIEW' => ($sort_method == 'pic_view_count') ? 'selected="selected"' : '',

	'SORT_RATING_OPTION' => $sort_rating_option,
	'SORT_COMMENTS_OPTION' => $sort_comments_option,
	'SORT_NEW_COMMENT_OPTION' => $sort_new_comment_option,

	'L_ASC' => $lang['Sort_Ascending'],
	'L_DESC' => $lang['Sort_Descending'],

	'SORT_ASC' => ($sort_order == 'ASC') ? 'selected="selected"' : '',
	'SORT_DESC' => ($sort_order == 'DESC') ? 'selected="selected"' : '',

	'S_AUTH_LIST' => $auth_list)
);

// For Jaime's initials mod
if ( $album_sp_config['jaime_lettering'] == 1)
{
	$template->assign_block_vars('lettering', array(
		'L_SELECT_INITIAL'	=> ( !empty( $lang['Select_initial'] ) ? $lang['Select_initial'] : 'Select:'  ),
		'INITIALS'		=> $initial_links
		)
	);
}

//if (empty($album_view_mode))
//{
	$show_personal_gallery_link = ($album_config['show_personal_gallery_link'] == 1) ? true : false;
	album_display_index($album_user_id, $cat_id, true, $show_personal_gallery_link, true);
//}
	
//
// Generate the page
//
$template->pparse('body');

 if ( !$is_block )
 {
	include($mx_root_path . 'includes/page_tail.'.$phpEx);
 }

// +--------------------------------------------------------+
// |  Powered by Photo Album 2.x.x (c) 2002-2003 Smartor    |
// |  with Volodymyr (CLowN) Skoryk's Service Pack 1  2003 |
// +--------------------------------------------------------+

?>