<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_edit.php,v 1.1.2.3 2008/03/13 08:27:30 orynider Exp $
* @copyright (c) 2003 [smartor_xp@hotmail.com, Smartor] Mx-Publisher Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

// MX
if ( !defined('IN_PORTAL') )
{
	die("Hacking attempt");
}

// ------------------------------------
// Check the request
// ------------------------------------

if( isset($HTTP_GET_VARS['pic_id']) )
{
	$pic_id = intval($HTTP_GET_VARS['pic_id']);
}
else if( isset($HTTP_POST_VARS['pic_id']) )
{
	$pic_id = intval($HTTP_POST_VARS['pic_id']);
}
else
{
	mx_message_die(GENERAL_ERROR, 'No pics specified');
}


// ------------------------------------
// Get this pic info
// ------------------------------------

$sql = "SELECT *
		FROM ". ALBUM_TABLE ."
		WHERE pic_id = '$pic_id'";
if( !($result = $db->sql_query($sql)) )
{
	mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
}
$thispic = $db->sql_fetchrow($result);

$cat_id = $thispic['pic_cat_id'];
$user_id = $thispic['pic_user_id'];

$pic_filename = $thispic['pic_filename'];
$pic_thumbnail = $thispic['pic_thumbnail'];

if( empty($thispic) )
{
	mx_message_die(GENERAL_ERROR, $lang['Pic_not_exist']);
}


// ------------------------------------
// Get the current Category Info
// ------------------------------------

if ($cat_id != PERSONAL_GALLERY)
{
	$sql = "SELECT *
			FROM ". ALBUM_CAT_TABLE ."
			WHERE cat_id = '$cat_id'";
	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query category information', '', __LINE__, __FILE__, $sql);
	}

	$thiscat = $db->sql_fetchrow($result);
}
else
{
	$thiscat = init_personal_gallery_cat($user_id);
}

if (empty($thiscat))
{
	mx_message_die(GENERAL_ERROR, $lang['Category_not_exist']);
}


// ------------------------------------
// Check the permissions
// ------------------------------------

$album_user_access = album_user_access($cat_id, $thiscat, 0, 0, 0, 0, 1, 0); // EDIT

if ($album_user_access['edit'] == 0)
{
	if (!$userdata['session_logged_in'])
	{
		mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
		redirect(mx_append_sid($phpbb_root_path ."login.$phpEx?redirect=album.php?smartor_mode=album_edit&pic_id=$pic_id"));
	}
	else
	{
		mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
	}
}
else
{	
	if( (!$album_user_access['moderator']) or ($userdata['user_level'] != ADMIN) )
	{
		if ($thispic['pic_user_id'] != $userdata['user_id'])
		{
			mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
		}
	}
}


/*
+----------------------------------------------------------
| Main work here...
+----------------------------------------------------------
*/

if( !isset($HTTP_POST_VARS['pic_title']) )
{
	//
	// Start output of page
	//
	$page_title = $lang['Album'];
	 if ( !$is_block )
 {
	include($mx_root_path . 'includes/page_header.'.$phpEx);
 }


	$template->set_filenames(array(
		'body' => 'album_edit_body.tpl')
	);

	$template->assign_vars(array(
		'L_EDIT_PIC_INFO' => $lang['Edit_Pic_Info'],

		'CAT_TITLE' => $thiscat['cat_title'],
		'U_VIEW_CAT' => ($cat_id != PERSONAL_GALLERY) ? mx_append_sid(this_smartor_mxurl("smartor_mode=album_cat&cat_id=$cat_id")) : mx_append_sid(this_smartor_mxurl("smartor_mode=album_personal&user_id=$user_id")),

		'L_PIC_TITLE' => $lang['Pic_Title'],
		'PIC_TITLE' => $thispic['pic_title'],
		'PIC_DESC' => $thispic['pic_desc'],

		'L_PIC_DESC' => $lang['Pic_Desc'],
		'L_PLAIN_TEXT_ONLY' => $lang['Plain_text_only'],
		'L_MAX_LENGTH' => $lang['Max_length'],

		'L_UPLOAD_NO_TITLE' => $lang['Upload_no_title'],
		'L_DESC_TOO_LONG' => $lang['Desc_too_long'],
		'S_PIC_DESC_MAX_LENGTH' => $album_config['desc_length'],

		'L_RESET' => $lang['Reset'],
		'L_SUBMIT' => $lang['Submit'],

		'S_ALBUM_ACTION' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_edit&pic_id=$pic_id")),
		)
	);

	//
	// Generate the page
	//
	$template->pparse('body');

	 if ( !$is_block )
 {
	include($mx_root_path . 'includes/page_tail.'.$phpEx);
 }

}
else
{
	// --------------------------------
	// Check posted info
	// --------------------------------

	$pic_title = str_replace("\'", "`", htmlspecialchars(trim($HTTP_POST_VARS['pic_title'])));

	//Added by GH 
	$pic_title = addslashes($pic_title);

	$pic_title = str_replace("'", "`", $pic_title);

	$pic_desc = str_replace("\'", "`", htmlspecialchars(substr(trim($HTTP_POST_VARS['pic_desc']), 0, $album_config['desc_length'])));

	//Added by GH 
	$pic_desc = addslashes($pic_desc);

	$pic_desc = str_replace("'", "`", $pic_desc);

	if( empty($pic_title) )
	{
		mx_message_die(GENERAL_ERROR, $lang['Missed_pic_title']);
	}


	// --------------------------------
	// Update the DB
	// --------------------------------

	$sql = "UPDATE ". ALBUM_TABLE ."
			SET pic_title = '$pic_title', pic_desc= '$pic_desc'
			WHERE pic_id = '$pic_id'";
	if( !$result = $db->sql_query($sql) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not update pic information', '', __LINE__, __FILE__, $sql);
	}


	// --------------------------------
	// Complete... now send a message to user
	// --------------------------------

	$message = $lang['Pics_updated_successfully'];

	if ($cat_id != PERSONAL_GALLERY)
	{
		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="3;url=' . mx_append_sid(this_smartor_mxurl("smartor_mode=album_cat&cat_id=$cat_id")) . '">')
		);

		$message .= "<br /><br />" . sprintf($lang['Click_return_category'], "<a href=\"" . mx_append_sid(this_smartor_mxurl("smartor_mode=album_cat&cat_id=$cat_id")) . "\">", "</a>");
	}
	else
	{
		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="3;url=' . mx_append_sid(this_smartor_mxurl("smartor_mode=album_personal")) . '">')
		);

		$message .= "<br /><br />" . sprintf($lang['Click_return_personal_gallery'], "<a href=\"" . mx_append_sid(this_smartor_mxurl("smartor_mode=album_personal")) . "\">", "</a>");
	}

	$message .= "<br /><br />" . sprintf($lang['Click_return_album_index'], "<a href=\"" . mx_append_sid(this_smartor_mxurl()) . "\">", "</a>");

	mx_message_die(GENERAL_MESSAGE, $message);

}


// +------------------------------------------------------+
// |  Powered by Photo Album 2.x.x (c) 2002-2003 Smartor  |
// +------------------------------------------------------+

?>