<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_page.php,v 1.1.2.3 2008/03/13 08:27:31 orynider Exp $
* @copyright (c) 2002-2006 [Smartor, Volodymyr (CLowN) Skoryk, IdleVoid, Jon Ohlsson] Mx-Publisher Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/

// +-------------------------------------------------------------+
// |  Powered by Photo Album 2.x.x (c) 2002-2003 Smartor         |
// |  with Volodymyr (CLowN) Skoryk's Service Pack 1  2003-2004 |
// +-------------------------------------------------------------+



// MX
if ( !defined('IN_PORTAL') )
{
	die("Hacking attempt");
}

if( $module_root_path =  '' )
{
	$module_root_path = '../';
	$mx_root_path = $module_root_path . '../../';
}

// ------------------------------------
// Check the request
// ------------------------------------

if( isset($HTTP_GET_VARS['pic_id']) )
{
	$pic_id = intval($HTTP_GET_VARS['pic_id']);
}
else if( isset($HTTP_POST_VARS['pic_id']) )
{
	$pic_id = intval($HTTP_POST_VARS['pic_id']);
}
else
{
	mx_message_die(GENERAL_ERROR, 'No pic_id set');
}


// ------------------------------------
// PREVIOUS & NEXT
// ------------------------------------

if( isset($HTTP_GET_VARS['mode']) )
{
	if( ($HTTP_GET_VARS['mode'] == 'next') or ($HTTP_GET_VARS['mode'] == 'previous') )
	{
		$sql = "SELECT pic_id, pic_cat_id, pic_user_id
				FROM ". ALBUM_TABLE ."
				WHERE pic_id = $pic_id";

		if( !($result = $db->sql_query($sql)) )
		{
			mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
		}

		$row = $db->sql_fetchrow($result);

		if( empty($row) )
		{
			mx_message_die(GENERAL_ERROR, 'Bad pic_id');
		}

		$sql = "SELECT new.pic_id, new.pic_time
				FROM ". ALBUM_TABLE ." AS new, ". ALBUM_TABLE ." AS cur
				WHERE cur.pic_id = $pic_id
					AND new.pic_id <> cur.pic_id
					AND new.pic_cat_id = cur.pic_cat_id";

		$sql .= ($HTTP_GET_VARS['mode'] == 'next') ? " AND new.pic_time >= cur.pic_time" : " AND new.pic_time <= cur.pic_time";

		$sql .= ($row['pic_cat_id'] == PERSONAL_GALLERY) ? " AND new.pic_user_id = cur.pic_user_id" : "";

		$sql .= ($HTTP_GET_VARS['mode'] == 'next') ? " ORDER BY pic_time ASC LIMIT 1" : " ORDER BY pic_time DESC LIMIT 1";

		if( !($result = $db->sql_query($sql)) )
		{
			mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
		}

		$row = $db->sql_fetchrow($result);

		if( empty($row) )
		{
			mx_message_die(GENERAL_ERROR, $lang['Pic_not_exist']);
		}

		$pic_id = $row['pic_id']; // NEW pic_id
	}
}


// ------------------------------------
// Get this pic info
// ------------------------------------

$sql = "SELECT p.*, u.user_id, u.username, r.rate_pic_id, AVG(r.rate_point) AS rating, COUNT(DISTINCT c.comment_id) AS comments
		FROM ". ALBUM_TABLE ." AS p
			LEFT JOIN ". USERS_TABLE ." AS u ON p.pic_user_id = u.user_id
			LEFT JOIN ". ALBUM_RATE_TABLE ." AS r ON p.pic_id = r.rate_pic_id
			LEFT JOIN ". ALBUM_COMMENT_TABLE ." AS c ON p.pic_id = c.comment_pic_id
		WHERE pic_id = '$pic_id'
		GROUP BY p.pic_id";
if( !($result = $db->sql_query($sql)) )
{
	mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
}
$thispic = $db->sql_fetchrow($result);

$cat_id = $thispic['pic_cat_id'];
$user_id = $thispic['pic_user_id'];

if( empty($thispic) or !file_exists(ALBUM_UPLOAD_PATH . $pic_filename) )
{
	mx_message_die(GENERAL_ERROR, $lang['Pic_not_exist']);
}


// ------------------------------------
// Get the current Category Info
// ------------------------------------

if ($cat_id != PERSONAL_GALLERY)
{
	$sql = "SELECT *
			FROM ". ALBUM_CAT_TABLE ."
			WHERE cat_id = '$cat_id'";
	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query category information', '', __LINE__, __FILE__, $sql);
	}

	$thiscat = $db->sql_fetchrow($result);
}
else
{
	$thiscat = init_personal_gallery_cat($user_id);
}

if (empty($thiscat))
{
	mx_message_die(GENERAL_ERROR, $lang['Category_not_exist']);
}


// ------------------------------------
// Check the permissions
// ------------------------------------

$album_user_access = album_user_access($cat_id, $thiscat, 1, 0, 0, 0, 0, 0); // VIEW

if ($album_user_access['view'] == 0)
{
	if (!$userdata['session_logged_in'])
	{
		mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
		redirect(mx_append_sid($phpbb_root_path ."login.$phpEx?redirect=album.php?smartor_mode=album_page&pic_id=$pic_id"));
	}
	else
	{
		mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
	}
}



// ------------------------------------
// Check Pic Approval
// ------------------------------------

if ($userdata['user_level'] != ADMIN)
{
	if( ($thiscat['cat_approval'] == ADMIN) or (($thiscat['cat_approval'] == MOD) and !$album_user_access['moderator']) )
	{
		if ($thispic['pic_approval'] != 1)
		{
			mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
		}
	}
}


/*
+----------------------------------------------------------
| Main work here...
+----------------------------------------------------------
*/

//
// Start output of page
//
$page_title = $lang['Album'];
 if ( !$is_block )
 {
	include($mx_root_path . 'includes/page_header.'.$phpEx);
 }


$template->set_filenames(array(
	'body' => 'album_page_body.tpl')
);

if( ($thispic['pic_user_id'] == ALBUM_GUEST) or ($thispic['username'] == '') )
{
	$poster = ($thispic['pic_username'] == '') ? $lang['Guest'] : $thispic['pic_username'];
}
else
{
	$poster = '<a href="'. mx_append_sid($phpbb_root_path ."profile.$phpEx?mode=viewprofile&amp;". POST_USERS_URL .'='. $thispic['user_id']) .'">'. $thispic['username'] .'</a>';
}


$template->assign_vars(array(
	'CAT_TITLE' => $thiscat['cat_title'],
	'U_VIEW_CAT' => ($cat_id != PERSONAL_GALLERY) ? mx_append_sid(this_smartor_mxurl("smartor_mode=album_cat&cat_id=$cat_id")) : mx_append_sid(this_smartor_mxurl("smartor_mode=album_personal&user_id=$user_id")),

	'U_PIC' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_pic&pic_id=$pic_id")),

	'PIC_TITLE' => $thispic['pic_title'],
	'PIC_DESC' => nl2br($thispic['pic_desc']),

	'POSTER' => $poster,

	'PIC_TIME' => create_date($board_config['default_dateformat'], $thispic['pic_time'], $board_config['board_timezone']),

	'PIC_VIEW' => $thispic['pic_view_count'],

	'PIC_RATING' => ($thispic['rating'] != 0) ? round($thispic['rating'], 2) : $lang['Not_rated'],

	'PIC_COMMENTS' => $thispic['comments'],

	'U_RATE' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_rate&pic_id=$pic_id")),
	'U_COMMENT' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_comment&pic_id=$pic_id")),

	'U_NEXT' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_page&pic_id=$pic_id&amp;mode=next")),
	'U_PREVIOUS' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_page&pic_id=$pic_id&amp;mode=previous")),

	'L_NEXT' => $lang['Next'],
	'L_PREVIOUS' => $lang['Previous'],

	'L_RATING' => $lang['Rating'],
	'L_PIC_TITLE' => $lang['Pic_Title'],
	'L_PIC_DESC' => $lang['Pic_Desc'],
	'L_POSTER' => $lang['Poster'],
	'L_POSTED' => $lang['Posted'],
	'L_VIEW' => $lang['View'],
	'L_COMMENTS' => $lang['Comments'])
);

if ($album_config['rate'])
{
	$template->assign_block_vars('rate_switch', array());
}

if ($album_config['comment'])
{
	$template->assign_block_vars('comment_switch', array());
}

//
// Generate the page
//
$template->pparse('body');

 if ( !$is_block )
 {
	include($mx_root_path . 'includes/page_tail.'.$phpEx);
 }



// +------------------------------------------------------+
// |  Powered by Photo Album 2.x.x (c) 2002-2003 Smartor  |
// +------------------------------------------------------+

?>