<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_search.php,v 1.1.2.3 2008/03/13 08:27:32 orynider Exp $
* @copyright (c) 2002-2006 [Smartor, Volodymyr (CLowN) Skoryk, IdleVoid, Jon Ohlsson] Mx-Publisher Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/



$phpEx = substr(strrchr(__FILE__, '.'), 1);
include_once($mx_root_path . 'common.'.$phpEx);

//
// Start session management
//
$mx_user->init($user_ip, PAGE_INDEX);
// End session management

define('ALBUM_MOD_PATH', 'album_mod/');

if (!isset($album_root_path) || empty($album_root_path))
{
	$album_root_path = $module_root_path . ALBUM_MOD_PATH . '';
}

include($album_root_path . 'album_common.'.$phpEx);

$page_title = !empty($lang['Search']) ? $lang['Search'] : 'Album Search';

// MX
if ( !defined('IN_PORTAL') )
{
	die("Hacking attempt");
}
	
  if ( !$is_block )
  {
	include($mx_root_path . 'includes/page_header.'.$phpEx);
  }

$template->set_filenames(array(
	'body' => 'album_search_body.tpl'
	)
);

if (( isset($_POST['search']) || isset($_GET['search']) ) && ( $_POST['search'] != '' || $_GET['search'] != '' ))
{
	$template->assign_block_vars('switch_search_results', array());

	if ( isset($_POST['mode']) )
	{
		$m = $_POST['mode'];
	}
	elseif ( isset($_GET['mode']) )
	{
		$m = $_GET['mode'];
	}
	else
	{
		message_die(GENERAL_ERROR, 'Bad request');
	}

	if ( isset($_POST['search']) )
	{
		$s = mysql_real_escape_string($_POST['search']);
	}
	elseif ( isset($_GET['search']) )
	{
		$s = mysql_real_escape_string($_GET['search']);
	}

	if ($m == 'user')
	{
		$where = 'p.pic_username';
	}
	elseif ($m == 'name')
	{
		$where = 'p.pic_title';
	}
	elseif ($m == 'desc')
	{
		$where = 'p.pic_desc';
	}
	else
	{
		mx_message_die(GENERAL_ERROR, 'Bad request');
	}

	// --------------------------------
	// Pagination
	// --------------------------------

	// Number of matches displayed
	$pics_per_page = $album_config['rows_per_page'] * $album_config['cols_per_page'];
	if ($pics_per_page == 0)
	{
		$pics_per_page = 20;
	}
	//$pics_per_page = 4;

	if (isset ($_GET['start']))
	{
		$start = intval($_GET['start']);
	}
	elseif (isset ($_POST['start']))
	{
		$start = intval($_POST['start']);
	}
	else
	{
		$start = 0;
	}

	// ------------------------------------
	// Count pic matches
	// ------------------------------------

	if ( ($album_config['personal_gallery_view'] == -1) || ($userdata['user_level'] == ADMIN))
	{
		$search_pg = '';
	}
	else
	{
		$search_pg = 'AND c.cat_user_id = 0';
	}
	$limit_sql = ($start == 0) ? $pics_per_page : $start . ',' . $pics_per_page;
	$count_sql = "SELECT COUNT(pic_id) AS count
								FROM " . ALBUM_TABLE . ' AS p,' . ALBUM_CAT_TABLE . " AS c
								WHERE p.pic_approval = 1
								AND " . $where .  " LIKE '%" . $s . "%'
								" . $search_pg . "
								AND p.pic_cat_id = c.cat_id";

	if( !($result = $db->sql_query($count_sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not count '.$m, '', __LINE__, __FILE__, $count_sql);
	}

	$row = $db->sql_fetchrow($result);

	$total_pics = $row['count'];

	$sql = "SELECT p.pic_id, p.pic_title, p.pic_desc, p.pic_user_id, p.pic_username, p.pic_time, p.pic_cat_id, p.pic_approval, c.cat_id, c.cat_title, c.cat_user_id
			FROM " . ALBUM_TABLE . ' AS p,' . ALBUM_CAT_TABLE . " AS c
			WHERE p.pic_approval = 1
				AND " . $where .  " LIKE '%" . $s . "%'
				AND p.pic_cat_id = c.cat_id
				" . $search_pg . "
			ORDER BY p.pic_time DESC LIMIT ".$limit_sql."";

	if ( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, "Couldn't obtain a list of matching information (searching for: $search)", "", __LINE__, __FILE__, $sql);
	}

	$numres = 0;

	if ( $row = $db->sql_fetchrow($result) )
	{
		$in = array();
		do
		{
			if ( !in_array($row['pic_id'], $in) )
			{
				$album_user_id = $row['cat_user_id'];
				$cat_id = $row['cat_id'];
				//$cat_id = album_get_personal_root_id($album_user_id);

				$check_permissions = ALBUM_AUTH_VIEW|ALBUM_AUTH_RATE|ALBUM_AUTH_COMMENT|ALBUM_AUTH_EDIT|ALBUM_AUTH_DELETE;
				$auth_data = album_permissions($album_user_id, $cat_id, $check_permissions, $row);
				//$auth_data = album_get_auth_data($cat_id);

				if ($album_config['lb_preview'] == 0)
				{
					$pic_preview = '';
				}
				else
				{
					$pic_preview = 'onmouseover="showtrail(\''. mx_append_sid(this_fap_addonurl("smartor_mode=album_picm&pic_id=" . $row['pic_id'])) . '\',\'' . addslashes($row['pic_title']) . '\', ' . $album_sp_config['midthumb_width'] . ', ' . $album_sp_config['midthumb_height'] . ')" onmouseout="hidetrail()"';
				}

				//if( !$auth_data['view'] )
				if ( $auth_data['view'] >= 0 )
				{
					$template->assign_block_vars('switch_search_results.search_results', array(
						'L_USERNAME' => $row['pic_username'],
						'U_PROFILE' => mx_append_sid($phpbb_root_path . 'profile.' . $phpEx . '?mode=viewprofile&u=' . $row['pic_user_id']),

						'L_CAT' => ($row['cat_user_id'] != ALBUM_PUBLIC_GALLERY ) ? $lang['Users_Personal_Galleries'] : $row['cat_title'],
						'U_CAT' => ($row['pic_cat_id'] == 0 ) ? mx_append_sid(this_smartor_mxurl('smartor_mode=album_personal&user_id=' . $row['pic_user_id'])) : mx_append_sid(this_smartor_mxurl('smartor_mode=album_cat&cat_id=' . $row['cat_id'])),
						//'U_CAT' => ($row['cat_id'] == $cat_id) ? mx_append_sid(this_smartor_mxurl('smartor_mode=album_cat' . '&cat_id=' . $row['cat_id'])) : mx_append_sid(this_smartor_mxurl()),

						'L_PIC' => $row['pic_title'],
						'U_PIC' => mx_append_sid(this_smartor_mxurl('smartor_mode=album_showpage&pic_id=' . $row['pic_id'])),
						//'U_PIC' => ($album_config['fullpic_popup'] == 1) ? mx_append_sid(this_smartor_mxurl('smartor_mode=album_pic' . '&pic_id=' . $row['pic_id'])) : mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage" . '&pic_id=' . $row['pic_id'])),
						'THUMBNAIL' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_thumbnail&pic_id=". $row['pic_id'], TRUE)),
						//'THUMBNAIL' => mx_append_sid(album_append_uid($module_root_path. 'includes/album_thumbnail.' . $phpEx . '?pic_id=' . $row['pic_id'])),
						'PIC_PREVIEW' => $pic_preview,
						'DESC' => $row['pic_desc'],
						'L_TIME' => create_date($board_config['default_dateformat'], $row['pic_time'], $board_config['board_timezone'])
						)
					);

					$in[$numres] = $row['pic_id'];
					$numres++;
				}
			}
		}
		while( $row = $db->sql_fetchrow($result) );

		$template->assign_vars(array(
			'L_NRESULTS' => $numres,
			'L_TRESULTS' => $total_pics,
			'IMG_FOLDER' => $images['folder'],
			'L_TCATEGORY' => $lang['Pic_Cat'],
			'L_TTITLE' => $lang['Pic_Image'],
			'L_TSUBMITER' => $lang['Author'],
			'L_TSUBMITED' => $lang['Time']
			)
		);
	}
	else
	{
		mx_message_die(GENERAL_MESSAGE, $lang['No_search_match']);
	}
}
else
{
	$template->assign_block_vars('switch_search', array());
}

// --------------------------------
// Pagination
// --------------------------------

$template->assign_vars(array(
	'PAGINATION' => mx_generate_pagination(mx_append_sid(this_smartor_mxurl("smartor_mode=album_search&mode=" . $m . "&amp;search=" . $s)), $total_pics, $pics_per_page, $start),
	'PAGE_NUMBER' => sprintf($lang['Page_of'], (floor($start / $pics_per_page) + 1), ceil($total_pics / $pics_per_page))
	)
);

$template->pparse('body');

if ( !$is_block )
{
	include($mx_root_path . 'includes/page_tail.'.$phpEx);
}

?>