<?php
/**
*
* @package Mx-Publisher Module - mx_smartor
* @version $Id: album_showpage.php,v 1.1.2.3 2008/03/13 08:27:32 orynider Exp $
* @copyright (c) 2002-2006 [Smartor, Volodymyr (CLowN) Skoryk, IdleVoid, Jon Ohlsson] Mx-Publisher Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
*
*/


// MX
if ( !defined('IN_PORTAL') )
{
	die("Hacking attempt");
}

if ( $mode == 'smilies' )
{
	include_once($phpbb_root_path . 'includes/functions_post.'.$phpEx);

	smartor_generate_smilies('window', PAGE_POSTING);
	exit;
}

include_once($phpbb_root_path . 'includes/functions_validate.'.$phpEx);


//
// Get general album information
//
if ( !defined('ALBUM_MOD_PATH') )
{
	define('ALBUM_MOD_PATH', 'album_mod/');
}

if (!isset($album_root_path) || empty($album_root_path))
{
	$album_root_path = $module_root_path . ALBUM_MOD_PATH . '';
}

if ( defined('IS_PHPBBXS') )
{
	include_once($phpbb_root_path . 'includes/functions_color_groups.' . $phpEx);
	include_once($phpbb_root_path . 'includes/bbcode.' . $phpEx);

	if ( isset($_POST['message']) )
	{
		$_POST['comment'] = $_POST['message'];
	}
}
else
{
	if ($album_config['album_bbcode'] == 1)
	{
		include_once($album_root_path . 'includes/album_bbcode.' . $phpEx);
	}
}

if( !function_exists('smilies_pass'))
{
	include_once($phpbb_root_path . 'includes/bbcode.'.$phpEx);
}

// ------------------------------------
// Check feature enabled
// ------------------------------------

if( $album_config['comment'] == 0 )
{
	mx_message_die(GENERAL_MESSAGE, $lang['Not_Authorised']);
}

if( isset($_GET['mode']) && $_GET['mode'] == 'smilies' )
{
	if ( defined('IS_PHPBBXS') )
	{
		generate_smilies('window', PAGE_ALBUM_PICTURE);
		exit;
	}
	else
	{
		generate_smilies_album('window', PAGE_ALBUM_PICTURE);
		exit;
	}
}


// ------------------------------------
// Check the request
// ------------------------------------

if( isset($_GET['pic_id']) || isset($_POST['pic_id']) )
{
	$pic_id = ( isset($_GET['pic_id']) ) ? intval($_GET['pic_id']) : intval($_POST['pic_id']);
}
else
{
	if( isset($_GET['comment_id']) || isset($_POST['comment_id']) )
	{
		$pic_id = ( isset($_GET['pic_id']) ) ? intval($_GET['pic_id']) : intval($_POST['pic_id']);
		$comment_id = (isset($_GET['comment_id'])) ? intval($_GET['comment_id']) : intval($_POST['comment_id']);
	}
	else
	{
		mx_message_die(GENERAL_ERROR, 'Bad request');
	}
}

// Midthumb & Full Pic
if( isset($_GET['full']) || isset($_POST['full']) )
{
	$picm = false;
	$full_size_param = '&amp;full=true';
}
else
{
	if ($album_sp_config['midthumb_use'] == 1)
	{
		$picm = true;
		$full_size_param = '&amp;full=false';
	}
	else
	{
		$picm = false;
		$full_size_param = '&amp;full=true';
	}
}

if( isset($_GET['sort_method']) || isset($_POST['sort_method']) )
{
	$sort_method = (isset($_GET['sort_method'])) ? $_GET['sort_method'] : $_POST['sort_method'];
	$sort_method = ( ($sort_method == 'comments') || ($sort_method == 'rating') )? $album_config['sort_method'] : $sort_method;
}
else
{
	$sort_method = $album_config['sort_method'];
}

if( isset($_GET['sort_order']) || isset($_POST['sort_order']) )
{
	$sort_order = (isset($_GET['sort_order'])) ? $_GET['sort_order'] : $_POST['sort_order'];
}
else
{
	$sort_order = $album_config['sort_order'];
}

$sort_append = '&amp;sort_method=' . $sort_method . '&amp;sort_order=' . $sort_order;

// ------------------------------------
// TEMPLATE ASSIGNEMENT
// ------------------------------------
if ((isset($_GET['slideshow']) && (intval($_GET['slideshow']) > 0)) || (isset($_POST['slideshow']) && (intval($_POST['slideshow']) > 0)))
{
	$gen_simple_header = true;
	$show_template = 'album_slideshow_body.tpl';
	$nuffimage_pic = ( $picm == false ) ? 'album_pic' : 'album_picm';
	$nuffimage_vars = '';
}
else
{
	//$show_template = 'album_showpage_body.tpl';
	if ( (isset($_GET['nuffimage']) || isset($_POST['nuffimage'])) && ($album_config['enable_nuffimage'] == 1) )
	{
		require($album_root_path . 'includes/album_nuffimage_box.' . $phpEx);
		$template->assign_var_from_handle('NUFFIMAGE_BOX', 'nuffimage_box');
		$show_template = 'album_pic_nuffed_body.tpl';
		$nuffimage_vars = '&amp;nuffimage=true';
		$nuffimage_pic = 'album_pic_nuffed';
		$nuff_http_full_string = $nuff_http['full_string'];
		$template->assign_block_vars('disable_pic_nuffed', array(
			'L_PIC_UNNUFFED_CLICK' => $lang['Nuff_UnClick'],
			'U_PIC_UNNUFFED_CLICK' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage" . '&pic_id=' . $pic_id . $full_size_param)),
			)
		);
	}
	else
	{
		$show_template = 'album_showpage_body.tpl';
		$nuffimage_vars = '';
		$nuffimage_pic = ( $picm == false ) ? 'album_pic' : 'album_picm';
		$nuff_http_full_string = '';
	}
}


// ------------------------------------
// PREVIOUS / NEXT / PICS NAV
// ------------------------------------
$nav_mode = $mx_request_vars->request('mode', MX_TYPE_NO_TAGS, '');
if( isset($_GET['mode']) )
{
	//if( ($_GET['mode'] == 'next') && ($no_next_pic == false) )
	if($nav_mode == 'next')
	{
		//$pic_id = $next_pic_id[0];
		$sql_where = 'AND n.pic_id > c.pic_id';
		$sql_order = 'ORDER BY n.pic_id ASC LIMIT 1';

	}

	//if( ($_GET['mode'] == 'prev') && ($no_prev_pic == false) )
	if($nav_mode == 'prev')
	{
		//$pic_id = $prev_pic_id[0];
		$sql_where = 'AND n.pic_id < c.pic_id';
		$sql_order = 'ORDER BY n.pic_id DESC LIMIT 1';
	}

	$sql = "SELECT n.pic_id, n.pic_cat_id, n.pic_user_id, n.pic_time
			FROM ". ALBUM_TABLE ." as n, ". ALBUM_TABLE ." AS c
			WHERE c.pic_id = $pic_id
				$sql_where
			AND n.pic_cat_id = c.pic_cat_id
				$sql_order";
	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
				
}
else if (($mx_cache->get('thispic'.$pic_id)) && ($use_cache))
{
	$row = $mx_cache->get('thispic'.$pic_id);
}
else
{
	$sql = "SELECT * FROM " . ALBUM_TABLE . "  WHERE pic_id = '$pic_id'";

	if (!($result = $db->sql_query($sql)))
	{
		if (!function_exists('mx_message_die'))
		{
			die("Couldnt query smartor album pic information, Allso this hosting or server is using a cache optimizer not compatible with MX-Publisher or just lost connection to database wile query.");
		}
		else
		{
			mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
		}
	}
	
	$row = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);

	if ($use_cache)
	{
		$mx_cache->put('thispic'.$pic_id, $row);
	}
}

if(empty($row))
{
	mx_message_die(GENERAL_ERROR, $lang['Pic_not_exist']);
}

$pic_id_old = $pic_id;
$pic_id_tmp = $row['pic_id'];
$pic_cat_id_tmp = $row['pic_cat_id'];
$pic_time_tmp = $row['pic_time'];
$pic_user_id_tmp = $row['pic_user_id'];

if (($nav_mode == 'next') || ($nav_mode == 'prev'))
{
	$pic_id = $pic_id_tmp;
}

if ($album_config['show_pics_nav'] == 1)
{
	$template->assign_block_vars('pics_nav', array(
		'L_PICS_NAV' => $lang['Pics_Nav'],
		'L_PICS_NAV_NEXT' => $lang['Pics_Nav_Next'],
		'L_PICS_NAV_PREV' => $lang['Pics_Nav_Prev'],
		)
	);
}
// NEXT
$sql = "SELECT a.*
		FROM " . ALBUM_TABLE . " AS a
		WHERE a.pic_id > " . $pic_id_tmp . "
			AND a.pic_cat_id = " . $pic_cat_id_tmp . "
			AND a.pic_approval = 1
		ORDER BY pic_id ASC LIMIT 2";

if( !($result = $db->sql_query($sql)) )
{
	mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
}

//$row = $db->sql_fetchrow($result);
$next_pic_count = $db->sql_numrows($result);
$next_pic_rows = $db->sql_fetchrowset($result);
$db->sql_freeresult($result);

if ($next_pic_count == 0)
{
	$no_next_pic = true;

	$sql = "SELECT a.*
			FROM " . ALBUM_TABLE . " AS a
			WHERE a.pic_cat_id = " . $pic_cat_id_tmp . "
				AND a.pic_approval = 1
			ORDER BY pic_id ASC LIMIT 1";

	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);
	$first_pic_id = $row['pic_id'];
	$db->sql_freeresult($result);
}
else
{
	$no_next_pic = false;
	if ( $album_config['invert_nav_arrows'] == 0 )
	{
		for($i = $next_pic_count - 1; $i >= 0; $i--)
		{
			$next_pic_id[$i] = $next_pic_rows[$i]['pic_id'];
			$thumbnail_file = mx_append_sid(this_smartor_mxurl('smartor_mode=album_thumbnail&pic_id=' . $next_pic_id[$i], true));
			if ( ($album_config['thumbnail_cache'] == true) && ($album_config['quick_thumbs'] == true) )
			{
				$pic_filename = $next_pic_rows[$i]['pic_filename'];
				$pic_filetype = strtolower(substr($pic_filename, strlen($pic_filename) - 4, 4));
				$pic_thumbnail = ( $next_pic_rows[$i]['pic_thumbnail'] == '' ) ? md5($pic_filename) . $pic_filetype : $next_pic_rows[$i]['pic_thumbnail'];
				//$pic_thumbnail = ( $next_pic_rows[$i]['pic_thumbnail'] == '' ) ? $pic_filename : $next_pic_rows[$i]['pic_thumbnail'];
				$pic_thumbnail_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail;
				if ( file_exists($pic_thumbnail_fullpath) )
				{
					$thumbnail_file = $pic_thumbnail_fullpath;
				}
			}
			if ($album_config['lb_preview'] == 0)
			{
				$pic_preview = '';
			}
			else
			{
				$pic_preview = 'onmouseover="showtrail(\''. mx_append_sid(this_smartor_mxurl('smartor_mode=album_picm&?pic_id=' . $next_pic_rows[$i]['pic_id'], true)) . '\',\'' . addslashes($next_pic_rows[$i]['pic_title']) . '\', ' . $album_config['midthumb_width'] . ', ' . $album_config['midthumb_height'] . ')" onmouseout="hidetrail()"';
			}
			if ($album_config['show_pics_nav'] == 1)
			{
				$template->assign_block_vars('pics_nav.next', array(
					'U_PICS_THUMB' => $thumbnail_file,
					'U_PICS_LINK' => mx_append_sid(this_smartor_mxurl('smartor_mode=album_showpage&pic_id=' . $next_pic_id[$i] . $full_size_param . $nuffimage_vars, false)),
					'PIC_PREVIEW' => $pic_preview,
					)
				);
			}
		}
	}
	else
	{
		for($i = 0; $i < $next_pic_count; $i++)
		{
			$next_pic_id[$i] = $next_pic_rows[$i]['pic_id'];
			$thumbnail_file = mx_append_sid(this_smartor_mxurl('smartor_mode=album_thumbnail&pic_id=' . $next_pic_id[$i], true));
			if ( ($album_config['thumbnail_cache'] == true) && ($album_config['quick_thumbs'] == true) )
			{
				$pic_filename = $next_pic_rows[$i]['pic_filename'];
				$pic_filetype = strtolower(substr($pic_filename, strlen($pic_filename) - 4, 4));
				$pic_thumbnail = ( $next_pic_rows[$i]['pic_thumbnail'] == '' ) ? md5($pic_filename) . $pic_filetype : $next_pic_rows[$i]['pic_thumbnail'];
				//$pic_thumbnail = ( $next_pic_rows[$i]['pic_thumbnail'] == '' ) ? $pic_filename : $next_pic_rows[$i]['pic_thumbnail'];
				$pic_thumbnail_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail;
				if ( file_exists($pic_thumbnail_fullpath) )
				{
					$thumbnail_file = $pic_thumbnail_fullpath;
				}
			}
			if ($album_config['lb_preview'] == 0)
			{
				$pic_preview = '';
			}
			else
			{
				$pic_preview = 'onmouseover="showtrail(\''. mx_append_sid(this_smartor_mxurl('smartor_mode=album_picm&pic_id=' . $next_pic_rows[$i]['pic_id'], true)) . '\',\'' . addslashes($next_pic_rows[$i]['pic_title']) . '\', ' . $album_config['midthumb_width'] . ', ' . $album_config['midthumb_height'] . ')" onmouseout="hidetrail()"';
			}
			if ($album_config['show_pics_nav'] == 1)
			{
				$template->assign_block_vars('pics_nav.prev', array(
					'U_PICS_THUMB' => $thumbnail_file,
					'U_PICS_LINK' => mx_append_sid(this_smartor_mxurl('smartor_mode=album_showpage&pic_id=' . $next_pic_id[$i] . $full_size_param . $nuffimage_vars, false)),
					'PIC_PREVIEW' => $pic_preview,
					)
				);
			}
		}
	}
}

//PREV
$sql = "SELECT a.*
		FROM " . ALBUM_TABLE . " AS a
		WHERE a.pic_id < " . $pic_id_tmp . "
			AND a.pic_cat_id = " . $pic_cat_id_tmp . "
			AND a.pic_approval = 1
		ORDER BY pic_id DESC LIMIT 2";

if( !($result = $db->sql_query($sql)) )
{
	mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
}

//$row = $db->sql_fetchrow($result);
$prev_pic_count = $db->sql_numrows($result);
$prev_pic_rows = $db->sql_fetchrowset($result);
$db->sql_freeresult($result);

if ($prev_pic_count == 0)
{
	$no_prev_pic = true;

	$sql = "SELECT a.*
			FROM " . ALBUM_TABLE . " AS a
			WHERE a.pic_cat_id = " . $pic_cat_id_tmp . "
				AND a.pic_approval = 1
			ORDER BY pic_id DESC LIMIT 1";

	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);
	$last_pic_id = $row['pic_id'];
	$db->sql_freeresult($result);
}
else
{
	$no_prev_pic = false;
	if ( $album_config['invert_nav_arrows'] == 0 )
	{
		for($i = 0; $i < $prev_pic_count; $i++)
		{
			$prev_pic_id[$i] = $prev_pic_rows[$i]['pic_id'];
			$thumbnail_file = mx_append_sid(this_smartor_mxurl('smartor_mode=album_thumbnail&pic_id=' . $prev_pic_id[$i], true));
			if ( ($album_config['thumbnail_cache'] == true) && ($album_config['quick_thumbs'] == true) )
			{
				$pic_filename = $prev_pic_rows[$i]['pic_filename'];
				$pic_filetype = strtolower(substr($pic_filename, strlen($pic_filename) - 4, 4));
				$pic_thumbnail = ( $prev_pic_rows[$i]['pic_thumbnail'] == '' ) ? md5($pic_filename) . $pic_filetype : $prev_pic_rows[$i]['pic_thumbnail'];
				//$pic_thumbnail = ( $prev_pic_rows[$i]['pic_thumbnail'] == '' ) ? $pic_filename : $prev_pic_rows[$i]['pic_thumbnail'];
				$pic_thumbnail_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail;
				if ( file_exists($pic_thumbnail_fullpath) )
				{
					$thumbnail_file = $pic_thumbnail_fullpath;
				}
			}
			if ($album_config['lb_preview'] == 0)
			{
				$pic_preview = '';
			}
			else
			{
				$pic_preview = 'onmouseover="showtrail(\''. mx_append_sid(this_smartor_mxurl('smartor_mode=album_picm&pic_id=' . $prev_pic_rows[$i]['pic_id'], true)) . '\',\'' . addslashes($prev_pic_rows[$i]['pic_title']) . '\', ' . $album_config['midthumb_width'] . ', ' . $album_config['midthumb_height'] . ')" onmouseout="hidetrail()"';
			}
			if ($album_config['show_pics_nav'] == 1)
			{
				$template->assign_block_vars('pics_nav.prev', array(
					'U_PICS_THUMB' => $thumbnail_file,
					'U_PICS_LINK' => mx_append_sid(this_smartor_mxurl('smartor_mode=album_showpage&pic_id=' . $prev_pic_id[$i] . $full_size_param . $nuffimage_vars, false)),
					'PIC_PREVIEW' => $pic_preview,
					)
				);
			}
		}
	}
	else
	{
		for($i = $prev_pic_count - 1; $i >= 0; $i--)
		{
			$prev_pic_id[$i] = $prev_pic_rows[$i]['pic_id'];
			$thumbnail_file = mx_append_sid(this_smartor_mxurl('smartor_mode=album_thumbnail&pic_id=' . $prev_pic_id[$i], true));
			if ( ($album_config['thumbnail_cache'] == true) && ($album_config['quick_thumbs'] == true) )
			{
				$pic_filename = $prev_pic_rows[$i]['pic_filename'];
				$pic_filetype = strtolower(substr($pic_filename, strlen($pic_filename) - 4, 4));
				$pic_thumbnail = ( $prev_pic_rows[$i]['pic_thumbnail'] == '' ) ? md5($pic_filename) . $pic_filetype : $prev_pic_rows[$i]['pic_thumbnail'];
				//$pic_thumbnail = ( $prev_pic_rows[$i]['pic_thumbnail'] == '' ) ? $pic_filename : $prev_pic_rows[$i]['pic_thumbnail'];
				$pic_thumbnail_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail;
				if ( file_exists($pic_thumbnail_fullpath) )
				{
					$thumbnail_file = $pic_thumbnail_fullpath;
				}
			}
			if ($album_config['lb_preview'] == 0)
			{
				$pic_preview = '';
			}
			else
			{
				$pic_preview = 'onmouseover="showtrail(\''. mx_append_sid(this_smartor_mxurl('smartor_mode=album_picm&pic_id=' . $prev_pic_rows[$i]['pic_id'], true)) . '\',\'' . addslashes($prev_pic_rows[$i]['pic_title']) . '\', ' . $album_config['midthumb_width'] . ', ' . $album_config['midthumb_height'] . ')" onmouseout="hidetrail()"';
			}
			if ($album_config['show_pics_nav'] == 1)
			{
				$template->assign_block_vars('pics_nav.next', array(
					'U_PICS_THUMB' => $thumbnail_file,
					'U_PICS_LINK' => mx_append_sid(this_smartor_mxurl('smartor_mode=album_showpage&pic_id=' . $prev_pic_id[$i] . $full_size_param . $nuffimage_vars, false)),
					'PIC_PREVIEW' => $pic_preview,
					)
				);
			}
		}
	}
}

// ------------------------------------
// IMAGES ARRAY
// SLIDESHOW SCRIPTS
// ------------------------------------
if ( $album_config['slideshow_script'] == 1 )
{
	$template->assign_block_vars('switch_slideshow_scripts', array());

	$pic_link = ( $picm == false ) ? 'album_pic' : 'album_picm';

	$sql = "SELECT *
			FROM " . ALBUM_TABLE . " AS a
			WHERE a.pic_cat_id = " . $pic_cat_id_tmp . "
				AND a.pic_approval = 1
			ORDER BY pic_id ASC";

	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
	}

	$total_pic_count = $db->sql_numrows($result);
	$total_pic_rows = $db->sql_fetchrowset($result);
	$db->sql_freeresult($result);

	$pic_list = '';
	$tit_list = '';
	$des_list = '';

	for($i = 0; $i < $total_pic_count; $i++)
	{
		$pic_list .= 'Pic[' . $i . '] = \'' . mx_append_sid(this_smartor_mxurl('smartor_mode=' . $pic_link . '&pic_id=' . $total_pic_rows[$i]['pic_id'], true), true) . '\'; ' . "\n";
		$tit_list .= 'Tit[' . $i . '] = \'' . $total_pic_rows[$i]['pic_title'] . '\'; ' . "\n";
		$des_list .= 'Des[' . $i . '] = \'' . $total_pic_rows[$i]['pic_desc'] . '\'; ' . "\n";
		/*
		$pic_list .= 'Pic[' . $i . '] = \'' . ALBUM_UPLOAD_PATH . $total_pic_rows[$i]['pic_filename'] . '\'; ' . "\n";
		*/
	}

	$template->assign_vars(array(
		'PIC_LIST' => $pic_list,
		'TIT_LIST' => $tit_list,
		'DES_LIST' => $des_list,
		)
	);
}


// ------------------------------------
// SPECIAL FX
// ------------------------------------
if ($album_config['enable_nuffimage'] == 1)
{
	$template->assign_block_vars('pic_nuffed_enabled', array(
		'L_PIC_NUFFED_CLICK' => $lang['Nuff_Click'],
		'U_PIC_NUFFED_CLICK' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage" . '&pic_id=' . $pic_id . $full_size_param . '&amp;nuffimage=true')),
		)
	);
}
else
{
	$template->assign_block_vars('switch_slideshow_no_scripts', array());
}


// ------------------------------------
// Get $pic_id from $comment_id
// ------------------------------------

if( isset($comment_id) )
{
	$sql = "SELECT comment_id, comment_pic_id
			FROM ". ALBUM_COMMENT_TABLE ."
			WHERE comment_id = '$comment_id'";

	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query comment and pic information', '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);

	if( empty($row) )
	{
		mx_message_die(GENERAL_ERROR, 'This comment does not exist');
	}

	$pic_id = $row['comment_pic_id'];
}


// ------------------------------------
// Get this pic info
// ------------------------------------

$sql = "SELECT p.*, u.user_id, u.username, u.user_rank, r.rate_pic_id, AVG(r.rate_point) AS rating, COUNT(c.comment_id) AS comments_count
		FROM ". ALBUM_TABLE ." AS p
			LEFT JOIN ". USERS_TABLE ." AS u ON p.pic_user_id = u.user_id
			LEFT JOIN ". ALBUM_COMMENT_TABLE ." AS c ON p.pic_id = c.comment_pic_id
			LEFT JOIN ". ALBUM_RATE_TABLE ." AS r ON p.pic_id = r.rate_pic_id
		WHERE pic_id = '$pic_id'
		GROUP BY p.pic_id
		LIMIT 1";
if( !($result = $db->sql_query($sql)) )
{
	mx_message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
}
$thispic = $db->sql_fetchrow($result);

$cat_id = $thispic['pic_cat_id'];
$user_id = $thispic['pic_user_id'];

$total_comments = $thispic['comments_count'];
$comments_per_page = $board_config['posts_per_page'];

if( empty($thispic) )
{
	mx_message_die(GENERAL_ERROR, $lang['Pic_not_exist'] . ' -> ' . $pic_id);
}


// ------------------------------------
// Get the current Category Info
// ------------------------------------

if ($cat_id != PERSONAL_GALLERY)
{
	$sql = "SELECT *
			FROM ". ALBUM_CAT_TABLE ."
			WHERE cat_id = '$cat_id'";
	if( !($result = $db->sql_query($sql)) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query category information', '', __LINE__, __FILE__, $sql);
	}

	$thiscat = $db->sql_fetchrow($result);
}
else
{
	$thiscat = init_personal_gallery_cat($user_id);
}

if (empty($thiscat))
{
	mx_message_die(GENERAL_ERROR, $lang['Category_not_exist']);
}


// ------------------------------------
// Check the permissions
// ------------------------------------
$auth_data = album_user_access($cat_id, $thiscat, 1, 0, 1, 1, 1, 1);

if ($auth_data['view'] == 0)
{
	if (!$userdata['session_logged_in'])
	{
		mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
		mx_redirect(mx_append_sid($phpbb_root_path ."login.$phpEx?mx_redirect=album.php?smartor_mode=album_showpage&amp;pic_id=$pic_id"));
		exit;
	}
	else
	{
		mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
	}
}
// ------------------------------------
//RATING:  Additional Check: if this user already rated
// ------------------------------------

if( $userdata['session_logged_in'] )
{
	$sql = "SELECT *
			FROM ". ALBUM_RATE_TABLE ."
			WHERE rate_pic_id = '$pic_id'
				AND rate_user_id = '". $userdata['user_id'] ."'
			LIMIT 1";

	if( !$result = $db->sql_query($sql) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not query rating information', '', __LINE__, __FILE__, $sql);
	}

	if ($db->sql_numrows($result) > 0)
	{
		$already_rated = TRUE;
	}
	else
	{
		$already_rated = FALSE;
	}
}
else
{
	$already_rated = FALSE;
}




/*
+----------------------------------------------------------
| Main work here...
+----------------------------------------------------------
*/


if( !isset($HTTP_POST_VARS['comment']) )
{
	
	/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
               Comments Screen
	   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */

	// ------------------------------------
	// Get the comments thread
	// Beware: when this script was called with comment_id (without start)
	// ------------------------------------

	if( !isset($comment_id) )
	{
		if( isset($HTTP_GET_VARS['start']) )
		{
			$start = intval($HTTP_GET_VARS['start']);
		}
		else if( isset($HTTP_POST_VARS['start']) )
		{
			$start = intval($HTTP_POST_VARS['start']);
		}
		else
		{
			$start = 0;
		}
	}
	else
	{
		// We must do a query to co-ordinate this comment
		$sql = "SELECT COUNT(comment_id) AS count
				FROM ". ALBUM_COMMENT_TABLE ."
				WHERE comment_pic_id = $pic_id
					AND comment_id < $comment_id";

		if( !$result = $db->sql_query($sql) )
		{
			mx_message_die(GENERAL_ERROR, 'Could not obtain comments information from the database', '', __LINE__, __FILE__, $sql);
		}

		$row = $db->sql_fetchrow($result);

		if( !empty($row) )
		{
			$start = floor( $row['count'] / $comments_per_page ) * $comments_per_page;
		}
		else
		{
			$start = 0;
		}
	}

	if( isset($HTTP_GET_VARS['sort_order']) )
	{
		switch ($HTTP_GET_VARS['sort_order'])
		{
			case 'ASC':
				$sort_order = 'ASC';
				break;
			default:
				$sort_order = 'DESC';
		}
	}
	else if( isset($HTTP_POST_VARS['sort_order']) )
	{
		switch ($HTTP_POST_VARS['sort_order'])
		{
			case 'ASC':
				$sort_order = 'ASC';
				break;
			default:
				$sort_order = 'DESC';
		}
	}
	else
	{
		$sort_order = 'ASC';
	}

	if ($total_comments > 0)
	{
		$template->assign_block_vars('coment_switcharo_top', array());
		
		$limit_sql = ($start == 0) ? $comments_per_page : $start .','. $comments_per_page;

		$sql = "SELECT c.*, u.user_id, u.username, u.user_regdate, u.user_posts, u.user_allowavatar, u.user_rank, u.user_avatar, u.user_avatar_type, u.user_email, u.user_icq, u.user_website, u.user_from, u.user_aim, u.user_yim, u.user_msnm
				FROM ". ALBUM_COMMENT_TABLE ." AS c
					LEFT JOIN ". USERS_TABLE ." AS u ON c.comment_user_id = u.user_id
				WHERE c.comment_pic_id = '$pic_id'
				ORDER BY c.comment_id $sort_order
				LIMIT $limit_sql";

		if( !$result = $db->sql_query($sql) )
		{
			mx_message_die(GENERAL_ERROR, 'Could not obtain comments information from the database', '', __LINE__, __FILE__, $sql);
		}

		$commentrow = array();

		while( $row = $db->sql_fetchrow($result) )
		{
			$commentrow[] = $row;
		}

		for ($i = 0; $i < count($commentrow); $i++)
		{
			if( ($commentrow[$i]['user_id'] == ALBUM_GUEST) or ($commentrow[$i]['username'] == '') )
			{
				$poster = ($commentrow[$i]['comment_username'] == '') ? $lang['Guest'] : $commentrow[$i]['comment_username'];
			}
			else
			{
				$poster = '<a href="'. mx_append_sid($phpbb_root_path ."profile.php?mode=viewprofile&amp;". POST_USERS_URL .'='. $commentrow[$i]['user_id']) .'">'. $commentrow[$i]['username'] .'</a>';
			}

			if ($commentrow[$i]['comment_edit_count'] > 0)
			{
				$sql = "SELECT c.comment_id, c.comment_edit_user_id, u.user_id, u.username
						FROM ". ALBUM_COMMENT_TABLE ." AS c
							LEFT JOIN ". USERS_TABLE ." AS u ON c.comment_edit_user_id = u.user_id
						WHERE c.comment_id = '".$commentrow[$i]['comment_id']."'
						LIMIT 1";

				if( !$result = $db->sql_query($sql) )
				{
					mx_message_die(GENERAL_ERROR, 'Could not obtain last edit information from the database', '', __LINE__, __FILE__, $sql);
				}

				$lastedit_row = $db->sql_fetchrow($result);

				$edit_info = ($commentrow[$i]['comment_edit_count'] == 1) ? $lang['Edited_time_total'] : $lang['Edited_times_total'];

				$edit_info = '<br /><br />&raquo;&nbsp;'. sprintf($edit_info, $lastedit_row['username'], create_date($board_config['default_dateformat'], $commentrow[$i]['comment_edit_time'], $board_config['board_timezone']), $commentrow[$i]['comment_edit_count']) .'<br />';
			}
			else
			{
				$edit_info = '';
			}
			
			// Smilies
			$commentrow[$i]['comment_text'] = mx_smilies_pass($commentrow[$i]['comment_text']);
			$commentrow[$i]['comment_text'] = make_clickable($commentrow[$i]['comment_text']);
			$commentrow[$i]['comment_text'] = nl2br($commentrow[$i]['comment_text']);
			
			//email, profile, pm links
			$email_uri = ( $board_config['board_email_form'] ) ? mx_append_sid($phpbb_root_path ."profile.$phpEx?mode=email&amp;" . POST_USERS_URL .'=' . $commentrow[$i]['user_id']) : 'mailto:' . $commentrow[$i]['user_email'];
			$profile_url = mx_append_sid($phpbb_root_path ."profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $commentrow[$i]['user_id'] );
			$pm_url = mx_append_sid($phpbb_root_path ."privmsg.$phpEx?mode=post&amp;" . POST_USERS_URL . "=" . $commentrow[$i]['user_id']);
			
			//avatar
			$poster_avatar = '';
			if ( $commentrow[$i]['user_avatar_type'] && $commentrow[$i]['user_id'] != ANONYMOUS && $commentrow[$i]['user_allowavatar'] )
			{
				switch( $commentrow[$i]['user_avatar_type'] )
				{
					case USER_AVATAR_UPLOAD:
						$poster_avatar = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $phpbb_root_path .$board_config['avatar_path'] . '/' . $commentrow[$i]['user_avatar'] . '" alt="" border="0" />' : '';
						break;
					case USER_AVATAR_REMOTE:
						$poster_avatar = ( $board_config['allow_avatar_remote'] ) ? '<img src="' .$commentrow[$i]['user_avatar'] . '" alt="" border="0" />' : '';
						break;
					case USER_AVATAR_GALLERY:
						$poster_avatar = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $phpbb_root_path .$board_config['avatar_gallery_path'] . '/' . $commentrow[$i]['user_avatar'] . '" alt="" border="0" />' : '';
						break;
				}
			}
			
			//rank & rank image
			$sql = "SELECT *
				FROM " . RANKS_TABLE . "
				ORDER BY rank_special, rank_min";
			if ( !($result = $db->sql_query($sql)) )
			{
				mx_message_die(GENERAL_ERROR, "Could not obtain ranks information.", '', __LINE__, __FILE__, $sql);
			}

			$ranksrow = array();
			while ( $row = $db->sql_fetchrow($result) )
			{
				$ranksrow[] = $row;
			}
			$db->sql_freeresult($result);

			$poster_rank = '';
			$rank_image = '';
			if ($commentrow[$i]['user_id'] == ANONYMOUS)
			{
				$poster_rank = $lang['Guest'];
			}
			else if ( $commentrow[$i]['user_rank'] )
			{
				for($j = 0; $j < count($ranksrow); $j++)
				{
					if ( $commentrow[$i]['user_rank'] == $ranksrow[$j]['rank_id'] && $ranksrow[$j]['rank_special'] )
					{
						$poster_rank = $ranksrow[$j]['rank_title'];
						$rank_image = ( $ranksrow[$j]['rank_image'] ) ? '<img src="' . $phpbb_root_path .$ranksrow[$j]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : '';
					}
				}
			}
			else
			{
				for($j = 0; $j < count($ranksrow); $j++)
				{
					if ( $commentrow[$i]['user_posts'] >= $ranksrow[$j]['rank_min'] && !$ranksrow[$j]['rank_special'] )
					{
						$poster_rank = $ranksrow[$j]['rank_title'];
						$rank_image = ( $ranksrow[$j]['rank_image'] ) ? '<img src="' . $phpbb_root_path . $ranksrow[$j]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : '';
					}
				}
			}

			//
			// Handle anon users posting with usernames
			//
			if ( $commentrow[$i]['user_id'] == ANONYMOUS && $commentrow[$i]['post_username'] != '' )
			{
				$poster = $commentrow[$i]['post_username'];
				$poster_rank = $lang['Guest'];
			}
			
			$template->assign_block_vars('commentrow', array(
				'ID' => $commentrow[$i]['comment_id'],
				'POSTER_NAME' => $poster,
				'TIME' => create_date($board_config['default_dateformat'], $commentrow[$i]['comment_time'], $board_config['board_timezone']),
				'IP' => ($userdata['user_level'] == ADMIN) ? '<a href="http://www.nic.com/cgi-bin/whois.cgi?query=' . decode_ip($commentrow[$i]['comment_user_ip']) . '" target="_blank">' . decode_ip($commentrow[$i]['comment_user_ip']) .'</a><br />' : '',
				
				//users mesangers, website, email
				'PROFILE_IMG' => ( $commentrow[$i]['user_id'] != ANONYMOUS ) ? '<a href="' . $phpbb_root_path .$profile_url . '"><img src="' . $images['icon_profile'] . '" alt="' . $lang['Read_profile'] . '" title="' . $lang['Read_profile'] . '" border="0" /></a>' : '',
				'PM_IMG' => ( $commentrow[$i]['user_id'] != ANONYMOUS ) ? '<a href="' . $phpbb_root_path .$pm_url . '"><img src="' . $images['icon_pm'] . '" alt="' . $lang['Send_private_message'] . '" title="' . $lang['Send_private_message'] . '" border="0" /></a>' : '',
				'AIM_IMG' => ( $commentrow[$i]['user_id'] != ANONYMOUS ) ? ( $commentrow[$i]['user_aim'] ) ? '<a href="aim:goim?screenname=' . $commentrow[$i]['user_aim'] . '&amp;message=Hello+Are+you+there?"><img src="' . $images['icon_aim'] . '" alt="' . $lang['AIM'] . '" title="' . $lang['AIM'] . '" border="0" /></a>' : '' : '',
				'YIM_IMG' => ( $commentrow[$i]['user_id'] != ANONYMOUS ) ? ( $commentrow[$i]['user_yim'] ) ? '<a href="http://edit.yahoo.com/config/send_webmesg?.target=' . $commentrow[$i]['user_yim'] . '&amp;.src=pg"><img src="' . $images['icon_yim'] . '" alt="' . $lang['YIM'] . '" title="' . $lang['YIM'] . '" border="0" /></a>' : '' : '',
				'MSNM_IMG' => ( $commentrow[$i]['user_id'] != ANONYMOUS ) ? ( $commentrow[$i]['user_msnm'] ) ? '<a href="' . $temp_url . '"><img src="' . $images['icon_msnm'] . '" alt="' . $lang['MSNM'] . '" title="' . $lang['MSNM'] . '" border="0" /></a>' : '' : '',
				'ICQ_IMG' =>  ( $commentrow[$i]['user_id'] != ANONYMOUS ) ? ( $commentrow[$i]['user_icq'] ) ? '<a href="http://wwp.icq.com/scripts/search.dll?to=' . $commentrow[$i]['user_icq'] . '"><img src="' . $images['icon_icq'] . '" alt="' . $lang['ICQ'] . '" title="' . $lang['ICQ'] . '" border="0" /></a>' : '' : '',
				'EMAIL_IMG' => ( $commentrow[$i]['user_id'] != ANONYMOUS ) ? '<a href="' . $email_uri . '"><img src="' . $images['icon_email'] . '" alt="' . $lang['Send_email'] . '" title="' . $lang['Send_email'] . '" border="0" /></a>' : '',
				'WWW_IMG' => ( $commentrow[$i]['user_id'] != ANONYMOUS ) ? ( $commentrow[$i]['user_website'] ) ? '<a href="' . $commentrow[$i]['user_website'] . '" target="_userwww"><img src="' . $images['icon_www'] . '" alt="' . $lang['Visit_website'] . '" title="' . $lang['Visit_website'] . '" border="0" /></a>' : '' : '',
				
				'POSTER_AVATAR' => $poster_avatar,
				'POSTER_RANK' => $poster_rank,
				'POSTER_RANK_IMGAGE' => $phpbb_root_path .$rank_image,
				'POSTER_JOINED' => ( $commentrow[$i]['user_id'] != ANONYMOUS ) ? $lang['Joined'] . ': ' . create_date($lang['DATE_FORMAT'], $commentrow[$i]['user_regdate'], $board_config['board_timezone']) : '',
				'POSTER_POSTS' => ( $commentrow[$i]['user_id'] != ANONYMOUS ) ? $lang['Posts'] . ': ' . $commentrow[$i]['user_posts'] : '',
				'POSTER_FROM' => ( $commentrow[$i]['user_from'] && $commentrow[$i]['user_id'] != ANONYMOUS ) ? $lang['Location'] . ': ' . $commentrow[$i]['user_from'] : '',
				

				'TEXT' => $commentrow[$i]['comment_text'],
				'EDIT_INFO' => $edit_info,

				'EDIT' => ( ( $auth_data['edit'] and ($commentrow[$i]['comment_user_id'] == $userdata['user_id']) ) or ($auth_data['moderator'] and ($thiscat['cat_edit_level'] != ALBUM_ADMIN) ) or ($userdata['user_level'] == ADMIN) ) ? '<a href="'. mx_append_sid(this_smartor_mxurl("smartor_mode=album_comment_edit&comment_id=". $commentrow[$i]['comment_id'])) .'">'. $lang['Edit_pic'] .'</a>' : '',

				'DELETE' => ( ( $auth_data['delete'] and ($commentrow[$i]['comment_user_id'] == $userdata['user_id']) ) or ($auth_data['moderator'] and ($thiscat['cat_delete_level'] != ALBUM_ADMIN) ) or ($userdata['user_level'] == ADMIN) ) ? '<a href="'. mx_append_sid(this_smartor_mxurl("smartor_mode=album_comment_delete&comment_id=". $commentrow[$i]['comment_id'])) .'">'. $lang['Delete_pic'] .'</a>' : ''
				)
			);
		}

		$template->assign_block_vars('switch_comment', array());

		$template->assign_vars(array(
			'PAGINATION' => mx_generate_pagination(mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=$pic_id&amp;sort_order=$sort_order")), $total_comments, $comments_per_page, $start),
			'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $comments_per_page ) + 1 ), ceil( $total_comments / $comments_per_page ))
			)
		);
		$template->assign_block_vars('coment_switcharo_bottom', array());
	}

	//
	// Start output of page
	//
	$page_title = $lang['Album'];
	if ( !is_object($mx_block) )
 	{
		include($mx_root_path . 'includes/page_header.'.$phpEx);
 	}


	//$template->set_filenames(array('body' => 'album_showpage_body.tpl'));

	$template->set_filenames(array('body' => $show_template));

	if( ($thispic['pic_user_id'] == ALBUM_GUEST) or ($thispic['username'] == '') )
	{
		$poster = ($thispic['pic_username'] == '') ? $lang['Guest'] : $thispic['pic_username'];
	}
	else
	{
		$poster = '<a href="'. mx_append_sid($phpbb_root_path ."profile.$phpEx?mode=viewprofile&amp;". POST_USERS_URL .'='. $thispic['user_id']) .'">'. $thispic['username'] .'</a>';
	}

	//---------------------------------
	// Comment Posting Form
	//---------------------------------
	if ($auth_data['comment'] == 1)
	{
		$template->assign_block_vars('switch_comment_post', array());

		if( !$userdata['session_logged_in'] )
		{
			$template->assign_block_vars('switch_comment_post.logout', array());
		}
	}

		$image_rating = ImageRating($thispic['rating']);

		//begin shows smilies
		$max_smilies = 20;

		$sql = 'SELECT emoticon, code, smile_url
						FROM ' . SMILIES_TABLE . ' 
						GROUP BY smile_url
						ORDER BY smilies_id LIMIT ' . $max_smilies;

		if (!$result = $db->sql_query($sql))
		{
			mx_message_die(GENERAL_ERROR, "Couldn't retrieve smilies list", '', __LINE__, __FILE__, $sql);
		}
		$smilies_count = $db->sql_numrows($result);
		$smilies_data = $db->sql_fetchrowset($result);

		if ($auth_data['comment'] == 1)
		{
			for ($i = 1; $i < $smilies_count+1; $i++)
			{
				$template->assign_block_vars('switch_comment_post.smilies', array(
					'CODE' => $smilies_data[$i - 1]['code'],
					'URL' => $phpbb_root_path . $board_config['smilies_path'] . '/' . $smilies_data[$i - 1]['smile_url'],
					'DESC' => $smilies_data[$i - 1]['emoticon']
				));

				if ( is_integer($i / 5) )
				{
					$template->assign_block_vars('switch_comment_post.smilies.new_col', array());
				}
			}
		}

	// --------------------------------
	// Rate Scale
	// --------------------------------
	if (!$already_rated)
	{
		if ($auth_data['rate'] == 1)
		{
			for ($i = 0; $i < $album_config['rate_scale']; $i++)
			{   
				$template->assign_block_vars('switch_comment_post.rate_row', array(
					'POINT' => ($i + 1)
				));
			}
		}
	}

	if ($album_config['rate'])
	{
		$template->assign_block_vars('rate_switch', array());
	}

	// Mighty Gorgon - Slideshow - BEGIN
	if ( ((isset($_GET['slideshow']) && (intval($_GET['slideshow']) > 0)) || (isset($_POST['slideshow']) && (intval($_POST['slideshow']) > 0))) )
	{
		$template->assign_block_vars('switch_slideshow', array());
		$slideshow_delay = (isset($_GET['slideshow']) ? intval($_GET['slideshow']) : intval($_POST['slideshow']));
		$slideshow_select = '';
		$slideshow_onoff = $lang['Slideshow_Off'];
		$slideshow_link = mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $pic_id));
		$slideshow_link_full = '<a href="' . $slideshow_link . '">' . $lang['Slideshow_Off'] . '</a>';
		$pic_link = mx_append_sid(this_smartor_mxurl("smartor_mode=" . $nuffimage_pic . "&pic_id=" . $pic_id, TRUE));
		$next_pic = ($no_next_pic == false) ? '<a href="' . mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $pic_id . $full_size_param . '&amp;mode=next&amp;slideshow=' . $slideshow_delay)) . '#TopPic"><img src="' . $images['icon_right_arrow3'] . '" title="' . $lang['Next_Pic'] . '" border="0" alt="' . $lang['Next_Pic'] . '" align="middle" /></a>' : '';
		$prev_pic = ($no_prev_pic == false) ? '<a href="' . mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $pic_id . $full_size_param . '&amp;mode=prev&amp;slideshow=' . $slideshow_delay)) . '#TopPic"><img src="' . $images['icon_left_arrow3'] . '" title="' . $lang['Prev_Pic'] . '" border="0" alt="' . $lang['Prev_Pic'] . '" align="middle" /></a>' : '';
		$next_pic_url = ($no_next_pic == false) ? mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $pic_id . $full_size_param . '&amp;mode=next&amp;slideshow=' . $slideshow_delay)) . '#TopPic' : mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $first_pic_id . $full_size_param)) . '#TopPic';
		$prev_pic_url = ($no_prev_pic == false) ? mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $pic_id . $full_size_param . '&amp;mode=prev&amp;slideshow=' . $slideshow_delay)) . '#TopPic' : mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $last_pic_id . $full_size_param)) . '#TopPic';
	}
	else
	{
		if ($album_config['show_slideshow'] == 1)
		{
			$template->assign_block_vars('switch_slideshow_enabled', array());
		}
		//$slideshow_delay = 5;
		$slideshow_delay = array();
		$slideshow_select = $lang['Slideshow_Delay'] . ':&nbsp;';
		$slideshow_select .= '<select name="slideshow">';
		$slideshow_select .= '<option value="1">1 Sec</option>';
		$slideshow_select .= '<option value="3">3 Sec</option>';
		$slideshow_select .= '<option value="5" selected="selected">5 Sec</option>';
		$slideshow_select .= '<option value="7">7 Sec</option>';
		$slideshow_select .= '<option value="10">10 Sec</option>';
		$slideshow_select .= '</select>&nbsp;';
		$slideshow_onoff = $lang['Slideshow_On']; 
		//$slideshow_link = mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $pic_id . '&amp;full=true&amp;slideshow=' . $slideshow_delay));
		$slideshow_link = mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $pic_id . '&amp;full=true'));
		$slideshow_link_full = '<a href="' . $slideshow_link . '">' . $lang['Slideshow_On'] . '</a>';
		$pic_link = mx_append_sid(this_smartor_mxurl("smartor_mode=" . $nuffimage_pic . "&pic_id=" . $pic_id . $sort_append . $full_size_param . $nuff_http_full_string, TRUE));
		$next_pic = ($no_next_pic == false) ? '<a href="' . mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $pic_id . $full_size_param . '&amp;mode=next' . $nuffimage_vars)) . '#TopPic"><img src="' . $images['icon_left_arrow3'] . '" title="' . $lang['Next_Pic'] . '" border="0" alt="' . $lang['Next_Pic'] . '" align="middle" /></a>' : '';
		$prev_pic = ($no_prev_pic == false) ? '<a href="' . mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=" . $pic_id . $full_size_param . '&amp;mode=prev' . $nuffimage_vars)) . '#TopPic"><img src="' . $images['icon_right_arrow3'] . '" title="' . $lang['Prev_Pic'] . '" border="0" alt="' . $lang['Prev_Pic'] . '" align="middle" /></a>' : '';
		$next_pic_url = '#TopPic';
		$prev_pic_url = '#TopPic';
	}

	//$temp_js = '<script language="JavaScript" type="text/javascript">window.attachEvent(\'onload\', runSlideShow();)</script>';
	if ( $album_config['slideshow_script'] == 1 )
	{
		$slideshow_refresh = '</body><body onload="runSlideShow()">';
		//$slideshow_refresh = $temp_js;
	}
	else
	{
		$slideshow_refresh = '</body><head><meta http-equiv="refresh" content="' . $slideshow_delay .  ';url=' . $next_pic_url . '"></head><body>';
	}
	// Mighty Gorgon - Slideshow - END

	// Mighty Gorgon - Pic Size - BEGIN
	$pic_size = @getimagesize(ALBUM_UPLOAD_PATH . $thispic['pic_filename']);
	$pic_width = $pic_size[0];
	$pic_height = $pic_size[1];
	$pic_filesize = filesize(ALBUM_UPLOAD_PATH . $thispic['pic_filename']);
	// Mighty Gorgon - Pic Size - END

	if( !defined('exif_read_data') )
	{
		define('exif_read_data', true);
	}

	if ( ($album_config['show_exif'] == 1) && (function_exists(exif_read_data)) )
	{
		$template->assign_block_vars('switch_exif_enabled', array());
		$xif = @exif_read_data(ALBUM_UPLOAD_PATH . $thispic['pic_filename'], 0, true);
		if (!empty($xif[IFD0]) || !empty($xif[EXIF]))
		{
			include_once($album_root_path . 'album_exif_info.' . $phpEx);
		}
	}

	$server_protocol = ( $board_config['cookie_secure'] ) ? 'https://' : 'http://';
	$server_name = trim($board_config['server_name']);
	$server_port = ( $board_config['server_port'] <> 80 ) ? ':' . trim($board_config['server_port']) . '/' : '/';
	$script_name = preg_replace('/^\/?(.*?)\/?$/', '\1', trim($board_config['script_path']));
	$script_name = ( $script_name == '' ) ? '' : $script_name . '/';
	$server_path = $server_protocol . $server_name . $server_port . $script_name;

	$thumbnail_file = mx_append_sid(this_smartor_mxurl("album_thumbnail" . '&pic_id=' . $pic_id, true));
	if ( ($album_config['thumbnail_cache'] == true) && ($album_config['quick_thumbs'] == true) )
	{
		$pic_filename = $thispic['pic_filename'];
		$pic_filetype = strtolower(substr($pic_filename, strlen($pic_filename) - 4, 4));
		$pic_thumbnail = ( $thispic['pic_thumbnail'] == '' ) ? md5($pic_filename) . $pic_filetype : $thispic['pic_thumbnail'];
		//$pic_thumbnail = ( $thispic['pic_thumbnail'] == '' ) ? $pic_filename : $thispic['pic_thumbnail'];
		$pic_thumbnail_fullpath = ALBUM_CACHE_PATH . $pic_thumbnail;
		if ( file_exists($pic_thumbnail_fullpath) )
		{
			$thumbnail_file = $pic_thumbnail_fullpath;
		}
	}

	$template->assign_vars(array(
		'CAT_TITLE' => $thiscat['cat_title'],
		'U_VIEW_CAT' => ($cat_id != PERSONAL_GALLERY) ? mx_append_sid(this_smartor_mxurl("smartor_mode=album_cat&cat_id=$cat_id")) : mx_append_sid(this_smartor_mxurl("smartor_mode=album_personal&user_id=$user_id")),

		//'U_PIC' => ( $picm ) ? mx_append_sid(this_smartor_mxurl("smartor_mode=album_pic&pic_id=$pic_id", TRUE)) : mx_append_sid(this_smartor_mxurl("smartor_mode=album_picm&pic_id=$pic_id", TRUE)),
		'U_PIC' => $pic_link,
		'U_PIC_L1' => ( $picm ) ? '<a href='.this_smartor_mxurl("smartor_mode=album_showpage&full=true&pic_id=" . $pic_id) . '>' : '',
		'U_PIC_L2' => ( $picm ) ? '</a>' : '',
		'U_PIC_CLICK' => ( $picm ) ? '' : 'Click on image to view larger image',
		
		'U_PIC_THUMB' => mx_append_sid(this_smartor_mxurl('smartor_mode=album_thumbnail&pic_id=' . $pic_id . $full_size_param . $nuffimage_vars, true)),
		'U_PIC_LINK' => mx_append_sid(this_smartor_mxurl('smartor_mode=album_showpage&pic_id=' . $pic_id . $full_size_param . $nuffimage_vars, false)),

		'U_SMILEY_CREATOR' => mx_append_sid(this_smartor_mxurl('smartor_mode=smiley_creator&mode=text2shield')),
		
		'NEXT_PIC' => $next_pic,
		'PREV_PIC' => $prev_pic,

		'U_NEXT' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=$pic_id&amp;mode=next")),
		'U_PREVIOUS' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=$pic_id&amp;mode=previous")),
		
		'PIC_RATING' => $image_rating,

		'PIC_ID' => $pic_id,
		'PIC_BBCODE' => '[albumimg]' . $pic_id . '[/albumimg]',
		'PIC_TITLE' => $thispic['pic_title'],
		'PIC_DESC' => nl2br($thispic['pic_desc']),

		'POSTER' => $poster,

		'PIC_TIME' => create_date($board_config['default_dateformat'], $thispic['pic_time'], $board_config['board_timezone']),
		'PIC_VIEW' => $thispic['pic_view_count'],
		'PIC_COMMENTS' => $total_comments,

		'TARGET_BLANK' => ($album_config['fullpic_popup']) ? 'target="_blank"' : '',

		'L_PIC_ID' => $lang['Pic_ID'],
		'L_PIC_BBCODE' => $lang['Pic_BBCode'],
		'L_PIC_TITLE' => $lang['Pic_Image'],
		'L_PIC_DESC' => $lang['Pic_Desc'],
		'L_POSTER' => $lang['Poster'],
		'L_POSTED' => $lang['Posted'],
		'L_VIEW' => $lang['View'],
		'L_COMMENTS' => $lang['Comments'],
		'L_RATING' => $lang['Rating'],

		'L_POST_YOUR_COMMENT' => $lang['Post_your_comment'],
		'L_MESSAGE' => $lang['Message'],
		'L_USERNAME' => $lang['Username'],
		'L_COMMENT_NO_TEXT' => $lang['Comment_no_text'],
		'L_COMMENT_TOO_LONG' => $lang['Comment_too_long'],
		'L_MAX_LENGTH' => $lang['Max_length'],
		'S_MAX_LENGTH' => $album_config['desc_length'],

		'L_ORDER' => $lang['Order'],
		'L_SORT' => $lang['Sort'],
		'L_ASC' => $lang['Sort_Ascending'],
		'L_DESC' => $lang['Sort_Descending'],

		'SORT_ASC' => ($sort_order == 'ASC') ? 'selected="selected"' : '',
		'SORT_DESC' => ($sort_order == 'DESC') ? 'selected="selected"' : '',

		'L_SUBMIT' => $lang['Submit'],

		'S_ALBUM_ACTION' => mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=$pic_id")),
		
		// Mighty Gorgon - Slideshow - BEGIN
		'L_SLIDESHOW' => $lang['Slideshow'],
		'L_SLIDESHOW_DELAY' => $lang['Slideshow_Delay'],
		'L_SLIDESHOW_ONOFF' => $slideshow_onoff,
		'SLIDESHOW_SELECT' => $slideshow_select,
		'SLIDESHOW_DELAY' => $slideshow_delay,
		'U_SLIDESHOW' => $slideshow_link,
		'U_SLIDESHOW_FULL' => $slideshow_link_full,
		'U_SLIDESHOW_REFRESH' => $slideshow_refresh,
		'U_SLIDESHOW_REFRESH_META' => '<meta http-equiv="refresh" content="' . $slideshow_delay .  ';url=' . $next_pic_url . '">',
		// Mighty Gorgon - Slideshow - END

		// Mighty Gorgon - Pic Size - BEGIN
		'L_PIC_DETAILS' => $lang['Pic_Details'],
		'L_PIC_SIZE' => $lang['Pic_Size'],
		'L_PIC_TYPE' => $lang['Pic_Type'],
		'PIC_SIZE' => $pic_width . ' x ' . $pic_height . ' (' . intval($pic_filesize/1024) . 'KB)',
		'PIC_TYPE' => strtoupper(substr($thispic['pic_filename'], strlen($thispic['pic_filename']) - 3, 3)),
		// Mighty Gorgon - Pic Size - END
		
		//rating
		'S_RATE_MSG' => (  !$userdata['session_logged_in'] && $auth_data['rate'] == 0 ) ? 'Login to vote!' : ( ($already_rated) ? $lang['Already_rated'] : $lang['Rating'] ),
		'L_CURRENT_RATING' => $lang['Current_Rating'],
		'L_PLEASE_RATE_IT' => $lang['Please_Rate_It']
	));

	//
	// Generate the page
	//
	$template->pparse('body');

	if ( !is_object($mx_block) )
	{
		include($mx_root_path . 'includes/page_tail.'.$phpEx);
	}
}
else
{
	/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
              Comment Submited
	   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */

	// ------------------------------------
	// Check the permissions: COMMENT
	// ------------------------------------

	if ($auth_data['comment'] == 0)
	{
		if (!$userdata['session_logged_in'])
		{
			mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
			mx_redirect(mx_append_sid($phpbb_root_path ."login.$phpEx?mx_redirect=album.php?smartor_mode=album_showpage&amp;pic_id=$pic_id"));
		}
		else
		{
			mx_message_die(GENERAL_ERROR, $lang['Not_Authorised']);
		}
	}

	$comment_text = str_replace("\'", "''", htmlspecialchars(substr(trim($HTTP_POST_VARS['comment']), 0, $album_config['desc_length'])));

	$comment_username = (!$userdata['session_logged_in']) ? str_replace("\'", "''", substr(htmlspecialchars(trim($HTTP_POST_VARS['comment_username'])), 0, 32)) : str_replace("'", "''", htmlspecialchars(trim($userdata['username'])));



	// --------------------------------
	// Check Pic Locked
	// --------------------------------

	if( ($thispic['pic_lock'] == 1) and (!$auth_data['moderator']) )
	{
		mx_message_die(GENERAL_ERROR, $lang['Pic_Locked']);
	}


	// --------------------------------
	// Check username for guest posting
	// --------------------------------

	if (!$userdata['session_logged_in'])
	{
		if ($comment_username != '')
		{
			$result = validate_username($comment_username);
			if ( $result['error'] )
			{
				mx_message_die(GENERAL_MESSAGE, $result['error_msg']);
			}
		}
	}


	// --------------------------------
	// Prepare variables
	// --------------------------------

	$comment_time = time();
	$comment_user_id = $userdata['user_id'];
	$comment_user_ip = $userdata['session_ip'];


	// --------------------------------
	// Get $comment_id
	// --------------------------------
	$sql = "SELECT MAX(comment_id) AS max
			FROM ". ALBUM_COMMENT_TABLE;

	if( !$result = $db->sql_query($sql) )
	{
		mx_message_die(GENERAL_ERROR, 'Could not found comment_id', '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);

	$comment_id = $row['max'] + 1;
	

	// --------------------------------
	// Insert into DB
	// --------------------------------
	/*
	if ($comment_text != '') //if user only rated, but didnt enter a comment ..... only update rating
	{
		$sql = "INSERT INTO ". ALBUM_COMMENT_TABLE ." (comment_id, comment_pic_id, comment_user_id, comment_username, comment_user_ip, comment_time, comment_text)
				VALUES ('$comment_id', '$pic_id', '$comment_user_id', '$comment_username', '$comment_user_ip', '$comment_time', '$comment_text')";
		if( !$result = $db->sql_query($sql) )
		{
			mx_message_die(GENERAL_ERROR, 'Could not insert new entry', '', __LINE__, __FILE__, $sql);
		}
	}
	*/

	// Fix by OryNider for smartor 2.0 Beta 2
	// If user only rated, but didn't enter a comment... only update rating
	if ( $comment_text != '' )
	{
		$sql = "INSERT INTO " . ALBUM_COMMENT_TABLE ." (comment_id, comment_pic_id, comment_cat_id, comment_user_id, comment_username, comment_user_ip, comment_time, comment_text)
				VALUES ('$comment_id', '$pic_id', '$cat_id', '$comment_user_id', '$comment_username', '$comment_user_ip', '$comment_time', '$comment_text')";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not insert new entry', '', __LINE__, __FILE__, $sql);
		}
	}
	//Rating System
	$rate_point = intval($HTTP_POST_VARS['rate']);
	
	if ($rate_point != -1)//if user didnt vote, dont update database
	{
		if( ($rate_point <= 0) or ($rate_point > $album_config['rate_scale']) )
		{
			mx_message_die(GENERAL_ERROR, 'Bad submited value');
		}

		$rate_user_id = $userdata['user_id'];
		$rate_user_ip = $userdata['session_ip'];
		
		$sql = "INSERT INTO ". ALBUM_RATE_TABLE ." (rate_pic_id, rate_user_id, rate_user_ip, rate_point)
				VALUES ('$pic_id', '$rate_user_id', '$rate_user_ip', '$rate_point')";

		if( !$result = $db->sql_query($sql) )
		{
			mx_message_die(GENERAL_ERROR, 'Could not insert new rating', '', __LINE__, __FILE__, $sql);
		}
	}

	// --------------------------------
	// Complete... now send a message to user
	// --------------------------------

	$template->assign_vars(array(
		'META' => '<meta http-equiv="refresh" content="3;url=' . mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=$pic_id")) . '">')
	);

	$message = $lang['Stored'] . "<br /><br />" . sprintf($lang['Click_view_message'], "<a href=\"" . mx_append_sid(this_smartor_mxurl("smartor_mode=album_showpage&pic_id=$pic_id ")) . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_album_index'], "<a href=\"" . mx_append_sid(this_smartor_mxurl()) . "\">", "</a>");

	mx_message_die(GENERAL_MESSAGE, $message);
}


// +--------------------------------------------------------+
// |  Powered by Photo Album 2.x.x (c) 2002-2003 Smartor    |
// |  with Volodymyr (CLowN) Skoryk's Service Pack 1  2003 |
// +--------------------------------------------------------+

?>