<?php 
/**
*
* @package mx_mod
* @version $Id: functions_styles.php,v 1.1 2008/03/10 06:02:26 orynider Exp $
* @copyright (c) 2002-2006 mxBB Project Team
* @license http://opensource.org/licenses/gpl-license.php GNU General Public License v2
* @link http://www.mxbb.net
*
*/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}

/**
 * Class: mx_Template from mx_functions_style.php
 *
 * The mx_Template class extends the native phpBB Template class, in reality only redefining the make_filename method.
 * Thus modded phpBB templates (eg eXtreme Styles MOD) will also be available for MX-Publisher.
 *
 * @package Style
 * @author Markus, Jon Ohlsson
 * @access public
 */
class mx_Template extends Template
{
	/**
	 * Constructor.
	 *
	 * Simply calling parent construtor.
	 * This is required. Reason is constructors have different method names.
	 *
	 * @access private
	 */
	function mx_Template($root = '.')
	{
		$this->root = $root;
		parent::Template($this->root);
	}

	var $module_template_path = '';

	/**
	 * make_filename.
	 *
	 * This make_filename implementation overrides parent method.
	 * Generates a full path+filename for the given filename, which can either
	 * be an absolute name, or a name relative to the rootdir for this Template
	 * object.
	 *
	 * @access public
	 */
	function make_filename($filename)
	{
		global $module_root_path, $mx_root_path, $phpbb_root_path, $theme, $mx_user, $mx_block;

		switch (PORTAL_BACKEND)
		{
			case 'internal':
			case 'phpbb2':
				$style_path = $theme['template_name'];
				break;
			case 'phpbb3':
				$style_path = $theme['style_name'];
				break;
		}

		//
		// Also search for "the other" file extension
		//
		$filename2 = substr_count($filename, 'html') ? str_replace(".html", ".tpl", $filename) : str_replace(".tpl", ".html", $filename);
		//
		// Look at MX-Publisher-Module folder.........................................................................MX-Publisher-module
		//
		if (!empty($module_root_path))
		{
			$this->module_template_path = '';
			$moduleDefault = !empty($mx_user->loaded_default_styles[$module_root_path]) ? $mx_user->loaded_default_styles[$module_root_path] : $mx_user->default_template_name;

			if( file_exists($module_root_path . 'templates/' . $style_path . '/' . $filename) )
			{
				//
				// First check current template
				//
				$filename = $module_root_path . 'templates/' . $style_path . '/' . $filename;
				$this->module_template_path = 'templates/' . $style_path . '/';
			}
			else if( file_exists($module_root_path . 'templates/' . $style_path . '/' . $filename2) )
			{
				//
				// tpl - html
				//
				$filename = $module_root_path . 'templates/' . $style_path . '/' . $filename2;
				$this->module_template_path = 'templates/' . $style_path . '/';
			}
			else if( file_exists($module_root_path . 'templates/' . $mx_user->cloned_template_name . '/' . $filename) && !empty($mx_user->cloned_template_name))
			{
				//
				// Then check Cloned template
				//
				$filename = $module_root_path . 'templates/' . $mx_user->cloned_template_name . '/' . $filename;
				$this->module_template_path = 'templates/' . $mx_user->cloned_template_name . '/';
			}
			else if( file_exists($module_root_path . 'templates/' . $mx_user->cloned_template_name . '/' . $filename2) && !empty($mx_user->cloned_template_name))
			{
				//
				// tpl - html
				//
				$filename = $module_root_path . 'templates/' . $mx_user->cloned_template_name . '/' . $filename2;
				$this->module_template_path = 'templates/' . $mx_user->cloned_template_name . '/';
			}
			else if( file_exists($module_root_path . 'templates/' . $moduleDefault . '/' . $filename) )
			{
				//
				// Then check default template
				//
				$filename = $module_root_path . 'templates/' . $moduleDefault . '/' . $filename;
				$this->module_template_path = 'templates/' . $moduleDefault . '/';
			}
			else if( file_exists($module_root_path . 'templates/' . $moduleDefault . '/' . $filename2) )
			{
				//
				// tpl - html
				//
				$filename = $module_root_path . 'templates/' . $moduleDefault . '/' . $filename2;
				$this->module_template_path = 'templates/' . $moduleDefault . '/';
			}
			else if( file_exists($module_root_path . 'templates/' . $filename) )
			{
				//
				// Finally check the template root (for compatibility with some old modules)
				//
				$filename = $module_root_path . 'templates/' . $filename;
				$this->module_template_path = 'templates/';
			}
			else if( file_exists($module_root_path . 'templates/' . $filename2) )
			{
				//
				// tpl - html
				//
				$filename = $module_root_path . 'templates/' . $filename2;
				$this->module_template_path = 'templates/';
			}

			if (!empty($this->module_template_path))
			{
				return $filename;
			}
		}

		//
		// Look at MX-Publisher-Root folder.........................................................................MX-Publisher-Root
		//
		if( file_exists($mx_root_path . 'templates/' . $style_path . '/' . $filename) )
		{
			//
			// First check current template
			//
			$filename = $mx_root_path . 'templates/' . $style_path . '/' . $filename;
		}
		else if( file_exists($mx_root_path . 'templates/' . $style_path . '/' . $filename2) )
		{
			//
			// tpl - html
			//
			$filename = $mx_root_path . 'templates/' . $style_path . '/' . $filename2;
		}
		else if( file_exists($mx_root_path . 'templates/' . $mx_user->cloned_template_name . '/' . $filename) && !empty($mx_user->cloned_template_name))
		{
			//
			// Then check Cloned template
			//
			$filename = $mx_root_path . 'templates/' . $mx_user->cloned_template_name . '/' . $filename;
		}
		else if( file_exists($mx_root_path . 'templates/' . $mx_user->cloned_template_name . '/' . $filename2) && !empty($mx_user->cloned_template_name))
		{
			//
			// tpl - html
			//
			$filename = $mx_root_path . 'templates/' . $mx_user->cloned_template_name . '/' . $filename2;
		}
		else if( file_exists($mx_root_path . 'templates/' . $mx_user->default_template_name . '/' . $filename) )
		{
			//
			// Then check Default template
			//
			$filename = $mx_root_path . 'templates/' . $mx_user->default_template_name . '/' . $filename;
		}
		else if( file_exists($mx_root_path . 'templates/' . $mx_user->default_template_name . '/' . $filename2) )
		{
			//
			// tpl - html
			//
			$filename = $mx_root_path . 'templates/' . $mx_user->default_template_name . '/' . $filename2;
		}
		//
		// Look at Custom Root folder..............this is used my mx_mod installers too.......this does not use standard templates folders wich are set when the template was re-initialized and defined as custom var
		//
		else if( file_exists( $this->root . '/' . $filename) )
		{
			$filename =  $this->root . '/' . $filename;
		}
		if( file_exists($this->root . '/' . $style_path . '/' . $filename) )
		{
			//
			// First check current template
			//
			$filename = $this->root . '/' . $style_path . '/' . $filename;
		}
		else if( file_exists($this->root . '/' . $style_path . '/' . $filename2) )
		{
			//
			// tpl - html
			//
			$filename = $this->root. '/' . $style_path . '/' . $filename2;
		}
		else if( file_exists($this->root . '/' . $mx_user->default_template_name . '/' . $filename) )
		{
			//
			// Then check current template
			//
			$filename = $mx_root_path . '/' . $mx_user->default_template_name . '/' . $filename;
		}
		else if( file_exists($this->root . '/' . $moduleDefault . '/' . $filename) )
		{
			//
			// Finally check the Custom Root folde(for compatibility with some old modules)
			//
			$filename = $this->root . '/' . $moduleDefault . '/' . $filename;
		}
		else
		{
			//
			// phpBB.........................................................................phpBB
			//
			switch (PORTAL_BACKEND)
			{
				//
				// Look at phpBB2-Root folder...
				//
				case 'internal':
				case 'phpbb2':

					if( file_exists($phpbb_root_path . 'templates/' . $style_path . '/' . $filename) )
					{
						//
						// First check current template
						//
						$filename = $phpbb_root_path . 'templates/' . $style_path . '/' . $filename;
					}
					else if( file_exists($phpbb_root_path . 'templates/' . $mx_user->cloned_template_name . '/' . $filename) && !empty($mx_user->cloned_template_name))
					{
						//
						// Then check Cloned
						//
						$filename = $phpbb_root_path . 'templates/' . $mx_user->cloned_template_name . '/' . $filename;
					}
					else if( file_exists($phpbb_root_path . 'templates/' . $mx_user->default_template_name . '/' . $filename) && !empty($mx_user->default_template_name))
					{
						//
						// Then check Default
						//
						$filename = $phpbb_root_path . 'templates/' . $mx_user->default_template_name . '/' . $filename;
					}
					else if( file_exists($phpbb_root_path . $this->root . '/' . $filename) )
					{
						$filename = $phpbb_root_path . $this->root . '/' . $filename;
					}
					else if( file_exists($this->root . '/' . $filename) )
					{
						//
						// Check if it's an absolute or relative path.
						//
						if( substr($filename, 0, 1) != '/' )
						{
							$filename = ($rp_filename = phpBB2::phpbb_realpath($this->root . '/' . $filename)) ? $rp_filename : $filename;
						}
					}

					break;

				//
				// Look at phpBB3-Root folder...
				//
				case 'phpbb3':
					if( file_exists($phpbb_root_path . 'styles/' . $style_path . '/' . 'theme/' . $filename) )
					{
						//
						// First check current template
						//
						$filename = $phpbb_root_path . 'styles/' . $style_path . '/' . 'theme/' . $filename;
					}
					else if( file_exists($phpbb_root_path . 'styles/' . $mx_user->cloned_template_name . '/' . 'theme/' . $filename) && !empty($mx_user->cloned_template_name))
					{
						//
						// Then check Cloned Template
						//
						$filename = $phpbb_root_path . 'styles/' . $mx_user->cloned_template_name . '/' . 'theme/' . $filename;
					}
					else if( file_exists($phpbb_root_path . $this->root . '/' . $filename) )
					{
						$filename = $phpbb_root_path . $this->root . '/' . $filename;
					}
					if( file_exists($phpbb_root_path . 'adm/style/' . $filename) )
					{
						//
						// First check  ACP template
						//
						$filename = $phpbb_root_path . 'adm/style/' . $filename;
					}
					else if( file_exists($this->root . '/' . $filename) )
					{
						//
						// Check if it's an absolute or relative path.
						//
						if( substr($filename, 0, 1) != '/' )
						{
							$filename = ($rp_filename = phpBB2::phpbb_realpath($this->root . '/' . $filename)) ? $rp_filename : $filename;
						}
					}

					break;
			}

			if( !file_exists($filename) )
			{
				die("Template->make_filename(): Error - file $filename does not exist. <br />Class-Root: $this->root <br />Module: $module_root_path <br />Current style: $style_path <br />Cloned style: $mx_user->cloned_template_name <br />Default style: $mx_user->default_template_name <br />Custom module default style: $moduleDefault");
			}
		}

		return $filename;
	}

	/**
	* Set template location
	* phpBB3
	* @access public
	*/
	function set_template()
	{
		global $phpbb_root_path, $mx_root_path, $mx_user;

		if (file_exists($phpbb_root_path . 'styles/' . $mx_user->theme['template_path'] . '/template'))
		{
			$this->root = $phpbb_root_path . 'styles/' . $mx_user->theme['template_path'] . '/template';
			$this->cachepath = $phpbb_root_path . 'cache/tpl_' . $mx_user->theme['template_path'] . '_';
		}
		else
		{
			trigger_error('Template path could not be found: styles/' . $mx_user->theme['template_path'] . '/template', E_USER_ERROR);
		}

		$this->_rootref = &$this->_tpldata['.'][0];

		return true;
	}


}	// class mx_Template

/**#@+
 * mx_user class specific definitions
 *
 */
define('MX_LANG_MAIN'	, 10);
define('MX_LANG_ADMIN'	, 20);
define('MX_LANG_ALL'	, 30);
define('MX_LANG_NONE'	, 40);
define('MX_IMAGES'		, 50);
define('MX_IMAGES_NONE'	, 60);
define('MX_LANG_CUSTOM'	, 70);
/**#@-*/

/**
 * Class: phpbb_user based on mx_user from  mx_functions_style.php
 *
 * @package Style
 * @author Jon Ohlsson
 * @access public
 */
class mx_user 
{
	//
	// Implementation Conventions:
	// Properties and methods prefixed with underscore are intented to be private. ;-)
	//

	// ------------------------------
	// Vars
	//
	/**#@+
	 * mx_user class specific vars
	 *
	 */
	var $loaded_langs = array();
	var $loaded_styles = array();
	var $loaded_default_styles = array();

	var $template_path = 'templates/';

	var $template_name = '';
	var $template_names = array();
	var $current_template_path = '';

	var $cloned_template_name = '';
	var $cloned_current_template_path = '';

	var $default_template_name = 'subSilver';
	var $default_current_template_path = '';

	var $default_module_style = '';

	var $is_admin = false;
	var $page_id = '';
	var $user_ip = '';

	var $data = array(); // For future Olympus comp.
	/**#@-*/

	// ------------------------------
	// Properties
	//

	// ------------------------------
	// Constructor
	//

	// ------------------------------
	// Private Methods
	//

	/**
	 * Init session.
	 *
	 * Start session management (phpBB 2.0.x)
	 * - populate $userdata, $mx_user->data
	 *
	 *This is based on early mxBB 2.9.0 (MXP)
	 *
	 * @access private
	 * @param unknown_type $user_ip
	 * @param unknown_type $page_id
	 */
	function _init_session()
	{
		global $userdata, $board_config;
	
		switch (PORTAL_BACKEND)
		{
			case 'internal':
			case 'phpbb2':
				$userdata = session_pagestart($this->user_ip, - ( MX_PORTAL_PAGES_OFFSET + $this->page_id )); // Use native phpBB 2.0.x session handling
				$this->data = $userdata; //for compatibility with Olympus style modules
				$this->is_admin = $userdata['user_level'] == ADMIN && $userdata['session_logged_in'];
			break;

			case 'phpbb3':
				global $user, $config;			
				$user->session_begin(); // Use native phpBB 3.0.x session handling
				$userdata = $this->data = $user->data; //for compatibility with old modules
				$board_config = $config; // Get phpBB config settings
				$this->is_admin = ($userdata['user_type'] == ADMIN) || ($userdata['user_type'] == USER_FOUNDER);
			break;
		}
	}

	/**
	 * Init userprefs.
	 *
	 * Initialise user settings on page load.
	 * - populate $lang, $theme, $images and initiate $template
	 *
	 * @access private
	 */
	function _init_userprefs()
	{
		global $userdata, $board_config, $portal_config, $theme, $images;
		global $template, $lang, $phpEx, $phpbb_root_path, $mx_root_path, $mx_mod_path, $db;
		global $nav_links;

		if ( $this->data['user_id'] != ANONYMOUS || $this->data['user_id'] != 1 )
		{
			if ( !empty($this->data['user_lang']))
			{
				switch (PORTAL_BACKEND)
				{
					case 'internal':
					case 'phpbb2':
						$this->lang['default_lang'] = phpBB2::phpbb_ltrim(basename(phpBB2::phpbb_rtrim($this->data['user_lang'])), "'");
					break;

					case 'phpbb3':
						global $user;
						$this->lang['default_lang'] = $user->data['user_lang'];
					break;
				}
			}

			if ( !empty($this->data['user_dateformat']) )
			{
				$board_config['default_dateformat'] = $this->data['user_dateformat'];
			}

			if ( isset($this->data['user_timezone']) )
			{
				$board_config['board_timezone'] = $this->data['user_timezone'];
			}

		}
		else
		{
			switch (PORTAL_BACKEND)
			{
				case 'internal':

				case 'phpbb2':

					$this->lang['default_lang'] = phpBB2::phpbb_ltrim(basename(phpBB2::phpbb_rtrim($board_config['default_lang'])), "'");
					break;

				case 'phpbb3':

					$this->lang['default_lang'] = phpBB2::phpbb_ltrim(basename(phpBB2::phpbb_rtrim($this->data['default_lang'])), "'");
					break;
			}
		}

		//
		// Now, $this->lang['default_lang'] is populated. But do we have a mathing MX-Publisher lang file?
		// Note: $this->get_old_lang() is used to translate phpBB3 lang keys/paths to old ways, eg to ensure lang_english and not lang_en.
		//
		/*
		if ( !file_exists(phpBB2::phpbb_realpath($phpbb_root_path . 'language/lang_' . $this->get_old_lang($this->lang['default_lang']) . '/lang_main.'.$phpEx)) )
		{
			if ( $this->data['user_id'] != ANONYMOUS || $this->data['user_id'] != 1 )
			{
				// For logged in users, try the board default language next
				$this->lang['default_lang'] = phpBB2::phpbb_ltrim(basename(phpBB2::phpbb_rtrim($board_config['default_lang'])), "'");
			}
			else
			{
				// For guests it means the default language is not present, try english
				// This is a long shot since it means serious errors in the setup to reach here,
				// but english is part of a new install so it's worth us trying
				//$this->lang['default_lang'] = $this->get_old_lang('en'); //this will not work with sessions
				$this->lang['default_lang'] = 'en';
			}

			if (!file_exists(phpBB2::phpbb_realpath($phpbb_root_path . 'language/lang_' . $this->get_old_lang($this->lang['default_lang']) . '/lang_main.'.$phpEx)))
			{
				mx_message_die(CRITICAL_ERROR, 'Could not locate valid language pack');
			}
		}
		*/

		// If we've had to change the value in any way then let's write it back to the database
		// before we go any further since it means there is something wrong with it
		if ( ($this->data['user_id'] != ANONYMOUS || $this->data['user_id'] != 1) && $this->data['user_lang'] !== $this->lang['default_lang'] )
		{
			$sql = 'UPDATE ' . USERS_TABLE . "
				SET user_lang = '" . $this->lang['default_lang'] . "'
				WHERE user_lang = '" . $this->data['user_lang'] . "'";

			if ( !($result = $db->sql_query($sql)) )
			{
				mx_message_die(CRITICAL_ERROR, 'Could not update user language info');
			}

			$userdata['user_lang'] = $this->lang['default_lang'];
		}
		elseif ( $this->data['user_id'] === ANONYMOUS && $board_config['default_lang'] !== $this->lang['default_lang'] )
		{
			$sql = 'UPDATE ' . CONFIG_TABLE . "
				SET config_value = '" . $this->lang['default_lang'] . "'
				WHERE config_name = 'default_lang'";

			if ( !($result = $db->sql_query($sql)) )
			{
				mx_message_die(CRITICAL_ERROR, 'Could not update user language info');
			}
		}

		$board_config['phpbb_lang'] = $this->lang['default_lang'];
		$board_config['default_lang'] = $this->get_old_lang($this->lang['default_lang']); // This will expand the lang name

		switch (PORTAL_BACKEND)
		{
			case 'internal':
			case 'phpbb3':
				$phpbb_lang_path = $mx_mod_path . 'includes/shared/phpbb2/language/';
			break;
			case 'phpbb2':
				$phpbb_lang_path = $phpbb_root_path . 'language/';
			break;
			default:
				$phpbb_lang_path = $phpbb_root_path . 'language/';
		}

		//Load phpBB lang keys
		if ((@include $phpbb_lang_path . "lang_" . $board_config['default_lang'] . "/lang_main.$phpEx") === false)
		{
			if ((@include $phpbb_lang_path . "lang_english/lang_main.$phpEx") === false)
			{
				mx_message_die(GENERAL_ERROR, 'Language file ' . $phpbb_lang_path . "lang_" . $board_config['default_lang'] . "/lang_main.$phpEx" . ' couldn\'t be opened.');
			}
		}

		//include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_main.' . $phpEx);

		//Load AdminCP lang keys
		if ( defined('IN_ADMIN') )
		{
			if( !file_exists($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_admin.'.$phpEx))
			{
				$board_config['default_lang'] = 'english';
			}
			
			include($phpbb_lang_path . "lang_" . $board_config['default_lang'] . "/lang_admin.$phpEx"); // Also include phpBB admin lang keys
			//include($mx_root_path . 'language/lang_' . $board_config['default_lang'] . "/lang_admin.$phpEx"); // Also include mxP Admin lang keys
		}

		//
		// Mozilla navigation bar
		// Default items that should be valid on all pages.
		// Defined here to correctly assign the Language Variables
		// and be able to change the variables within code.
		//
		$nav_links['top'] = array (
			'url' => mx_append_sid($phpbb_root_path . 'index.' . $phpEx),
			'title' => sprintf($lang['Forum_Index'], $board_config['sitename'])
		);
		$nav_links['search'] = array (
			'url' => mx_append_sid($phpbb_root_path . 'search.' . $phpEx),
			'title' => $lang['Search']
		);
		$nav_links['help'] = array (
			'url' => mx_append_sid($phpbb_root_path . 'faq.' . $phpEx),
			'title' => $lang['FAQ']
		);
		$nav_links['author'] = array (
			'url' => mx_append_sid($phpbb_root_path . 'memberlist.' . $phpEx),
			'title' => $lang['Memberlist']
		);
	}

	/**
	 * Init style.
	 *
	 * @access private
	 * @return unknown
	 */
	function _init_style()
	{
		global $userdata, $board_config, $portal_config, $theme, $images;
		global $template, $lang, $phpEx, $phpbb_root_path, $mx_root_path, $db;
		global $mx_page;

		//
		// Build Portal style
		//
		$portal_config['default_admin_style'] = $portal_config['default_admin_style'] == -1 ? $board_config['default_style'] : $portal_config['default_admin_style'];
		$portal_config['default_style'] = $portal_config['default_style'] == -1 ? $board_config['default_style'] : $portal_config['default_style'];
		$portal_config['override_user_style'] = $portal_config['override_user_style'] == -1 ? $board_config['override_user_style'] : $portal_config['override_user_style'];

		if ( defined('IN_ADMIN') )
		{
			$init_style = $portal_config['default_admin_style'];
			$init_override = 1;
		}
		else if (isset($mx_page))
		{
			$init_style = $mx_page->default_style == -1 ? $portal_config['default_style'] : $mx_page->default_style;
			$init_override = intval($mx_page->override_user_style) == -1 ? $portal_config['override_user_style'] : $mx_page->override_user_style;
		}
		else
		{
			$init_style = $portal_config['default_style'];
			$init_override = $portal_config['override_user_style'];
		}

		if (!$init_style)
		{
			$init_style = 1;
			$init_override = 1;
		}

		//
		// Setup demo style
		//
		if ( isset($_GET['demo_theme']) || isset($_COOKIE['demo_theme']))
		{
				$style = isset($_GET['demo_theme']) ? intval($_GET['demo_theme']) : intval($_COOKIE['demo_theme']);
				if ( $theme = $this->_setup_style($style) )
				{
					setcookie('demo_theme', $style, (time()+21600), $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
					return;
				}
		}

		//
		// Setup style
		//
		/*
		if ( !$init_override )
		{
			if ( $userdata['user_id'] != ANONYMOUS && $userdata['user_style'] > 0 )
			{
				$style = isset($_POST['user_style']) ? intval($_POST['user_style']) : $userdata['user_style'];
				if ( $theme = $this->_setup_style($style) )
				{
					return;
				}
			}
		}
		*/
		
		if ( $userdata['user_id'] != ANONYMOUS && $userdata['user_style'] > 0 )
		{
			$style = isset($_POST['user_style']) ? intval($_POST['user_style']) : $userdata['user_style'];
			if ( $theme = $this->_setup_style($style) )
			{
				return;
			}
		}
		else
		{
			$style = isset($_POST['default_style']) ? intval($_POST['default_style']) : $board_config['default_style'];
		}
		$theme = $this->_setup_style($style);

		return;
	}

	/**
	 * Setup style backported from MXP 2.9.
	 *
	 * @access private
	 * @param unknown_type $style
	 * @return unknown
	 */
	function _setup_style($style)
	{
		global $db, $board_config, $portal_config, $template, $phpbb_root_path, $mx_root_path, $theme;

		//
		// Get Style data.
		//
		switch (PORTAL_BACKEND)
		{
			case 'internal':
			case 'phpbb2':
				$sql = "SELECT *
					FROM " . THEMES_TABLE . "
					WHERE themes_id = " . (int) $style;
				break;
			case 'phpbb3':
				$sql = "SELECT *
					FROM " . STYLES_TABLE . "
					WHERE style_id = " . (int) $style;
				break;
		}

		if ( !($result = $db->sql_query($sql, 120)) )
		{
			mx_message_die(CRITICAL_ERROR, "Could not query database for theme info", '', __LINE__, __FILE__, $sql);
		}

		//
		// Use default style if custom style doesn't exist.
		//
		if ( !($row = $db->sql_fetchrow($result)) )
		{
			$style = $board_config['default_style'];

			switch (PORTAL_BACKEND)
			{
				case 'internal':
				case 'phpbb2':
					$sql = "SELECT *
						FROM " . THEMES_TABLE . "
						WHERE themes_id = " . (int) $style;
					break;
				case 'phpbb3':
					$sql = "SELECT *
						FROM " . STYLES_TABLE . "
						WHERE themes_id = " . (int) $style;
					break;
			}

			if ( !($result = $db->sql_query($sql, 120)) )
			{
				mx_message_die(CRITICAL_ERROR, 'Could not query database for theme info');
			}

			//
			// Last desperate try...
			//
			if ( !($row = $db->sql_fetchrow($result)) )
			{
				switch (PORTAL_BACKEND)
				{
					case 'internal':
					case 'phpbb2':
						$sql = 'SELECT *
							FROM ' . THEMES_TABLE . '
							LIMIT 1';
						break;
					case 'phpbb3':
						$sql = 'SELECT *
							FROM ' . STYLES_TABLE . '
							LIMIT 1';
						break;
				}

				if ( !($result = $db->sql_query($sql, 120)) )
				{
					mx_message_die(CRITICAL_ERROR, 'Could not query database for theme info');
				}

				if ( !($row = $db->sql_fetchrow($result)) )
				{
					mx_message_die(CRITICAL_ERROR, "Could not get MX-Publisher style data for themes_id [$style]");
				}
			}
		}

		$db->sql_freeresult($result);

		//
		// Init class settings
		//
		switch (PORTAL_BACKEND)
		{
			case 'internal':
			case 'phpbb2':
				$this->template_name = $row['template_name'];
				break;
			case 'phpbb3':
				$this->template_name = $row['style_name'];
				break;
		}

		$this->current_template_path = $this->template_path . $this->template_name;
		$this->default_current_template_path = $this->template_path . $this->default_template_name;
		$this->style = $style;

		//
		// Load template settings
		// - pass cloned template name to $theme
		//
		$template_config_row = $this->_load_template_config();

		$row['template_copy'] = $template_config_row['template_copy'];
		$row['cloned_template_name'] = $template_config_row['cloned_template'];
		$row['border_graphics'] = $template_config_row['border_graphics'];

		switch (PORTAL_BACKEND)
		{
			case 'internal':
				foreach($template_config_row as $key => $value)
				{
					$row[$key] = $value;
				}
				break;
			case 'phpbb3':
				$row['style_copy'] = $template_config_row['template_copy'];
				$row['head_stylesheet'] = $row['style_name'] . '.css';
				break;
		}

		$this->cloned_template_name = $row['cloned_template_name'];
		$this->cloned_current_template_path = !empty($this->cloned_template_name) ? $this->template_path . $this->cloned_template_name : '';

		//
		// Load images
		//
		$this->_load_phpbb_images();
		$this->_load_mxbb_images();

		//
		// What template to use?
		//
		$template = new mx_Template($mx_root_path . $this->template_path . $this->template_name);

		define('TEMPLATE_ROOT_PATH', $this->template_path . $this->template_name . '/');

		//
		// Get missing theme colors from *.cfg file (sort of desperate fix)
		//
		foreach($row as $key => $value)
		{
			if(empty($value) && !empty($theme[$key]))
			{
				$row[$key] = $theme[$key];
			}
		}

		return $row;
	}

	/**
	 * Enter description here...
	 *
	 * Main features droped to work with vannila phpBB by OryNider
	 *
	 * @access private
	 * @return unknown
	 */
	function _load_template_config()
	{
		global $board_config, $template, $phpbb_root_path, $mx_root_path;

		/*
		$mx_template_config = false;

		//
		// Load mxBB Template configuration data
		//
		@include($mx_root_path . $this->current_template_path . '/' . $this->template_name . '.cfg');
		*/
		@include($phpbb_root_path . $this->current_template_path . "/$this->template_name.cfg");
		
		if ( !defined('TEMPLATE_CONFIG') )
		{
			//
			// Since we have no Template Config file, use default (subSilver) instead
			//
			@include($phpbb_root_path . $this->default_current_template_path . '/' . $this->default_template_name . '.cfg');

			//
			// Make default template -> current template
			//
			$this->template_name = $this->default_template_name;
			$this->current_template_path = $this->default_current_template_path;

		}

		/*
		if ( !$mx_template_config )
		{
			mx_message_die(CRITICAL_ERROR, "Could not open mxBB $this->template_name template config file", '', __LINE__, __FILE__);
		}
		*/

		if ( !defined('TEMPLATE_CONFIG') )
		{
			mx_message_die(CRITICAL_ERROR, "Could not open phpBB " . $phpbb_root_path . $this->current_template_path . "/" . $this->template_name . ".cfg template config file", '', __LINE__, __FILE__);
		}
 

		//
		// Is this a cloned temmplate - defined by main *.cfg?
		//
		/*
		$template_config_row['cloned_template'] = trim(htmlspecialchars($mx_template_settings['cloned_template']));
		$template_config_row['border_graphics'] = $mx_template_settings['border_graphics'];
		$template_config_row['template_copy'] = $mx_template_settings['template_copy'];
		*/
		
		$template_config_row['cloned_template'] = 'subSilver';
		$template_config_row['border_graphics'] = '';
		$template_config_row['template_copy'] = '';

		return $template_config_row;
	}

	/**
	 * Enter description here...
	 * Backported from MXP 2.9 with some modifications
	 * @access private
	 */
	function _load_phpbb_images()
	{
		global $images, $board_config, $template, $phpbb_root_path, $mx_root_path;

		unset($GLOBALS['TEMPLATE_CONFIG']);

		switch (PORTAL_BACKEND)
		{
			case 'internal':
				define(TEMPLATE_CONFIG, TRUE);
				break;
			case 'phpbb2':
				//
				// Load phpBB Template configuration data
				// - First try current template
				//
				if ( file_exists( $phpbb_root_path . $this->current_template_path . "/images" ) )
				{
					$current_template_path = $this->current_template_path;
					$template_name = $this->template_name;

					include($phpbb_root_path . $this->current_template_path . '/' . $this->template_name . '.cfg');
				}

				//
				// Since we have no current Template Config file, try the cloned template instead
				//
				if ( file_exists( $phpbb_root_path . $this->cloned_current_template_path . "/images" ) && !defined('TEMPLATE_CONFIG') )
				{
					$current_template_path = $this->cloned_current_template_path;
					$template_name = $this->cloned_template_name;

					include($phpbb_root_path . $this->cloned_current_template_path . '/' . $this->cloned_template_name . '.cfg');
				}

				//
				// Last attempt, use default template intead
				//
				if ( file_exists( $phpbb_root_path . $this->default_current_template_path . "/images" ) && !defined('TEMPLATE_CONFIG') )
				{
					$current_template_path = $this->default_current_template_path;
					$template_name = $this->default_template_name;

					include($phpbb_root_path . $this->default_current_template_path . '/' . $this->default_template_name . '.cfg');
				}

			break;

			case 'phpbb3':
				global $user;
				$user->setup();

				// Here we overwrite phpBB images from the template configuration file with images from database

				$images['icon_quote'] =  $user->images('icon_quote');
				$images['icon_edit'] = $user->images('icon_edit');
				$images['icon_search'] = $user->images('icon_search');
				$images['icon_profile'] = $user->images('icon_profile');
				$images['icon_pm'] = $user->images('icon_pm');
				$images['icon_email'] = $user->images('icon_email');
				$images['icon_delpost'] = $user->images('icon_delpost');
				$images['icon_ip'] = $user->images('icon_ip');
				$images['icon_www'] = $user->images('icon_www');
				$images['icon_icq'] = $user->images('icon_icq');
				$images['icon_aim'] = $user->images('icon_aim');
				$images['icon_yim'] = $user->images('icon_yim');
				$images['icon_msnm'] = $user->images('icon_msnm');
				$images['icon_minipost'] = $user->images('icon_minipost');
				$images['icon_gotopost'] = $user->images('icon_gotopost');
				$images['icon_minipost_new'] = $user->images('icon_minipost_new');
				$images['icon_latest_reply'] = $images['icon_topic_latest'] = $user->images('icon_topic_latest');
				$images['icon_newest_reply'] = $user->images('icon_newest_reply');

				$images['forum'] = $user->images('forum');
				$images['forums'] = $user->images('forums');
				$images['forum_new'] = $user->images('forum_new');
				$images['forum_locked'] = $user->images('forum_locked');

				$images['folder'] = $images['topic_read'] = $user->images('topic_read');
				$images['folder_new'] = $images['topic_unread'] = $user->images('topic_unread');
				$images['folder_hot'] = $images['topic_hot'] = $user->images('topic_hot');
				$images['folder_hot_new'] = $images['topic_hot_unread'] = $user->images('topic_hot_unread');
				$images['folder_locked'] = $images['topic_locked'] = $user->images('topic_locked');
				$images['folder_locked_new'] = $images['topic_locked_unread'] = $user->images('topic_locked_unread');
				$images['folder_sticky'] = $images['topic_sticky'] = $user->images('topic_sticky');
				$images['folder_sticky_new'] = $images['topic_sticky_unread'] = $user->images('topic_sticky_unread');
				$images['folder_announce'] = $images['topic_announce'] = $user->images('topic_announce');
				$images['folder_announce_new'] = $images['topic_announce_unread'] = $user->images('topic_announce_unread');

				$images['post_new'] = $user->images('post_new');
				$images['post_locked'] = $user->images('post_locked');
				$images['reply_new'] = $user->images('reply_new');
				$images['reply_locked'] = $user->images('reply_locked');

				$images['pm_inbox'] = $user->images('pm_inbox');
				$images['pm_outbox'] = $user->images('pm_outbox');
				$images['pm_savebox'] = $user->images('pm_savebox');
				$images['pm_sentbox'] = $user->images('pm_sentbox');
				$images['pm_readmsg'] = $user->images('pm_readmsg');
				$images['pm_unreadmsg'] = $user->images('pm_unreadmsg');
				$images['pm_replymsg'] = $user->images('pm_replymsg');
				$images['pm_postmsg'] = $user->images('pm_postmsg');
				$images['pm_quotemsg'] = $user->images('pm_quotemsg');
				$images['pm_editmsg'] = $user->images('pm_editmsg');
				$images['pm_new_msg'] = $user->images('pm_new_msg');
				$images['pm_no_new_msg'] = $user->images('pm_no_new_msg');

				$images['Topic_watch'] = $user->images('Topic_watch');
				$images['topic_un_watch'] = $user->images('topic_un_watch');
				$images['topic_mod_lock'] = $user->images('topic_mod_lock');
				$images['topic_mod_unlock'] = $user->images('topic_mod_unlock');
				$images['topic_mod_split'] = $user->images('topic_mod_split');
				$images['topic_mod_move'] = $user->images('topic_mod_move');
				$images['topic_mod_delete'] = $user->images('topic_mod_delete');

				$images['voting_graphic'] = $user->images('voting_graphic');

				define('TEMPLATE_CONFIG', TRUE);

			break;
		}

		if (PORTAL_BACKEND == 'phpbb3')
		{
			$img_lang = ($this->lang['default_lang']) ? $this->lang['default_lang'] : (($board_config['phpbb_lang']) ? $board_config['phpbb_lang'] : 'en');
		}
		else
		{
			$img_lang = ($this->lang['default_lang']) ? $this->get_old_lang($this->lang['default_lang']) : (($board_config['default_lang']) ? $board_config['default_lang'] : 'english');
		}

		//
		// Import phpBB Graphics, prefix with PHPBB_URL, and apply LANG info
		//
		while( list($key, $value) = @each($images) )
		{
			if (is_array($value))
			{
				foreach( $value as $key2 => $val2 )
				{
					$images[$key][$key2] = PHPBB_URL . $val2;
				}
			}
			else
			{
				$images[$key] = str_replace('{LANG}', 'lang_' . $img_lang, $value);
				$images[$key] = PHPBB_URL . $images[$key];
			}
		}
	}

	/**
	 * Enter description here...
	 *
	 *Modified for phpBB by OryNider from mxBB 2.8.2
	 * @access private 
	 * @param unknown_type $module_root_path
	 */
	function _load_mxbb_images($module_root_path = '')
	{
		global $images, $board_config, $template, $phpbb_root_path, $mx_root_path, $theme, $current_module_images;

		//unset($GLOBALS['MX_TEMPLATE_CONFIG']);
		$mx_template_config = false;
		
		//
		// Load mxBB Template configuration data
		// - First try current template
		//
		$current_template_path = $module_root_path . $this->current_template_path;
		$cloned_template_path = $module_root_path . $this->cloned_current_template_path;
		$default_template_path = $module_root_path . $this->default_current_template_path;
		$template_name = $this->template_name;

		//Fix
		if($module_root_path !== $mx_root_path)
		{
			@include($mx_root_path . $module_root_path . $this->current_template_path . '/' . $this->template_name . '.cfg');
		}
		else
		{
			@include($module_root_path . $this->current_template_path . '/' . $this->template_name . '.cfg');
		}
		
		//
		// Since we have no current Template Config file, try the cloned template instead
		//
		if ( !$mx_template_config )
		{
			$current_template_path = $module_root_path . $this->cloned_current_template_path;
			$template_name = $this->cloned_template_name;

			@include($mx_root_path . $module_root_path . $this->cloned_current_template_path . '/' . $this->cloned_template_name . '.cfg');
		}

		//
		// If use default template intead
		//
		if ( !$mx_template_config )
		{
			$current_template_path = $module_root_path . $this->default_current_template_path;
			$template_name = $this->default_template_name;

			@include($mx_root_path . $module_root_path . $this->default_current_template_path . '/' . $this->default_template_name . '.cfg');
		}

		//
		// If use default template with difrent modules config file name
		//
		if ( (!$mx_template_config) &&	!empty($this->module_cfg_name[$module_root_path]))
		{
			$current_template_path = $module_root_path . $this->default_current_template_path;
			$template_name = $this->default_template_name;

			if ((include $module_root_path . $this->default_current_template_path . '/' . $this->module_cfg_name[$module_root_path] . '.cfg') === false)
			{
				mx_message_die(CRITICAL_ERROR, "Could not open mod " . $module_root_path . $this->default_current_template_path . '/' . $this->module_cfg_name[$module_root_path] . '.cfg' . " style config file", '', __LINE__, __FILE__);
			}		
		}
		
		//
		// We have no template to use - die
		//
		if (!$mx_template_config)
		{
			//mx_message_die(CRITICAL_ERROR, "Could not open mod " . $module_root_path . $this->default_current_template_path . '/' . $this->module_cfg_name[$module_root_path] . '.cfg' . " style config file", '', __LINE__, __FILE__);
		}
		
		$img_lang = ( file_exists($mx_root_path . $current_template_path . '/images/lang_' . $board_config['default_lang']) ) ? $board_config['default_lang'] : 'english';

		while( list($key, $value) = @each($mx_images) )
		{
			if (is_array($value))
			{
				foreach( $value as $key2 => $val2 )
				{
					$images[$key][$key2] = $val2;
				}
			}
			else
			{
				$images[$key] = str_replace('{LANG}', 'lang_' . $img_lang, $value);
			}
		}

		//
		// What template is the module using?
		//
		$module_key = !empty($module_root_path) ? $module_root_path : 'subSilver';
		$this->template_names[$module_key] = $template_name;

		unset($mx_images);
	}

	/**
	 * Enter description here...
	 *
	 * @access private
	 * @param unknown_type $lang_mode
	 */
	function _load_module_lang($lang_mode = MX_LANG_MAIN)
	{
		//global $lang, $board_config, $mx_block, $phpEx, $mx_root_path;
		
		global $lang, $board_config, $module_root_path, $phpEx, $mx_root_path;

		if (!isset($this->loaded_langs[$module_root_path]))
		{
			if (!empty($this->module_lang_path[$module_root_path]))
			{
				$module_lang_path = $this->module_lang_path[$module_root_path];				
			}
			else
			{
				$module_lang_path = $mx_root_path . $module_root_path;
			}

			if ($lang_mode == MX_LANG_MAIN || $lang_mode == MX_LANG_ALL)
			{
				// -------------------------------------------------------------------------
				// Read Module Main Language Definition
				// -------------------------------------------------------------------------
				if ( !file_exists( $module_lang_path . 'language/lang_' . $board_config['default_lang'] . '/lang_main.' . $phpEx ) )
				{
					include( $module_lang_path . 'language/lang_english/lang_main.' . $phpEx );
				}
				else
				{
					include( $module_lang_path . 'language/lang_' . $board_config['default_lang'] . '/lang_main.' . $phpEx );
				}
			}

			if ($lang_mode == MX_LANG_ADMIN || $lang_mode == MX_LANG_ALL)
			{
				// -------------------------------------------------------------------------
				// Read Module Admin Language Definition
				// -------------------------------------------------------------------------
				if ( !file_exists( $module_lang_path . 'language/lang_' . $board_config['default_lang'] . '/lang_admin.' . $phpEx ) )
				{
					include( $module_lang_path . 'language/lang_english/lang_admin.' . $phpEx );
				}
				else
				{
					include( $module_lang_path . 'language/lang_' . $board_config['default_lang'] . '/lang_admin.' . $phpEx );
				}
			}
			
			$this->loaded_langs[$module_root_path] = '1';
		}
	}

	/**
	 * Enter description here...
	 * @access private
	 */
	function _load_module_style()
	{
		//global $mx_block, $phpEx;
		global $module_root_path, $phpEx;

		if (!isset($this->loaded_styles[$module_root_path]))
		{
			// -------------------------------------------------------------------------
			// Read Module Style Definition
			// -------------------------------------------------------------------------
			$this->_load_mxbb_images($module_root_path);

			$this->loaded_styles[$module_root_path] = '1';
		}
	}

	// USE: $default_lang = $mx_user->get_old_lang($board_config['default_lang']);
	function get_old_lang($lang)
	{
		if ( PORTAL_BACKEND != 'phpbb3' )
		{
			return $lang;
		}

		switch( $lang )
		{
			case 'ar':
				$default_lang = 'arabic';
				break;
			case 'bg':
				$default_lang = 'bulgarian';
				break;
			case 'ca':
				$default_lang = 'catalan';
				break;
			case 'cs':
				$default_lang = 'czech';
				break;
			case 'da':
				$default_lang = 'danish';
				break;
			case 'de':
				$default_lang = 'german';
				break;
			case 'et':
				$default_lang = 'estonian';
				break;
			case 'en':
				$default_lang = 'english';
				break;
			case 'fi':
				$default_lang = 'finnish';
				break;
			case 'fr ':
				$default_lang = 'french';
				break;
			case 'el':
				$default_lang = 'greek';
				break;
			case 'es[_-]ar':
				$default_lang = 'spanish_argentina';
				break;
			case 'es([_-][a-z]+)?':
				$default_lang = 'spanish';
				break;
			case 'gd':
				$default_lang = 'gaelic';
				break;
			case 'gl':
				$default_lang = 'galego';
				break;
			case 'gu':
				$default_lang = 'gujarati';
				break;
			case 'he':
				$default_lang = 'hebrew';
				break;
			case 'hi':
				$default_lang = 'hindi';
				break;
			case 'is':
				$default_lang = 'icelandic';
				break;
			case 'id ':
				$default_lang = 'indonesian';
				break;
			case 'it':
				$default_lang = 'italian';
				break;
			case 'ja':
				$default_lang = 'japanese';
				break;
			case 'ko':
				$default_lang = 'korean';
				break;
			case 'lv':
				$default_lang = 'latvian';
				break;
			case 'mk':
				$default_lang = 'macedonian';
				break;
			case 'nl ':
				$default_lang = 'dutch';
				break;
			case 'no':
				$default_lang = 'norwegian';
				break;
			case 'pa':
				$default_lang = 'punjabi';
				break;
			case 'lt':
				$default_lang = 'lithuanian';
				break;
			case 'pl':
				$default_lang = 'polish';
				break;
			case 'pt[_-]br':
				$default_lang = 'portuguese_brazil';
				break;
			case 'pt ':
				$default_lang = 'portuguese';
				break;
			case 'ro':
				$default_lang = 'romanian';
				break;
			case 'sl':
				$default_lang = 'slovenian';
				break;
			case 'sr':
				$default_lang = 'serbian';
				break;
			case 'sv':
				$default_lang = 'slovak';
				break;
			case 'sw':
				$default_lang = 'swedish';
				break;
			case 'th':
				$default_lang = 'thai';
				break;
			case 'tr':
				$default_lang = 'turkish';
				break;
			case 'uk':
				$default_lang = 'ukranian';
				break;
			case 'ur':
				$default_lang = 'urdu';
				break;
			case 'vi':
				$default_lang = 'viatnamese';
				break;
			case 'zh':
				$default_lang = 'chinese_simplified';
				break;
			case 'zh[_-]tw':
				$default_lang = 'chinese_traditional_taiwan';
				break;
			case 'pl':
				$default_lang = 'polish';
				break;
			case 'pl':
				$default_lang = 'polish';
				break;
			case 'pl':
				$default_lang = 'polish';
				break;
			default:
				$default_lang = $lang;
				break;
		}

		return $default_lang;
	}

	/**
	* Get option bit field from user options
	*/
	function optionget($key, $data = false)
	{
		if (!isset($this->keyvalues[$key]))
		{
			$var = ($data) ? $data : $this->data['user_options'];
			$this->keyvalues[$key] = ($var & 1 << $this->keyoptions[$key]) ? true : false;
		}

		return $this->keyvalues[$key];
	}
	
	// ------------------------------
	// Public Methods
	//

	/**
	 * Init user class.
	 * Populate $userdata, $lang
	 *
	 * @access public
	 * @param unknown_type $user_ip
	 * @param unknown_type $page_id
	 */
	function init( $user_ip, $page_id, $init_style = true )
	{
		//
		// Define basic constants
		//
		$this->page_id = $page_id;
		$this->user_ip = $user_ip;

		//
		// Inititate User data
		//
		$this->_init_session($user_ip, $thispage_id);
		$this->_init_userprefs();

		//
		// Inititate User style
		//
		if ($init_style)
		{
			$this->_init_style();
		}
	}

	/**
	 * Init user style.
	 * Populate $template, $theme, $images
	 *
	 * @access public
	 * @param unknown_type $user_ip
	 * @param unknown_type $thispage_id
	 */
	function init_style()
	{
		//
		// The User class must first be initiated.
		//
		if (empty($this->page_id))
		{
			die('Bad initialization method of the User Class!');
		}

		//
		// Inititate User style
		//
		$this->_init_style();
	}

	/**
	 * Extend.
	 *
	 * Extend User Style with module lang and images.
	 *
	 * Usage:
	 * - $mx_user->extend(LANG, IMAGES)
	 *
	 * Switches:
	 * - LANG: MX_LANG_MAIN (default), MX_LANG_ADMIN, MX_LANG_ALL
	 * - IMAGES: MX_IMAGES (default), MX_NO_IMAGES
	 *
	 * @access public
	 * @param unknown_type $lang_mode
	 * @param unknown_type $image_mode
	 */
	function extend($lang_mode = MX_LANG_MAIN, $image_mode = MX_IMAGES)
	{
		//global $mx_block; 		//modifyed for phpBB
		global $module_root_path;

		if (defined('IN_ADMIN'))
		{
			return;
		}

		if (!empty($this->loaded_default_styles[$module_root_path]))
		{
			$this->default_module_style = $this->loaded_default_styles[$module_root_path];
			$this->default_template_name = $this->default_module_style;
			$this->default_current_template_path = 'templates/' . $this->default_template_name;
		}

		if ($lang_mode != MX_LANG_NONE)
		{
			$this->_load_module_lang($lang_mode);
		}

		if ($image_mode != MX_IMAGES_NONE)
		{
			$this->_load_module_style();
		}

		//
		// Reset custom module default style, once used.
		//
		if (!empty($this->default_module_style))
		{
			$this->default_template_name = 'subSilver';
			$this->default_current_template_path = 'templates/' . $this->default_template_name;
			$this->default_module_style = '';
		}
	}

	function set_module_default_style($default_module_style = '')
	{
		//global $mx_block;
		global $module_root_path;

			//$this->loaded_default_styles[$mx_block->module_root_path] = $default_module_style;
			$this->loaded_default_styles[$module_root_path] = $default_module_style;
	}
	
	function set_module_cfg_name($module_cfg_name = '')
	{
		//global $mx_block;
		global $module_root_path;
	
		//$this->loaded_default_styles[$mx_block->module_root_path] = $default_module_style;
		$this->module_cfg_name[$module_root_path] = $module_cfg_name;
	}
	
	function set_module_lang_path($module_lang_path = '')
	{
		//global $mx_block;
		global $module_root_path;
	
		//$this->loaded_default_styles[$mx_block->module_root_path] = $default_module_style;
		$this->module_lang_path[$module_root_path] = $module_lang_path;
	}
}	// class mx_user
// THE END
?>